/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.datatype;

import ca.uhn.hl7v2.model.AbstractComposite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.IS;
import ca.uhn.hl7v2.model.v26.datatype.NM;

public class DTN
extends AbstractComposite {
    private Type[] data;

    public DTN(Message message) {
        super(message);
        this.init();
    }

    private void init() {
        this.data = new Type[2];
        this.data[0] = new IS(this.getMessage(), 149);
        this.data[1] = new NM(this.getMessage());
    }

    public Type[] getComponents() {
        return this.data;
    }

    public Type getComponent(int number) throws DataTypeException {
        try {
            return this.data[number];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + ((Object)((Object)this)).getClass().getName() + " has only " + this.data.length + " components)");
        }
    }

    public IS getDayType() {
        return (IS)this.getTyped(0, IS.class);
    }

    public IS getDtn1_DayType() {
        return (IS)this.getTyped(0, IS.class);
    }

    public NM getNumberOfDays() {
        return (NM)this.getTyped(1, NM.class);
    }

    public NM getDtn2_NumberOfDays() {
        return (NM)this.getTyped(1, NM.class);
    }
}

