/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.CNE;
import ca.uhn.hl7v2.model.v26.datatype.CWE;
import ca.uhn.hl7v2.model.v26.datatype.DTM;
import ca.uhn.hl7v2.model.v26.datatype.ID;
import ca.uhn.hl7v2.model.v26.datatype.IS;
import ca.uhn.hl7v2.model.v26.datatype.NM;
import ca.uhn.hl7v2.model.v26.datatype.PL;
import ca.uhn.hl7v2.model.v26.datatype.SI;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class AIL
extends AbstractSegment {
    public AIL(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, true, 1, 4, new Object[]{this.getMessage()}, "Set ID - AIL");
            this.add(ID.class, false, 1, 3, new Object[]{this.getMessage(), new Integer(206)}, "Segment Action Code");
            this.add(PL.class, false, 0, 80, new Object[]{this.getMessage()}, "Location Resource ID");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Location Type - AIL");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Location Group");
            this.add(DTM.class, false, 1, 24, new Object[]{this.getMessage()}, "Start Date/Time");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage()}, "Start Date/Time Offset");
            this.add(CNE.class, false, 1, 250, new Object[]{this.getMessage()}, "Start Date/Time Offset Units");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage()}, "Duration");
            this.add(CNE.class, false, 1, 250, new Object[]{this.getMessage()}, "Duration Units");
            this.add(IS.class, false, 1, 10, new Object[]{this.getMessage(), new Integer(279)}, "Allow Substitution Code");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Filler Status Code");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating AIL - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public SI getSetIDAIL() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getAil1_SetIDAIL() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public ID getSegmentActionCode() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public ID getAil2_SegmentActionCode() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public PL[] getLocationResourceID() {
        PL[] retVal = (PL[])this.getTypedField(3, (Type[])new PL[0]);
        return retVal;
    }

    public PL[] getAil3_LocationResourceID() {
        PL[] retVal = (PL[])this.getTypedField(3, (Type[])new PL[0]);
        return retVal;
    }

    public int getLocationResourceIDReps() {
        return this.getReps(3);
    }

    public PL getLocationResourceID(int rep) {
        PL retVal = (PL)this.getTypedField(3, rep);
        return retVal;
    }

    public PL getAil3_LocationResourceID(int rep) {
        PL retVal = (PL)this.getTypedField(3, rep);
        return retVal;
    }

    public int getAil3_LocationResourceIDReps() {
        return this.getReps(3);
    }

    public PL insertLocationResourceID(int rep) throws HL7Exception {
        return (PL)super.insertRepetition(3, rep);
    }

    public PL insertAil3_LocationResourceID(int rep) throws HL7Exception {
        return (PL)super.insertRepetition(3, rep);
    }

    public PL removeLocationResourceID(int rep) throws HL7Exception {
        return (PL)super.removeRepetition(3, rep);
    }

    public PL removeAil3_LocationResourceID(int rep) throws HL7Exception {
        return (PL)super.removeRepetition(3, rep);
    }

    public CWE getLocationTypeAIL() {
        CWE retVal = (CWE)this.getTypedField(4, 0);
        return retVal;
    }

    public CWE getAil4_LocationTypeAIL() {
        CWE retVal = (CWE)this.getTypedField(4, 0);
        return retVal;
    }

    public CWE getLocationGroup() {
        CWE retVal = (CWE)this.getTypedField(5, 0);
        return retVal;
    }

    public CWE getAil5_LocationGroup() {
        CWE retVal = (CWE)this.getTypedField(5, 0);
        return retVal;
    }

    public DTM getStartDateTime() {
        DTM retVal = (DTM)this.getTypedField(6, 0);
        return retVal;
    }

    public DTM getAil6_StartDateTime() {
        DTM retVal = (DTM)this.getTypedField(6, 0);
        return retVal;
    }

    public NM getStartDateTimeOffset() {
        NM retVal = (NM)this.getTypedField(7, 0);
        return retVal;
    }

    public NM getAil7_StartDateTimeOffset() {
        NM retVal = (NM)this.getTypedField(7, 0);
        return retVal;
    }

    public CNE getStartDateTimeOffsetUnits() {
        CNE retVal = (CNE)this.getTypedField(8, 0);
        return retVal;
    }

    public CNE getAil8_StartDateTimeOffsetUnits() {
        CNE retVal = (CNE)this.getTypedField(8, 0);
        return retVal;
    }

    public NM getDuration() {
        NM retVal = (NM)this.getTypedField(9, 0);
        return retVal;
    }

    public NM getAil9_Duration() {
        NM retVal = (NM)this.getTypedField(9, 0);
        return retVal;
    }

    public CNE getDurationUnits() {
        CNE retVal = (CNE)this.getTypedField(10, 0);
        return retVal;
    }

    public CNE getAil10_DurationUnits() {
        CNE retVal = (CNE)this.getTypedField(10, 0);
        return retVal;
    }

    public IS getAllowSubstitutionCode() {
        IS retVal = (IS)this.getTypedField(11, 0);
        return retVal;
    }

    public IS getAil11_AllowSubstitutionCode() {
        IS retVal = (IS)this.getTypedField(11, 0);
        return retVal;
    }

    public CWE getFillerStatusCode() {
        CWE retVal = (CWE)this.getTypedField(12, 0);
        return retVal;
    }

    public CWE getAil12_FillerStatusCode() {
        CWE retVal = (CWE)this.getTypedField(12, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new ID(this.getMessage(), new Integer(206));
            }
            case 2: {
                return new PL(this.getMessage());
            }
            case 3: {
                return new CWE(this.getMessage());
            }
            case 4: {
                return new CWE(this.getMessage());
            }
            case 5: {
                return new DTM(this.getMessage());
            }
            case 6: {
                return new NM(this.getMessage());
            }
            case 7: {
                return new CNE(this.getMessage());
            }
            case 8: {
                return new NM(this.getMessage());
            }
            case 9: {
                return new CNE(this.getMessage());
            }
            case 10: {
                return new IS(this.getMessage(), new Integer(279));
            }
            case 11: {
                return new CWE(this.getMessage());
            }
        }
        return null;
    }
}

