/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.CP;
import ca.uhn.hl7v2.model.v26.datatype.CWE;
import ca.uhn.hl7v2.model.v26.datatype.IS;
import ca.uhn.hl7v2.model.v26.datatype.SI;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class PCE
extends AbstractSegment {
    public PCE(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, true, 1, 2, new Object[]{this.getMessage()}, "Set ID - PCE");
            this.add(IS.class, false, 1, 30, new Object[]{this.getMessage(), new Integer(319)}, "Cost Center Account Number");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Transaction Code");
            this.add(CP.class, false, 1, 12, new Object[]{this.getMessage()}, "Transaction amount - unit");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating PCE - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public SI getSetIDPCE() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getPce1_SetIDPCE() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public IS getCostCenterAccountNumber() {
        IS retVal = (IS)this.getTypedField(2, 0);
        return retVal;
    }

    public IS getPce2_CostCenterAccountNumber() {
        IS retVal = (IS)this.getTypedField(2, 0);
        return retVal;
    }

    public CWE getTransactionCode() {
        CWE retVal = (CWE)this.getTypedField(3, 0);
        return retVal;
    }

    public CWE getPce3_TransactionCode() {
        CWE retVal = (CWE)this.getTypedField(3, 0);
        return retVal;
    }

    public CP getTransactionAmountUnit() {
        CP retVal = (CP)this.getTypedField(4, 0);
        return retVal;
    }

    public CP getPce4_TransactionAmountUnit() {
        CP retVal = (CP)this.getTypedField(4, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new IS(this.getMessage(), new Integer(319));
            }
            case 2: {
                return new CWE(this.getMessage());
            }
            case 3: {
                return new CP(this.getMessage());
            }
        }
        return null;
    }
}

