/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import oracle.ons.ONS;
import oracle.ons.QueueElement;

public class NotificationQueue {
    private QueueElement head = null;
    private QueueElement tail = null;
    private Object lock = new Object();
    private Object closelock = null;
    private int waiters = 0;
    private int count = 0;
    private boolean closed = false;
    private boolean closing;
    private int closewaiters = 0;
    protected static final int DEFAULT_PRIORITY = 10;
    protected static final int LOW_PRIORITY = 10;
    protected static final int HIGH_PRIORITY = 1;

    protected NotificationQueue() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enqueue(Object e) {
        QueueElement newelement = new QueueElement(e);
        Object object = this.lock;
        synchronized (object) {
            if (!this.closed && !this.closing) {
                if (this.head == null) {
                    this.head = newelement;
                } else if (this.tail == null) {
                    this.head.next = this.tail = newelement;
                } else {
                    this.tail.next = newelement;
                    this.tail = newelement;
                }
                if (this.waiters > 0) {
                    this.lock.notify();
                    --this.waiters;
                }
                ++this.count;
            }
        }
    }

    protected void push(Object e) {
        this.push(e, 10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void push(Object e, int p) {
        QueueElement newelement = new QueueElement(e, p);
        Object object = this.lock;
        synchronized (object) {
            if (!this.closed && !this.closing) {
                if (this.head == null) {
                    this.head = newelement;
                } else if (p <= this.head.priority) {
                    if (this.tail == null) {
                        this.tail = this.head;
                    }
                    newelement.next = this.head;
                    this.head = newelement;
                } else {
                    QueueElement prev = this.head;
                    QueueElement cur = this.head.next;
                    while (cur != null && p > cur.priority) {
                        prev = cur;
                        cur = cur.next;
                    }
                    if (cur != null) {
                        prev.next = newelement;
                        newelement.next = cur;
                    } else {
                        prev.next = newelement;
                        this.tail = newelement;
                    }
                }
                if (this.waiters > 0) {
                    this.lock.notify();
                    --this.waiters;
                }
                ++this.count;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close() {
        Object object = this.lock;
        synchronized (object) {
            this.closed = true;
            if (this.waiters > 0) {
                this.lock.notifyAll();
            }
        }
    }

    protected Object dequeue(boolean blocking) {
        return this.internalDequeue(blocking, -1L);
    }

    protected Object dequeue(long wait) {
        return this.internalDequeue(true, wait);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object internalDequeue(boolean blocking, long wait) {
        Object ret = null;
        boolean lc = false;
        Object object = this.lock;
        synchronized (object) {
            lc = this.closing;
            if (!this.closed) {
                block16: {
                    if (blocking && this.head == null && !this.closing) {
                        ++this.waiters;
                        try {
                            if (wait != -1L) {
                                this.lock.wait(wait);
                            } else {
                                this.lock.wait();
                            }
                        }
                        catch (Exception e) {
                            if (!ONS.debug) break block16;
                            e.printStackTrace(ONS.errstream);
                        }
                    }
                }
                if (this.head != null) {
                    ret = this.head.obj;
                    if (this.head.next == this.tail) {
                        this.tail = null;
                    }
                    this.head = this.head.next;
                    --this.count;
                }
            }
        }
        if (ret == null && lc) {
            object = this.closelock;
            synchronized (object) {
                if (this.closewaiters > 0) {
                    this.closelock.notifyAll();
                }
            }
        }
        return ret;
    }

    protected int count() {
        return this.count;
    }

    protected int waiters() {
        return this.waiters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void wake() {
        Object object = this.lock;
        synchronized (object) {
            if (this.waiters > 0) {
                this.lock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drain_and_close() {
        boolean needtowait = false;
        Object object = this.lock;
        synchronized (object) {
            this.closing = true;
            this.closelock = new Object();
            if (this.count > 0) {
                needtowait = true;
            }
        }
        if (needtowait) {
            object = this.closelock;
            synchronized (object) {
                Object object2 = this.lock;
                synchronized (object2) {
                    if (this.count == 0) {
                        needtowait = false;
                    }
                }
                if (needtowait) {
                    try {
                        ++this.closewaiters;
                        this.closelock.wait(ONS.shutdowntimeout * 1000);
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        --this.closewaiters;
                    }
                }
            }
        }
        this.close();
    }
}

