/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import java.io.IOException;
import java.io.OutputStream;
import oracle.ons.ONS;

public class OutputBuffer {
    private static final int BUFFERSIZE = 1024;
    private OutputStream ostr;
    private byte[] buffer;
    private int spaceleft;
    private int position;

    protected OutputBuffer(OutputStream o) {
        this.ostr = o;
        this.buffer = new byte[1024];
        this.spaceleft = 1024;
        this.position = 0;
    }

    protected void putBytes(byte[] b, int len) throws IOException {
        if (this.spaceleft >= len) {
            System.arraycopy(b, 0, this.buffer, this.position, len);
            this.spaceleft -= len;
            this.position += len;
        } else if (len > 1024) {
            if (this.position > 0) {
                this.ostr.write(this.buffer, 0, this.position);
            }
            this.position = 0;
            this.spaceleft = 1024;
            this.ostr.write(b, 0, len);
        } else {
            System.arraycopy(b, 0, this.buffer, this.position, this.spaceleft);
            this.ostr.write(this.buffer, 0, 1024);
            System.arraycopy(b, this.spaceleft, this.buffer, 0, len - this.spaceleft);
            this.position = len - this.spaceleft;
            this.spaceleft = 1024 - this.position;
        }
    }

    protected void putString(String s) throws IOException {
        this.putBytes(s.getBytes(), s.length());
    }

    protected void putByte(byte b) throws IOException {
        if (this.spaceleft == 0) {
            this.ostr.write(this.buffer, 0, 1024);
            this.spaceleft = 1024;
            this.position = 0;
        }
        this.buffer[this.position] = b;
        ++this.position;
        --this.spaceleft;
    }

    protected void flush() throws IOException {
        if (ONS.debug) {
            ONS.outstream.println("OutputBuffer.flush ==> position=" + this.position);
        }
        if (this.position > 0) {
            this.ostr.write(this.buffer, 0, this.position);
        }
        this.ostr.flush();
        this.position = 0;
        this.spaceleft = 1024;
        if (ONS.debug) {
            ONS.outstream.println("OutputBuffer.flush ==> leaving method, no exceptions");
        }
    }
}

