/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import java.io.IOException;
import java.net.Socket;
import oracle.ons.Connection;
import oracle.ons.Notification;
import oracle.ons.NotificationQueue;
import oracle.ons.ONS;
import oracle.ons.OutputBuffer;
import oracle.ons.SendElement;
import oracle.ons.SubscriptionNotification;

public class SenderThread
extends Thread {
    private ONS oems;
    private Connection connection;
    private boolean shutdown = false;
    private boolean quiescent = false;
    private boolean waitQ = false;
    private NotificationQueue q;
    private String id;
    private Object lock = new Object();

    protected SenderThread(ONS o, Connection co) {
        this.setDaemon(true);
        this.oems = o;
        this.connection = co;
        this.q = new NotificationQueue();
        this.connection.setClientSender(this);
        this.id = new String("SenderThread[" + this.connection.getId() + "]");
    }

    public void run() {
        if (ONS.debug) {
            ONS.outstream.println(this.id + "::run ==> start");
        }
        if (ONS.localConn) {
            this.runLocal();
        } else {
            this.runRemote();
        }
        if (ONS.debug) {
            ONS.outstream.println(this.id + "::run ==> stop");
        }
    }

    private void runLocal() {
        Socket lastsocket = null;
        while (!this.shutdown) {
            if (this.quiescent) {
                while (this.quiescent && !this.shutdown) {
                    try {
                        SenderThread.sleep(500L);
                    }
                    catch (Exception e) {}
                }
            }
            SendElement se = (SendElement)this.q.dequeue(true);
            if (ONS.debug) {
                ONS.outstream.println(this.id + "::run ==> have a send element:\n" + se);
            }
            if (se == null) continue;
            Socket s = this.connection.getClientSocket(true);
            if (ONS.debug) {
                ONS.outstream.println(this.id + "::run ==> have socket: " + s);
            }
            if (s == null) {
                this.q.push(se);
                continue;
            }
            if (s != lastsocket) {
                if (ONS.debug) {
                    ONS.outstream.println(this.id + "::run ==> socket changed (push)");
                }
                lastsocket = s;
                this.q.push(se);
                se = (SendElement)this.q.dequeue(true);
                if (se == null) continue;
            }
            try {
                if (ONS.debug) {
                    ONS.outstream.println(this.id + "::run ==> send element");
                }
                if (se.e != null) {
                    se.e.send(new OutputBuffer(s.getOutputStream()), this.connection);
                    continue;
                }
                if (se.s == null) continue;
                se.s.send(new OutputBuffer(s.getOutputStream()));
            }
            catch (IOException ex) {
                if (ONS.debug) {
                    ONS.errstream.println(this.id + "::run ==> caught exception trying to send element");
                    ex.printStackTrace(ONS.errstream);
                }
                this.q.push(se);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runRemote() {
        while (!this.shutdown) {
            Socket s;
            if (this.quiescent) {
                while (this.quiescent && !this.shutdown) {
                    try {
                        SenderThread.sleep(500L);
                    }
                    catch (Exception ex) {}
                }
            }
            Notification e = null;
            SendElement se = (SendElement)this.q.dequeue(false);
            if (se == null) {
                e = this.oems.getFirstPublished(this);
                if (e == null) {
                    if (ONS.debug) {
                        ONS.outstream.println(this.id + "::run ==> waiting on local queue");
                    }
                    Object ex = this.lock;
                    synchronized (ex) {
                        this.waitQ = true;
                    }
                    se = (SendElement)this.q.dequeue(true);
                    ex = this.lock;
                    synchronized (ex) {
                        this.waitQ = false;
                    }
                    if (se == null) {
                        continue;
                    }
                } else {
                    se = new SendElement(e);
                }
            }
            if (ONS.debug) {
                if (e != null) {
                    ONS.outstream.println(this.id + "::run ==> have an event:\n" + se);
                } else {
                    ONS.outstream.println(this.id + "::run ==> have a subscription:\n" + se);
                }
            }
            if ((s = this.connection.getClientSocket(false)) == null) {
                if (ONS.debug) {
                    ONS.outstream.println(this.id + "::run ==> no socket");
                }
                this.oems.clearPublishedSender(this);
                se = null;
                e = null;
                s = this.connection.getClientSocket(true);
                continue;
            }
            if (ONS.debug) {
                ONS.outstream.println(this.id + "::run ==> have socket: " + s);
            }
            try {
                if (ONS.debug) {
                    ONS.outstream.println(this.id + "::run ==> send element");
                }
                if (se.e != null) {
                    se.e.send(new OutputBuffer(s.getOutputStream()), this.connection);
                    this.oems.removeFirstPublished(se.e, this);
                    continue;
                }
                if (se.s == null) continue;
                se.s.send(new OutputBuffer(s.getOutputStream()));
            }
            catch (IOException ex) {
                if (ONS.debug) {
                    ONS.errstream.println(this.id + "::run ==> caught exception trying to send element");
                    ex.printStackTrace(ONS.errstream);
                }
                this.oems.clearPublishedSender(this);
            }
        }
        this.oems.clearPublishedSender(this);
    }

    protected void send(Notification e) {
        SendElement se = new SendElement(e);
        if (ONS.debug) {
            ONS.outstream.println(this.id + "::send ==> queueing notification:\n" + e);
        }
        this.q.enqueue(se);
    }

    protected void send(SubscriptionNotification e) {
        SendElement se = new SendElement(e);
        if (ONS.debug) {
            ONS.outstream.println(this.id + "::send ==> queueing SubscriptionNotification:\n" + e);
        }
        this.q.enqueue(se);
    }

    protected void send(SubscriptionNotification e, int p) {
        SendElement se = new SendElement(e);
        if (ONS.debug) {
            ONS.outstream.println(this.id + "::send ==> priority " + p + ": pushing SubscriptionNotification:\n" + e);
        }
        this.q.push(se, p);
    }

    protected void shutdown() {
        if (ONS.debug) {
            ONS.outstream.println(this.id + "::shutdown");
        }
        try {
            this.q.drain_and_close();
            this.shutdown = true;
            this.quiescent = false;
        }
        catch (Exception e) {
            ONS.errstream.println(this.id + "::shutdown ==> exception draining queue");
            e.printStackTrace(ONS.errstream);
        }
    }

    protected void quiescent(boolean status) {
        this.quiescent = status;
    }

    protected void stopThread() {
        if (ONS.debug) {
            ONS.outstream.println(this.id + "::stopThread");
        }
        this.shutdown = true;
        this.quiescent = false;
        this.wakeThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void wakeThread() {
        if (ONS.debug) {
            ONS.outstream.println(this.id + "::wakeThread");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.waitQ) {
                this.q.wake();
            }
        }
    }

    protected void flushSenderQueue() {
        SendElement se;
        while ((se = (SendElement)this.q.dequeue(false)) != null) {
            se = null;
        }
    }
}

