/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import oracle.ons.CallBack;
import oracle.ons.CallBackThread;
import oracle.ons.Notification;
import oracle.ons.NotificationQueue;
import oracle.ons.ONS;
import oracle.ons.ONSException;
import oracle.ons.PublishPermission;
import oracle.ons.Publisher;
import oracle.ons.SubscribePermission;
import oracle.ons.SubscriptionException;

public class Subscriber {
    private String subscription;
    private String component;
    private Publisher pub;
    private ONS oems;
    private boolean closed;
    private int id;
    private NotificationQueue queue;
    private CallBack cb;
    private int cbmode;
    private Object cblock;
    private int numcbthreads;
    private CallBackThread cbthread;
    public static final int CBMODE_ONETHREAD = 1;
    public static final int CBMODE_THREADPERCB = 2;

    public Subscriber(String s, String c) throws SubscriptionException, ONSException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new SubscribePermission("ONSUser"));
        }
        this.oems = ONS.getONS();
        this.realStartup(s, c, -1L);
    }

    public Subscriber(String s, String c, long timeout) throws SubscriptionException, ONSException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new SubscribePermission("ONSUser"));
        }
        this.oems = ONS.getONS();
        this.realStartup(s, c, timeout);
    }

    Subscriber(ONS o, String s, String c) {
        this.oems = o;
        this.realStartup(s, c, -1L);
    }

    Subscriber(ONS o, String s, String c, long timeout) {
        this.oems = o;
        this.realStartup(s, c, timeout);
    }

    private void realStartup(String s, String c, long timeout) {
        this.subscription = s;
        this.pub = new Publisher(this.oems, c);
        this.component = c;
        this.closed = false;
        this.id = -1;
        this.queue = new NotificationQueue();
        this.oems.addSubscriber(this, timeout);
        this.cb = null;
        this.cbmode = 0;
        this.cblock = new Object();
        this.numcbthreads = 0;
    }

    public Publisher getPublisher() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new PublishPermission("ONSUser"));
        }
        return this.pub;
    }

    public Notification receive(boolean blocking) {
        return (Notification)this.queue.dequeue(blocking);
    }

    public Notification receive(long wait) {
        return (Notification)this.queue.dequeue(wait);
    }

    public void close() {
        if (this.cb != null) {
            this.cancel_callback();
        }
        this.closed = true;
        this.oems.removeSubscriber(this.id);
        this.pub.close();
        this.queue.close();
    }

    public void relinquish(Notification e) {
    }

    public String subscription() {
        return this.subscription;
    }

    public String component() {
        return this.component;
    }

    public int id() {
        return this.id;
    }

    protected void setID(int i) {
        this.id = i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deliver(Notification n) {
        if (this.cb != null && this.cbmode == 2) {
            CallBackThread cbt = new CallBackThread(this, this.cb, n);
            Object object = this.cblock;
            synchronized (object) {
                --this.numcbthreads;
            }
            cbt.start();
        } else {
            this.queue.enqueue(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register_callback(CallBack c, int mode) throws SubscriptionException {
        if (this.cb != null) {
            throw new SubscriptionException("Callback object already registered");
        }
        this.cb = c;
        this.cbmode = mode;
        if (mode == 1) {
            this.cbthread = new CallBackThread(this, c);
            Object object = this.cblock;
            synchronized (object) {
                --this.numcbthreads;
            }
            this.cbthread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel_callback() throws SubscriptionException {
        int numthreads;
        if (this.cb == null) {
            throw new SubscriptionException("No callback object registered");
        }
        this.cb = null;
        if (this.cbmode == 1) {
            this.cbthread.set_shutdown();
        }
        Object object = this.cblock;
        synchronized (object) {
            numthreads = this.numcbthreads;
        }
        while (numthreads > 0) {
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            object = this.cblock;
            synchronized (object) {
                numthreads = this.numcbthreads;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cbthread_exit() {
        Object object = this.cblock;
        synchronized (object) {
            --this.numcbthreads;
        }
    }
}

