/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins;

import io.takari.maven.plugins.TakariLifecycleMojo;
import io.takari.maven.plugins.util.AetherUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.installation.InstallRequest;
import org.eclipse.aether.installation.InstallationException;
import org.eclipse.aether.util.artifact.SubArtifact;

@Mojo(name="install", defaultPhase=LifecyclePhase.INSTALL, configurator="takari")
public class Install
extends TakariLifecycleMojo {
    @Override
    public void executeMojo() throws MojoExecutionException {
        this.installProject(this.project);
    }

    private void installProject(MavenProject project) throws MojoExecutionException {
        Artifact artifact;
        InstallRequest installRequest = new InstallRequest();
        if ("pom".equals(project.getPackaging())) {
            artifact = AetherUtils.toArtifact(project.getArtifact());
            artifact = artifact.setFile(project.getFile());
            installRequest.addArtifact(artifact);
        } else {
            artifact = AetherUtils.toArtifact(project.getArtifact());
            installRequest.addArtifact(artifact);
            SubArtifact pomArtifact = new SubArtifact(artifact, "", "pom");
            pomArtifact = pomArtifact.setFile(project.getFile());
            installRequest.addArtifact((Artifact)pomArtifact);
        }
        for (org.apache.maven.artifact.Artifact attachedArtifact : project.getAttachedArtifacts()) {
            installRequest.addArtifact(AetherUtils.toArtifact(attachedArtifact));
        }
        try {
            this.repositorySystem.install(this.repositorySystemSession, installRequest);
        }
        catch (InstallationException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }
}

