/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins.compile.jdt;

import com.google.common.base.Stopwatch;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import io.takari.incrementalbuild.MessageSeverity;
import io.takari.incrementalbuild.Output;
import io.takari.incrementalbuild.Resource;
import io.takari.incrementalbuild.ResourceMetadata;
import io.takari.incrementalbuild.ResourceStatus;
import io.takari.maven.plugins.compile.AbstractCompileMojo;
import io.takari.maven.plugins.compile.AbstractCompiler;
import io.takari.maven.plugins.compile.CompilerBuildContext;
import io.takari.maven.plugins.compile.ProjectClasspathDigester;
import io.takari.maven.plugins.compile.jdt.AccessRestrictionClasspathEntry;
import io.takari.maven.plugins.compile.jdt.AnnotationProcessorManager;
import io.takari.maven.plugins.compile.jdt.ClassfileDigester;
import io.takari.maven.plugins.compile.jdt.ClasspathDigester;
import io.takari.maven.plugins.compile.jdt.ClasspathEntryCache;
import io.takari.maven.plugins.compile.jdt.OutputDirectoryClasspathEntry;
import io.takari.maven.plugins.compile.jdt.ProcessingEnvImpl;
import io.takari.maven.plugins.compile.jdt.ReferenceCollection;
import io.takari.maven.plugins.compile.jdt.classpath.Classpath;
import io.takari.maven.plugins.compile.jdt.classpath.ClasspathDirectory;
import io.takari.maven.plugins.compile.jdt.classpath.ClasspathEntry;
import io.takari.maven.plugins.compile.jdt.classpath.DependencyClasspathEntry;
import io.takari.maven.plugins.compile.jdt.classpath.JavaInstallation;
import io.takari.maven.plugins.compile.jdt.classpath.MutableClasspathEntry;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import javax.tools.JavaFileManager;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import org.apache.maven.plugin.MojoExecutionException;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.apt.util.EclipseFileManager;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.IrritantSet;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblem;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.jdt.internal.core.builder.ProblemFactory;

@Named(value="jdt")
public class CompilerJdt
extends AbstractCompiler
implements ICompilerRequestor {
    public static final String ID = "jdt";
    private static final String ATTR_CLASS_DIGEST = "jdt.class.digest";
    private static final String ATTR_CLASSPATH_DIGEST = "jdt.classpath.digest";
    private static final String ATTR_REFERENCES = "jdt.references";
    private List<File> dependencies;
    private List<File> processorpath;
    private boolean lenientProcOnly;
    private Classpath dependencypath;
    private final Map<File, ResourceMetadata<File>> sources = new LinkedHashMap<File, ResourceMetadata<File>>();
    private final Map<File, ICompilationUnit> compileQueue = new LinkedHashMap<File, ICompilationUnit>();
    private final ClassfileDigester digester = new ClassfileDigester();
    private final ClasspathEntryCache classpathCache;
    private final ClasspathDigester classpathDigester;
    private final ProjectClasspathDigester processorpathDigester;
    private CompilationStrategy strategy;

    @Inject
    public CompilerJdt(CompilerBuildContext context, ClasspathEntryCache classpathCache, ClasspathDigester classpathDigester, ProjectClasspathDigester processorpathDigester) {
        super(context);
        this.classpathCache = classpathCache;
        this.classpathDigester = classpathDigester;
        this.processorpathDigester = processorpathDigester;
        this.strategy = context.isEscalated() ? new FullCompilationStrategy() : new IncrementalCompilationStrategy();
    }

    @Override
    public int compile() throws MojoExecutionException, IOException {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", this.getTarget());
        args.put("org.eclipse.jdt.core.compiler.compliance", this.getTarget());
        args.put("org.eclipse.jdt.core.compiler.source", this.getSource());
        args.put("org.eclipse.jdt.core.compiler.problem.forbiddenReference", "error");
        Set<AbstractCompileMojo.Debug> debug = this.getDebug();
        if (debug == null || debug.contains((Object)AbstractCompileMojo.Debug.all)) {
            args.put("org.eclipse.jdt.core.compiler.debug.localVariable", "generate");
            args.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
            args.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
        } else if (debug.contains((Object)AbstractCompileMojo.Debug.none)) {
            args.put("org.eclipse.jdt.core.compiler.debug.localVariable", "do not generate");
            args.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "do not generate");
            args.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "do not generate");
        } else {
            args.put("org.eclipse.jdt.core.compiler.debug.localVariable", "do not generate");
            args.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "do not generate");
            args.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "do not generate");
            for (AbstractCompileMojo.Debug keyword : debug) {
                switch (keyword) {
                    case lines: {
                        args.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
                        break;
                    }
                    case source: {
                        args.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
                        break;
                    }
                    case vars: {
                        args.put("org.eclipse.jdt.core.compiler.debug.localVariable", "generate");
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
        }
        class _CompilerOptions
        extends CompilerOptions {
            _CompilerOptions() {
            }

            public void setShowWarnings(boolean showWarnings) {
                this.warningThreshold = showWarnings ? IrritantSet.COMPILER_DEFAULT_WARNINGS : new IrritantSet(0);
            }
        }
        _CompilerOptions compilerOptions = new _CompilerOptions();
        compilerOptions.set(args);
        compilerOptions.performMethodsFullRecovery = false;
        compilerOptions.performStatementsRecovery = false;
        compilerOptions.verbose = this.isVerbose();
        compilerOptions.suppressWarnings = true;
        compilerOptions.setShowWarnings(this.isShowWarnings());
        compilerOptions.docCommentSupport = true;
        if (this.isProcEscalate() && this.strategy instanceof IncrementalCompilationStrategy) {
            this.strategy.enqueueAllSources();
            this.strategy = new FullCompilationStrategy();
        }
        Classpath namingEnvironment = this.strategy.createClasspath();
        IErrorHandlingPolicy errorHandlingPolicy = DefaultErrorHandlingPolicies.exitAfterAllProblems();
        ProblemFactory problemFactory = ProblemFactory.getProblemFactory((Locale)Locale.getDefault());
        Compiler compiler = new Compiler((INameEnvironment)namingEnvironment, errorHandlingPolicy, (CompilerOptions)compilerOptions, (ICompilerRequestor)this, (IProblemFactory)problemFactory);
        compiler.options.produceReferenceInfo = true;
        EclipseFileManager fileManager = null;
        try {
            if (!this.isProcNone()) {
                fileManager = new EclipseFileManager(null, this.getSourceEncoding());
                fileManager.setLocation((JavaFileManager.Location)StandardLocation.ANNOTATION_PROCESSOR_PATH, this.dependencies);
                fileManager.setLocation((JavaFileManager.Location)StandardLocation.CLASS_OUTPUT, Collections.singleton(this.getOutputDirectory()));
                fileManager.setLocation((JavaFileManager.Location)StandardLocation.SOURCE_OUTPUT, Collections.singleton(this.getGeneratedSourcesDirectory()));
                ProcessingEnvImpl processingEnv = new ProcessingEnvImpl(this.context, (StandardJavaFileManager)fileManager, this.getAnnotationProcessorOptions(), compiler, this);
                compiler.annotationProcessorManager = new AnnotationProcessorManager(processingEnv, (StandardJavaFileManager)fileManager, this.getAnnotationProcessors());
                compiler.options.storeAnnotations = true;
            }
            int n = this.strategy.compile(namingEnvironment, compiler);
            return n;
        }
        finally {
            if (fileManager != null) {
                fileManager.flush();
                fileManager.close();
            }
        }
    }

    @Override
    public boolean setSources(List<ResourceMetadata<File>> sources) throws IOException {
        return this.strategy.setSources(sources);
    }

    private CompilationUnit newSourceFile(File source) {
        String fileName = source.getAbsolutePath();
        String encoding = this.getSourceEncoding() != null ? this.getSourceEncoding().name() : null;
        return new CompilationUnit(null, fileName, encoding, this.getOutputDirectory().getAbsolutePath(), false);
    }

    private Classpath createClasspath(Collection<File> staleOutputs) throws IOException {
        ArrayList<ClasspathEntry> entries = new ArrayList<ClasspathEntry>();
        ArrayList<MutableClasspathEntry> mutableentries = new ArrayList<MutableClasspathEntry>();
        for (File file : JavaInstallation.getDefault().getClasspath()) {
            DependencyClasspathEntry entry = this.classpathCache.get(file);
            if (entry == null) continue;
            entries.add(entry);
        }
        if (!this.isProcOnly()) {
            OutputDirectoryClasspathEntry output = new OutputDirectoryClasspathEntry(this.getOutputDirectory(), staleOutputs);
            entries.add(output);
            mutableentries.add(output);
        }
        entries.addAll(this.dependencypath.getEntries());
        return new Classpath(entries, mutableentries);
    }

    @Override
    public boolean setClasspath(List<File> dependencies, File mainClasses, Set<File> directDependencies) throws IOException {
        DependencyClasspathEntry entry;
        this.dependencies = dependencies;
        ArrayList<ClasspathEntry> dependencypath = new ArrayList<ClasspathEntry>();
        ArrayList<File> files = new ArrayList<File>();
        if (this.isProcOnly() && (entry = ClasspathDirectory.create(this.getOutputDirectory())) != null) {
            dependencypath.add(AccessRestrictionClasspathEntry.allowAll(entry));
            files.add(this.getOutputDirectory());
        }
        if (mainClasses != null && (entry = this.classpathCache.get(mainClasses)) != null) {
            dependencypath.add(AccessRestrictionClasspathEntry.allowAll(entry));
            files.add(mainClasses);
        }
        for (File dependency : dependencies) {
            DependencyClasspathEntry entry2 = this.classpathCache.get(dependency);
            if (entry2 == null) continue;
            if (this.getTransitiveDependencyReference() == AbstractCompileMojo.AccessRulesViolation.error && !directDependencies.contains(dependency)) {
                dependencypath.add(AccessRestrictionClasspathEntry.forbidAll(entry2));
            } else if (this.getPrivatePackageReference() == AbstractCompileMojo.AccessRulesViolation.ignore) {
                dependencypath.add(AccessRestrictionClasspathEntry.allowAll(entry2));
            } else {
                dependencypath.add(entry2);
            }
            files.add(dependency);
        }
        if (this.log.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            for (ClasspathEntry element : dependencypath) {
                msg.append("\n\u2002\u2002 ").append(element.getEntryDescription());
            }
            this.log.debug("Compile classpath: {} entries{}", (Object)dependencies.size(), (Object)msg.toString());
        }
        this.dependencypath = new Classpath(dependencypath, null);
        Stopwatch stopwatch = Stopwatch.createStarted();
        long typecount = 0L;
        long packagecount = 0L;
        HashMap<String, byte[]> digest = this.classpathDigester.digestDependencies(files);
        Map oldDigest = (Map)((Object)this.context.setAttribute(ATTR_CLASSPATH_DIGEST, digest));
        this.log.debug("Digested {} types and {} packages in {} ms", new Object[]{typecount, packagecount, stopwatch.elapsed(TimeUnit.MILLISECONDS)});
        this.strategy.enqueueAffectedSources(digest, oldDigest);
        return !this.compileQueue.isEmpty();
    }

    @Override
    public boolean setProcessorpath(List<File> processorpath) throws IOException {
        if (processorpath == null) {
            this.processorpath = this.dependencies;
        } else if (processorpath.isEmpty()) {
            this.processorpath = Collections.emptyList();
        } else {
            throw new IllegalArgumentException();
        }
        if (!this.isProcNone() && this.processorpathDigester.digestProcessorpath(this.processorpath)) {
            this.log.debug("Annotation processor path changed, recompiling all sources");
            this.strategy.enqueueAllSources();
        }
        return !this.compileQueue.isEmpty();
    }

    @Override
    public void setLenientProcOnly(boolean lenient) {
        this.lenientProcOnly = lenient;
    }

    public void acceptResult(CompilationResult result) {
        int n;
        int n2;
        CategorizedProblem[] categorizedProblemArray;
        if (result == null) {
            return;
        }
        String sourceName = new String(result.getFileName());
        File sourceFile = new File(sourceName);
        Resource<File> input = this.context.getProcessedSource(sourceFile);
        if (result.rootReferences != null && result.qualifiedReferences != null && result.simpleNameReferences != null) {
            this.context.setAttribute((File)input.getResource(), ATTR_REFERENCES, new ReferenceCollection(result.rootReferences, result.qualifiedReferences, result.simpleNameReferences));
        }
        if (result.hasProblems() && (!this.isLenientProcOnly() || this.isShowWarnings())) {
            categorizedProblemArray = result.getProblems();
            n2 = categorizedProblemArray.length;
            n = 0;
            while (n < n2) {
                CategorizedProblem problem = categorizedProblemArray[n];
                MessageSeverity severity = this.isLenientProcOnly() ? MessageSeverity.WARNING : (problem.isError() ? MessageSeverity.ERROR : MessageSeverity.WARNING);
                input.addMessage(problem.getSourceLineNumber(), ((DefaultProblem)problem).column, problem.getMessage(), severity, null);
                ++n;
            }
        }
        try {
            if (!result.hasErrors() && !this.isProcOnly()) {
                categorizedProblemArray = result.getClassFiles();
                n2 = categorizedProblemArray.length;
                n = 0;
                while (n < n2) {
                    CategorizedProblem classFile = categorizedProblemArray[n];
                    char[] filename = classFile.fileName();
                    int length = filename.length;
                    char[] relativeName = new char[length + 6];
                    System.arraycopy(filename, 0, relativeName, 0, length);
                    System.arraycopy(SuffixConstants.SUFFIX_class, 0, relativeName, length, 6);
                    CharOperation.replace((char[])relativeName, (char)'/', (char)File.separatorChar);
                    String relativeStringName = new String(relativeName);
                    this.writeClassFile(input, relativeStringName, (ClassFile)classFile);
                    ++n;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean isProcOnly() {
        return this.getProc() == AbstractCompileMojo.Proc.only || this.getProc() == AbstractCompileMojo.Proc.onlyEX;
    }

    private boolean isProcNone() {
        return this.getProc() == AbstractCompileMojo.Proc.none;
    }

    private boolean isProcEscalate() {
        return this.getProc() == AbstractCompileMojo.Proc.procEX || this.getProc() == AbstractCompileMojo.Proc.onlyEX;
    }

    private boolean isLenientProcOnly() {
        return this.lenientProcOnly && this.isProcOnly();
    }

    private void writeClassFile(Resource<File> input, String relativeStringName, ClassFile classFile) throws IOException {
        byte[] bytes = classFile.getBytes();
        File outputFile = new File(this.getOutputDirectory(), relativeStringName);
        Output<File> output = this.context.associatedOutput(input, outputFile);
        boolean significantChange = this.digestClassFile(output, bytes);
        if (significantChange) {
            this.strategy.addDependentsOf(CharOperation.toString((char[][])classFile.getCompoundName()));
        }
        try (BufferedOutputStream os = new BufferedOutputStream(output.newOutputStream());){
            os.write(bytes);
            os.flush();
        }
    }

    private boolean digestClassFile(Output<File> output, byte[] definition) {
        boolean significantChange = true;
        try {
            ClassFileReader reader = new ClassFileReader(definition, ((File)output.getResource()).getAbsolutePath().toCharArray());
            byte[] hash = this.digester.digest((IBinaryType)reader);
            if (hash != null) {
                byte[] oldHash = (byte[])this.context.setAttribute((File)output.getResource(), ATTR_CLASS_DIGEST, hash);
                significantChange = oldHash == null || !Arrays.equals(hash, oldHash);
            }
        }
        catch (ClassFormatException classFormatException) {}
        return significantChange;
    }

    public void addGeneratedSource(Output<File> generatedSource) {
        this.strategy.addGeneratedSource(generatedSource);
    }

    private abstract class CompilationStrategy {
        protected final Multimap<File, File> sourceOutputs = HashMultimap.create();

        private CompilationStrategy() {
        }

        public abstract boolean setSources(List<ResourceMetadata<File>> var1) throws IOException;

        public abstract void enqueueAffectedSources(HashMap<String, byte[]> var1, Map<String, byte[]> var2) throws IOException;

        public abstract void enqueueAllSources() throws IOException;

        public abstract void addDependentsOf(String var1);

        protected abstract void addDependentsOf(File var1);

        public abstract int compile(Classpath var1, Compiler var2) throws IOException;

        public Classpath createClasspath() throws IOException {
            return CompilerJdt.this.createClasspath(this.sourceOutputs.values());
        }

        public abstract void addGeneratedSource(Output<File> var1);

        protected boolean deleteOrphanedOutputs() throws IOException {
            boolean changed = false;
            for (ResourceMetadata<File> source : CompilerJdt.this.context.getRemovedSources()) {
                for (ResourceMetadata<File> output : CompilerJdt.this.context.getAssociatedOutputs(source)) {
                    File outputFile = (File)output.getResource();
                    CompilerJdt.this.context.deleteOutput(outputFile);
                    this.addDependentsOf(outputFile);
                    changed = true;
                }
            }
            return changed;
        }

        protected boolean deleteStaleOutputs() throws IOException {
            boolean changed = false;
            for (File sourceFile : this.sourceOutputs.keySet()) {
                for (File associatedOutput : this.sourceOutputs.get((Object)sourceFile)) {
                    if (CompilerJdt.this.context.isProcessedOutput(associatedOutput)) continue;
                    CompilerJdt.this.context.deleteOutput(associatedOutput);
                    this.addDependentsOf(associatedOutput);
                    changed = true;
                }
            }
            return changed;
        }

        protected void processSources() {
            this.sourceOutputs.clear();
            for (File sourceFile : CompilerJdt.this.compileQueue.keySet()) {
                ResourceMetadata source = (ResourceMetadata)CompilerJdt.this.sources.get(sourceFile);
                for (ResourceMetadata<File> output : CompilerJdt.this.context.getAssociatedOutputs((ResourceMetadata<File>)source)) {
                    this.sourceOutputs.put((Object)sourceFile, (Object)((File)output.getResource()));
                }
                CompilerJdt.this.sources.put((File)source.getResource(), source.process());
            }
        }
    }

    private class FullCompilationStrategy
    extends CompilationStrategy {
        private FullCompilationStrategy() {
        }

        @Override
        public boolean setSources(List<ResourceMetadata<File>> sources) throws IOException {
            for (ResourceMetadata<File> source : sources) {
                File sourceFile = (File)source.getResource();
                CompilerJdt.this.sources.put(sourceFile, source);
                CompilerJdt.this.compileQueue.put(sourceFile, CompilerJdt.this.newSourceFile(sourceFile));
            }
            this.deleteOrphanedOutputs();
            return true;
        }

        @Override
        public void enqueueAffectedSources(HashMap<String, byte[]> digest, Map<String, byte[]> oldDigest) throws IOException {
        }

        @Override
        public void enqueueAllSources() throws IOException {
        }

        @Override
        public void addDependentsOf(String string) {
        }

        @Override
        protected void addDependentsOf(File resource) {
        }

        @Override
        public int compile(Classpath namingEnvironment, Compiler compiler) throws IOException {
            if (!CompilerJdt.this.compileQueue.isEmpty()) {
                this.processSources();
                ICompilationUnit[] compilationUnits = CompilerJdt.this.compileQueue.values().toArray(new ICompilationUnit[CompilerJdt.this.compileQueue.size()]);
                compiler.compile(compilationUnits);
                this.deleteStaleOutputs();
            }
            return CompilerJdt.this.compileQueue.size();
        }

        @Override
        public void addGeneratedSource(Output<File> generatedSource) {
        }
    }

    private class IncrementalCompilationStrategy
    extends CompilationStrategy {
        private final Set<File> processedQueue = new HashSet<File>();
        private final Multiset<File> processedSources = HashMultiset.create();
        private final Set<String> rootNames = new LinkedHashSet<String>();
        private final Set<String> qualifiedNames = new LinkedHashSet<String>();
        private final Set<String> simpleNames = new LinkedHashSet<String>();

        private IncrementalCompilationStrategy() {
        }

        @Override
        public int compile(Classpath namingEnvironment, Compiler compiler) throws IOException {
            while (!CompilerJdt.this.compileQueue.isEmpty()) {
                this.processedQueue.clear();
                this.processedQueue.addAll(CompilerJdt.this.compileQueue.keySet());
                this.processSources();
                ICompilationUnit[] compilationUnits = CompilerJdt.this.compileQueue.values().toArray(new ICompilationUnit[CompilerJdt.this.compileQueue.size()]);
                CompilerJdt.this.compileQueue.clear();
                compiler.compile(compilationUnits);
                namingEnvironment.reset();
                if (compiler.annotationProcessorManager != null) {
                    ((AnnotationProcessorManager)compiler.annotationProcessorManager).hardReset();
                }
                this.deleteStaleOutputs();
                this.enqueueAffectedSources();
            }
            return this.processedSources.size();
        }

        @Override
        protected void addDependentsOf(File resource) {
            this.addDependentsOf(this.getJavaType(resource));
        }

        @Override
        public boolean setSources(List<ResourceMetadata<File>> sources) throws IOException {
            for (ResourceMetadata<File> source : sources) {
                CompilerJdt.this.sources.put((File)source.getResource(), source);
                if (source.getStatus() == ResourceStatus.UNMODIFIED) continue;
                this.enqueue(source);
            }
            boolean compilationRequired = false;
            compilationRequired = this.deleteOrphanedOutputs() || compilationRequired;
            this.enqueueAffectedSources();
            return compilationRequired || !CompilerJdt.this.compileQueue.isEmpty();
        }

        private void enqueueAffectedSources() throws IOException {
            for (ResourceMetadata input : CompilerJdt.this.sources.values()) {
                ReferenceCollection references;
                File resource = (File)input.getResource();
                if (this.processedQueue.contains(resource) || !resource.canRead() || (references = CompilerJdt.this.context.getAttribute(resource, CompilerJdt.ATTR_REFERENCES, ReferenceCollection.class)) == null || !references.includes(this.qualifiedNames, this.simpleNames, this.rootNames)) continue;
                this.enqueue((ResourceMetadata<File>)input);
            }
            this.qualifiedNames.clear();
            this.simpleNames.clear();
            this.rootNames.clear();
        }

        private String getJavaType(File outputFile) {
            String outputDirectory = CompilerJdt.this.getOutputDirectory().getAbsolutePath();
            String path = outputFile.getAbsolutePath();
            if (!path.startsWith(outputDirectory) || !path.endsWith(".class")) {
                return null;
            }
            if ((path = path.substring(outputDirectory.length(), path.length() - ".class".length())).startsWith(File.separator)) {
                path = path.substring(1);
            }
            return path.replace(File.separatorChar, '.');
        }

        @Override
        public void enqueueAllSources() throws IOException {
            for (ResourceMetadata input : CompilerJdt.this.sources.values()) {
                File resource = (File)input.getResource();
                if (this.processedQueue.contains(resource) || !resource.canRead()) continue;
                this.enqueue((ResourceMetadata<File>)input);
            }
            this.qualifiedNames.clear();
            this.simpleNames.clear();
            this.rootNames.clear();
        }

        @Override
        public void addDependentsOf(String typeOrPackage) {
            if (typeOrPackage != null) {
                int idx = typeOrPackage.indexOf(46);
                if (idx > 0) {
                    this.rootNames.add(typeOrPackage.substring(0, idx));
                    idx = typeOrPackage.lastIndexOf(46);
                    this.qualifiedNames.add(typeOrPackage.substring(0, idx));
                    this.simpleNames.add(typeOrPackage.substring(idx + 1));
                } else {
                    this.rootNames.add(typeOrPackage);
                    this.simpleNames.add(typeOrPackage);
                }
            }
        }

        private void enqueue(ResourceMetadata<File> input) {
            File sourceFile = (File)input.getResource();
            if (this.processedSources.count((Object)sourceFile) > 10) {
                throw new IllegalStateException("Too many recompiles " + sourceFile);
            }
            this.processedSources.add((Object)sourceFile);
            CompilerJdt.this.compileQueue.put(sourceFile, CompilerJdt.this.newSourceFile(sourceFile));
        }

        @Override
        public void enqueueAffectedSources(HashMap<String, byte[]> digest, Map<String, byte[]> oldDigest) throws IOException {
            if (oldDigest != null) {
                HashSet<String> changedPackages = new HashSet<String>();
                for (Map.Entry<String, byte[]> entry : digest.entrySet()) {
                    String type = entry.getKey();
                    byte[] hash = entry.getValue();
                    if (!Arrays.equals(hash, oldDigest.get(type))) {
                        this.addDependentsOf(type);
                    }
                    changedPackages.add(this.getPackage(type));
                }
                for (String oldType : oldDigest.keySet()) {
                    if (!digest.containsKey(oldType)) {
                        this.addDependentsOf(oldType);
                    }
                    changedPackages.remove(this.getPackage(oldType));
                }
                for (String changedPackage : changedPackages) {
                    this.addDependentsOf(changedPackage);
                }
                this.enqueueAffectedSources();
            }
        }

        private String getPackage(String type) {
            int idx = type.lastIndexOf(46);
            return idx > 0 ? type.substring(0, idx) : null;
        }

        @Override
        public void addGeneratedSource(Output<File> generatedSource) {
            CompilerJdt.this.sources.put((File)generatedSource.getResource(), generatedSource);
            this.processedQueue.add((File)generatedSource.getResource());
        }
    }
}

