/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.dependency;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.MavenArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.transfer.artifact.ArtifactCoordinate;
import org.apache.maven.shared.transfer.artifact.DefaultArtifactCoordinate;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolver;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolverException;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResult;
import org.apache.maven.shared.transfer.dependencies.DefaultDependableCoordinate;
import org.apache.maven.shared.transfer.dependencies.DependableCoordinate;
import org.apache.maven.shared.transfer.dependencies.resolve.DependencyResolver;
import org.apache.maven.shared.transfer.dependencies.resolve.DependencyResolverException;

@Mojo(name="list-classes", requiresProject=false, threadSafe=true)
public class ListClassesMojo
extends AbstractMojo {
    private static final Pattern ALT_REPO_SYNTAX_PATTERN = Pattern.compile("(.+)::(.*)::(.+)");
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession session;
    @Component
    private ArtifactResolver artifactResolver;
    @Component
    private DependencyResolver dependencyResolver;
    @Component
    private ArtifactHandlerManager artifactHandlerManager;
    @Component(role=ArtifactRepositoryLayout.class)
    private Map<String, ArtifactRepositoryLayout> repositoryLayouts;
    @Component
    private RepositorySystem repositorySystem;
    private DefaultDependableCoordinate coordinate = new DefaultDependableCoordinate();
    @Parameter(property="groupId")
    private String groupId;
    @Parameter(property="artifactId")
    private String artifactId;
    @Parameter(property="version")
    private String version;
    @Parameter(property="classifier")
    private String classifier;
    @Parameter(property="packaging", defaultValue="jar")
    private String packaging = "jar";
    @Parameter(property="remoteRepositories")
    private String remoteRepositories;
    @Parameter(property="artifact")
    private String artifact;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", readonly=true, required=true)
    private List<ArtifactRepository> pomRemoteRepositories;
    @Parameter(property="transitive", defaultValue="false")
    private boolean transitive = false;
    @Parameter(property="mdep.skip", defaultValue="false")
    private boolean skip;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping plugin execution");
            return;
        }
        ProjectBuildingRequest buildingRequest = this.makeBuildingRequest();
        try {
            if (this.transitive) {
                Iterable artifacts = this.dependencyResolver.resolveDependencies(buildingRequest, (DependableCoordinate)this.coordinate, null);
                for (ArtifactResult result : artifacts) {
                    this.printClassesFromArtifactResult(result);
                }
            } else {
                ArtifactResult result = this.artifactResolver.resolveArtifact(buildingRequest, this.toArtifactCoordinate((DependableCoordinate)this.coordinate));
                this.printClassesFromArtifactResult(result);
            }
        }
        catch (IOException | ArtifactResolverException | DependencyResolverException e) {
            throw new MojoExecutionException("Couldn't download artifact: " + e.getMessage(), (Exception)e);
        }
    }

    private void printClassesFromArtifactResult(ArtifactResult result) throws IOException {
        try (JarFile jarFile = new JarFile(result.getArtifact().getFile());){
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String entryName = entry.getName();
                if (!entryName.endsWith(".class")) continue;
                String className = entryName.substring(0, entryName.length() - 6).replace('/', '.');
                this.getLog().info((CharSequence)className);
            }
        }
    }

    boolean hasGAVSpecified() {
        return this.artifact != null || this.groupId != null && this.artifactId != null && this.version != null;
    }

    private ProjectBuildingRequest makeBuildingRequest() throws MojoExecutionException, MojoFailureException {
        String[] stringArray;
        if (!this.hasGAVSpecified()) {
            throw new MojoFailureException("You must specify an artifact OR GAV separately, e.g. -Dartifact=org.apache.maven.plugins:maven-downloader-plugin:1.0 OR -DgroupId=org.apache.maven.plugins -DartifactId=maven-downloader-plugin -Dversion=1.0");
        }
        if (this.artifact != null) {
            stringArray = this.artifact.split(":");
        } else if (this.classifier != null) {
            String[] stringArray2 = new String[5];
            stringArray2[0] = this.groupId;
            stringArray2[1] = this.artifactId;
            stringArray2[2] = this.version;
            stringArray2[3] = this.packaging;
            stringArray = stringArray2;
            stringArray2[4] = this.classifier;
        } else if (this.packaging != null) {
            String[] stringArray3 = new String[4];
            stringArray3[0] = this.groupId;
            stringArray3[1] = this.artifactId;
            stringArray3[2] = this.version;
            stringArray = stringArray3;
            stringArray3[3] = this.packaging;
        } else {
            String[] stringArray4 = new String[3];
            stringArray4[0] = this.groupId;
            stringArray4[1] = this.artifactId;
            stringArray = stringArray4;
            stringArray4[2] = this.version;
        }
        String[] tokens = stringArray;
        if (tokens.length < 3 || tokens.length > 5) {
            throw new MojoFailureException("Invalid artifact, you must specify groupId:artifactId:version[:packaging[:classifier]] " + this.artifact);
        }
        this.coordinate.setGroupId(tokens[0]);
        this.coordinate.setArtifactId(tokens[1]);
        this.coordinate.setVersion(tokens[2]);
        if (tokens.length >= 4) {
            this.coordinate.setType(tokens[3]);
        }
        if (tokens.length == 5) {
            this.coordinate.setClassifier(tokens[4]);
        }
        ArtifactRepositoryPolicy always = new ArtifactRepositoryPolicy(true, "always", "warn");
        ArrayList<ArtifactRepository> repoList = new ArrayList<ArtifactRepository>();
        if (this.pomRemoteRepositories != null) {
            repoList.addAll(this.pomRemoteRepositories);
        }
        if (this.remoteRepositories != null) {
            String[] repos;
            for (String repo : repos = this.remoteRepositories.split(",")) {
                repoList.add(this.parseRepository(repo, always));
            }
        }
        DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
        Settings settings = this.session.getSettings();
        this.repositorySystem.injectMirror(repoList, settings.getMirrors());
        this.repositorySystem.injectProxy(repoList, settings.getProxies());
        this.repositorySystem.injectAuthentication(repoList, settings.getServers());
        buildingRequest.setRemoteRepositories(repoList);
        return buildingRequest;
    }

    private ArtifactCoordinate toArtifactCoordinate(DependableCoordinate dependableCoordinate) {
        ArtifactHandler artifactHandler = this.artifactHandlerManager.getArtifactHandler(dependableCoordinate.getType());
        DefaultArtifactCoordinate artifactCoordinate = new DefaultArtifactCoordinate();
        artifactCoordinate.setGroupId(dependableCoordinate.getGroupId());
        artifactCoordinate.setArtifactId(dependableCoordinate.getArtifactId());
        artifactCoordinate.setVersion(dependableCoordinate.getVersion());
        artifactCoordinate.setClassifier(dependableCoordinate.getClassifier());
        artifactCoordinate.setExtension(artifactHandler.getExtension());
        return artifactCoordinate;
    }

    protected ArtifactRepository parseRepository(String repo, ArtifactRepositoryPolicy policy) throws MojoFailureException {
        String id = "temp";
        ArtifactRepositoryLayout layout = this.getLayout("default");
        if (repo.contains("::")) {
            Matcher matcher = ALT_REPO_SYNTAX_PATTERN.matcher(repo);
            if (!matcher.matches()) {
                throw new MojoFailureException((Object)repo, "Invalid syntax for repository: " + repo, "Invalid syntax for repository. Use \"id::layout::url\" or \"URL\".");
            }
            id = matcher.group(1).trim();
            if (matcher.group(2) != null && !matcher.group(2).trim().isEmpty()) {
                layout = this.getLayout(matcher.group(2).trim());
            }
            repo = matcher.group(3).trim();
        }
        return new MavenArtifactRepository(id, repo, layout, policy, policy);
    }

    private ArtifactRepositoryLayout getLayout(String id) throws MojoFailureException {
        ArtifactRepositoryLayout layout = this.repositoryLayouts.get(id);
        if (layout == null) {
            throw new MojoFailureException((Object)id, "Invalid repository layout", "Invalid repository layout: " + id);
        }
        return layout;
    }
}

