/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.resources;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.MavenResourcesExecution;
import org.apache.maven.shared.filtering.MavenResourcesFiltering;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;

public class ResourcesMojo
extends AbstractMojo {
    protected String encoding;
    private File outputDirectory;
    private List resources;
    protected MavenProject project;
    protected List filters;
    protected MavenResourcesFiltering mavenResourcesFiltering;
    protected MavenSession session;
    protected String escapeString;
    private boolean overwrite;
    protected boolean includeEmptyDirs;
    protected List nonFilteredFileExtensions;

    public void execute() throws MojoExecutionException {
        try {
            if (StringUtils.isEmpty((String)this.encoding) && this.isFilteringEnabled(this.getResources())) {
                this.getLog().warn((CharSequence)("File encoding has not been set, using platform encoding " + ReaderFactory.FILE_ENCODING + ", i.e. build is platform dependent!"));
            }
            MavenResourcesExecution mavenResourcesExecution = new MavenResourcesExecution(this.getResources(), this.getOutputDirectory(), this.project, this.encoding, this.filters, Collections.EMPTY_LIST, this.session);
            mavenResourcesExecution.setEscapeString(this.escapeString);
            mavenResourcesExecution.setOverwrite(this.overwrite);
            mavenResourcesExecution.setIncludeEmptyDirs(this.includeEmptyDirs);
            if (this.nonFilteredFileExtensions != null) {
                mavenResourcesExecution.setNonFilteredFileExtensions(this.nonFilteredFileExtensions);
            }
            this.mavenResourcesFiltering.filterResources(mavenResourcesExecution);
        }
        catch (MavenFilteringException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private boolean isFilteringEnabled(Collection resources) {
        if (resources != null) {
            Iterator i = resources.iterator();
            while (i.hasNext()) {
                Resource resource = (Resource)i.next();
                if (!resource.isFiltering()) continue;
                return true;
            }
        }
        return false;
    }

    public List getResources() {
        return this.resources;
    }

    public void setResources(List resources) {
        this.resources = resources;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public boolean isIncludeEmptyDirs() {
        return this.includeEmptyDirs;
    }

    public void setIncludeEmptyDirs(boolean includeEmptyDirs) {
        this.includeEmptyDirs = includeEmptyDirs;
    }
}

