/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.resources;

import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.api.ProjectScope;
import org.apache.maven.api.plugin.MojoException;
import org.apache.maven.api.plugin.annotations.Mojo;
import org.apache.maven.api.plugin.annotations.Parameter;
import org.apache.maven.api.services.ProjectManager;
import org.apache.maven.plugins.resources.ResourceUtils;
import org.apache.maven.plugins.resources.ResourcesMojo;
import org.apache.maven.shared.filtering.Resource;

@Mojo(name="testResources", defaultPhase="process-test-resources", projectRequired=true)
public class TestResourcesMojo
extends ResourcesMojo {
    @Parameter(defaultValue="${project.build.testOutputDirectory}", required=true)
    private Path outputDirectory;
    @Parameter
    private List<Resource> resources;
    @Parameter(property="maven.test.skip", defaultValue="false")
    private boolean skip;

    @Override
    public void execute() throws MojoException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Not copying test resources");
            return;
        }
        if (this.resources == null) {
            this.resources = ((ProjectManager)this.session.getService(ProjectManager.class)).getResources(this.project, ProjectScope.TEST).stream().map(ResourceUtils::newResource).collect(Collectors.toList());
        }
        super.doExecute();
    }

    @Override
    public Path getOutputDirectory() {
        return this.outputDirectory;
    }

    @Override
    public void setOutputDirectory(Path outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    @Override
    public List<Resource> getResources() {
        return this.resources;
    }

    @Override
    public void setResources(List<Resource> resources) {
        this.resources = resources;
    }
}

