/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.ssh.jsch;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.HostKey;
import com.jcraft.jsch.HostKeyRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.ProxyHTTP;
import com.jcraft.jsch.ProxySOCKS5;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.util.List;
import java.util.Properties;
import org.apache.maven.wagon.CommandExecutionException;
import org.apache.maven.wagon.CommandExecutor;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.StreamWagon;
import org.apache.maven.wagon.Streams;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.providers.ssh.CommandExecutorStreamProcessor;
import org.apache.maven.wagon.providers.ssh.ScpHelper;
import org.apache.maven.wagon.providers.ssh.SshWagon;
import org.apache.maven.wagon.providers.ssh.interactive.InteractiveUserInfo;
import org.apache.maven.wagon.providers.ssh.interactive.NullInteractiveUserInfo;
import org.apache.maven.wagon.providers.ssh.jsch.WagonUserInfo;
import org.apache.maven.wagon.providers.ssh.jsch.interactive.UserInfoUIKeyboardInteractiveProxy;
import org.apache.maven.wagon.providers.ssh.knownhost.KnownHostChangedException;
import org.apache.maven.wagon.providers.ssh.knownhost.KnownHostsProvider;
import org.apache.maven.wagon.providers.ssh.knownhost.UnknownHostException;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.resource.Resource;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringInputStream;

public abstract class AbstractJschWagon
extends StreamWagon
implements SshWagon,
CommandExecutor {
    protected ScpHelper sshTool = new ScpHelper((CommandExecutor)this);
    protected Session session;
    private KnownHostsProvider knownHostsProvider;
    private InteractiveUserInfo interactiveUserInfo;
    private UIKeyboardInteractive uIKeyboardInteractive;
    private static final int SOCKS5_PROXY_PORT = 1080;
    protected static final String EXEC_CHANNEL = "exec";

    public void openConnectionInternal() throws AuthenticationException {
        File privateKey;
        if (this.authenticationInfo == null) {
            this.authenticationInfo = new AuthenticationInfo();
        }
        if (!this.interactive) {
            this.uIKeyboardInteractive = null;
            this.setInteractiveUserInfo((InteractiveUserInfo)new NullInteractiveUserInfo());
        }
        JSch sch = new JSch();
        try {
            privateKey = ScpHelper.getPrivateKey((AuthenticationInfo)this.authenticationInfo);
        }
        catch (FileNotFoundException e) {
            throw new AuthenticationException(e.getMessage());
        }
        if (privateKey != null && privateKey.exists()) {
            this.fireSessionDebug("Using private key: " + privateKey);
            try {
                sch.addIdentity(privateKey.getAbsolutePath(), this.authenticationInfo.getPassphrase());
            }
            catch (JSchException e) {
                throw new AuthenticationException("Cannot connect. Reason: " + e.getMessage(), (Throwable)e);
            }
        }
        String host = this.getRepository().getHost();
        int port = this.repository.getPort() == -1 ? 22 : this.repository.getPort();
        try {
            String userName = this.authenticationInfo.getUserName();
            if (userName == null) {
                userName = System.getProperty("user.name");
            }
            this.session = sch.getSession(userName, host, port);
            this.session.setTimeout(this.getTimeout());
        }
        catch (JSchException e) {
            throw new AuthenticationException("Cannot connect. Reason: " + e.getMessage(), (Throwable)e);
        }
        ProxySOCKS5 proxy = null;
        ProxyInfo proxyInfo = this.getProxyInfo("SOCKS_5", this.getRepository().getHost());
        if (proxyInfo != null && proxyInfo.getHost() != null) {
            proxy = new ProxySOCKS5(proxyInfo.getHost(), proxyInfo.getPort());
            proxy.setUserPasswd(proxyInfo.getUserName(), proxyInfo.getPassword());
        } else {
            proxyInfo = this.getProxyInfo("HTTP", this.getRepository().getHost());
            if (proxyInfo != null && proxyInfo.getHost() != null) {
                proxy = new ProxyHTTP(proxyInfo.getHost(), proxyInfo.getPort());
                ((ProxyHTTP)proxy).setUserPasswd(proxyInfo.getUserName(), proxyInfo.getPassword());
            } else {
                proxyInfo = this.getProxyInfo(this.getRepository().getProtocol(), this.getRepository().getHost());
                if (proxyInfo != null && proxyInfo.getHost() != null) {
                    if (proxyInfo.getPort() == 1080) {
                        proxy = new ProxySOCKS5(proxyInfo.getHost(), proxyInfo.getPort());
                        proxy.setUserPasswd(proxyInfo.getUserName(), proxyInfo.getPassword());
                    } else {
                        proxy = new ProxyHTTP(proxyInfo.getHost(), proxyInfo.getPort());
                        ((ProxyHTTP)proxy).setUserPasswd(proxyInfo.getUserName(), proxyInfo.getPassword());
                    }
                }
            }
        }
        this.session.setProxy((Proxy)proxy);
        Object ui = new WagonUserInfo(this.authenticationInfo, this.getInteractiveUserInfo());
        if (this.uIKeyboardInteractive != null) {
            ui = new UserInfoUIKeyboardInteractiveProxy((UserInfo)ui, this.uIKeyboardInteractive);
        }
        Properties config = new Properties();
        if (this.getKnownHostsProvider() != null) {
            try {
                String contents = this.getKnownHostsProvider().getContents();
                if (contents != null) {
                    sch.setKnownHosts((InputStream)new StringInputStream(contents));
                }
            }
            catch (JSchException e) {
                // empty catch block
            }
            config.setProperty("StrictHostKeyChecking", this.getKnownHostsProvider().getHostKeyChecking());
        }
        if (this.authenticationInfo.getPassword() != null) {
            config.setProperty("PreferredAuthentications", "gssapi-with-mic,publickey,password,keyboard-interactive");
        }
        config.setProperty("BatchMode", this.interactive ? "no" : "yes");
        this.session.setConfig(config);
        this.session.setUserInfo((UserInfo)ui);
        StringWriter stringWriter = new StringWriter();
        try {
            this.session.connect();
            if (this.getKnownHostsProvider() != null) {
                PrintWriter w = new PrintWriter(stringWriter);
                HostKeyRepository hkr = sch.getHostKeyRepository();
                HostKey[] keys = hkr.getHostKey();
                for (int i = 0; keys != null && i < keys.length; ++i) {
                    HostKey key = keys[i];
                    w.println(key.getHost() + " " + key.getType() + " " + key.getKey());
                }
            }
        }
        catch (JSchException e) {
            if (e.getMessage().startsWith("UnknownHostKey:") || e.getMessage().startsWith("reject HostKey:")) {
                throw new UnknownHostException(host, (Throwable)e);
            }
            if (e.getMessage().indexOf("HostKey has been changed") >= 0) {
                throw new KnownHostChangedException(host, (Throwable)e);
            }
            throw new AuthenticationException("Cannot connect. Reason: " + e.getMessage(), (Throwable)e);
        }
        try {
            this.getKnownHostsProvider().storeKnownHosts(stringWriter.toString());
        }
        catch (IOException e) {
            this.closeConnection();
            throw new AuthenticationException("Connection aborted - failed to write to known_hosts. Reason: " + e.getMessage(), (Throwable)e);
        }
    }

    public void closeConnection() {
        if (this.session != null) {
            this.session.disconnect();
            this.session = null;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Streams executeCommand(String command, boolean ignoreFailures) throws CommandExecutionException {
        Streams streams;
        ChannelExec channel = null;
        BufferedReader stdoutReader = null;
        BufferedReader stderrReader = null;
        try {
            channel = (ChannelExec)this.session.openChannel(EXEC_CHANNEL);
            channel.setCommand(command + "\n");
            InputStream stdout = channel.getInputStream();
            InputStream stderr = channel.getErrStream();
            channel.connect();
            stdoutReader = new BufferedReader(new InputStreamReader(stdout));
            stderrReader = new BufferedReader(new InputStreamReader(stderr));
            Streams streams2 = CommandExecutorStreamProcessor.processStreams((BufferedReader)stderrReader, (BufferedReader)stdoutReader);
            if (streams2.getErr().length() > 0 && !ignoreFailures) {
                int exitCode = channel.getExitStatus();
                throw new CommandExecutionException("Exit code: " + exitCode + " - " + streams2.getErr());
            }
            streams = streams2;
        }
        catch (IOException e) {
            try {
                throw new CommandExecutionException("Cannot execute remote command: " + command, (Throwable)e);
                catch (JSchException e2) {
                    throw new CommandExecutionException("Cannot execute remote command: " + command, (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(stdoutReader);
                IOUtil.close(stderrReader);
                if (channel != null) {
                    channel.disconnect();
                }
                throw throwable;
            }
        }
        IOUtil.close((Reader)stdoutReader);
        IOUtil.close((Reader)stderrReader);
        if (channel != null) {
            channel.disconnect();
        }
        return streams;
    }

    protected void handleGetException(Resource resource, Exception e) throws TransferFailedException {
        this.fireTransferError(resource, e, 5);
        String msg = "Error occurred while downloading '" + resource + "' from the remote repository:" + this.getRepository() + ": " + e.getMessage();
        throw new TransferFailedException(msg, (Throwable)e);
    }

    public List getFileList(String destinationDirectory) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        return this.sshTool.getFileList(destinationDirectory, this.repository);
    }

    public void putDirectory(File sourceDirectory, String destinationDirectory) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        this.sshTool.putDirectory((Wagon)this, sourceDirectory, destinationDirectory);
    }

    public boolean resourceExists(String resourceName) throws TransferFailedException, AuthorizationException {
        return this.sshTool.resourceExists(resourceName, this.repository);
    }

    public boolean supportsDirectoryCopy() {
        return true;
    }

    public void executeCommand(String command) throws CommandExecutionException {
        this.fireTransferDebug("Executing command: " + command);
        this.executeCommand(command, false);
    }

    public InteractiveUserInfo getInteractiveUserInfo() {
        return this.interactiveUserInfo;
    }

    public KnownHostsProvider getKnownHostsProvider() {
        return this.knownHostsProvider;
    }

    public void setInteractiveUserInfo(InteractiveUserInfo interactiveUserInfo) {
        this.interactiveUserInfo = interactiveUserInfo;
    }

    public void setKnownHostsProvider(KnownHostsProvider knownHostsProvider) {
        this.knownHostsProvider = knownHostsProvider;
    }
}

