/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.lang.reflect.Executable;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.ons.Notification;
import oracle.ons.Subscriber;
import oracle.ucp.ConnectionAffinityCallback;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.admin.UniversalConnectionPoolManagerBase;
import oracle.ucp.common.AffinityContext;
import oracle.ucp.common.ConnectionSource;
import oracle.ucp.common.CoreConnection;
import oracle.ucp.common.ONSDriver;
import oracle.ucp.common.PeakIntegerCounter;
import oracle.ucp.common.Selector;
import oracle.ucp.common.Selectors;
import oracle.ucp.common.Service;
import oracle.ucp.common.ServiceMember;
import oracle.ucp.jdbc.oracle.DataBasedConnectionAffinityCallback;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.util.Task;
import oracle.ucp.util.TaskHandle;
import oracle.ucp.util.TaskManager;
import oracle.ucp.util.TaskManagerException;
import oracle.ucp.util.UCPTaskBase;
import oracle.ucp.util.Util;

@DefaultLogger(value="oracle.ucp.common")
@Supports(value={Feature.LOAD_BALANCING})
public abstract class LoadBalancer {
    public static final int REBALANCE_LIMIT = 15;
    private static final boolean isAffinityStrict;
    private final TaskManager taskManager;
    private AtomicReference<Task<Object>> task = new AtomicReference<Object>(null);
    private AtomicReference<TaskHandle<Object>> taskHandle = new AtomicReference<Object>(null);
    private Event recentEvent = null;
    private final AtomicBoolean terminate = new AtomicBoolean(false);
    private static final Pattern lb_ptop;
    private static final Pattern lb_pg1;
    private static final Pattern lb_pg2;
    private static final Pattern lb_pg3;
    private static final Pattern lb_pg4;
    private static final Pattern lb_pg5;
    private static MixTable mixTable;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;

    public LoadBalancer() {
        this(UniversalConnectionPoolManagerBase.getTaskManager());
    }

    public LoadBalancer(TaskManager taskManager) {
        this.taskManager = taskManager;
    }

    protected abstract ConnectionSource.RebalanceCallback.Result onEvent(Event var1, Selector var2, Selector var3);

    protected abstract Service service();

    private Task<Object> prepareTask(final ONSDriver onsDriver, final String serviceName) {
        return new UCPTaskBase<Object>(){
            Subscriber subscriber = null;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;

            @Override
            public boolean isCritical() {
                return true;
            }

            @Override
            @DefaultLogger(value="oracle.ucp.common")
            @Supports(value={Feature.LOAD_BALANCING})
            public void run() {
                boolean bl = (0x80000000000000L & TraceControllerImpl.feature) != 0L;
                try {
                    this.subscriber = AccessController.doPrivileged(new PrivilegedExceptionAction<Subscriber>(){
                        private static Executable $$$methodRef$$$0;
                        private static Logger $$$loggerRef$$$0;
                        private static Executable $$$methodRef$$$1;
                        private static Logger $$$loggerRef$$$1;
                        private static Executable $$$methodRef$$$2;
                        private static Logger $$$loggerRef$$$2;

                        @Override
                        public Subscriber run() throws UniversalConnectionPoolException {
                            try {
                                return onsDriver.createSubscriber("%\"eventType=database/event/servicemetrics/" + serviceName + "\"");
                            }
                            catch (Exception e) {
                                throw new UniversalConnectionPoolException(e);
                            }
                        }

                        static {
                            try {
                                $$$methodRef$$$2 = 1.class.getDeclaredConstructor(1.class);
                            }
                            catch (Throwable throwable) {}
                            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                            try {
                                $$$methodRef$$$1 = 1.class.getDeclaredMethod("run", new Class[0]);
                            }
                            catch (Throwable throwable) {}
                            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                            try {
                                $$$methodRef$$$0 = 1.class.getDeclaredMethod("run", new Class[0]);
                            }
                            catch (Throwable throwable) {}
                            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                        }
                    });
                    if (null == this.subscriber) {
                        return;
                    }
                    this.handleNotifications();
                }
                catch (PrivilegedActionException e) {
                    if (bl) {
                        ClioSupport.ilogThrowing($$$loggerRef$$$1, 1.class, $$$methodRef$$$1, this, e);
                    }
                }
                finally {
                    if (null != this.subscriber) {
                        this.subscriber.close();
                        this.subscriber = null;
                    }
                }
            }

            @DefaultLogger(value="oracle.ucp.common")
            @Supports(value={Feature.LOAD_BALANCING})
            private void handleNotifications() {
                boolean bl = (0x80000000000000L & TraceControllerImpl.feature) != 0L;
                LoadBalancer.this.terminate.set(false);
                while (!Thread.currentThread().isInterrupted() && !LoadBalancer.this.terminate.get()) {
                    try {
                        Event event;
                        Notification notification = this.subscriber.receive(true);
                        if (notification == null) {
                            if (!bl) continue;
                            ClioSupport.ilogFine($$$loggerRef$$$2, 1.class, $$$methodRef$$$2, this, "empty notification");
                            continue;
                        }
                        String nType = notification.type();
                        if (bl) {
                            ClioSupport.ilogFinest($$$loggerRef$$$2, 1.class, $$$methodRef$$$2, this, nType);
                        }
                        if (bl) {
                            ClioSupport.ilogFinest($$$loggerRef$$$2, 1.class, $$$methodRef$$$2, this, new String(notification.body()));
                        }
                        if ((event = LoadBalancer.this.parseNotification(nType.toLowerCase(), new String(notification.body()).toLowerCase())).wrongFormat()) {
                            if (!bl) continue;
                            ClioSupport.ilogFine($$$loggerRef$$$2, 1.class, $$$methodRef$$$2, this, "wrong notification format");
                            continue;
                        }
                        LoadBalancer.this.service().markup(event);
                        if (bl) {
                            ClioSupport.ilogFinest($$$loggerRef$$$2, 1.class, $$$methodRef$$$2, this, event.toString());
                        }
                        long sucLbDelta = LoadBalancer.this.service().lbStats.lbBorrows.successful.delta();
                        BigInteger sucLbTotal = LoadBalancer.this.service().lbStats.lbBorrows.successful.total();
                        long failedLbDelta = LoadBalancer.this.service().lbStats.lbBorrows.failed.delta();
                        BigInteger failedLbTotal = LoadBalancer.this.service().lbStats.lbBorrows.failed.total();
                        if (bl) {
                            ClioSupport.ilogFinest($$$loggerRef$$$2, 1.class, $$$methodRef$$$2, this, String.format("successfulBorrows=%d(%s), failedLbBorrows=%d(%s)", sucLbDelta, sucLbTotal.toString(), failedLbDelta, failedLbTotal.toString()));
                        }
                        long totalBorrowTimeDelta = LoadBalancer.this.service().lbStats.borrowTimes.totalDelta();
                        LoadBalancer.this.service().lbStats.accumulate();
                        boolean peaked = false;
                        for (ServiceMember instance : LoadBalancer.this.service().getAllMembers()) {
                            float borrowBasedLoad;
                            instance.saveAdvisedLoad(event.normalizedPercent(instance.name()));
                            instance.savePeakBorrows();
                            if (instance.peaked()) {
                                peaked = true;
                            }
                            Stats instStats = instance.lbStats;
                            int totalConns = LoadBalancer.this.service().activeCount() - LoadBalancer.this.service().pendingCloseCount.get();
                            int instConns = instance.activeCount.get() - instance.pendingCloseCount.get();
                            float actualLoad = 0 != totalConns ? (float)instConns / (float)totalConns * 100.0f : 0.0f;
                            int delta = (int)Math.ceil((double)totalConns * (double)instance.averageAdvisedLoad() / 100.0) - instConns;
                            instance.connsToRebalance.set(delta);
                            long returnedDelta = instStats.returns.delta();
                            BigInteger returnedTotal = instStats.returns.total();
                            long peakBorrowsDelta = instStats.peakBorrows.delta();
                            long peakBorrowsTotal = instStats.peakBorrows.total();
                            long minBorrowTimeDelta = instStats.borrowTimes.minDelta();
                            long minBorrowTimeTotal = instStats.borrowTimes.minTotal();
                            long maxBorrowTimeDelta = instStats.borrowTimes.maxDelta();
                            long maxBorrowTimeTotal = instStats.borrowTimes.maxTotal();
                            long borrowTimeDelta = instStats.borrowTimes.totalDelta();
                            BigInteger borrowTimeTotal = instStats.borrowTimes.total();
                            String instName = instance.name();
                            float f = borrowBasedLoad = 0L != totalBorrowTimeDelta ? (float)borrowTimeDelta / (float)totalBorrowTimeDelta * 100.0f : 0.0f;
                            if (bl) {
                                ClioSupport.ilogFinest($$$loggerRef$$$2, 1.class, $$$methodRef$$$2, this, instName + ":active=" + instance.activeCount + (delta < 0 ? (char)'-' : '+') + Math.abs(delta) + "(" + String.format("%.2f", Float.valueOf(actualLoad)) + "%)" + ",load=" + String.format("%.2f", Float.valueOf(borrowBasedLoad)) + "%" + ",advised=" + String.format("%.2f", Float.valueOf(event.percent(instName))) + "%" + ",normalized=" + String.format("%.2f", Float.valueOf(event.normalizedPercent(instName))) + "%" + ",average=" + String.format("%.2f", Float.valueOf(instance.averageAdvisedLoad())) + "%" + " (opened=" + instStats.opens.delta() + "(" + instStats.opens.total() + ")" + ",closed=" + instStats.closes.successful.delta() + "(" + instStats.closes.successful.total() + ")" + ",aborted=" + instStats.closes.aborted.delta() + "(" + instStats.closes.aborted.total() + ")" + ",returned=" + returnedDelta + "(" + returnedTotal + ")" + ",borrowed:peak=" + peakBorrowsDelta + "(" + peakBorrowsTotal + ")" + ",minTime=" + minBorrowTimeDelta + "(" + minBorrowTimeTotal + ")" + ",maxTime=" + maxBorrowTimeDelta + "(" + maxBorrowTimeTotal + ")" + ",totalTime=" + borrowTimeDelta + "(" + borrowTimeTotal + "))");
                            }
                            instance.lbStats.accumulate();
                        }
                        StringBuilder sb = new StringBuilder();
                        sb.append("pendingCloseCount: all=").append(LoadBalancer.this.service().pendingCloseCount.get());
                        for (ServiceMember instance : LoadBalancer.this.service().getAllMembers()) {
                            sb.append(", inst(" + instance.name() + ")=" + instance.pendingCloseCount.get());
                        }
                        if (bl) {
                            ClioSupport.ilogFinest($$$loggerRef$$$2, 1.class, $$$methodRef$$$2, this, sb.toString());
                        }
                        if (bl) {
                            ClioSupport.ilogFinest($$$loggerRef$$$2, 1.class, $$$methodRef$$$2, this, "peaked=" + peaked);
                        }
                        LoadBalancer.this.recentEvent = event;
                        LoadBalancer.this.service().pendingRebalance.getAndSet(LoadBalancer.this.onEvent(event, peaked ? LoadBalancer.this.gravitationSelector(true) : Selectors.NONE, peaked ? LoadBalancer.this.gravitationSelector(false) : Selectors.NONE)).terminate();
                        continue;
                    }
                    catch (Throwable e) {
                        if (bl) {
                            ClioSupport.ilogFine($$$loggerRef$$$2, 1.class, $$$methodRef$$$2, this, e.toString());
                        }
                        if (!bl) continue;
                        ClioSupport.ilogThrowing($$$loggerRef$$$2, 1.class, $$$methodRef$$$2, this, e);
                        continue;
                    }
                    break;
                }
                return;
            }

            static {
                try {
                    $$$methodRef$$$3 = 1.class.getDeclaredConstructor(LoadBalancer.class, ONSDriver.class, String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$2 = 1.class.getDeclaredMethod("handleNotifications", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
                try {
                    $$$methodRef$$$1 = 1.class.getDeclaredMethod("run", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
                try {
                    $$$methodRef$$$0 = 1.class.getDeclaredMethod("isCritical", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
    }

    @DisableTrace
    public Selector gravitationSelector(final boolean cleanup) {
        return new Selector(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            @Override
            public boolean selected(CoreConnection conn) {
                if (cleanup ^ conn.available()) {
                    return false;
                }
                if (conn.markedCloseOnReturn() || conn.markedToReplace()) {
                    return false;
                }
                return conn.serviceMember().active();
            }

            static {
                try {
                    $$$methodRef$$$1 = 2.class.getDeclaredConstructor(LoadBalancer.class, Boolean.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 2.class.getDeclaredMethod("selected", CoreConnection.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @DefaultLogger(value="oracle.ucp.common")
    @Supports(value={Feature.LOAD_BALANCING})
    Event parseNotification(String string, String string2) {
        void nBodyLowerCase;
        boolean bl = (0x80000000000000L & TraceControllerImpl.feature) != 0L;
        final Properties dbdata = new Properties();
        final boolean[] wrongFormat = new boolean[]{false};
        HashMap<String, Properties> instsdata = new HashMap<String, Properties>();
        Matcher mtop = lb_ptop.matcher((CharSequence)nBodyLowerCase);
        if (mtop.find()) {
            Matcher mg1 = lb_pg1.matcher(mtop.group(1));
            Matcher mg2 = lb_pg2.matcher(mtop.group(2));
            Matcher mg3 = lb_pg3.matcher(mtop.group(3));
            Matcher mg4 = lb_pg4.matcher(mtop.group(3));
            while (mg1.find()) {
                dbdata.setProperty(mg1.group(1), mg1.group(2));
            }
            while (mg2.find()) {
                Matcher mg21 = lb_pg1.matcher(mg2.group(1));
                Properties instdata = new Properties();
                while (mg21.find()) {
                    instdata.setProperty(mg21.group(1), mg21.group(2));
                }
                instsdata.put(instdata.getProperty("instance", "***noname***"), instdata);
            }
            if (0 == instsdata.size()) {
                wrongFormat[0] = true;
            }
            if (mg3.find()) {
                dbdata.put(mg3.group(1), mg3.group(2));
            }
            if (mg4.find()) {
                if (lb_pg5.matcher(mg4.group(2)).find()) {
                    dbdata.put(mg4.group(1), mg4.group(2));
                } else {
                    if (bl) {
                        ClioSupport.ilogFinest($$$loggerRef$$$1, LoadBalancer.class, $$$methodRef$$$1, this, "unaccepted timezone format: " + mg4.group(2));
                    }
                    wrongFormat[0] = true;
                }
            }
        }
        return new Event((String)nBodyLowerCase, instsdata){
            private final String version;
            private final String service;
            private final String database;
            private final String host;
            private Date timestamp;
            private final Map<String, Float> instAdvisories;
            private final Map<String, Float> instNormalizedAdvisories;
            final /* synthetic */ String val$nBodyLowerCase;
            final /* synthetic */ Map val$instsdata;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;
            private static Executable $$$methodRef$$$4;
            private static Logger $$$loggerRef$$$4;
            private static Executable $$$methodRef$$$5;
            private static Logger $$$loggerRef$$$5;
            private static Executable $$$methodRef$$$6;
            private static Logger $$$loggerRef$$$6;
            private static Executable $$$methodRef$$$7;
            private static Logger $$$loggerRef$$$7;
            private static Executable $$$methodRef$$$8;
            private static Logger $$$loggerRef$$$8;
            private static Executable $$$methodRef$$$9;
            private static Logger $$$loggerRef$$$9;
            private static Executable $$$methodRef$$$10;
            private static Logger $$$loggerRef$$$10;
            private static Executable $$$methodRef$$$11;
            private static Logger $$$loggerRef$$$11;
            private static Executable $$$methodRef$$$12;
            private static Logger $$$loggerRef$$$12;
            private static Executable $$$methodRef$$$13;
            private static Logger $$$loggerRef$$$13;
            {
                this.val$nBodyLowerCase = string;
                this.val$instsdata = map;
                boolean bl = (0L & TraceControllerImpl.feature) != 0L;
                this.version = dbdata.getProperty("version");
                this.service = dbdata.getProperty("service");
                this.database = dbdata.getProperty("database");
                this.host = dbdata.getProperty("host");
                this.timestamp = new Date();
                if (null == this.version) {
                    if (bl) {
                        ClioSupport.ilogFinest($$$loggerRef$$$13, 3.class, $$$methodRef$$$13, null, "no version");
                    }
                    wrongFormat[0] = true;
                }
                String ts = dbdata.getProperty("timestamp", "");
                String tz = dbdata.getProperty("timezone", "");
                if ("".equals(ts) && !"".equals(tz)) {
                    if (bl) {
                        ClioSupport.ilogFinest($$$loggerRef$$$13, 3.class, $$$methodRef$$$13, null, "single timezone (without timestamp) is not allowed");
                    }
                    wrongFormat[0] = true;
                }
                if ("".equals(ts)) {
                    this.timestamp = new Date();
                } else {
                    try {
                        this.timestamp = "".equals(tz) ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(ts) : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z").parse((String)ts + " GMT" + tz);
                    }
                    catch (ParseException e) {
                        if (bl) {
                            ClioSupport.ilogThrowing($$$loggerRef$$$13, 3.class, $$$methodRef$$$13, null, e);
                        }
                        wrongFormat[0] = true;
                    }
                }
                this.instAdvisories = new HashMap<String, Float>();
                for (String inst : this.instances()) {
                    String percenti;
                    String percentf = this.instanceAttrs(inst).getProperty("percentf");
                    if (null != percentf) {
                        try {
                            this.instAdvisories.put(inst, Float.valueOf(Float.parseFloat(percentf)));
                            continue;
                        }
                        catch (Exception e) {
                            if (bl) {
                                ClioSupport.ilogThrowing($$$loggerRef$$$13, 3.class, $$$methodRef$$$13, null, e);
                            }
                            wrongFormat[0] = true;
                        }
                    }
                    if (null != (percenti = this.instanceAttrs(inst).getProperty("percent"))) {
                        try {
                            this.instAdvisories.put(inst, Float.valueOf(Integer.parseInt(percenti)));
                            continue;
                        }
                        catch (Exception e) {
                            if (bl) {
                                ClioSupport.ilogThrowing($$$loggerRef$$$13, 3.class, $$$methodRef$$$13, null, e);
                            }
                            wrongFormat[0] = true;
                        }
                    }
                    if (bl) {
                        ClioSupport.ilogFinest($$$loggerRef$$$13, 3.class, $$$methodRef$$$13, null, "no advisory percent in the load balancing event");
                    }
                    wrongFormat[0] = true;
                }
                this.instNormalizedAdvisories = new HashMap<String, Float>();
                if (!wrongFormat[0]) {
                    float alivePercent = 0.0f;
                    for (Map.Entry<String, Float> entry : this.instAdvisories.entrySet()) {
                        Event.Flag flag = this.flag(entry.getKey());
                        if (Event.Flag.BLOCKED == flag || Event.Flag.NO_DATA == flag) continue;
                        alivePercent += entry.getValue().floatValue();
                    }
                    if (bl) {
                        ClioSupport.ilogFinest($$$loggerRef$$$13, 3.class, $$$methodRef$$$13, null, "alivePercent=" + alivePercent);
                    }
                    if (0.0f == alivePercent) {
                        wrongFormat[0] = true;
                    }
                    for (Map.Entry<String, Float> entry : this.instAdvisories.entrySet()) {
                        String instname;
                        Event.Flag flag = this.flag(instname = entry.getKey());
                        this.instNormalizedAdvisories.put(instname, Float.valueOf(Event.Flag.BLOCKED != flag && Event.Flag.NO_DATA != flag ? entry.getValue().floatValue() / alivePercent * 100.0f : 0.0f));
                    }
                    if (bl) {
                        ClioSupport.ilogFinest($$$loggerRef$$$13, 3.class, $$$methodRef$$$13, null, "instNormalizedAdvisories=" + this.instNormalizedAdvisories.toString());
                    }
                }
            }

            @Override
            public byte[] body() {
                return this.val$nBodyLowerCase.getBytes();
            }

            @Override
            public String version() {
                return this.version;
            }

            @Override
            public String service() {
                return this.service;
            }

            @Override
            public String database() {
                return this.database;
            }

            @Override
            public String host() {
                return this.host;
            }

            @Override
            public Date timestamp() {
                return this.timestamp;
            }

            @Override
            public Set<String> instances() {
                return this.val$instsdata.keySet();
            }

            @Override
            public float percent(String instance) {
                Float percent = this.instAdvisories.get(instance);
                return null != percent ? percent.floatValue() : 0.0f;
            }

            @Override
            public float normalizedPercent(String instance) {
                Float percent = this.instNormalizedAdvisories.get(instance);
                return null != percent ? percent.floatValue() : 0.0f;
            }

            @Override
            public boolean affinity(String instance) {
                return "true".equals(this.instanceAttrs(instance).getProperty("aff", "false").toLowerCase().trim());
            }

            @Override
            public Event.Flag flag(String instance) {
                return Event.Flag.parse(this.instanceAttrs(instance).getProperty("flag", "good"));
            }

            private Properties instanceAttrs(String instance) {
                Properties instdata = (Properties)this.val$instsdata.get(instance);
                return null != instdata ? instdata : new Properties();
            }

            @Override
            public boolean wrongFormat() {
                return wrongFormat[0];
            }

            @DisableTrace
            public String toString() {
                return "" + this.val$instsdata + dbdata;
            }

            static {
                try {
                    $$$methodRef$$$13 = 3.class.getDeclaredConstructor(LoadBalancer.class, Properties.class, boolean[].class, String.class, Map.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$12 = 3.class.getDeclaredMethod("wrongFormat", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$11 = 3.class.getDeclaredMethod("instanceAttrs", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$10 = 3.class.getDeclaredMethod("flag", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$9 = 3.class.getDeclaredMethod("affinity", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$8 = 3.class.getDeclaredMethod("normalizedPercent", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$7 = 3.class.getDeclaredMethod("percent", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$6 = 3.class.getDeclaredMethod("instances", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$5 = 3.class.getDeclaredMethod("timestamp", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$4 = 3.class.getDeclaredMethod("host", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$3 = 3.class.getDeclaredMethod("database", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$2 = 3.class.getDeclaredMethod("service", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$1 = 3.class.getDeclaredMethod("version", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 3.class.getDeclaredMethod("body", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
    }

    @DefaultLogger(value="oracle.ucp.common")
    @Supports(value={Feature.LOAD_BALANCING})
    public Selector borrowSelector(final ConnectionRetrievalInfo cri, final ConnectionAffinityCallback callback) {
        abstract class AffinitySelector
        implements Selector {
            final /* synthetic */ ConnectionAffinityCallback val$callback;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;
            private static Executable $$$methodRef$$$4;
            private static Logger $$$loggerRef$$$4;

            AffinitySelector() {
                this.val$callback = connectionAffinityCallback;
            }

            private void successfulAffBorrowed(CoreConnection conn) {
                LoadBalancer.this.service().lbStats.onSuccessfulAffBorrowed();
                conn.serviceMember().lbStats.onSuccessfulAffBorrowed();
            }

            private void failedAffBorrowed(CoreConnection conn) {
                LoadBalancer.this.service().lbStats.onFailedAffBorrowed();
                conn.serviceMember().lbStats.onFailedAffBorrowed();
            }

            /*
             * WARNING - void declaration
             */
            protected boolean affined(CoreConnection coreConnection) {
                boolean bl;
                boolean bl2 = bl = (0L & TraceControllerImpl.feature) != 0L;
                if (null == this.val$callback) {
                    throw new IllegalArgumentException("callback is null");
                }
                Object affContext = this.val$callback.getConnectionAffinityContext();
                if (affContext instanceof AffinityContext) {
                    void conn;
                    AffinityContext context = (AffinityContext)affContext;
                    String ctxInstName = context.getInstanceName();
                    if (null == ctxInstName) {
                        if (bl) {
                            ClioSupport.ilogWarning($$$loggerRef$$$2, AffinitySelector.class, $$$methodRef$$$2, this, "no instance name in affinity context");
                        }
                        this.failedAffBorrowed((CoreConnection)conn);
                        return conn.serviceMember().active();
                    }
                    ServiceMember ctxinst = LoadBalancer.this.service().getMember(ctxInstName, context.getDatabaseUniqueName(), context.getServiceName());
                    if (null == ctxinst) {
                        if (bl) {
                            ClioSupport.ilogWarning($$$loggerRef$$$2, AffinitySelector.class, $$$methodRef$$$2, this, String.format("unknown %s in affinity context", ctxInstName));
                        }
                        this.failedAffBorrowed((CoreConnection)conn);
                        return conn.serviceMember().active();
                    }
                    if (!ctxinst.active() || ctxinst.violating()) {
                        if (bl) {
                            ClioSupport.ilogFine($$$loggerRef$$$2, AffinitySelector.class, $$$methodRef$$$2, this, ctxinst.name() + " is unavailable");
                        }
                        this.failedAffBorrowed((CoreConnection)conn);
                        return conn.serviceMember().active();
                    }
                    ConnectionAffinityCallback.AffinityPolicy policy = this.val$callback.getAffinityPolicy();
                    if (conn.serviceMember().name().equals(ctxinst.name())) {
                        if (ConnectionAffinityCallback.AffinityPolicy.WEBSESSION_BASED_AFFINITY == policy) {
                            if (conn.serviceMember().affined()) {
                                this.successfulAffBorrowed((CoreConnection)conn);
                                return true;
                            }
                        } else {
                            if (ConnectionAffinityCallback.AffinityPolicy.TRANSACTION_BASED_AFFINITY == policy) {
                                this.successfulAffBorrowed((CoreConnection)conn);
                                return true;
                            }
                            throw new IllegalStateException("wrong affinity policy");
                        }
                    }
                    return false;
                }
                throw new IllegalStateException("wrong affinity context type or null");
            }

            protected boolean dbAffined(CoreConnection conn) {
                DataBasedConnectionAffinityCallback cbk = (DataBasedConnectionAffinityCallback)this.val$callback;
                if (0 == LoadBalancer.this.service().getAllMembers().size()) {
                    throw new IllegalStateException("data affinity: list of instances is empty");
                }
                int activeInsts = LoadBalancer.this.service().activeMembersCount();
                if (0 == activeInsts) {
                    return false;
                }
                int i = 0;
                ServiceMember inst = null;
                int partitionId = cbk.getPartitionId();
                block0: while (i++ < mixTable.size()) {
                    int instIdToFind = partitionId % activeInsts;
                    for (ServiceMember instance : LoadBalancer.this.service().getAllMembers()) {
                        inst = instance;
                        int id = inst.id() % activeInsts;
                        if (instIdToFind != id) continue;
                        if (isAffinityStrict) {
                            if (inst.active() && !inst.violating()) break block0;
                            this.failedAffBorrowed(conn);
                            return false;
                        }
                        if (inst.affined() && inst.active() && !inst.violating()) break block0;
                        this.failedAffBorrowed(conn);
                        return conn.serviceMember().active();
                    }
                    partitionId = mixTable.nextPartition(partitionId);
                }
                if (null == inst) {
                    return false;
                }
                boolean res = conn.serviceMember().name().equals(inst.name());
                if (res) {
                    this.successfulAffBorrowed(conn);
                }
                return res;
            }

            static {
                try {
                    $$$methodRef$$$4 = AffinitySelector.class.getDeclaredConstructor(LoadBalancer.class, ConnectionAffinityCallback.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$3 = AffinitySelector.class.getDeclaredMethod("dbAffined", CoreConnection.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$2 = AffinitySelector.class.getDeclaredMethod("affined", CoreConnection.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$1 = AffinitySelector.class.getDeclaredMethod("failedAffBorrowed", CoreConnection.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = AffinitySelector.class.getDeclaredMethod("successfulAffBorrowed", CoreConnection.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        }
        return new AffinitySelector(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            {
                super(LoadBalancer.this, connectionAffinityCallback);
            }

            @Override
            public boolean selected(CoreConnection conn) {
                if (!conn.available()) {
                    return false;
                }
                boolean active = conn.serviceMember().active();
                if (null != callback && ConnectionAffinityCallback.AffinityPolicy.DATA_BASED_AFFINITY == callback.getAffinityPolicy()) {
                    return active && this.dbAffined(conn);
                }
                if (null != callback && callback.getConnectionAffinityContext() != null) {
                    return active && this.affined(conn);
                }
                if (null == LoadBalancer.this.recentEvent) {
                    return conn.serviceMember().serviceRef.proportionalDistributionSelector().selected(conn);
                }
                if (!active) {
                    return false;
                }
                ServiceMember instance = conn.serviceMember();
                String chunkName = LoadBalancer.this.service().connectionSource().isShardedDatabase() ? LoadBalancer.this.service().shardRoutingCache().matchingChunkName(cri) : null;
                float advisedLoad = instance.active() ? instance.averageAdvisedLoad(cri) : 0.0f;
                long instBorrowedTime = instance.lbStats.borrowTimes.totalDelta();
                long totalBorrowedTime = LoadBalancer.this.service().totalBorrowTimes(cri);
                float actualLoad = 0L != totalBorrowedTime ? (float)instBorrowedTime / (float)totalBorrowedTime * 100.0f : 0.0f;
                return actualLoad <= advisedLoad;
            }

            static {
                try {
                    $$$methodRef$$$1 = 4.class.getDeclaredConstructor(LoadBalancer.class, ConnectionAffinityCallback.class, ConnectionRetrievalInfo.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 4.class.getDeclaredMethod("selected", CoreConnection.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
    }

    public ServiceMember underloadedInstance() {
        return this.underloadedInstance(null);
    }

    ServiceMember underloadedInstance(ConnectionRetrievalInfo cri) {
        Event event = this.recentEvent;
        if (null == event) {
            return null;
        }
        ServiceMember underloadedInstance = null;
        int maxDelta = Integer.MIN_VALUE;
        do {
            for (ServiceMember instance : this.service().getAllMembers(cri, true)) {
                int delta;
                if (!instance.active() || (delta = instance.connsToRebalance.get()) <= 0 || delta <= maxDelta) continue;
                maxDelta = delta;
                underloadedInstance = instance;
            }
        } while (null != underloadedInstance && !underloadedInstance.connsToRebalance.compareAndSet(maxDelta, maxDelta - 1));
        return underloadedInstance;
    }

    /*
     * WARNING - void declaration
     */
    public boolean start(ONSDriver oNSDriver, String string) {
        void service;
        void onsDriver;
        boolean bl;
        boolean bl2 = bl = (0x80000000000000L & TraceControllerImpl.feature) != 0L;
        if (this.task.compareAndSet(null, this.prepareTask((ONSDriver)onsDriver, (String)service))) {
            this.taskHandle.set(this.taskManager.submitTask(this.task.get()));
            if (bl) {
                ClioSupport.ilogFinest($$$loggerRef$$$5, LoadBalancer.class, $$$methodRef$$$5, this, "started");
            }
        }
        return true;
    }

    public void stop() {
        boolean bl = (0x80000000000000L & TraceControllerImpl.feature) != 0L;
        Task t = this.task.getAndSet(null);
        if (null != t) {
            block5: {
                t.release();
                this.terminate.set(true);
                try {
                    TaskHandle th = this.taskHandle.getAndSet(null);
                    if (null != th) {
                        th.get(100000L);
                    }
                }
                catch (TaskManagerException e) {
                    if (e.getCause() instanceof CancellationException || !bl) break block5;
                    ClioSupport.ilogThrowing($$$loggerRef$$$6, LoadBalancer.class, $$$methodRef$$$6, this, e);
                }
            }
            if (bl) {
                ClioSupport.ilogFinest($$$loggerRef$$$6, LoadBalancer.class, $$$methodRef$$$6, this, "stopped");
            }
        }
    }

    public Event recentEvent() {
        return this.recentEvent;
    }

    static {
        try {
            $$$methodRef$$$14 = LoadBalancer.class.getDeclaredConstructor(TaskManager.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$13 = LoadBalancer.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$12 = LoadBalancer.class.getDeclaredMethod("access$100", LoadBalancer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$11 = LoadBalancer.class.getDeclaredMethod("access$300", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$10 = LoadBalancer.class.getDeclaredMethod("access$200", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$9 = LoadBalancer.class.getDeclaredMethod("access$102", LoadBalancer.class, Event.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$8 = LoadBalancer.class.getDeclaredMethod("access$000", LoadBalancer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$7 = LoadBalancer.class.getDeclaredMethod("recentEvent", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$6 = LoadBalancer.class.getDeclaredMethod("stop", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$5 = LoadBalancer.class.getDeclaredMethod("start", ONSDriver.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$4 = LoadBalancer.class.getDeclaredMethod("underloadedInstance", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$3 = LoadBalancer.class.getDeclaredMethod("underloadedInstance", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$2 = LoadBalancer.class.getDeclaredMethod("borrowSelector", ConnectionRetrievalInfo.class, ConnectionAffinityCallback.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$1 = LoadBalancer.class.getDeclaredMethod("parseNotification", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$0 = LoadBalancer.class.getDeclaredMethod("prepareTask", ONSDriver.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        isAffinityStrict = Util.isAffinityStrict();
        lb_ptop = Pattern.compile("([^{]*)\\{(.*)\\}(.*)");
        lb_pg1 = Pattern.compile("(\\w+)=([a-zA-Z_0-9\\.\\-\\:\\%]+)");
        lb_pg2 = Pattern.compile("\\{([^{]*)\\}");
        lb_pg3 = Pattern.compile("(timestamp)=(\\d{4}\\-\\d{2}\\-\\d{2} \\d{2}\\:\\d{2}\\:\\d{2})");
        lb_pg4 = Pattern.compile("(timezone)=(.*)");
        lb_pg5 = Pattern.compile("[\\+\\-]\\d{2}:\\d{2}");
        mixTable = new MixTable();
    }

    @DisableTrace
    public static class Stats {
        public final Counter returns = new Counter();
        public final Counter opens = new Counter();
        public final CloseResultsCounter closes = new CloseResultsCounter();
        public final BorrowResultsCounter lbBorrows = new BorrowResultsCounter();
        public final BorrowResultsCounter affBorrows = new BorrowResultsCounter();
        public final PeakBorrowed peakBorrows = new PeakBorrowed();
        public final Times borrowTimes = new Times();

        void onBorrowed(int borrowedCount) {
            this.peakBorrows.update(borrowedCount);
        }

        void onReturned(long borrowedTimeInterval) {
            this.borrowTimes.update(borrowedTimeInterval);
            this.returns.increment();
        }

        void onOpened() {
            this.opens.increment();
        }

        public void onClosed() {
            this.closes.successful.increment();
        }

        void onAborted() {
            this.closes.aborted.increment();
        }

        void onSuccessfulLbBorrowed() {
            this.lbBorrows.successful.increment();
        }

        void onFailedLbBorrowed() {
            this.lbBorrows.failed.increment();
        }

        void onSuccessfulAffBorrowed() {
            this.affBorrows.successful.increment();
        }

        void onFailedAffBorrowed() {
            this.affBorrows.failed.increment();
        }

        void accumulate() {
            this.returns.accumulate();
            this.opens.accumulate();
            this.closes.accumulate();
            this.lbBorrows.accumulate();
            this.affBorrows.accumulate();
            this.peakBorrows.accumulate();
            this.borrowTimes.accumulate();
        }

        @DisableTrace
        static class Times {
            private final AtomicLong minAccumulator = new AtomicLong(Long.MAX_VALUE);
            private final AtomicLong minDelta = new AtomicLong(Long.MAX_VALUE);
            private final AtomicLong maxAccumulator = new AtomicLong(Long.MIN_VALUE);
            private final AtomicLong maxDelta = new AtomicLong(Long.MIN_VALUE);
            private final AtomicReference<BigInteger> totalAccumulator = new AtomicReference<BigInteger>(BigInteger.ZERO);
            private final AtomicLong totalDelta = new AtomicLong(0L);

            Times() {
            }

            private void update(long timeInterval) {
                long oldValue;
                this.totalDelta.addAndGet(timeInterval);
                while (!this.minDelta.compareAndSet(oldValue = this.minDelta.get(), Math.min(timeInterval, oldValue))) {
                }
                while (!this.maxDelta.compareAndSet(oldValue = this.maxDelta.get(), Math.max(timeInterval, oldValue))) {
                }
            }

            private void accumulate() {
                long oldValue;
                this.totalAccumulator.set(this.totalAccumulator.get().add(BigInteger.valueOf(this.totalDelta.getAndSet(0L))));
                long delta = this.minDelta.getAndSet(0L);
                while (!this.minAccumulator.compareAndSet(oldValue = this.minAccumulator.get(), Math.min(delta, oldValue))) {
                }
                delta = this.maxDelta.getAndSet(0L);
                while (!this.maxAccumulator.compareAndSet(oldValue = this.maxAccumulator.get(), Math.max(delta, oldValue))) {
                }
            }

            public long minDelta() {
                long val = this.minDelta.get();
                return val < Long.MAX_VALUE ? val : 0L;
            }

            public long maxDelta() {
                long val = this.maxDelta.get();
                return val > Long.MIN_VALUE ? val : 0L;
            }

            public long totalDelta() {
                return this.totalDelta.get();
            }

            public long minTotal() {
                long val = Math.min(this.minAccumulator.get(), this.minDelta.get());
                return val < Long.MAX_VALUE ? val : 0L;
            }

            public long maxTotal() {
                long val = Math.max(this.maxAccumulator.get(), this.maxDelta.get());
                return val > Long.MIN_VALUE ? val : 0L;
            }

            public BigInteger total() {
                return this.totalAccumulator.get().add(BigInteger.valueOf(this.totalDelta.get()));
            }
        }

        @DisableTrace
        public static class PeakBorrowed {
            private final PeakIntegerCounter accumulator = new PeakIntegerCounter(0);
            private final PeakIntegerCounter delta = new PeakIntegerCounter(0);

            private void update(int nItems) {
                this.delta.update(nItems);
            }

            private void accumulate() {
                this.accumulator.update(this.delta.getAndSet(0));
            }

            public int delta() {
                return this.delta.get();
            }

            public int total() {
                PeakIntegerCounter counter = new PeakIntegerCounter(0);
                counter.update(this.accumulator.get());
                counter.update(this.delta.get());
                return counter.get();
            }
        }

        @DisableTrace
        public static class BorrowResultsCounter {
            public final Counter successful = new Counter();
            public final Counter failed = new Counter();

            private void accumulate() {
                this.successful.accumulate();
                this.failed.accumulate();
            }
        }

        @DisableTrace
        public static class CloseResultsCounter {
            public final Counter successful = new Counter();
            public final Counter aborted = new Counter();

            private void accumulate() {
                this.successful.accumulate();
                this.aborted.accumulate();
            }
        }

        public static class Counter {
            private final AtomicReference<BigInteger> accumulator = new AtomicReference<BigInteger>(BigInteger.ZERO);
            private final AtomicLong delta = new AtomicLong(0L);
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;
            private static Executable $$$methodRef$$$4;
            private static Logger $$$loggerRef$$$4;
            private static Executable $$$methodRef$$$5;
            private static Logger $$$loggerRef$$$5;
            private static Executable $$$methodRef$$$6;
            private static Logger $$$loggerRef$$$6;

            private void increment() {
                this.delta.incrementAndGet();
            }

            private void accumulate() {
                this.accumulator.set(this.accumulator.get().add(BigInteger.valueOf(this.delta.getAndSet(0L))));
            }

            public long delta() {
                return this.delta.get();
            }

            public BigInteger total() {
                return this.accumulator.get().add(BigInteger.valueOf(this.delta.get()));
            }

            static {
                try {
                    $$$methodRef$$$6 = Counter.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$5 = Counter.class.getDeclaredMethod("access$700", Counter.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$4 = Counter.class.getDeclaredMethod("access$400", Counter.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$3 = Counter.class.getDeclaredMethod("total", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$2 = Counter.class.getDeclaredMethod("delta", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$1 = Counter.class.getDeclaredMethod("accumulate", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = Counter.class.getDeclaredMethod("increment", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        }
    }

    @DisableTrace
    private static class MixTable {
        private int[] mixTable;
        private static final int MIX_TABLE_SIZE = 4096;
        private static final int IRREDUCIBLE_POLYNOMIAL = 4105;
        private static final int MIX_TABLE_GENERATOR = 3;

        MixTable() {
            this.generateMixTable();
        }

        int nextPartition(int pid) {
            return this.mixTable[pid % this.mixTable.length];
        }

        int size() {
            return this.mixTable.length;
        }

        private void generateMixTable() {
            if (this.mixTable != null) {
                return;
            }
            int[] alog = new int[4096];
            alog[0] = 1;
            for (int i = 1; i < 4096; ++i) {
                alog[i] = alog[i - 1] << 1 ^ alog[i - 1];
                if ((alog[i] & 0x1000) == 0) continue;
                int n = i;
                alog[n] = alog[n] ^ 0x1009;
            }
            int[] log = new int[4096];
            for (int i = 0; i < 4096; ++i) {
                log[alog[i]] = i;
            }
            log[0] = 4096;
            int[] mix = new int[4096];
            for (int i = 1; i < 4096; ++i) {
                mix[log[i - 1] - 1] = log[i] - 1;
            }
            mix[log[4095] - 1] = log[0] - 1;
            this.mixTable = mix;
        }
    }

    public static interface Event {
        public String version();

        public String database();

        public String host();

        public String service();

        public Set<String> instances();

        public float percent(String var1);

        public float normalizedPercent(String var1);

        public boolean wrongFormat();

        public boolean affinity(String var1);

        public Flag flag(String var1);

        public Date timestamp();

        public byte[] body();

        public static final class Flag
        extends Enum<Flag> {
            public static final /* enum */ Flag GOOD;
            public static final /* enum */ Flag VIOLATING;
            public static final /* enum */ Flag NO_DATA;
            public static final /* enum */ Flag UNKNOWN;
            public static final /* enum */ Flag BLOCKED;
            private static final /* synthetic */ Flag[] $VALUES;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;

            public static Flag[] values() {
                return (Flag[])$VALUES.clone();
            }

            public static Flag valueOf(String name) {
                return Enum.valueOf(Flag.class, name);
            }

            static Flag parse(String flag) {
                for (Flag f : Flag.values()) {
                    if (!f.toString().toLowerCase().equals(flag)) continue;
                    return f;
                }
                throw new IllegalStateException("unknown flag " + flag);
            }

            static {
                try {
                    $$$methodRef$$$3 = Flag.class.getDeclaredConstructor(String.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$2 = Flag.class.getDeclaredMethod("parse", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$1 = Flag.class.getDeclaredMethod("valueOf", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = Flag.class.getDeclaredMethod("values", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                GOOD = new Flag();
                VIOLATING = new Flag();
                NO_DATA = new Flag();
                UNKNOWN = new Flag();
                BLOCKED = new Flag();
                $VALUES = new Flag[]{GOOD, VIOLATING, NO_DATA, UNKNOWN, BLOCKED};
            }
        }
    }
}

