/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.util;

import java.util.ArrayList;
import java.util.List;
import oracle.jdbc.logging.annotations.DisableTrace;

@DisableTrace
public class RingBuffer<T> {
    public static final int DEFAULT_CAPACITY = 64;
    public final Object[] ring;
    public int pointer = 0;
    protected long nUpdates = 0L;

    public RingBuffer() {
        this(64);
    }

    public RingBuffer(int capacity) {
        this.ring = new Object[capacity];
    }

    public int next(int i) {
        return (i + 1) % this.getCapacity();
    }

    public int previous(int i) {
        int j = i - 1;
        return j < 0 ? this.getCapacity() - 1 : j;
    }

    public void addItem(T item) {
        this.pointer = this.next(this.pointer);
        this.ring[this.pointer] = item;
        if (++this.nUpdates < 0L) {
            this.nUpdates = Long.MAX_VALUE;
        }
    }

    public int getCapacity() {
        return this.ring.length;
    }

    public long getNumberOfUpdates() {
        return this.nUpdates;
    }

    public List<T> getAsList() {
        ArrayList<Object> listHistory = new ArrayList<Object>();
        int index = this.pointer;
        int i = 0;
        while ((long)i < Math.min((long)this.getCapacity(), this.getNumberOfUpdates())) {
            listHistory.add(this.ring[index]);
            index = this.previous(index);
            ++i;
        }
        return listHistory;
    }

    @DisableTrace
    public String toString() {
        return this.toString(this.getCapacity());
    }

    @DisableTrace
    public String toString(int nItems) {
        StringBuilder sb = new StringBuilder();
        int i = this.pointer;
        int n = nItems;
        if (n < 1) {
            return "";
        }
        do {
            Object item;
            if (null == (item = this.ring[i])) continue;
            sb.append(item.toString());
        } while ((i = this.previous(i)) != this.pointer && --n > 0);
        return sb.toString();
    }

    public void clear() {
        this.pointer = 0;
        this.nUpdates = 0L;
    }
}

