/*
 * Decompiled with CFR 0.152.
 */
package com.google.debugging.sourcemap;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.debugging.sourcemap.SourceMapConsumer;
import com.google.debugging.sourcemap.SourceMapLineDecoder;
import com.google.debugging.sourcemap.SourceMapParseException;
import com.google.debugging.sourcemap.proto.Mapping;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SourceMapConsumerV2
implements SourceMapConsumer {
    private Map<Integer, List<Integer>> characterMap = null;
    private JSONArray lineMaps = null;
    private List<Mapping.OriginalMapping> mappings;

    @Override
    public void parse(String string) throws SourceMapParseException {
        try {
            JSONObject jSONObject = new JSONObject(string);
            this.parse(jSONObject);
        }
        catch (JSONException jSONException) {
            throw new SourceMapParseException("JSON parse exception: " + (Object)((Object)jSONException));
        }
    }

    public void parse(JSONObject jSONObject) throws SourceMapParseException {
        try {
            this.parseInternal(jSONObject);
        }
        catch (JSONException jSONException) {
            throw new SourceMapParseException("JSON parse exception: " + (Object)((Object)jSONException));
        }
    }

    private void parseInternal(JSONObject jSONObject) throws JSONException, SourceMapParseException {
        int n = jSONObject.getInt("version");
        if (n != 2) {
            throw new SourceMapParseException("Unknown version: " + n);
        }
        String string = jSONObject.getString("file");
        if (string.isEmpty()) {
            throw new SourceMapParseException("File entry is missing or empty");
        }
        int n2 = jSONObject.getInt("lineCount");
        this.lineMaps = jSONObject.getJSONArray("lineMaps");
        if (n2 != this.lineMaps.length()) {
            throw new SourceMapParseException("lineMaps length does not match lineCount");
        }
        this.characterMap = Maps.newHashMap();
        JSONArray jSONArray = jSONObject.getJSONArray("sources");
        JSONArray jSONArray2 = jSONObject.has("names") ? jSONObject.getJSONArray("names") : null;
        JSONArray jSONArray3 = jSONObject.getJSONArray("mappings");
        this.mappings = Lists.newArrayListWithCapacity((int)n2);
        for (int i = 0; i < jSONArray3.length(); ++i) {
            JSONArray jSONArray4 = jSONArray3.getJSONArray(i);
            String string2 = jSONArray4.optString(3, "");
            if (jSONArray2 != null) {
                try {
                    int n3 = jSONArray4.getInt(3);
                    string2 = jSONArray2.getString(n3);
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
            String string3 = jSONArray.getString(jSONArray4.getInt(0));
            int n4 = jSONArray4.getInt(1);
            int n5 = jSONArray4.getInt(2);
            Mapping.OriginalMapping.Builder builder = Mapping.OriginalMapping.newBuilder().setOriginalFile(string3).setLineNumber(n4).setColumnPosition(n5).setIdentifier(string2);
            this.mappings.add(builder.build());
        }
    }

    @Override
    public Mapping.OriginalMapping getMappingForLine(int n, int n2) {
        List<Integer> list;
        --n2;
        if (--n >= this.lineMaps.length()) {
            return null;
        }
        Preconditions.checkState((n >= 0 ? 1 : 0) != 0, (Object)"Line number must be >= 0");
        Preconditions.checkState((n2 >= 0 ? 1 : 0) != 0, (Object)"Column index must be >= 0");
        if (!this.characterMap.containsKey(n)) {
            try {
                this.characterMap.put(n, SourceMapLineDecoder.decodeLine(this.lineMaps.getString(n)));
            }
            catch (JSONException jSONException) {
                throw new IllegalStateException("JSON exception when retrieving line map", jSONException);
            }
        }
        if ((list = this.characterMap.get(n)) == null || list.size() <= n2) {
            return null;
        }
        int n3 = list.get(n2);
        if (n3 == -1) {
            return null;
        }
        Preconditions.checkState((n3 < this.mappings.size() ? 1 : 0) != 0, (Object)"Invalid mapping reference");
        return this.mappings.get(n3);
    }
}

