/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.JSModuleGraph;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.Strings;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

class AliasExternals
implements CompilerPass {
    private static final int DEFAULT_REQUIRED_USAGE = 4;
    private int requiredUsage = 4;
    private static final int MIN_PROP_SIZE = 4;
    static final String PROTOTYPE_PROPERTY_NAME = AliasExternals.getArrayNotationNameFor("prototype");
    private final Map<String, Symbol> props = Maps.newHashMap();
    private final List<Node> accessors = Lists.newArrayList();
    private final List<Node> mutators = Lists.newArrayList();
    private final Map<Node, Node> replacementMap = new IdentityHashMap<Node, Node>();
    private final Map<String, Symbol> globals = Maps.newHashMap();
    private final AbstractCompiler compiler;
    private final JSModuleGraph moduleGraph;
    private Node defaultRoot;
    private Map<JSModule, Node> moduleRoots;
    private final Set<String> unaliasableGlobals = Sets.newHashSet((Object[])new String[]{"arguments", "eval", "NodeFilter", "JSCompiler_renameProperty"});
    private final Set<String> aliasableGlobals = Sets.newHashSet();

    AliasExternals(AbstractCompiler abstractCompiler, JSModuleGraph jSModuleGraph) {
        this(abstractCompiler, jSModuleGraph, null, null);
    }

    AliasExternals(AbstractCompiler abstractCompiler, JSModuleGraph jSModuleGraph, @Nullable String string, @Nullable String string2) {
        this.compiler = abstractCompiler;
        this.moduleGraph = jSModuleGraph;
        if (!Strings.isEmpty(string) && !Strings.isEmpty(string2)) {
            throw new IllegalArgumentException("Cannot pass in both unaliasable and aliasable globals; you must choose one or the other.");
        }
        if (!Strings.isEmpty(string)) {
            this.unaliasableGlobals.addAll(Arrays.asList(string.split(",")));
        }
        if (!Strings.isEmpty(string2)) {
            this.aliasableGlobals.addAll(Arrays.asList(string2.split(",")));
        }
        if (jSModuleGraph != null) {
            this.moduleRoots = Maps.newHashMap();
        }
    }

    public void setRequiredUsage(int n) {
        this.requiredUsage = n;
    }

    @Override
    public void process(Node node, Node node2) {
        this.defaultRoot = node2.getFirstChild();
        Preconditions.checkState((this.defaultRoot.getType() == 132 ? 1 : 0) != 0);
        this.aliasProperties(node, node2);
        this.aliasGlobals(node, node2);
    }

    private void aliasProperties(Node node, Node node2) {
        NodeTraversal.traverse(this.compiler, node, new GetAliasableNames(this.aliasableGlobals));
        this.props.put("prototype", this.newSymbolForProperty("prototype"));
        NodeTraversal.traverse(this.compiler, node2, new PropertyGatherer());
        for (Symbol object : this.props.values()) {
            if (object.name.length() < 4) continue;
            if (object.accessorCount >= this.requiredUsage) {
                object.aliasAccessor = true;
            }
            if (object.mutatorCount < this.requiredUsage) continue;
            object.aliasMutator = true;
        }
        for (Node node3 : this.accessors) {
            this.replaceAccessor(node3);
        }
        for (Node node4 : this.mutators) {
            this.replaceMutator(node4);
        }
        for (Symbol symbol : this.props.values()) {
            if (!symbol.aliasAccessor) continue;
            this.addAccessorPropName(symbol.name, this.getAddingRoot(symbol.deepestModuleAccess));
        }
        for (Symbol symbol : this.props.values()) {
            if (!symbol.aliasMutator) continue;
            this.addMutatorFunction(symbol.name, this.getAddingRoot(symbol.deepestModuleMutate));
        }
    }

    private void replaceAccessor(Node node) {
        Node node2 = node.getLastChild();
        String string = node2.getString();
        if (this.props.get((Object)string).aliasAccessor) {
            Node node3 = node.getFirstChild();
            node.removeChild(node3);
            Node node4 = Node.newString(38, AliasExternals.getArrayNotationNameFor(string));
            Node node5 = new Node(35, node3, node4);
            this.replaceNode(node.getParent(), node, node5);
            this.compiler.reportCodeChange();
        }
    }

    private void replaceMutator(Node node) {
        Node node2 = node.getLastChild();
        Node node3 = node.getParent();
        Symbol symbol = this.props.get(node2.getString());
        if (symbol.aliasMutator) {
            Node node4 = node.getFirstChild();
            Node node5 = node3.getLastChild();
            node.removeChild(node4);
            node.removeChild(node2);
            node3.removeChild(node5);
            Node node6 = Node.newString(38, AliasExternals.getMutatorFor(node2.getString()));
            Node node7 = new Node(37, node6, node4, node5);
            this.replaceNode(node3.getParent(), node3, node7);
            this.compiler.reportCodeChange();
        }
    }

    private void replaceNode(Node node, Node node2, Node node3) {
        if (this.replacementMap.containsKey(node)) {
            node = this.replacementMap.get(node);
        }
        node.replaceChild(node2, node3);
        this.replacementMap.put(node2, node3);
    }

    private void addAccessorPropName(String string, Node node) {
        Node node2 = Node.newString(40, string);
        Node node3 = Node.newString(38, AliasExternals.getArrayNotationNameFor(string));
        node3.addChildToFront(node2);
        Node node4 = new Node(118, node3);
        node.addChildToFront(node4);
        this.compiler.reportCodeChange();
    }

    private void addMutatorFunction(String string, Node node) {
        String string2 = AliasExternals.getMutatorFor(string);
        String string3 = AliasExternals.getMutatorFor(string) + "$a";
        String string4 = AliasExternals.getMutatorFor(string) + "$b";
        Node node2 = Node.newString(38, string3);
        Node node3 = Node.newString(38, string4);
        ArrayList arrayList = Lists.newArrayList((Object[])new Node[]{node2, node3});
        Node node4 = Node.newString(38, string3);
        Node node5 = Node.newString(40, string);
        Node node6 = new Node(33, node4, node5);
        Node node7 = Node.newString(38, string4);
        Node node8 = new Node(86, node6, node7);
        Node node9 = new Node(4, node8);
        Node node10 = new Node(125, node9);
        Node node11 = NodeUtil.newFunctionNode(string2, arrayList, node10, -1, -1);
        node.addChildToFront(node11);
        this.compiler.reportCodeChange();
    }

    private Node getAddingRoot(JSModule jSModule) {
        if (jSModule != null) {
            Node node = this.moduleRoots.get(jSModule);
            if (node != null) {
                return node;
            }
            node = this.compiler.getNodeForCodeInsertion(jSModule);
            if (node != null) {
                this.moduleRoots.put(jSModule, node);
                return node;
            }
        }
        return this.defaultRoot;
    }

    private static String getMutatorFor(String string) {
        return "SETPROP_" + string;
    }

    private static String getArrayNotationNameFor(String string) {
        return "$$PROP_" + string;
    }

    private void aliasGlobals(Node node, Node node2) {
        NodeTraversal.traverse(this.compiler, node, new GetGlobals());
        NodeTraversal.traverse(this.compiler, node2, new GlobalGatherer());
        for (Symbol symbol : this.globals.values()) {
            if (symbol.mutatorCount > 0) continue;
            int n = symbol.name.length() * symbol.accessorCount;
            int n2 = 8 + symbol.name.length() + 2 * symbol.accessorCount;
            if (n2 >= n) continue;
            symbol.aliasAccessor = true;
        }
        for (Symbol symbol : this.globals.values()) {
            for (Node node3 : symbol.uses) {
                this.replaceGlobalUse(node3);
            }
            if (!symbol.aliasAccessor) continue;
            this.addGlobalAliasNode(symbol, this.getAddingRoot(symbol.deepestModuleAccess));
        }
    }

    private void replaceGlobalUse(Node node) {
        String string = node.getString();
        if (this.globals.get((Object)string).aliasAccessor) {
            node.setString("GLOBAL_" + string);
            node.putBooleanProp(43, false);
            this.compiler.reportCodeChange();
        }
    }

    private void addGlobalAliasNode(Symbol symbol, Node node) {
        String string = symbol.name;
        Node node2 = Node.newString(38, symbol.name);
        node2.putBooleanProp(43, symbol.isConstant);
        Node node3 = Node.newString(38, "GLOBAL_" + string);
        node3.addChildToFront(node2);
        Node node4 = new Node(118, node3);
        node.addChildToFront(node4);
        this.compiler.reportCodeChange();
    }

    private Symbol newSymbolForGlobalVar(Node node) {
        return new Symbol(node.getString(), node.getBooleanProp(43));
    }

    private Symbol newSymbolForProperty(String string) {
        return new Symbol(string, false);
    }

    private class Symbol {
        public final String name;
        public int accessorCount = 0;
        public int mutatorCount = 0;
        public boolean aliasMutator = false;
        public boolean aliasAccessor = false;
        public final boolean isConstant;
        JSModule deepestModuleAccess = null;
        JSModule deepestModuleMutate = null;
        List<Node> uses = Lists.newArrayList();

        private Symbol(String string, boolean bl) {
            this.name = string;
            this.isConstant = bl;
        }

        void recordAccessor(NodeTraversal nodeTraversal) {
            ++this.accessorCount;
            if (AliasExternals.this.moduleGraph != null) {
                this.deepestModuleAccess = this.deepestModuleAccess == null ? nodeTraversal.getModule() : AliasExternals.this.moduleGraph.getDeepestCommonDependencyInclusive(nodeTraversal.getModule(), this.deepestModuleAccess);
            }
        }

        void recordMutator(NodeTraversal nodeTraversal) {
            ++this.mutatorCount;
            if (AliasExternals.this.moduleGraph != null) {
                this.deepestModuleMutate = this.deepestModuleMutate == null ? nodeTraversal.getModule() : AliasExternals.this.moduleGraph.getDeepestCommonDependencyInclusive(nodeTraversal.getModule(), this.deepestModuleMutate);
            }
        }
    }

    private final class GlobalGatherer
    extends NodeTraversal.AbstractPostOrderCallback {
        private GlobalGatherer() {
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            if (node.getType() == 38) {
                String string = node.getString();
                Scope.Var var = nodeTraversal.getScope().getVar(string);
                if (var != null && var.isLocal()) {
                    return;
                }
                Symbol symbol = (Symbol)AliasExternals.this.globals.get(string);
                if (symbol != null) {
                    boolean bl;
                    if (node.getParent().getType() == 118 || node.getParent().getType() == 105) {
                        AliasExternals.this.globals.remove(string);
                    }
                    boolean bl2 = bl = node2.getFirstChild() == node;
                    if (NodeUtil.isAssignmentOp(node2) && bl || node2.getType() == 30 && bl || node2.getType() == 102 || node2.getType() == 103) {
                        symbol.recordMutator(nodeTraversal);
                    } else {
                        symbol.recordAccessor(nodeTraversal);
                    }
                    symbol.uses.add(node);
                }
            }
        }
    }

    private class GetGlobals
    extends NodeTraversal.AbstractShallowCallback {
        private GetGlobals() {
        }

        private void getGlobalName(NodeTraversal nodeTraversal, Node node, Node node2) {
            if (node.getType() == 38) {
                boolean bl;
                JSDocInfo jSDocInfo = node.getJSDocInfo() == null ? node2.getJSDocInfo() : node.getJSDocInfo();
                boolean bl2 = bl = !AliasExternals.this.unaliasableGlobals.contains(node.getString()) && (jSDocInfo == null || !jSDocInfo.isNoAlias());
                if (bl) {
                    String string = node.getString();
                    Scope.Var var = nodeTraversal.getScope().getVar(string);
                    if (var != null && !var.isLocal()) {
                        AliasExternals.this.globals.put(string, AliasExternals.this.newSymbolForGlobalVar(node));
                    }
                }
            }
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            switch (node.getType()) {
                case 105: {
                    this.getGlobalName(nodeTraversal, node.getFirstChild(), node);
                    break;
                }
                case 118: {
                    for (Node node3 = node.getFirstChild(); node3 != null; node3 = node3.getNext()) {
                        this.getGlobalName(nodeTraversal, node3, node);
                    }
                    break;
                }
            }
        }
    }

    private final class PropertyGatherer
    extends NodeTraversal.AbstractPostOrderCallback {
        private PropertyGatherer() {
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            if (node.getType() == 33) {
                String string;
                Node node3 = node.getLastChild();
                if (this.canReplaceWithGetProp(node3, node, node2)) {
                    string = node3.getString();
                    ((Symbol)AliasExternals.this.props.get(string)).recordAccessor(nodeTraversal);
                    AliasExternals.this.accessors.add(node);
                }
                if (this.canReplaceWithSetProp(node3, node, node2)) {
                    string = node3.getString();
                    ((Symbol)AliasExternals.this.props.get(string)).recordMutator(nodeTraversal);
                    AliasExternals.this.mutators.add(node);
                }
            }
        }

        private boolean canReplaceWithGetProp(Node node, Node node2, Node node3) {
            boolean bl = node3.getType() == 37 && node3.getFirstChild() == node2;
            boolean bl2 = NodeUtil.isAssignmentOp(node3) && node3.getFirstChild() == node2;
            boolean bl3 = node3.getType() == 102 || node3.getType() == 103;
            return node.getType() == 40 && !bl2 && (!bl || !"eval".equals(node.getString())) && !bl3 && AliasExternals.this.props.containsKey(node.getString());
        }

        private boolean canReplaceWithSetProp(Node node, Node node2, Node node3) {
            boolean bl = node3.getType() == 86 && node3.getFirstChild() == node2;
            return node.getType() == 40 && bl && AliasExternals.this.props.containsKey(node.getString());
        }
    }

    private class GetAliasableNames
    extends NodeTraversal.AbstractPostOrderCallback {
        private final Set<String> whitelist;

        public GetAliasableNames(Set<String> set) {
            this.whitelist = set;
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            switch (node.getType()) {
                case 33: 
                case 35: {
                    Node node3 = node.getFirstChild().getNext();
                    if (node3.getType() != 40 || !this.whitelist.isEmpty() && !this.whitelist.contains(node3.getString())) break;
                    AliasExternals.this.props.put(node3.getString(), AliasExternals.this.newSymbolForProperty(node3.getString()));
                }
            }
        }
    }
}

