/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;

public class AstValidator
implements CompilerPass {
    private final ViolationHandler violationHandler;

    public AstValidator(ViolationHandler violationHandler) {
        this.violationHandler = violationHandler;
    }

    public AstValidator() {
        this.violationHandler = new ViolationHandler(){

            @Override
            public void handleViolation(String string, Node node) {
                throw new IllegalStateException(string + " Reference node " + node.toString());
            }
        };
    }

    @Override
    public void process(Node node, Node node2) {
        if (node != null) {
            this.validateCodeRoot(node);
        }
        if (node2 != null) {
            this.validateCodeRoot(node2);
        }
    }

    public void validateRoot(Node node) {
        this.validateNodeType(125, node);
        this.validateIsSynthetic(node);
        this.validateChildCount(node, 2);
        this.validateCodeRoot(node.getFirstChild());
        this.validateCodeRoot(node.getLastChild());
    }

    public void validateCodeRoot(Node node) {
        this.validateNodeType(125, node);
        this.validateIsSynthetic(node);
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
            this.validateScript(node2);
        }
    }

    public void validateScript(Node node) {
        this.validateNodeType(132, node);
        this.validateIsSynthetic(node);
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
            this.validateStatement(node2);
        }
    }

    public void validateStatement(Node node) {
        switch (node.getType()) {
            case 126: {
                this.validateLabel(node);
                return;
            }
            case 125: {
                this.validateBlock(node);
                return;
            }
            case 105: {
                this.validateFunctionStatement(node);
                return;
            }
            case 119: {
                this.validateWith(node);
                return;
            }
            case 115: {
                this.validateFor(node);
                return;
            }
            case 113: {
                this.validateWhile(node);
                return;
            }
            case 114: {
                this.validateDo(node);
                return;
            }
            case 110: {
                this.validateSwitch(node);
                return;
            }
            case 108: {
                this.validateIf(node);
                return;
            }
            case 118: {
                this.validateVar(node);
                return;
            }
            case 130: {
                this.validateExprStmt(node);
                return;
            }
            case 4: {
                this.validateReturn(node);
                return;
            }
            case 49: {
                this.validateThrow(node);
                return;
            }
            case 77: {
                this.validateTry(node);
                return;
            }
            case 116: {
                this.validateBreak(node);
                return;
            }
            case 117: {
                this.validateContinue(node);
                return;
            }
            case 124: {
                this.validateChildless(node);
                return;
            }
            case 152: {
                this.validateChildless(node);
                return;
            }
        }
        this.violation("Expected statement but was " + Node.tokenToName(node.getType()) + ".", node);
    }

    public void validateExpression(Node node) {
        switch (node.getType()) {
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                this.validateChildless(node);
                return;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 102: 
            case 103: 
            case 122: {
                this.validateUnaryOp(node);
                return;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 45: 
            case 46: 
            case 51: 
            case 52: 
            case 85: 
            case 100: 
            case 101: {
                this.validateBinaryOp(node);
                return;
            }
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: {
                this.validateAssignmentExpression(node);
                return;
            }
            case 98: {
                this.validateTrinaryOp(node);
                return;
            }
            case 40: {
                this.validateString(node);
                return;
            }
            case 39: {
                this.validateNumber(node);
                return;
            }
            case 38: {
                this.validateName(node);
                return;
            }
            case 35: {
                this.validateBinaryOp(node);
                return;
            }
            case 33: {
                this.validateGetProp(node);
                return;
            }
            case 63: {
                this.validateArrayLit(node);
                return;
            }
            case 64: {
                this.validateObjectLit(node);
                return;
            }
            case 47: {
                this.validateRegExpLit(node);
                return;
            }
            case 37: {
                this.validateCall(node);
                return;
            }
            case 30: {
                this.validateNew(node);
                return;
            }
            case 105: {
                this.validateFunctionExpression(node);
                return;
            }
        }
        this.violation("Expected expression but was " + Node.tokenToName(node.getType()), node);
    }

    private void validateBlock(Node node) {
        this.validateNodeType(125, node);
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
            this.validateStatement(node2);
        }
    }

    private void validateSyntheticBlock(Node node) {
        this.validateNodeType(125, node);
        this.validateIsSynthetic(node);
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
            this.validateStatement(node2);
        }
    }

    private void validateIsSynthetic(Node node) {
        if (!node.getBooleanProp(38)) {
            this.violation("Missing 'synthetic block' annotation.", node);
        }
    }

    private void validateLabel(Node node) {
        this.validateNodeType(126, node);
        this.validateChildCount(node, 2);
        this.validateLabelName(node.getFirstChild());
        this.validateStatement(node.getLastChild());
    }

    private void validateLabelName(Node node) {
        this.validateNodeType(153, node);
        this.validateNonEmptyString(node);
        this.validateChildCount(node, 0);
    }

    private void validateNonEmptyString(Node node) {
        this.validateNonNullString(node);
        if (node.getString().isEmpty()) {
            this.violation("Expected non-empty string.", node);
        }
    }

    private void validateNonNullString(Node node) {
        if (node.getString() == null) {
            this.violation("Expected non-null string.", node);
        }
    }

    private void validateName(Node node) {
        this.validateNodeType(38, node);
        this.validateNonEmptyString(node);
        this.validateChildCount(node, 0);
    }

    private void validateOptionalName(Node node) {
        this.validateNodeType(38, node);
        this.validateNonNullString(node);
        this.validateChildCount(node, 0);
    }

    private void validateFunctionStatement(Node node) {
        this.validateNodeType(105, node);
        this.validateChildCount(node, 3);
        this.validateName(node.getFirstChild());
        this.validateParameters(node.getChildAtIndex(1));
        this.validateBlock(node.getLastChild());
    }

    private void validateFunctionExpression(Node node) {
        this.validateNodeType(105, node);
        this.validateChildCount(node, 3);
        this.validateOptionalName(node.getFirstChild());
        this.validateParameters(node.getChildAtIndex(1));
        this.validateBlock(node.getLastChild());
    }

    private void validateParameters(Node node) {
        this.validateNodeType(83, node);
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
            this.validateName(node2);
        }
    }

    private void validateCall(Node node) {
        this.validateNodeType(37, node);
        this.validateMinimumChildCount(node, 1);
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
            this.validateExpression(node2);
        }
    }

    private void validateNew(Node node) {
        this.validateNodeType(30, node);
        this.validateMinimumChildCount(node, 1);
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
            this.validateExpression(node2);
        }
    }

    private void validateVar(Node node) {
        this.validateNodeType(118, node);
        this.validateMinimumChildCount(node, 1);
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
            this.validateNodeType(38, node2);
            this.validateNonEmptyString(node2);
            this.validateMaximumChildCount(node2, 1);
            if (!node2.hasChildren()) continue;
            this.validateExpression(node2.getFirstChild());
        }
    }

    private void validateFor(Node node) {
        this.validateNodeType(115, node);
        this.validateMinimumChildCount(node, 3);
        this.validateMaximumChildCount(node, 4);
        if (NodeUtil.isForIn(node)) {
            this.validateChildCount(node, 3);
            this.validateVarOrAssignmentTarget(node.getFirstChild());
            this.validateExpression(node.getChildAtIndex(1));
        } else {
            this.validateChildCount(node, 4);
            this.validateVarOrOptionalExpression(node.getFirstChild());
            this.validateOptionalExpression(node.getChildAtIndex(1));
            this.validateOptionalExpression(node.getChildAtIndex(2));
        }
        this.validateBlock(node.getLastChild());
    }

    private void validateVarOrOptionalExpression(Node node) {
        if (node.getType() == 118) {
            this.validateVar(node);
        } else {
            this.validateOptionalExpression(node);
        }
    }

    private void validateVarOrAssignmentTarget(Node node) {
        if (node.getType() == 118) {
            this.validateChildCount(node, 1);
            this.validateVar(node);
        } else {
            this.validateAssignmentTarget(node);
        }
    }

    private void validateWith(Node node) {
        this.validateNodeType(119, node);
        this.validateChildCount(node, 2);
        this.validateExpression(node.getFirstChild());
        this.validateBlock(node.getLastChild());
    }

    private void validateWhile(Node node) {
        this.validateNodeType(113, node);
        this.validateChildCount(node, 2);
        this.validateExpression(node.getFirstChild());
        this.validateBlock(node.getLastChild());
    }

    private void validateDo(Node node) {
        this.validateNodeType(114, node);
        this.validateChildCount(node, 2);
        this.validateBlock(node.getFirstChild());
        this.validateExpression(node.getLastChild());
    }

    private void validateIf(Node node) {
        this.validateNodeType(108, node);
        this.validateMinimumChildCount(node, 2);
        this.validateMaximumChildCount(node, 3);
        this.validateExpression(node.getFirstChild());
        this.validateBlock(node.getChildAtIndex(1));
        if (node.getChildCount() == 3) {
            this.validateBlock(node.getLastChild());
        }
    }

    private void validateExprStmt(Node node) {
        this.validateNodeType(130, node);
        this.validateChildCount(node, 1);
        this.validateExpression(node.getFirstChild());
    }

    private void validateReturn(Node node) {
        this.validateNodeType(4, node);
        this.validateMaximumChildCount(node, 1);
        if (node.hasChildren()) {
            this.validateExpression(node.getFirstChild());
        }
    }

    private void validateThrow(Node node) {
        this.validateNodeType(49, node);
        this.validateChildCount(node, 1);
        this.validateExpression(node.getFirstChild());
    }

    private void validateBreak(Node node) {
        this.validateNodeType(116, node);
        this.validateMaximumChildCount(node, 1);
        if (node.hasChildren()) {
            this.validateLabelName(node.getFirstChild());
        }
    }

    private void validateContinue(Node node) {
        this.validateNodeType(117, node);
        this.validateMaximumChildCount(node, 1);
        if (node.hasChildren()) {
            this.validateLabelName(node.getFirstChild());
        }
    }

    private void validateTry(Node node) {
        this.validateNodeType(77, node);
        this.validateMinimumChildCount(node, 2);
        this.validateMaximumChildCount(node, 3);
        this.validateBlock(node.getFirstChild());
        boolean bl = false;
        Node node2 = node.getChildAtIndex(1);
        this.validateNodeType(125, node2);
        this.validateMaximumChildCount(node2, 1);
        if (node2.hasChildren()) {
            this.validateCatch(node2.getFirstChild());
            bl = true;
        }
        if (node.getChildCount() == 3) {
            this.validateBlock(node.getLastChild());
            bl = true;
        }
        if (!bl) {
            this.violation("Missing catch or finally for try statement.", node);
        }
    }

    private void validateCatch(Node node) {
        this.validateNodeType(120, node);
        this.validateChildCount(node, 2);
        this.validateName(node.getFirstChild());
        this.validateBlock(node.getLastChild());
    }

    private void validateSwitch(Node node) {
        this.validateNodeType(110, node);
        this.validateMinimumChildCount(node, 1);
        this.validateExpression(node.getFirstChild());
        int n = 0;
        for (Node node2 = node.getFirstChild().getNext(); node2 != null; node2 = node2.getNext()) {
            this.validateSwitchMember(node.getLastChild());
            if (node2.getType() != 112) continue;
            ++n;
        }
        if (n > 1) {
            this.violation("Expected at most 1 'default' in switch but was " + n, node);
        }
    }

    private void validateSwitchMember(Node node) {
        switch (node.getType()) {
            case 111: {
                this.validateCase(node);
                return;
            }
            case 112: {
                this.validateDefault(node);
                return;
            }
        }
        this.violation("Expected switch member but was " + Node.tokenToName(node.getType()), node);
    }

    private void validateDefault(Node node) {
        this.validateNodeType(112, node);
        this.validateChildCount(node, 1);
        this.validateSyntheticBlock(node.getLastChild());
    }

    private void validateCase(Node node) {
        this.validateNodeType(111, node);
        this.validateChildCount(node, 2);
        this.validateExpression(node.getFirstChild());
        this.validateSyntheticBlock(node.getLastChild());
    }

    private void validateOptionalExpression(Node node) {
        if (node.getType() == 124) {
            this.validateChildless(node);
        } else {
            this.validateExpression(node);
        }
    }

    private void validateChildless(Node node) {
        this.validateChildCount(node, 0);
    }

    private void validateAssignmentExpression(Node node) {
        this.validateChildCount(node, 2);
        this.validateAssignmentTarget(node.getFirstChild());
        this.validateExpression(node.getLastChild());
    }

    private void validateAssignmentTarget(Node node) {
        switch (node.getType()) {
            case 33: 
            case 35: 
            case 38: {
                this.validateExpression(node);
                return;
            }
        }
        this.violation("Expected assignment target expression but was " + Node.tokenToName(node.getType()), node);
    }

    private void validateGetProp(Node node) {
        this.validateNodeType(33, node);
        this.validateChildCount(node, 2);
        this.validateExpression(node.getFirstChild());
        Node node2 = node.getLastChild();
        this.validateNodeType(40, node2);
        this.validateNonEmptyString(node2);
    }

    private void validateRegExpLit(Node node) {
        this.validateNodeType(47, node);
        this.validateMinimumChildCount(node, 1);
        this.validateMaximumChildCount(node, 2);
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
            this.validateString(node2);
        }
    }

    private void validateString(Node node) {
        this.validateNodeType(40, node);
        this.validateChildCount(node, 0);
        try {
            node.getString();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            this.violation("Invalid STRING node.", node);
        }
    }

    private void validateNumber(Node node) {
        this.validateNodeType(39, node);
        this.validateChildCount(node, 0);
        try {
            node.getDouble();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            this.violation("Invalid NUMBER node.", node);
        }
    }

    private void validateArrayLit(Node node) {
        this.validateNodeType(63, node);
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
            this.validateOptionalExpression(node2);
        }
    }

    private void validateObjectLit(Node node) {
        this.validateNodeType(64, node);
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
            this.validateObjectLitKey(node2);
        }
    }

    private void validateObjectLitKey(Node node) {
        switch (node.getType()) {
            case 147: {
                this.validateObjectLitGetKey(node);
                return;
            }
            case 148: {
                this.validateObjectLitSetKey(node);
                return;
            }
            case 40: {
                this.validateObjectLitStringKey(node);
                return;
            }
        }
        this.violation("Expected object literal key expression but was " + Node.tokenToName(node.getType()), node);
    }

    private void validateObjectLitGetKey(Node node) {
        Node node2;
        this.validateNodeType(147, node);
        this.validateChildCount(node, 1);
        this.validateObjectLiteralKeyName(node);
        Node node3 = node.getFirstChild();
        this.validateFunctionExpression(node3);
        if (!node3.getFirstChild().getString().isEmpty()) {
            this.violation("Expected unnamed function expression.", node);
        }
        if ((node2 = node3.getChildAtIndex(1)).hasChildren()) {
            this.violation("get methods must not have parameters.", node);
        }
    }

    private void validateObjectLitSetKey(Node node) {
        Node node2;
        this.validateNodeType(148, node);
        this.validateChildCount(node, 1);
        this.validateObjectLiteralKeyName(node);
        Node node3 = node.getFirstChild();
        this.validateFunctionExpression(node3);
        if (!node3.getFirstChild().getString().isEmpty()) {
            this.violation("Expected unnamed function expression.", node);
        }
        if (!(node2 = node3.getChildAtIndex(1)).hasOneChild()) {
            this.violation("set methods must have exactly one parameter.", node);
        }
    }

    private void validateObjectLitStringKey(Node node) {
        this.validateNodeType(40, node);
        this.validateChildCount(node, 1);
        this.validateObjectLiteralKeyName(node);
        this.validateExpression(node.getFirstChild());
    }

    private void validateObjectLiteralKeyName(Node node) {
        if (node.isQuotedString()) {
            try {
                node.getString();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                this.violation("getString failed for" + Node.tokenToName(node.getType()), node);
            }
        } else {
            this.validateNonEmptyString(node);
        }
    }

    private void validateUnaryOp(Node node) {
        this.validateChildCount(node, 1);
        this.validateExpression(node.getFirstChild());
    }

    private void validateBinaryOp(Node node) {
        this.validateChildCount(node, 2);
        this.validateExpression(node.getFirstChild());
        this.validateExpression(node.getLastChild());
    }

    private void validateTrinaryOp(Node node) {
        this.validateChildCount(node, 3);
        Node node2 = node.getFirstChild();
        this.validateExpression(node2);
        this.validateExpression(node2.getNext());
        this.validateExpression(node.getLastChild());
    }

    private void violation(String string, Node node) {
        this.violationHandler.handleViolation(string, node);
    }

    private void validateNodeType(int n, Node node) {
        if (node.getType() != n) {
            this.violation("Expected " + Node.tokenToName(n) + " but was " + Node.tokenToName(node.getType()), node);
        }
    }

    private void validateChildCount(Node node, int n) {
        boolean bl = false;
        if (n == 0) {
            bl = !node.hasChildren();
        } else if (n == 1) {
            bl = node.hasOneChild();
        } else {
            boolean bl2 = bl = node.getChildCount() == n;
        }
        if (!bl) {
            this.violation("Expected " + n + " children, but was " + node.getChildCount(), node);
        }
    }

    private void validateMinimumChildCount(Node node, int n) {
        boolean bl = false;
        if (n == 1) {
            bl = node.hasChildren();
        } else if (n == 2) {
            bl = node.hasMoreThanOneChild();
        } else {
            boolean bl2 = bl = node.getChildCount() >= n;
        }
        if (!bl) {
            this.violation("Expected at least " + n + " children, but was " + node.getChildCount(), node);
        }
    }

    private void validateMaximumChildCount(Node node, int n) {
        boolean bl = false;
        if (n == 1) {
            bl = !node.hasMoreThanOneChild();
        } else {
            boolean bl2 = bl = node.getChildCount() <= n;
        }
        if (!bl) {
            this.violation("Expected no more than " + n + " children, but was " + node.getChildCount(), node);
        }
    }

    public static interface ViolationHandler {
        public void handleViolation(String var1, Node var2);
    }
}

