/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.io.Serializable;

final class CheckGlobalThis
implements NodeTraversal.Callback {
    static final DiagnosticType GLOBAL_THIS = DiagnosticType.warning("JSC_USED_GLOBAL_THIS", "dangerous use of the global 'this' object");
    private final AbstractCompiler compiler;
    private Node assignLhsChild = null;

    CheckGlobalThis(AbstractCompiler abstractCompiler) {
        this.compiler = abstractCompiler;
    }

    @Override
    public boolean shouldTraverse(NodeTraversal nodeTraversal, Node node, Node node2) {
        Node node3;
        Serializable serializable;
        if (node.getType() == 105) {
            JSDocInfo jSDocInfo;
            serializable = this.getFunctionJsDocInfo(node);
            if (serializable != null && (((JSDocInfo)serializable).isConstructor() || ((JSDocInfo)serializable).isInterface() || ((JSDocInfo)serializable).hasThisType() || ((JSDocInfo)serializable).isOverride())) {
                return false;
            }
            int n = node2.getType();
            if (n != 125 && n != 132 && n != 38 && n != 86 && n != 40) {
                return false;
            }
            node3 = node2.getParent();
            if (NodeUtil.isObjectLitKey(node2, node3) && (jSDocInfo = node3.getJSDocInfo()) != null && jSDocInfo.getLendsName() != null && jSDocInfo.getLendsName().endsWith(".prototype")) {
                return false;
            }
        }
        if (node2 != null && node2.getType() == 86) {
            serializable = node2.getFirstChild();
            Node node4 = ((Node)serializable).getNext();
            if (node == serializable) {
                if (this.assignLhsChild == null) {
                    this.assignLhsChild = serializable;
                }
            } else if (NodeUtil.isGet((Node)serializable)) {
                if (((Node)serializable).getType() == 33 && ((Node)serializable).getLastChild().getString().equals("prototype")) {
                    return false;
                }
                node3 = ((Node)serializable).getFirstChild();
                if (node3.getType() == 33 && node3.getLastChild().getString().equals("prototype")) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
        if (node.getType() == 42 && this.shouldReportThis(node, node2)) {
            this.compiler.report(nodeTraversal.makeError(node, GLOBAL_THIS, new String[0]));
        }
        if (node == this.assignLhsChild) {
            this.assignLhsChild = null;
        }
    }

    private boolean shouldReportThis(Node node, Node node2) {
        if (this.assignLhsChild != null) {
            return true;
        }
        return node2 != null && NodeUtil.isGet(node2);
    }

    private JSDocInfo getFunctionJsDocInfo(Node node) {
        Node node2;
        int n;
        JSDocInfo jSDocInfo = node.getJSDocInfo();
        Node node3 = node.getParent();
        if (jSDocInfo == null && ((n = node3.getType()) == 38 || n == 86) && (jSDocInfo = node3.getJSDocInfo()) == null && n == 38 && (node2 = node3.getParent()).getType() == 118) {
            jSDocInfo = node2.getJSDocInfo();
        }
        return jSDocInfo;
    }
}

