/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.Lists;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import javax.annotation.Nullable;

class CreateSyntheticBlocks
implements CompilerPass {
    static final DiagnosticType UNMATCHED_START_MARKER = DiagnosticType.warning("JSC_UNMATCHED_START_MARKER", "Unmatched {0}");
    static final DiagnosticType UNMATCHED_END_MARKER = DiagnosticType.warning("JSC_UNMATCHED_END_MARKER", "Unmatched {1} - {0} not in the same block");
    static final DiagnosticType INVALID_MARKER_USAGE = DiagnosticType.warning("JSC_INVALID_MARKER_USAGE", "Marker {0} can only be used in a simple call expression");
    private final AbstractCompiler compiler;
    private final String startMarkerName;
    private final String endMarkerName;
    private final Deque<Node> markerStack = new ArrayDeque<Node>();
    private final List<Marker> validMarkers = Lists.newArrayList();

    public CreateSyntheticBlocks(AbstractCompiler abstractCompiler, String string, String string2) {
        this.compiler = abstractCompiler;
        this.startMarkerName = string;
        this.endMarkerName = string2;
    }

    @Override
    public void process(Node node, Node node2) {
        NodeTraversal.traverse(this.compiler, node2, new Callback());
        for (Node object : this.markerStack) {
            this.compiler.report(JSError.make(NodeUtil.getSourceName(object), object, UNMATCHED_START_MARKER, this.startMarkerName));
        }
        for (Marker marker : this.validMarkers) {
            this.addBlocks(marker);
        }
    }

    private void addBlocks(Marker marker) {
        Node node = marker.endMarker.getParent();
        Node node2 = new Node(125);
        node2.setIsSyntheticBlock(true);
        node.addChildBefore(node2, marker.startMarker);
        Node node3 = new Node(125);
        node3.setIsSyntheticBlock(true);
        this.moveSiblingExclusive(node, node3, marker.startMarker, marker.endMarker);
        node2.addChildToBack(node.removeChildAfter(node2));
        node2.addChildToBack(node3);
        node2.addChildToBack(node.removeChildAfter(node2));
        this.compiler.reportCodeChange();
    }

    private void moveSiblingExclusive(Node node, Node node2, @Nullable Node node3, @Nullable Node node4) {
        while (this.childAfter(node, node3) != node4) {
            Node node5 = this.removeChildAfter(node, node3);
            node2.addChildToBack(node5);
        }
    }

    private Node childAfter(Node node, @Nullable Node node2) {
        if (node2 == null) {
            return node.getFirstChild();
        }
        return node2.getNext();
    }

    private Node removeChildAfter(Node node, @Nullable Node node2) {
        if (node2 == null) {
            return node.removeFirstChild();
        }
        return node.removeChildAfter(node2);
    }

    private class Callback
    extends NodeTraversal.AbstractPostOrderCallback {
        private Callback() {
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            if (node.getType() != 37 || node.getFirstChild().getType() != 38) {
                return;
            }
            Node node3 = node.getFirstChild();
            String string = node3.getString();
            if (CreateSyntheticBlocks.this.startMarkerName.equals(string)) {
                if (node2.getType() != 130) {
                    CreateSyntheticBlocks.this.compiler.report(nodeTraversal.makeError(node, INVALID_MARKER_USAGE, CreateSyntheticBlocks.this.startMarkerName));
                    return;
                }
                CreateSyntheticBlocks.this.markerStack.push(node2);
                return;
            }
            if (!CreateSyntheticBlocks.this.endMarkerName.equals(string)) {
                return;
            }
            Node node4 = node2;
            if (node4.getType() != 130) {
                CreateSyntheticBlocks.this.compiler.report(nodeTraversal.makeError(node, INVALID_MARKER_USAGE, CreateSyntheticBlocks.this.endMarkerName));
                return;
            }
            if (CreateSyntheticBlocks.this.markerStack.isEmpty()) {
                CreateSyntheticBlocks.this.compiler.report(nodeTraversal.makeError(node, UNMATCHED_END_MARKER, CreateSyntheticBlocks.this.startMarkerName, CreateSyntheticBlocks.this.endMarkerName));
                return;
            }
            Node node5 = (Node)CreateSyntheticBlocks.this.markerStack.pop();
            if (node4.getParent() != node5.getParent()) {
                CreateSyntheticBlocks.this.compiler.report(nodeTraversal.makeError(node, UNMATCHED_END_MARKER, CreateSyntheticBlocks.this.startMarkerName, CreateSyntheticBlocks.this.endMarkerName));
                return;
            }
            CreateSyntheticBlocks.this.validMarkers.add(new Marker(node5, node4));
        }
    }

    private class Marker {
        final Node startMarker;
        final Node endMarker;

        public Marker(Node node, Node node2) {
            this.startMarker = node;
            this.endMarker = node2;
        }
    }
}

