/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DiagnosticGroup {
    private final Set<DiagnosticType> types;
    private final String name;
    private static final Map<DiagnosticType, DiagnosticGroup> singletons = Maps.newHashMap();

    DiagnosticGroup(String string, DiagnosticType ... diagnosticTypeArray) {
        this.name = string;
        this.types = ImmutableSet.copyOf(Arrays.asList(diagnosticTypeArray));
    }

    public DiagnosticGroup(DiagnosticType ... diagnosticTypeArray) {
        this((String)null, diagnosticTypeArray);
    }

    private DiagnosticGroup(DiagnosticType diagnosticType) {
        this.name = null;
        this.types = ImmutableSet.of((Object)diagnosticType);
    }

    static DiagnosticGroup forType(DiagnosticType diagnosticType) {
        if (!singletons.containsKey(diagnosticType)) {
            singletons.put(diagnosticType, new DiagnosticGroup(diagnosticType));
        }
        return singletons.get(diagnosticType);
    }

    public DiagnosticGroup(DiagnosticGroup ... diagnosticGroupArray) {
        this((String)null, diagnosticGroupArray);
    }

    public DiagnosticGroup(String string, DiagnosticGroup ... diagnosticGroupArray) {
        HashSet hashSet = Sets.newHashSet();
        for (DiagnosticGroup diagnosticGroup : diagnosticGroupArray) {
            hashSet.addAll(diagnosticGroup.types);
        }
        this.name = string;
        this.types = ImmutableSet.copyOf((Collection)hashSet);
    }

    public boolean matches(JSError jSError) {
        return this.matches(jSError.getType());
    }

    public boolean matches(DiagnosticType diagnosticType) {
        return this.types.contains(diagnosticType);
    }

    boolean isSubGroup(DiagnosticGroup diagnosticGroup) {
        for (DiagnosticType diagnosticType : diagnosticGroup.types) {
            if (this.matches(diagnosticType)) continue;
            return false;
        }
        return true;
    }

    Collection<DiagnosticType> getTypes() {
        return this.types;
    }

    public String toString() {
        return this.name == null ? super.toString() : "DiagnosticGroup<" + this.name + ">";
    }
}

