/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.MakeDeclaredNamesUnique;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.SyntacticScopeCreator;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.util.Map;
import java.util.Set;

class Normalize
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final boolean assertOnChange;
    private static final boolean CONVERT_WHILE_TO_FOR = true;
    static final boolean MAKE_LOCAL_NAMES_UNIQUE = true;
    public static final DiagnosticType CATCH_BLOCK_VAR_ERROR = DiagnosticType.error("JSC_CATCH_BLOCK_VAR_ERROR", "The use of scope variable {0} is not allowed within a catch block with a catch exception of the same name.");

    Normalize(AbstractCompiler abstractCompiler, boolean bl) {
        this.compiler = abstractCompiler;
        this.assertOnChange = bl;
    }

    static Node parseAndNormalizeSyntheticCode(AbstractCompiler abstractCompiler, String string, String string2) {
        Node node = abstractCompiler.parseSyntheticCode(string);
        NodeTraversal.traverse(abstractCompiler, node, new NormalizeStatements(abstractCompiler, false));
        NodeTraversal.traverse(abstractCompiler, node, new MakeDeclaredNamesUnique(new MakeDeclaredNamesUnique.BoilerplateRenamer(abstractCompiler.getUniqueNameIdSupplier(), string2)));
        return node;
    }

    static Node parseAndNormalizeTestCode(AbstractCompiler abstractCompiler, String string, String string2) {
        Node node = abstractCompiler.parseTestCode(string);
        NodeTraversal.traverse(abstractCompiler, node, new NormalizeStatements(abstractCompiler, false));
        NodeTraversal.traverse(abstractCompiler, node, new MakeDeclaredNamesUnique());
        return node;
    }

    private void reportCodeChange(String string) {
        if (this.assertOnChange) {
            throw new IllegalStateException("Normalize constraints violated:\n" + string);
        }
        this.compiler.reportCodeChange();
    }

    @Override
    public void process(Node node, Node node2) {
        new NodeTraversal(this.compiler, new NormalizeStatements(this.compiler, this.assertOnChange)).traverseRoots(node, node2);
        MakeDeclaredNamesUnique makeDeclaredNamesUnique = new MakeDeclaredNamesUnique();
        NodeTraversal nodeTraversal = new NodeTraversal(this.compiler, makeDeclaredNamesUnique);
        nodeTraversal.traverseRoots(node, node2);
        this.removeDuplicateDeclarations(node, node2);
        new PropagateConstantAnnotationsOverVars(this.compiler, this.assertOnChange).process(node, node2);
        if (!this.compiler.getLifeCycleStage().isNormalized()) {
            this.compiler.setLifeCycleStage(AbstractCompiler.LifeCycleStage.NORMALIZED);
        }
    }

    private void removeDuplicateDeclarations(Node node, Node node2) {
        ScopeTicklingCallback scopeTicklingCallback = new ScopeTicklingCallback();
        SyntacticScopeCreator syntacticScopeCreator = new SyntacticScopeCreator(this.compiler, new DuplicateDeclarationHandler());
        NodeTraversal nodeTraversal = new NodeTraversal(this.compiler, scopeTicklingCallback, syntacticScopeCreator);
        nodeTraversal.traverseRoots(node, node2);
    }

    private final class ScopeTicklingCallback
    implements NodeTraversal.ScopedCallback {
        private ScopeTicklingCallback() {
        }

        @Override
        public void enterScope(NodeTraversal nodeTraversal) {
            nodeTraversal.getScope();
        }

        @Override
        public void exitScope(NodeTraversal nodeTraversal) {
        }

        @Override
        public boolean shouldTraverse(NodeTraversal nodeTraversal, Node node, Node node2) {
            return true;
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
        }
    }

    private final class DuplicateDeclarationHandler
    implements SyntacticScopeCreator.RedeclarationHandler {
        private Set<Scope.Var> hasOkDuplicateDeclaration = Sets.newHashSet();

        private DuplicateDeclarationHandler() {
        }

        @Override
        public void onRedeclaration(Scope scope, String string, Node node, CompilerInput compilerInput) {
            Preconditions.checkState((node.getType() == 38 ? 1 : 0) != 0);
            Node node2 = node.getParent();
            Scope.Var var = scope.getVar(string);
            if (var != null && scope.isGlobal() && var.isExtern() && !compilerInput.isExtern() && this.hasOkDuplicateDeclaration.add(var)) {
                return;
            }
            if (var != null && var.getParentNode().getType() == 120) {
                string = MakeDeclaredNamesUnique.ContextualRenameInverter.getOrginalName(string);
                Normalize.this.compiler.report(JSError.make(compilerInput.getName(), node, CATCH_BLOCK_VAR_ERROR, string));
            } else if (var != null && node2.getType() == 105) {
                if (var.getParentNode().getType() == 118) {
                    scope.undeclare(var);
                    scope.declare(string, node, node.getJSType(), var.input);
                    this.replaceVarWithAssignment(var.getNameNode(), var.getParentNode(), var.getParentNode().getParent());
                }
            } else if (node2.getType() == 118) {
                Preconditions.checkState((boolean)node2.hasOneChild());
                this.replaceVarWithAssignment(node, node2, node2.getParent());
            }
        }

        private void replaceVarWithAssignment(Node node, Node node2, Node node3) {
            if (node.hasChildren()) {
                node2.removeChild(node);
                Node node4 = node.getFirstChild();
                node.removeChild(node4);
                Node node5 = new Node(86, node, node4);
                node5.copyInformationFrom(node2);
                node3.replaceChild(node2, NodeUtil.newExpr(node5));
            } else if (NodeUtil.isStatementBlock(node3)) {
                node3.removeChild(node2);
            } else if (node3.getType() == 115) {
                node2.removeChild(node);
                node3.replaceChild(node2, node);
            } else {
                Preconditions.checkState((node3.getType() == 126 ? 1 : 0) != 0);
                throw new IllegalStateException("Unexpected LABEL");
            }
            Normalize.this.reportCodeChange("Duplicate VAR declaration");
        }
    }

    static class NormalizeStatements
    implements NodeTraversal.Callback {
        private final AbstractCompiler compiler;
        private final boolean assertOnChange;

        NormalizeStatements(AbstractCompiler abstractCompiler, boolean bl) {
            this.compiler = abstractCompiler;
            this.assertOnChange = bl;
        }

        private void reportCodeChange(String string) {
            if (this.assertOnChange) {
                throw new IllegalStateException("Normalize constraints violated:\n" + string);
            }
            this.compiler.reportCodeChange();
        }

        @Override
        public boolean shouldTraverse(NodeTraversal nodeTraversal, Node node, Node node2) {
            this.doStatementNormalizations(nodeTraversal, node, node2);
            return true;
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            switch (node.getType()) {
                case 113: {
                    Node node3 = node.getFirstChild();
                    node.setType(115);
                    Node node4 = new Node(124);
                    node4.copyInformationFrom(node);
                    node.addChildBefore(node4, node3);
                    node.addChildAfter(node4.cloneNode(), node3);
                    this.reportCodeChange("WHILE node");
                    break;
                }
                case 105: {
                    this.normalizeFunctionDeclaration(node);
                    break;
                }
                case 38: 
                case 40: 
                case 147: 
                case 148: {
                    if (this.compiler.getLifeCycleStage().isNormalizedObfuscated()) break;
                    this.annotateConstantsByConvention(node, node2);
                }
            }
        }

        private void annotateConstantsByConvention(Node node, Node node2) {
            boolean bl;
            boolean bl2;
            Preconditions.checkState((node.getType() == 38 || node.getType() == 40 || node.getType() == 147 || node.getType() == 148 ? 1 : 0) != 0);
            boolean bl3 = NodeUtil.isObjectLitKey(node, node2);
            boolean bl4 = bl2 = bl3 || node2.getType() == 33 && node2.getLastChild() == node;
            if ((node.getType() == 38 || bl2) && !(bl = node.getBooleanProp(43)) && NodeUtil.isConstantByConvention(this.compiler.getCodingConvention(), node, node2)) {
                if (this.assertOnChange) {
                    String string = node.getString();
                    throw new IllegalStateException("Unexpected const change.\n  name: " + string + "\n" + "  parent:" + node.getParent().toStringTree());
                }
                node.putBooleanProp(43, true);
            }
        }

        private void normalizeFunctionDeclaration(Node node) {
            Preconditions.checkState((node.getType() == 105 ? 1 : 0) != 0);
            if (!NodeUtil.isFunctionExpression(node) && !NodeUtil.isHoistedFunctionDeclaration(node)) {
                this.rewriteFunctionDeclaration(node);
            }
        }

        private void rewriteFunctionDeclaration(Node node) {
            Node node2 = node.getFirstChild();
            Node node3 = node2.cloneNode();
            Node node4 = new Node(118, node3, node.getLineno(), node.getCharno());
            node4.copyInformationFrom(node);
            node2.setString("");
            Node node5 = node.getParent();
            node5.replaceChild(node, node4);
            node3.addChildToFront(node);
            this.reportCodeChange("Function declaration");
        }

        private void doStatementNormalizations(NodeTraversal nodeTraversal, Node node, Node node2) {
            if (node.getType() == 126) {
                this.normalizeLabels(node);
            }
            if (NodeUtil.isStatementBlock(node) || node.getType() == 126) {
                this.extractForInitializer(node, null, null);
            }
            if (NodeUtil.isStatementBlock(node)) {
                this.splitVarDeclarations(node);
            }
            if (node.getType() == 105) {
                this.moveNamedFunctions(node.getLastChild());
            }
        }

        private void normalizeLabels(Node node) {
            Preconditions.checkArgument((node.getType() == 126 ? 1 : 0) != 0);
            Node node2 = node.getLastChild();
            switch (node2.getType()) {
                case 113: 
                case 114: 
                case 115: 
                case 125: 
                case 126: {
                    return;
                }
            }
            Node node3 = new Node(125);
            node3.copyInformationFrom(node2);
            node.replaceChild(node2, node3);
            node3.addChildToFront(node2);
            this.reportCodeChange("LABEL normalization");
        }

        private void extractForInitializer(Node node, Node node2, Node node3) {
            Node node4 = node.getFirstChild();
            while (node4 != null) {
                Node node5 = node4.getNext();
                Node node6 = node2 == null ? node4 : node2;
                Node node7 = node2 == null ? node : node3;
                switch (node4.getType()) {
                    case 126: {
                        this.extractForInitializer(node4, node6, node7);
                        break;
                    }
                    case 115: {
                        Node node8;
                        Node node9;
                        Node node10;
                        if (NodeUtil.isForIn(node4)) {
                            node10 = node4.getFirstChild();
                            if (node10.getType() != 118) break;
                            node9 = node10;
                            node8 = node9.getFirstChild().cloneNode();
                            node10.getParent().replaceChild(node10, node8);
                            node7.addChildBefore(node9, node6);
                            this.reportCodeChange("FOR-IN var declaration");
                            break;
                        }
                        if (node4.getFirstChild().getType() == 124) break;
                        node10 = node4.getFirstChild();
                        node9 = new Node(124);
                        node9.copyInformationFrom(node4);
                        node4.replaceChild(node10, node9);
                        node8 = node10.getType() == 118 ? node10 : NodeUtil.newExpr(node10);
                        node7.addChildBefore(node8, node6);
                        this.reportCodeChange("FOR initializer");
                    }
                }
                node4 = node5;
            }
        }

        private void splitVarDeclarations(Node node) {
            Node node2 = node.getFirstChild();
            while (node2 != null) {
                Node node3 = node2.getNext();
                if (node2.getType() == 118) {
                    if (this.assertOnChange && !node2.hasChildren()) {
                        throw new IllegalStateException("Empty VAR node.");
                    }
                    while (node2.getFirstChild() != node2.getLastChild()) {
                        Node node4 = node2.getFirstChild();
                        node2.removeChild(node4);
                        Node node5 = new Node(118, node4, node.getLineno(), node.getCharno());
                        node.addChildBefore(node5, node2);
                        this.reportCodeChange("VAR with multiple children");
                    }
                }
                node2 = node3;
            }
        }

        private void moveNamedFunctions(Node node) {
            Node node2;
            Preconditions.checkState((node.getParent().getType() == 105 ? 1 : 0) != 0);
            Node node3 = null;
            for (node2 = node.getFirstChild(); node2 != null && NodeUtil.isFunctionDeclaration(node2); node2 = node2.getNext()) {
                node3 = node2;
            }
            Node node4 = node3;
            while (node2 != null) {
                Node node5 = node2.getNext();
                if (NodeUtil.isFunctionDeclaration(node2)) {
                    Preconditions.checkNotNull((Object)node3);
                    node.removeChildAfter(node3);
                    node4 = this.addToFront(node, node2, node4);
                    this.reportCodeChange("Move function declaration not at top of function");
                } else {
                    node3 = node2;
                }
                node2 = node5;
            }
        }

        private Node addToFront(Node node, Node node2, Node node3) {
            if (node3 == null) {
                node.addChildToFront(node2);
            } else {
                node.addChildAfter(node2, node3);
            }
            return node2;
        }
    }

    static class VerifyConstants
    extends NodeTraversal.AbstractPostOrderCallback
    implements CompilerPass {
        private final AbstractCompiler compiler;
        private final boolean checkUserDeclarations;
        private Map<String, Boolean> constantMap = Maps.newHashMap();

        VerifyConstants(AbstractCompiler abstractCompiler, boolean bl) {
            this.compiler = abstractCompiler;
            this.checkUserDeclarations = bl;
        }

        @Override
        public void process(Node node, Node node2) {
            Node node3 = node2.getParent();
            Preconditions.checkState((node3 != null ? 1 : 0) != 0);
            Preconditions.checkState((boolean)node3.hasChild(node));
            NodeTraversal.traverseRoots(this.compiler, Lists.newArrayList((Object[])new Node[]{node, node2}), this);
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            if (node.getType() == 38) {
                Boolean bl;
                String string = node.getString();
                if (node.getString().isEmpty()) {
                    return;
                }
                boolean bl2 = node.getBooleanProp(43);
                if (this.checkUserDeclarations) {
                    boolean bl3 = false;
                    CodingConvention codingConvention = this.compiler.getCodingConvention();
                    if (NodeUtil.isConstantName(node) || NodeUtil.isConstantByConvention(codingConvention, node, node2)) {
                        bl3 = true;
                    } else {
                        bl3 = false;
                        JSDocInfo jSDocInfo = null;
                        Scope.Var var = nodeTraversal.getScope().getVar(node.getString());
                        if (var != null) {
                            jSDocInfo = var.getJSDocInfo();
                        }
                        bl3 = jSDocInfo != null && jSDocInfo.isConstant();
                    }
                    if (bl3) {
                        Preconditions.checkState((bl3 == bl2 ? 1 : 0) != 0, (Object)("The name " + string + " is not annotated as constant."));
                    } else {
                        Preconditions.checkState((bl3 == bl2 ? 1 : 0) != 0, (Object)("The name " + string + " should not be annotated as constant."));
                    }
                }
                if ((bl = this.constantMap.get(string)) == null) {
                    this.constantMap.put(string, bl2);
                } else {
                    Preconditions.checkState((bl == bl2 ? 1 : 0) != 0, (Object)("The name " + string + " is not consistently annotated as " + "constant."));
                }
            }
        }
    }

    static class PropagateConstantAnnotationsOverVars
    extends NodeTraversal.AbstractPostOrderCallback
    implements CompilerPass {
        private final AbstractCompiler compiler;
        private final boolean assertOnChange;

        PropagateConstantAnnotationsOverVars(AbstractCompiler abstractCompiler, boolean bl) {
            this.compiler = abstractCompiler;
            this.assertOnChange = bl;
        }

        @Override
        public void process(Node node, Node node2) {
            new NodeTraversal(this.compiler, this).traverseRoots(node, node2);
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            if (node.getType() == 38) {
                if (node.getString().isEmpty()) {
                    return;
                }
                JSDocInfo jSDocInfo = null;
                Scope.Var var = nodeTraversal.getScope().getVar(node.getString());
                if (var != null) {
                    jSDocInfo = var.getJSDocInfo();
                }
                boolean bl = jSDocInfo != null && jSDocInfo.isConstant() || NodeUtil.isConstantByConvention(this.compiler.getCodingConvention(), node, node2);
                boolean bl2 = node.getBooleanProp(43);
                if (bl && !bl2) {
                    if (this.assertOnChange) {
                        String string = node.getString();
                        throw new IllegalStateException("Unexpected const change.\n  name: " + string + "\n" + "  parent:" + node.getParent().toStringTree());
                    }
                    node.putBooleanProp(43, true);
                }
            }
        }
    }
}

