/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.VariableNameGenerator;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.Deque;

class OperaCompoundAssignFix
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass,
NodeTraversal.ScopedCallback {
    private AbstractCompiler compiler;
    private final Deque<VariableNameGenerator> names;

    @Override
    public void enterScope(NodeTraversal nodeTraversal) {
        this.names.push(new VariableNameGenerator(nodeTraversal.getScope()));
    }

    @Override
    public void exitScope(NodeTraversal nodeTraversal) {
        this.names.pop();
    }

    OperaCompoundAssignFix(AbstractCompiler abstractCompiler) {
        this.compiler = abstractCompiler;
        this.names = Lists.newLinkedList();
    }

    @Override
    public void process(Node node, Node node2) {
        ArrayList arrayList = Lists.newArrayList((Object[])new Node[]{node, node2});
        NodeTraversal.traverseRoots(this.compiler, arrayList, this);
    }

    @Override
    public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
        if (!NodeUtil.isName(node)) {
            return;
        }
        if (!NodeUtil.isGet(node2)) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        Node node3 = null;
        Node node4 = node;
        while (!NodeUtil.isExpressionNode(node2) && !NodeUtil.isStatementBlock(node2)) {
            if (NodeUtil.isAssign(node2) && NodeUtil.isName(node2.getFirstChild()) && node2.getFirstChild().getString().equals(node.getString()) && bl) {
                bl2 = true;
                break;
            }
            if (NodeUtil.isAssignmentOp(node2) && node2.getLastChild() == node4) {
                if (node3 == null) {
                    bl = true;
                }
                node3 = node2;
            }
            node4 = node2;
            node2 = node2.getParent();
        }
        if (!bl2 || !bl) {
            return;
        }
        this.applyWorkAround(node2, nodeTraversal);
    }

    private void applyWorkAround(Node node, NodeTraversal nodeTraversal) {
        Preconditions.checkArgument((boolean)NodeUtil.isAssign(node));
        Node node2 = node.getParent();
        Node node3 = new Node(85);
        node3.copyInformationFrom(node);
        node2.replaceChild(node, node3);
        String string = this.names.peek().getNextNewName();
        Node node4 = new Node(86, Node.newString(38, string));
        node4.copyInformationFromForTree(node);
        node4.addChildToBack(node.getLastChild().detachFromParent());
        node3.addChildrenToBack(node4);
        node.addChildrenToBack(Node.newString(38, string).copyInformationFrom(node));
        node3.addChildrenToBack(node);
        Node node5 = nodeTraversal.getScopeRoot();
        Node node6 = new Node(118, Node.newString(38, string));
        node6.copyInformationFromForTree(node);
        if (NodeUtil.isStatementBlock(node5)) {
            node5 = this.compiler.getNodeForCodeInsertion(nodeTraversal.getModule());
            node5.addChildrenToFront(node6);
        } else {
            node5.getLastChild().addChildrenToFront(node6);
        }
        this.compiler.reportCodeChange();
    }
}

