/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractPeepholeOptimization;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;

public class PeepholeCollectPropertyAssignments
extends AbstractPeepholeOptimization {
    @Override
    Node optimizeSubtree(Node node) {
        if (node.getType() != 132 && node.getType() != 125) {
            return node;
        }
        boolean bl = false;
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
            Node node3;
            Node node4;
            if (node2.getType() != 118 && !NodeUtil.isExprAssign(node2) || !this.isPropertyAssignmentToName(node2.getNext())) continue;
            Preconditions.checkState((boolean)node2.hasOneChild());
            Node node5 = this.getName(node2);
            if (node5.getType() != 38 || (node4 = this.getValue(node2)) == null || !this.isInterestingValue(node4)) continue;
            while ((node3 = node2.getNext()) != null && this.collectProperty(node3, node5.getString(), node4)) {
                bl = true;
            }
        }
        if (bl) {
            this.reportCodeChange();
        }
        return node;
    }

    private Node getName(Node node) {
        if (node.getType() == 118) {
            return node.getFirstChild();
        }
        if (NodeUtil.isExprAssign(node)) {
            return node.getFirstChild().getFirstChild();
        }
        throw new IllegalStateException();
    }

    private Node getValue(Node node) {
        if (node.getType() == 118) {
            return node.getFirstChild().getFirstChild();
        }
        if (NodeUtil.isExprAssign(node)) {
            return node.getFirstChild().getLastChild();
        }
        throw new IllegalStateException();
    }

    boolean isInterestingValue(Node node) {
        return node.getType() == 64 || node.getType() == 63;
    }

    private boolean isPropertyAssignmentToName(Node node) {
        if (node == null) {
            return false;
        }
        if (!NodeUtil.isExprAssign(node)) {
            return false;
        }
        Node node2 = node.getFirstChild();
        Node node3 = node2.getFirstChild();
        if (node3.getType() != 35 && node3.getType() != 33) {
            return false;
        }
        Node node4 = node3.getFirstChild();
        return node4.getType() == 38;
    }

    private boolean collectProperty(Node node, String string, Node node2) {
        if (!this.isPropertyAssignmentToName(node)) {
            return false;
        }
        Node node3 = node.getFirstChild().getFirstChild();
        if (!string.equals(node3.getFirstChild().getString())) {
            return false;
        }
        Node node4 = node3.getNext();
        if (NodeUtil.mayHaveSideEffects(node4) || NodeUtil.canBeSideEffected(node4)) {
            return false;
        }
        if (PeepholeCollectPropertyAssignments.mightContainForwardReference(node4, string)) {
            return false;
        }
        switch (node2.getType()) {
            case 63: {
                if (this.collectArrayProperty(node2, node)) break;
                return false;
            }
            case 64: {
                if (this.collectObjectProperty(node2, node)) break;
                return false;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return true;
    }

    private boolean collectArrayProperty(Node node, Node node2) {
        int n;
        Node node3 = node2.getFirstChild();
        int n2 = node.getChildCount();
        Node node4 = node3.getFirstChild();
        Node node5 = node4.getNext();
        if (node4.getType() != 35) {
            return false;
        }
        Node node6 = node4.getFirstChild();
        Node node7 = node6.getNext();
        if (node7.getType() != 39) {
            return false;
        }
        double d = node7.getDouble();
        if (!(d >= 0.0) || Double.isInfinite(d) || d > 2.147483647E9) {
            return false;
        }
        int n3 = (int)d;
        if (d != (double)n3) {
            return false;
        }
        if (n + 4 < n3) {
            return false;
        }
        if (n3 > n) {
            for (n = n2 - 1; n < n3 - 1; ++n) {
                Node node8 = new Node(124).copyInformationFrom(node);
                node.addChildToBack(node8);
            }
            node.addChildToBack(node5.detachFromParent());
        } else {
            Node node9 = node.getChildAtIndex(n3);
            if (node9.getType() != 124) {
                return false;
            }
            node.replaceChild(node9, node5.detachFromParent());
        }
        node2.detachFromParent();
        return true;
    }

    private boolean collectObjectProperty(Node node, Node node2) {
        Node node3 = node2.getFirstChild();
        Node node4 = node3.getFirstChild();
        Node node5 = node4.getNext();
        Node node6 = node4.getFirstChild();
        Node node7 = node6.getNext();
        if (node4.getType() == 35 && node7.getType() != 40 && node7.getType() != 39) {
            return false;
        }
        String string = node7.getType() == 39 ? NodeUtil.getStringValue(node7) : node7.getString();
        Node node8 = Node.newString(string).copyInformationFrom(node7);
        if (node4.getType() == 35) {
            node8.setQuotedString();
        }
        Node node9 = node5.detachFromParent();
        node8.addChildToBack(node9);
        node.addChildToBack(node8);
        node2.detachFromParent();
        return true;
    }

    private static boolean mightContainForwardReference(Node node, String string) {
        if (node.getType() == 38) {
            return string.equals(node.getString());
        }
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
            if (!PeepholeCollectPropertyAssignments.mightContainForwardReference(node2, string)) continue;
            return true;
        }
        return false;
    }
}

