/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.CssRenamingMap;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.JSModuleGraph;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ProcessClosurePrimitives
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    static final DiagnosticType NULL_ARGUMENT_ERROR = DiagnosticType.error("JSC_NULL_ARGUMENT_ERROR", "method \"{0}\" called without an argument");
    static final DiagnosticType EXPECTED_OBJECTLIT_ERROR = DiagnosticType.error("JSC_EXPECTED_OBJECTLIT_ERROR", "method \"{0}\" expected an object literal argument");
    static final DiagnosticType EXPECTED_STRING_ERROR = DiagnosticType.error("JSC_EXPECTED_STRING_ERROR", "method \"{0}\" expected an object string argument");
    static final DiagnosticType INVALID_ARGUMENT_ERROR = DiagnosticType.error("JSC_INVALID_ARGUMENT_ERROR", "method \"{0}\" called with invalid argument");
    static final DiagnosticType INVALID_STYLE_ERROR = DiagnosticType.error("JSC_INVALID_CSS_NAME_MAP_STYLE_ERROR", "Invalid CSS name map style {0}");
    static final DiagnosticType TOO_MANY_ARGUMENTS_ERROR = DiagnosticType.error("JSC_TOO_MANY_ARGUMENTS_ERROR", "method \"{0}\" called with more than one argument");
    static final DiagnosticType DUPLICATE_NAMESPACE_ERROR = DiagnosticType.error("JSC_DUPLICATE_NAMESPACE_ERROR", "namespace \"{0}\" cannot be provided twice");
    static final DiagnosticType FUNCTION_NAMESPACE_ERROR = DiagnosticType.error("JSC_FUNCTION_NAMESPACE_ERROR", "\"{0}\" cannot be both provided and declared as a function");
    static final DiagnosticType MISSING_PROVIDE_ERROR = DiagnosticType.error("JSC_MISSING_PROVIDE_ERROR", "required \"{0}\" namespace never provided");
    static final DiagnosticType LATE_PROVIDE_ERROR = DiagnosticType.error("JSC_LATE_PROVIDE_ERROR", "required \"{0}\" namespace not provided yet");
    static final DiagnosticType INVALID_PROVIDE_ERROR = DiagnosticType.error("JSC_INVALID_PROVIDE_ERROR", "\"{0}\" is not a valid JS property name");
    static final DiagnosticType XMODULE_REQUIRE_ERROR = DiagnosticType.warning("JSC_XMODULE_REQUIRE_ERROR", "namespace \"{0}\" provided in module {1} but required in module {2}");
    static final DiagnosticType NON_STRING_PASSED_TO_SET_CSS_NAME_MAPPING_ERROR = DiagnosticType.error("JSC_NON_STRING_PASSED_TO_SET_CSS_NAME_MAPPING_ERROR", "goog.setCssNameMapping only takes an object literal with string values");
    static final DiagnosticType INVALID_CSS_RENAMING_MAP = DiagnosticType.warning("INVALID_CSS_RENAMING_MAP", "Invalid entries in css renaming map: {0}");
    static final DiagnosticType BASE_CLASS_ERROR = DiagnosticType.error("JSC_BASE_CLASS_ERROR", "incorrect use of goog.base: {0}");
    static final String GOOG = "goog";
    private final AbstractCompiler compiler;
    private final JSModuleGraph moduleGraph;
    private final Map<String, ProvidedName> providedNames = Maps.newTreeMap();
    private final List<UnrecognizedRequire> unrecognizedRequires = Lists.newArrayList();
    private final Set<String> exportedVariables = Sets.newHashSet();
    private final CheckLevel requiresLevel;
    private final boolean rewriteNewDateGoogNow;

    ProcessClosurePrimitives(AbstractCompiler abstractCompiler, CheckLevel checkLevel, boolean bl) {
        this.compiler = abstractCompiler;
        this.moduleGraph = abstractCompiler.getModuleGraph();
        this.requiresLevel = checkLevel;
        this.rewriteNewDateGoogNow = bl;
        this.providedNames.put(GOOG, new ProvidedName(GOOG, null, null, false));
    }

    Set<String> getExportedVariableNames() {
        return this.exportedVariables;
    }

    @Override
    public void process(Node node, Node node2) {
        new NodeTraversal(this.compiler, this).traverse(node2);
        for (ProvidedName object : this.providedNames.values()) {
            object.replace();
        }
        if (this.requiresLevel.isOn()) {
            for (UnrecognizedRequire unrecognizedRequire : this.unrecognizedRequires) {
                ProvidedName providedName = this.providedNames.get(unrecognizedRequire.namespace);
                DiagnosticType diagnosticType = providedName != null && providedName.firstNode != null ? LATE_PROVIDE_ERROR : MISSING_PROVIDE_ERROR;
                this.compiler.report(JSError.make(unrecognizedRequire.inputName, unrecognizedRequire.requireNode, this.requiresLevel, diagnosticType, unrecognizedRequire.namespace));
            }
        }
    }

    @Override
    public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
        switch (node.getType()) {
            case 37: {
                Node node3;
                boolean bl = node2.getType() == 130;
                Node node4 = node.getFirstChild();
                if (node4.getType() != 33 || (node3 = node4.getFirstChild()).getType() != 38 || !GOOG.equals(node3.getString())) break;
                String string = node3.getNext().getString();
                if ("base".equals(string)) {
                    this.processBaseClassCall(nodeTraversal, node);
                    break;
                }
                if (!bl) break;
                if ("require".equals(string)) {
                    this.processRequireCall(nodeTraversal, node, node2);
                    break;
                }
                if ("provide".equals(string)) {
                    this.processProvideCall(nodeTraversal, node, node2);
                    break;
                }
                if ("exportSymbol".equals(string)) {
                    Node node5 = node4.getNext();
                    if (node5.getType() != 40) break;
                    int n = node5.getString().indexOf(46);
                    if (n == -1) {
                        this.exportedVariables.add(node5.getString());
                        break;
                    }
                    this.exportedVariables.add(node5.getString().substring(0, n));
                    break;
                }
                if ("addDependency".equals(string)) {
                    CodingConvention codingConvention = this.compiler.getCodingConvention();
                    List<String> list = codingConvention.identifyTypeDeclarationCall(node);
                    if (list != null) {
                        for (String string2 : list) {
                            this.compiler.getTypeRegistry().forwardDeclareType(string2);
                        }
                    }
                    node2.replaceChild(node, Node.newNumber(0.0));
                    this.compiler.reportCodeChange();
                    break;
                }
                if (!"setCssNameMapping".equals(string)) break;
                this.processSetCssNameMapping(nodeTraversal, node, node2);
                break;
            }
            case 38: 
            case 86: {
                this.handleCandidateProvideDefinition(nodeTraversal, node, node2);
                break;
            }
            case 105: {
                String string;
                ProvidedName providedName;
                if (!nodeTraversal.inGlobalScope() || NodeUtil.isFunctionExpression(node) || (providedName = this.providedNames.get(string = node.getFirstChild().getString())) == null) break;
                this.compiler.report(nodeTraversal.makeError(node, FUNCTION_NAMESPACE_ERROR, string));
                break;
            }
            case 30: {
                this.trySimplifyNewDate(nodeTraversal, node, node2);
                break;
            }
            case 33: {
                if (node.getFirstChild().getType() != 38 || node2.getType() == 37 || node2.getType() == 86 || !"goog.base".equals(node.getQualifiedName())) break;
                this.reportBadBaseClassUse(nodeTraversal, node, "May only be called directly.");
            }
        }
    }

    private void processRequireCall(NodeTraversal nodeTraversal, Node node, Node node2) {
        Node node3;
        Node node4 = node.getFirstChild();
        if (this.verifyArgument(nodeTraversal, node4, node3 = node4.getNext())) {
            String string = node3.getString();
            ProvidedName providedName = this.providedNames.get(string);
            if (providedName == null || !providedName.isExplicitlyProvided()) {
                this.unrecognizedRequires.add(new UnrecognizedRequire(node, string, nodeTraversal.getSourceName()));
            } else {
                JSModule jSModule = providedName.explicitModule;
                Preconditions.checkNotNull((Object)jSModule);
                JSModule jSModule2 = nodeTraversal.getModule();
                if (this.moduleGraph != null && jSModule2 != jSModule && !this.moduleGraph.dependsOn(jSModule2, jSModule)) {
                    this.compiler.report(nodeTraversal.makeError(node, XMODULE_REQUIRE_ERROR, string, jSModule.getName(), jSModule2.getName()));
                }
            }
            if (providedName != null || this.requiresLevel.isOn()) {
                node2.detachFromParent();
                this.compiler.reportCodeChange();
            }
        }
    }

    private void processProvideCall(NodeTraversal nodeTraversal, Node node, Node node2) {
        Node node3;
        Node node4 = node.getFirstChild();
        if (this.verifyProvide(nodeTraversal, node4, node3 = node4.getNext())) {
            String string = node3.getString();
            if (this.providedNames.containsKey(string)) {
                ProvidedName providedName = this.providedNames.get(string);
                if (!providedName.isExplicitlyProvided()) {
                    providedName.addProvide(node2, nodeTraversal.getModule(), true);
                } else {
                    this.compiler.report(nodeTraversal.makeError(node, DUPLICATE_NAMESPACE_ERROR, string));
                }
            } else {
                this.registerAnyProvidedPrefixes(string, node2, nodeTraversal.getModule());
                this.providedNames.put(string, new ProvidedName(string, node2, nodeTraversal.getModule(), true));
            }
        }
    }

    private void handleCandidateProvideDefinition(NodeTraversal nodeTraversal, Node node, Node node2) {
        if (nodeTraversal.inGlobalScope()) {
            String string = null;
            if (node.getType() == 38 && node2.getType() == 118) {
                string = node.getString();
            } else if (node.getType() == 86 && node2.getType() == 130) {
                string = node.getFirstChild().getQualifiedName();
            }
            if (string != null) {
                if (node2.getBooleanProp(46)) {
                    this.processProvideFromPreviousPass(nodeTraversal, string, node2);
                } else {
                    ProvidedName providedName = this.providedNames.get(string);
                    if (providedName != null) {
                        providedName.addDefinition(node2, nodeTraversal.getModule());
                    }
                }
            }
        }
    }

    private void processBaseClassCall(NodeTraversal nodeTraversal, Node node) {
        Node node2 = node.getFirstChild();
        Node node3 = node2.getNext();
        if (node3 == null || node3.getType() != 42) {
            this.reportBadBaseClassUse(nodeTraversal, node, "First argument must be 'this'.");
            return;
        }
        Node node4 = this.getEnclosingDeclNameNode(nodeTraversal);
        if (node4 == null) {
            this.reportBadBaseClassUse(nodeTraversal, node, "Could not find enclosing method.");
            return;
        }
        String string = node4.getQualifiedName();
        if (string.indexOf(".prototype.") == -1) {
            Node node5;
            Node node6 = node4.getParent();
            Node node7 = (node6.getType() == 86 ? node6.getParent() : node6).getNext();
            Node node8 = null;
            if (node7 != null && node7.getType() == 130 && node7.getFirstChild().getType() == 37 && "goog.inherits".equals((node5 = node7.getFirstChild()).getFirstChild().getQualifiedName()) && node5.getLastChild().isQualifiedName()) {
                node8 = node5.getLastChild();
            }
            if (node8 == null) {
                this.reportBadBaseClassUse(nodeTraversal, node, "Could not find goog.inherits for base class");
                return;
            }
            node.replaceChild(node2, NodeUtil.newQualifiedNameNode(this.compiler.getCodingConvention(), String.format("%s.call", node8.getQualifiedName()), node2, "goog.base"));
            this.compiler.reportCodeChange();
        } else {
            Node node9 = node3.getNext();
            if (node9 == null || node9.getType() != 40) {
                this.reportBadBaseClassUse(nodeTraversal, node, "Second argument must name a method.");
                return;
            }
            String string2 = node9.getString();
            String string3 = ".prototype." + string2;
            if (string == null || !string.endsWith(string3)) {
                this.reportBadBaseClassUse(nodeTraversal, node, "Enclosing method does not match " + string2);
                return;
            }
            Node node10 = node4.getFirstChild().getFirstChild();
            node.replaceChild(node2, NodeUtil.newQualifiedNameNode(this.compiler.getCodingConvention(), String.format("%s.superClass_.%s.call", node10.getQualifiedName(), string2), node2, "goog.base"));
            node.removeChild(node9);
            this.compiler.reportCodeChange();
        }
    }

    private Node getEnclosingDeclNameNode(NodeTraversal nodeTraversal) {
        Node node = nodeTraversal.getScopeRoot();
        if (NodeUtil.isFunctionDeclaration(node)) {
            return node.getFirstChild();
        }
        Node node2 = node.getParent();
        if (node2 != null) {
            if (node2.getType() == 86 || node2.getLastChild() == node && node2.getFirstChild().isQualifiedName()) {
                return node2.getFirstChild();
            }
            if (node2.getType() == 38) {
                return node2;
            }
        }
        return null;
    }

    private void reportBadBaseClassUse(NodeTraversal nodeTraversal, Node node, String string) {
        this.compiler.report(nodeTraversal.makeError(node, BASE_CLASS_ERROR, string));
    }

    private void processProvideFromPreviousPass(NodeTraversal nodeTraversal, String string, Node node) {
        if (!this.providedNames.containsKey(string)) {
            Node node2 = new Node(130);
            node2.copyInformationFromForTree(node);
            node.getParent().addChildBefore(node2, node);
            this.compiler.reportCodeChange();
            JSModule jSModule = nodeTraversal.getModule();
            this.registerAnyProvidedPrefixes(string, node2, jSModule);
            ProvidedName providedName = new ProvidedName(string, node2, jSModule, true);
            this.providedNames.put(string, providedName);
            providedName.addDefinition(node, jSModule);
        } else if (ProcessClosurePrimitives.isNamespacePlaceholder(node)) {
            node.getParent().removeChild(node);
            this.compiler.reportCodeChange();
        }
    }

    private void processSetCssNameMapping(NodeTraversal nodeTraversal, Node node, Node node2) {
        Node node3;
        Node node4 = node.getFirstChild();
        if (this.verifySetCssNameMapping(nodeTraversal, node4, node3 = node4.getNext())) {
            Object object;
            Object object2;
            Object object3;
            final HashMap hashMap = Maps.newHashMap();
            for (object3 = node3.getFirstChild(); object3 != null; object3 = ((Node)object3).getNext()) {
                object2 = ((Node)object3).getFirstChild();
                if (((Node)object3).getType() != 40 || object2 == null || ((Node)object2).getType() != 40) {
                    this.compiler.report(nodeTraversal.makeError(node, NON_STRING_PASSED_TO_SET_CSS_NAME_MAPPING_ERROR, new String[0]));
                    return;
                }
                hashMap.put(((Node)object3).getString(), ((Node)object2).getString());
            }
            object3 = "BY_PART";
            if (node3.getNext() != null) {
                object3 = node3.getNext().getString();
            }
            try {
                object2 = CssRenamingMap.Style.valueOf((String)object3);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.compiler.report(nodeTraversal.makeError(node, INVALID_STYLE_ERROR, new String[]{object3}));
                return;
            }
            if (object2 == CssRenamingMap.Style.BY_PART) {
                object = Lists.newArrayList();
                for (String string : hashMap.keySet()) {
                    if (!string.contains("-")) continue;
                    object.add(string);
                }
                if (object.size() != 0) {
                    this.compiler.report(nodeTraversal.makeError(node, INVALID_CSS_RENAMING_MAP, object.toString()));
                }
            } else if (object2 == CssRenamingMap.Style.BY_WHOLE) {
                object = Lists.newArrayList();
                for (Map.Entry entry : hashMap.entrySet()) {
                    if (((String)entry.getKey()).length() > 10) continue;
                    for (Map.Entry entry2 : hashMap.entrySet()) {
                        String string = (String)hashMap.get((String)entry2.getKey() + "-" + (String)entry.getKey());
                        if (string == null || string.equals((String)entry2.getValue() + "-" + (String)entry.getValue())) continue;
                        object.add("map(" + (String)entry2.getKey() + "-" + (String)entry.getKey() + ") != map(" + (String)entry2.getKey() + ")-map(" + (String)entry.getKey() + ")");
                    }
                }
                if (object.size() != 0) {
                    this.compiler.report(nodeTraversal.makeError(node, INVALID_CSS_RENAMING_MAP, object.toString()));
                }
            }
            object = new CssRenamingMap((CssRenamingMap.Style)((Object)object2)){
                final /* synthetic */ CssRenamingMap.Style val$style;
                {
                    this.val$style = style;
                }

                @Override
                public String get(String string) {
                    if (hashMap.containsKey(string)) {
                        return (String)hashMap.get(string);
                    }
                    return string;
                }

                @Override
                public CssRenamingMap.Style getStyle() {
                    return this.val$style;
                }
            };
            this.compiler.setCssRenamingMap((CssRenamingMap)object);
            node2.getParent().removeChild(node2);
            this.compiler.reportCodeChange();
        }
    }

    private void trySimplifyNewDate(NodeTraversal nodeTraversal, Node node, Node node2) {
        if (!this.rewriteNewDateGoogNow) {
            return;
        }
        Preconditions.checkArgument((node.getType() == 30 ? 1 : 0) != 0);
        Node node3 = node.getFirstChild();
        if (!NodeUtil.isName(node3) || !"Date".equals(node3.getString())) {
            return;
        }
        Node node4 = node3.getNext();
        if (node4 == null || !NodeUtil.isCall(node4) || node4.getNext() != null) {
            return;
        }
        Node node5 = node4.getFirstChild();
        String string = node5.getQualifiedName();
        if (string == null || !"goog.now".equals(string) || node5.getNext() != null) {
            return;
        }
        node.removeChild(node4);
        this.compiler.reportCodeChange();
    }

    private boolean verifyProvide(NodeTraversal nodeTraversal, Node node, Node node2) {
        if (!this.verifyArgument(nodeTraversal, node, node2)) {
            return false;
        }
        for (String string : node2.getString().split("\\.")) {
            if (NodeUtil.isValidPropertyName(string)) continue;
            this.compiler.report(nodeTraversal.makeError(node2, INVALID_PROVIDE_ERROR, string));
            return false;
        }
        return true;
    }

    private boolean verifyArgument(NodeTraversal nodeTraversal, Node node, Node node2) {
        return this.verifyArgument(nodeTraversal, node, node2, 40);
    }

    private boolean verifyArgument(NodeTraversal nodeTraversal, Node node, Node node2, int n) {
        DiagnosticType diagnosticType = null;
        if (node2 == null) {
            diagnosticType = NULL_ARGUMENT_ERROR;
        } else if (node2.getType() != n) {
            diagnosticType = INVALID_ARGUMENT_ERROR;
        } else if (node2.getNext() != null) {
            diagnosticType = TOO_MANY_ARGUMENTS_ERROR;
        }
        if (diagnosticType != null) {
            this.compiler.report(nodeTraversal.makeError(node, diagnosticType, node.getQualifiedName()));
            return false;
        }
        return true;
    }

    private boolean verifySetCssNameMapping(NodeTraversal nodeTraversal, Node node, Node node2) {
        DiagnosticType diagnosticType = null;
        if (node2 == null) {
            diagnosticType = NULL_ARGUMENT_ERROR;
        } else if (node2.getType() != 64) {
            diagnosticType = EXPECTED_OBJECTLIT_ERROR;
        } else if (node2.getNext() != null) {
            Node node3 = node2.getNext();
            if (node3.getType() != 40) {
                diagnosticType = EXPECTED_STRING_ERROR;
            } else if (node3.getNext() != null) {
                diagnosticType = TOO_MANY_ARGUMENTS_ERROR;
            }
        }
        if (diagnosticType != null) {
            this.compiler.report(nodeTraversal.makeError(node, diagnosticType, node.getQualifiedName()));
            return false;
        }
        return true;
    }

    private void registerAnyProvidedPrefixes(String string, Node node, JSModule jSModule) {
        int n = string.indexOf(46);
        while (n != -1) {
            String string2 = string.substring(0, n);
            n = string.indexOf(46, n + 1);
            if (this.providedNames.containsKey(string2)) {
                this.providedNames.get(string2).addProvide(node, jSModule, false);
                continue;
            }
            this.providedNames.put(string2, new ProvidedName(string2, node, jSModule, false));
        }
    }

    private static boolean isNamespacePlaceholder(Node node) {
        if (!node.getBooleanProp(46)) {
            return false;
        }
        Node node2 = null;
        if (node.getType() == 130) {
            Node node3 = node.getFirstChild();
            node2 = node3.getLastChild();
        } else if (node.getType() == 118) {
            Node node4 = node.getFirstChild();
            node2 = node4.getFirstChild();
        }
        return node2 != null && node2.getType() == 64 && !node2.hasChildren();
    }

    private class UnrecognizedRequire {
        final Node requireNode;
        final String namespace;
        final String inputName;

        UnrecognizedRequire(Node node, String string, String string2) {
            this.requireNode = node;
            this.namespace = string;
            this.inputName = string2;
        }
    }

    private class ProvidedName {
        private final String namespace;
        private final Node firstNode;
        private final JSModule firstModule;
        private Node explicitNode = null;
        private JSModule explicitModule = null;
        private Node candidateDefinition = null;
        private JSModule minimumModule = null;
        private Node replacementNode = null;

        ProvidedName(String string, Node node, JSModule jSModule, boolean bl) {
            Preconditions.checkArgument((node == null || NodeUtil.isExpressionNode(node) ? 1 : 0) != 0);
            this.namespace = string;
            this.firstNode = node;
            this.firstModule = jSModule;
            this.addProvide(node, jSModule, bl);
        }

        void addProvide(Node node, JSModule jSModule, boolean bl) {
            if (bl) {
                Preconditions.checkState((this.explicitNode == null ? 1 : 0) != 0);
                Preconditions.checkArgument((boolean)NodeUtil.isExpressionNode(node));
                this.explicitNode = node;
                this.explicitModule = jSModule;
            }
            this.updateMinimumModule(jSModule);
        }

        boolean isExplicitlyProvided() {
            return this.explicitNode != null;
        }

        void addDefinition(Node node, JSModule jSModule) {
            Preconditions.checkArgument((NodeUtil.isExpressionNode(node) || NodeUtil.isFunction(node) || NodeUtil.isVar(node) ? 1 : 0) != 0);
            Preconditions.checkArgument((this.explicitNode != node ? 1 : 0) != 0);
            if (this.candidateDefinition == null || !NodeUtil.isExpressionNode(node)) {
                this.candidateDefinition = node;
                this.updateMinimumModule(jSModule);
            }
        }

        private void updateMinimumModule(JSModule jSModule) {
            if (this.minimumModule == null) {
                this.minimumModule = jSModule;
            } else if (ProcessClosurePrimitives.this.moduleGraph != null) {
                this.minimumModule = ProcessClosurePrimitives.this.moduleGraph.getDeepestCommonDependencyInclusive(this.minimumModule, jSModule);
            } else {
                Preconditions.checkState((jSModule == this.minimumModule ? 1 : 0) != 0, (Object)"Missing module graph");
            }
        }

        void replace() {
            if (this.firstNode == null) {
                this.replacementNode = this.candidateDefinition;
                return;
            }
            if (this.candidateDefinition != null && this.explicitNode != null) {
                this.explicitNode.detachFromParent();
                ProcessClosurePrimitives.this.compiler.reportCodeChange();
                this.replacementNode = this.candidateDefinition;
                if (NodeUtil.isExpressionNode(this.candidateDefinition)) {
                    this.candidateDefinition.putBooleanProp(46, true);
                    Node node = this.candidateDefinition.getFirstChild();
                    Node node2 = node.getFirstChild();
                    if (node2.getType() == 38) {
                        Node node3 = node2.getNext();
                        node.removeChild(node2);
                        node.removeChild(node3);
                        node2.addChildToFront(node3);
                        Node node4 = new Node(118, node2);
                        node4.copyInformationFrom(this.candidateDefinition);
                        this.candidateDefinition.getParent().replaceChild(this.candidateDefinition, node4);
                        node2.setJSDocInfo(node.getJSDocInfo());
                        ProcessClosurePrimitives.this.compiler.reportCodeChange();
                        this.replacementNode = node4;
                    }
                }
            } else {
                this.replacementNode = this.createDeclarationNode();
                if (this.firstModule == this.minimumModule) {
                    this.firstNode.getParent().addChildBefore(this.replacementNode, this.firstNode);
                } else {
                    int n = this.namespace.lastIndexOf(46);
                    if (n == -1) {
                        ProcessClosurePrimitives.this.compiler.getNodeForCodeInsertion(this.minimumModule).addChildToBack(this.replacementNode);
                    } else {
                        ProvidedName providedName = (ProvidedName)ProcessClosurePrimitives.this.providedNames.get(this.namespace.substring(0, n));
                        Preconditions.checkNotNull((Object)providedName);
                        Preconditions.checkNotNull((Object)providedName.replacementNode);
                        providedName.replacementNode.getParent().addChildAfter(this.replacementNode, providedName.replacementNode);
                    }
                }
                if (this.explicitNode != null) {
                    this.explicitNode.detachFromParent();
                }
                ProcessClosurePrimitives.this.compiler.reportCodeChange();
            }
        }

        private Node createDeclarationNode() {
            if (this.namespace.indexOf(46) == -1) {
                return this.makeVarDeclNode();
            }
            return this.makeAssignmentExprNode();
        }

        private Node makeVarDeclNode() {
            Node node = Node.newString(38, this.namespace);
            node.addChildToFront(this.createNamespaceLiteral());
            Node node2 = new Node(118, node);
            node2.putBooleanProp(46, true);
            if (ProcessClosurePrimitives.this.compiler.getCodingConvention().isConstant(this.namespace)) {
                node.putBooleanProp(43, true);
            }
            Preconditions.checkState((boolean)ProcessClosurePrimitives.isNamespacePlaceholder(node2));
            this.setSourceInfo(node2);
            return node2;
        }

        private Node createNamespaceLiteral() {
            Node node = new Node(64);
            node.setJSType(ProcessClosurePrimitives.this.compiler.getTypeRegistry().createAnonymousObjectType());
            return node;
        }

        private Node makeAssignmentExprNode() {
            Node node = new Node(130, new Node(86, NodeUtil.newQualifiedNameNode(ProcessClosurePrimitives.this.compiler.getCodingConvention(), this.namespace, this.firstNode, this.namespace), this.createNamespaceLiteral()));
            node.putBooleanProp(46, true);
            Preconditions.checkState((boolean)ProcessClosurePrimitives.isNamespacePlaceholder(node));
            this.setSourceInfo(node);
            return node;
        }

        private void setSourceInfo(Node node) {
            Node node2 = this.getProvideStringNode();
            int n = this.getSourceInfoOffset(node2);
            Node node3 = node2 == null ? this.firstNode : node2;
            node.copyInformationFromForTree(node3);
            if (n != 0) {
                node.setSourcePositionForTree(node.getSourcePosition() + n);
            }
        }

        private int getSourceInfoOffset(Node node) {
            if (node == null) {
                return 0;
            }
            int n = this.namespace.lastIndexOf(46);
            return 2 + n;
        }

        private Node getProvideStringNode() {
            return this.firstNode.getFirstChild() != null && NodeUtil.isExprCall(this.firstNode) ? this.firstNode.getFirstChild().getLastChild() : null;
        }
    }
}

