/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DefinitionProvider;
import com.google.javascript.jscomp.DefinitionSite;
import com.google.javascript.jscomp.DefinitionsRemover;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.UseSite;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.util.Collection;
import java.util.Map;

class SimpleDefinitionFinder
implements CompilerPass,
DefinitionProvider {
    private final AbstractCompiler compiler;
    private final Map<Node, DefinitionSite> definitionSiteMap;
    private final Multimap<String, DefinitionsRemover.Definition> nameDefinitionMultimap;
    private final Multimap<String, UseSite> nameUseSiteMultimap;

    public SimpleDefinitionFinder(AbstractCompiler abstractCompiler) {
        this.compiler = abstractCompiler;
        this.definitionSiteMap = Maps.newLinkedHashMap();
        this.nameDefinitionMultimap = HashMultimap.create();
        this.nameUseSiteMultimap = HashMultimap.create();
    }

    public Collection<DefinitionSite> getDefinitionSites() {
        return this.definitionSiteMap.values();
    }

    private DefinitionSite getDefinitionAt(Node node) {
        return this.definitionSiteMap.get(node);
    }

    DefinitionSite getDefinitionForFunction(Node node) {
        Preconditions.checkState((boolean)NodeUtil.isFunction(node));
        return this.getDefinitionAt(SimpleDefinitionFinder.getNameNodeFromFunctionNode(node));
    }

    @Override
    public Collection<DefinitionsRemover.Definition> getDefinitionsReferencedAt(Node node) {
        String string;
        if (this.definitionSiteMap.containsKey(node)) {
            return null;
        }
        if (NodeUtil.isGetProp(node) && ((string = node.getLastChild().getString()).equals("apply") || string.equals("call"))) {
            node = node.getFirstChild();
        }
        if ((string = SimpleDefinitionFinder.getSimplifiedName(node)) != null) {
            Collection collection = this.nameDefinitionMultimap.get((Object)string);
            if (!collection.isEmpty()) {
                return collection;
            }
            return null;
        }
        return null;
    }

    @Override
    public void process(Node node, Node node2) {
        NodeTraversal.traverse(this.compiler, node, new DefinitionGatheringCallback(true));
        NodeTraversal.traverse(this.compiler, node2, new DefinitionGatheringCallback(false));
        NodeTraversal.traverse(this.compiler, node2, new UseSiteGatheringCallback());
    }

    Collection<UseSite> getUseSites(DefinitionsRemover.Definition definition) {
        String string = SimpleDefinitionFinder.getSimplifiedName(definition.getLValue());
        return this.nameUseSiteMultimap.get((Object)string);
    }

    private static String getSimplifiedName(Node node) {
        if (NodeUtil.isName(node)) {
            String string = node.getString();
            if (string != null && !string.isEmpty()) {
                return string;
            }
            return null;
        }
        if (NodeUtil.isGetProp(node)) {
            return "this." + node.getLastChild().getString();
        }
        return null;
    }

    static boolean isCallOrNewSite(UseSite useSite) {
        Node node = useSite.node.getParent();
        if (node == null) {
            return false;
        }
        return NodeUtil.isCallOrNew(node) && node.getFirstChild() == useSite.node;
    }

    boolean canModifyDefinition(DefinitionsRemover.Definition definition) {
        if (this.isExported(definition)) {
            return false;
        }
        Collection<UseSite> collection = this.getUseSites(definition);
        if (collection.isEmpty()) {
            return false;
        }
        for (UseSite useSite : collection) {
            Node node = useSite.node;
            Collection<DefinitionsRemover.Definition> collection2 = this.getDefinitionsReferencedAt(node);
            if (collection2.size() > 1) {
                return false;
            }
            Preconditions.checkState((!collection2.isEmpty() ? 1 : 0) != 0);
            Preconditions.checkState((boolean)collection2.contains(definition));
        }
        return true;
    }

    private boolean isExported(DefinitionsRemover.Definition definition) {
        String string;
        Node node = definition.getLValue();
        if (node == null) {
            return true;
        }
        if (NodeUtil.isGetProp(node)) {
            string = node.getLastChild().getString();
        } else if (NodeUtil.isName(node)) {
            string = node.getString();
        } else {
            return true;
        }
        CodingConvention codingConvention = this.compiler.getCodingConvention();
        return codingConvention.isExported(string);
    }

    static boolean isSimpleFunctionDeclaration(Node node) {
        String string;
        Node node2 = node.getParent();
        Node node3 = node2.getParent();
        Node node4 = SimpleDefinitionFinder.getNameNodeFromFunctionNode(node);
        if (node4 != null && NodeUtil.isName(node4) && ((string = node4.getString()).equals("JSCompiler_renameProperty") || string.equals("JSCompiler_ObjectPropertyString"))) {
            return false;
        }
        if (NodeUtil.isFunctionDeclaration(node)) {
            return true;
        }
        return node.getFirstChild().getString().isEmpty() && (NodeUtil.isExprAssign(node3) || NodeUtil.isName(node2));
    }

    static Node getNameNodeFromFunctionNode(Node node) {
        Preconditions.checkState((boolean)NodeUtil.isFunction(node));
        if (NodeUtil.isFunctionDeclaration(node)) {
            return node.getFirstChild();
        }
        Node node2 = node.getParent();
        if (NodeUtil.isVarDeclaration(node2)) {
            return node2;
        }
        if (NodeUtil.isAssign(node2)) {
            return node2.getFirstChild();
        }
        if (NodeUtil.isObjectLitKey(node2, node2.getParent())) {
            return node2;
        }
        return null;
    }

    void removeReferences(Node node) {
        Object object2;
        if (DefinitionsRemover.isDefinitionNode(node)) {
            DefinitionsRemover.Definition object3;
            String string;
            object2 = this.definitionSiteMap.get(node);
            if (object2 != null && (string = SimpleDefinitionFinder.getSimplifiedName((object3 = ((DefinitionSite)object2).definition).getLValue())) != null) {
                this.definitionSiteMap.remove(node);
                this.nameDefinitionMultimap.remove((Object)string, (Object)node);
            }
        } else {
            String string;
            String string2;
            object2 = node;
            if (NodeUtil.isGetProp((Node)object2) && ((string2 = ((Node)object2).getLastChild().getString()).equals("apply") || string2.equals("call"))) {
                object2 = ((Node)object2).getFirstChild();
            }
            if ((string = SimpleDefinitionFinder.getSimplifiedName((Node)object2)) != null) {
                this.nameUseSiteMultimap.remove((Object)string, (Object)new UseSite((Node)object2, null, null));
            }
        }
        for (Node node2 : node.children()) {
            this.removeReferences(node2);
        }
    }

    private class UseSiteGatheringCallback
    extends NodeTraversal.AbstractPostOrderCallback {
        private UseSiteGatheringCallback() {
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            Collection<DefinitionsRemover.Definition> collection = SimpleDefinitionFinder.this.getDefinitionsReferencedAt(node);
            if (collection == null) {
                return;
            }
            DefinitionsRemover.Definition definition = collection.iterator().next();
            String string = SimpleDefinitionFinder.getSimplifiedName(definition.getLValue());
            Preconditions.checkNotNull((Object)string);
            SimpleDefinitionFinder.this.nameUseSiteMultimap.put((Object)string, (Object)new UseSite(node, nodeTraversal.getScope(), nodeTraversal.getModule()));
        }
    }

    private class DefinitionGatheringCallback
    extends NodeTraversal.AbstractPostOrderCallback {
        private boolean inExterns;

        DefinitionGatheringCallback(boolean bl) {
            this.inExterns = bl;
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            Object object4;
            Object object2;
            String string;
            if (this.inExterns && NodeUtil.isName(node) && node2.getType() == 83) {
                return;
            }
            Object object3 = DefinitionsRemover.getDefinition(node, this.inExterns);
            if (object3 != null && (string = SimpleDefinitionFinder.getSimplifiedName(((DefinitionsRemover.Definition)object3).getLValue())) != null) {
                Node node3 = ((DefinitionsRemover.Definition)object3).getRValue();
                if (node3 != null && !NodeUtil.isImmutableValue(node3) && !NodeUtil.isFunction(node3)) {
                    object3 = object2 = new DefinitionsRemover.UnknownDefinition(((DefinitionsRemover.Definition)object3).getLValue(), this.inExterns);
                }
                if (this.inExterns) {
                    object2 = Lists.newArrayList();
                    String string2 = node.getQualifiedName();
                    if (string2 != null) {
                        for (Object object4 : SimpleDefinitionFinder.this.nameDefinitionMultimap.get((Object)string)) {
                            String string3;
                            if (!(object4 instanceof DefinitionsRemover.ExternalNameOnlyDefinition) || this.jsdocContainsDeclarations(node) || !string2.equals(string3 = ((DefinitionsRemover.Definition)object4).getLValue().getQualifiedName())) continue;
                            object2.add(object4);
                        }
                        Object object5 = object2.iterator();
                        while (object5.hasNext()) {
                            object4 = (DefinitionsRemover.Definition)object5.next();
                            SimpleDefinitionFinder.this.nameDefinitionMultimap.remove((Object)string, object4);
                        }
                    }
                }
                SimpleDefinitionFinder.this.nameDefinitionMultimap.put((Object)string, object3);
                SimpleDefinitionFinder.this.definitionSiteMap.put(node, new DefinitionSite(node, (DefinitionsRemover.Definition)object3, nodeTraversal.getModule(), nodeTraversal.inGlobalScope(), this.inExterns));
            }
            if (this.inExterns && node2 != null && NodeUtil.isExpressionNode(node2) && (string = SimpleDefinitionFinder.getSimplifiedName(node)) != null) {
                boolean bl = false;
                if (!this.jsdocContainsDeclarations(node) && (object2 = node.getQualifiedName()) != null) {
                    for (Object object5 : SimpleDefinitionFinder.this.nameDefinitionMultimap.get((Object)string)) {
                        object4 = ((DefinitionsRemover.Definition)object5).getLValue().getQualifiedName();
                        if (!((String)object2).equals(object4)) continue;
                        bl = true;
                        break;
                    }
                }
                if (!bl) {
                    object2 = new DefinitionsRemover.ExternalNameOnlyDefinition(node);
                    SimpleDefinitionFinder.this.nameDefinitionMultimap.put((Object)string, object2);
                    SimpleDefinitionFinder.this.definitionSiteMap.put(node, new DefinitionSite(node, (DefinitionsRemover.Definition)object2, nodeTraversal.getModule(), nodeTraversal.inGlobalScope(), this.inExterns));
                }
            }
        }

        private boolean jsdocContainsDeclarations(Node node) {
            JSDocInfo jSDocInfo = node.getJSDocInfo();
            return jSDocInfo != null && jSDocInfo.containsDeclaration();
        }
    }
}

