/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.parsing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.mozilla.rhino.ErrorReporter;
import com.google.javascript.jscomp.mozilla.rhino.Node;
import com.google.javascript.jscomp.mozilla.rhino.Token;
import com.google.javascript.jscomp.mozilla.rhino.ast.ArrayLiteral;
import com.google.javascript.jscomp.mozilla.rhino.ast.Assignment;
import com.google.javascript.jscomp.mozilla.rhino.ast.AstNode;
import com.google.javascript.jscomp.mozilla.rhino.ast.AstRoot;
import com.google.javascript.jscomp.mozilla.rhino.ast.Block;
import com.google.javascript.jscomp.mozilla.rhino.ast.BreakStatement;
import com.google.javascript.jscomp.mozilla.rhino.ast.CatchClause;
import com.google.javascript.jscomp.mozilla.rhino.ast.Comment;
import com.google.javascript.jscomp.mozilla.rhino.ast.ConditionalExpression;
import com.google.javascript.jscomp.mozilla.rhino.ast.ContinueStatement;
import com.google.javascript.jscomp.mozilla.rhino.ast.DoLoop;
import com.google.javascript.jscomp.mozilla.rhino.ast.ElementGet;
import com.google.javascript.jscomp.mozilla.rhino.ast.EmptyExpression;
import com.google.javascript.jscomp.mozilla.rhino.ast.ExpressionStatement;
import com.google.javascript.jscomp.mozilla.rhino.ast.ForInLoop;
import com.google.javascript.jscomp.mozilla.rhino.ast.ForLoop;
import com.google.javascript.jscomp.mozilla.rhino.ast.FunctionCall;
import com.google.javascript.jscomp.mozilla.rhino.ast.FunctionNode;
import com.google.javascript.jscomp.mozilla.rhino.ast.IfStatement;
import com.google.javascript.jscomp.mozilla.rhino.ast.InfixExpression;
import com.google.javascript.jscomp.mozilla.rhino.ast.KeywordLiteral;
import com.google.javascript.jscomp.mozilla.rhino.ast.Label;
import com.google.javascript.jscomp.mozilla.rhino.ast.LabeledStatement;
import com.google.javascript.jscomp.mozilla.rhino.ast.Name;
import com.google.javascript.jscomp.mozilla.rhino.ast.NewExpression;
import com.google.javascript.jscomp.mozilla.rhino.ast.NumberLiteral;
import com.google.javascript.jscomp.mozilla.rhino.ast.ObjectLiteral;
import com.google.javascript.jscomp.mozilla.rhino.ast.ObjectProperty;
import com.google.javascript.jscomp.mozilla.rhino.ast.ParenthesizedExpression;
import com.google.javascript.jscomp.mozilla.rhino.ast.PropertyGet;
import com.google.javascript.jscomp.mozilla.rhino.ast.RegExpLiteral;
import com.google.javascript.jscomp.mozilla.rhino.ast.ReturnStatement;
import com.google.javascript.jscomp.mozilla.rhino.ast.Scope;
import com.google.javascript.jscomp.mozilla.rhino.ast.StringLiteral;
import com.google.javascript.jscomp.mozilla.rhino.ast.SwitchCase;
import com.google.javascript.jscomp.mozilla.rhino.ast.SwitchStatement;
import com.google.javascript.jscomp.mozilla.rhino.ast.ThrowStatement;
import com.google.javascript.jscomp.mozilla.rhino.ast.TryStatement;
import com.google.javascript.jscomp.mozilla.rhino.ast.UnaryExpression;
import com.google.javascript.jscomp.mozilla.rhino.ast.VariableDeclaration;
import com.google.javascript.jscomp.mozilla.rhino.ast.VariableInitializer;
import com.google.javascript.jscomp.mozilla.rhino.ast.WhileLoop;
import com.google.javascript.jscomp.mozilla.rhino.ast.WithStatement;
import com.google.javascript.jscomp.parsing.Config;
import com.google.javascript.jscomp.parsing.JsDocInfoParser;
import com.google.javascript.jscomp.parsing.JsDocTokenStream;
import com.google.javascript.jscomp.parsing.TypeSafeDispatcher;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.util.Set;

public class IRFactory {
    static final String SUSPICIOUS_COMMENT_WARNING = "Non-JSDoc comment has annotations. Did you mean to start it with '/**'?";
    private final String sourceString;
    private final String sourceName;
    private final Config config;
    private final ErrorReporter errorReporter;
    private final TransformDispatcher transformDispatcher;
    private final Set<String> ALLOWED_DIRECTIVES = Sets.newHashSet((Object[])new String[]{"use strict"});
    private static final Set<String> ES5_RESERVED_KEYWORDS = ImmutableSet.of((Object)"class", (Object)"const", (Object)"enum", (Object)"export", (Object)"extends", (Object)"import", (Object[])new String[]{"super"});
    private static final Set<String> ES5_STRICT_RESERVED_KEYWORDS = ImmutableSet.of((Object)"class", (Object)"const", (Object)"enum", (Object)"export", (Object)"extends", (Object)"import", (Object[])new String[]{"super", "implements", "interface", "let", "package", "private", "protected", "public", "static", "yield"});
    private final Set<String> reservedKeywords;
    com.google.javascript.rhino.Node rootNodeJsDocHolder = new com.google.javascript.rhino.Node(132);
    Node.FileLevelJsDocBuilder fileLevelJsDocBuilder = this.rootNodeJsDocHolder.getJsDocBuilderForNode();
    JSDocInfo fileOverviewInfo = null;
    private com.google.javascript.rhino.Node templateNode;

    private IRFactory(String string, String string2, Config config, ErrorReporter errorReporter) {
        this.sourceString = string;
        this.sourceName = string2;
        this.config = config;
        this.errorReporter = errorReporter;
        this.transformDispatcher = new TransformDispatcher();
        this.templateNode = this.createTemplateNode();
        switch (config.languageMode) {
            case ECMASCRIPT3: {
                this.reservedKeywords = null;
                break;
            }
            case ECMASCRIPT5: {
                this.reservedKeywords = ES5_RESERVED_KEYWORDS;
                break;
            }
            case ECMASCRIPT5_STRICT: {
                this.reservedKeywords = ES5_STRICT_RESERVED_KEYWORDS;
                break;
            }
            default: {
                throw new IllegalStateException("unknown language mode");
            }
        }
    }

    private com.google.javascript.rhino.Node createTemplateNode() {
        com.google.javascript.rhino.Node node = new com.google.javascript.rhino.Node(132);
        node.putProp(16, this.sourceName);
        return node;
    }

    public static com.google.javascript.rhino.Node transformTree(AstRoot astRoot, String string, Config config, ErrorReporter errorReporter) {
        IRFactory iRFactory = new IRFactory(string, astRoot.getSourceName(), config, errorReporter);
        com.google.javascript.rhino.Node node = iRFactory.transform(astRoot);
        if (astRoot.getComments() != null) {
            for (Comment comment : astRoot.getComments()) {
                if (comment.getCommentType() == Token.CommentType.JSDOC && !comment.isParsed()) {
                    iRFactory.handlePossibleFileOverviewJsDoc(comment);
                    continue;
                }
                if (comment.getCommentType() != Token.CommentType.BLOCK) continue;
                iRFactory.handleBlockComment(comment);
            }
        }
        iRFactory.setFileOverviewJsDoc(node);
        return node;
    }

    private void setFileOverviewJsDoc(com.google.javascript.rhino.Node node) {
        node.setJSDocInfo(this.rootNodeJsDocHolder.getJSDocInfo());
        if (this.fileOverviewInfo != null) {
            if (node.getJSDocInfo() != null && node.getJSDocInfo().getLicense() != null) {
                this.fileOverviewInfo.setLicense(node.getJSDocInfo().getLicense());
            }
            node.setJSDocInfo(this.fileOverviewInfo);
        }
    }

    private com.google.javascript.rhino.Node transformBlock(AstNode astNode) {
        com.google.javascript.rhino.Node node = this.transform(astNode);
        if (node.getType() != 125) {
            if (node.getType() == 124) {
                node.setType(125);
                node.setWasEmptyNode(true);
            } else {
                com.google.javascript.rhino.Node node2 = this.newNode(125, node);
                node2.setLineno(node.getLineno());
                node2.setCharno(node.getCharno());
                node = node2;
            }
        }
        return node;
    }

    private void handleBlockComment(Comment comment) {
        String string = comment.getValue();
        if (string.indexOf("/* @") != -1 || string.indexOf("\n * @") != -1) {
            this.errorReporter.warning(SUSPICIOUS_COMMENT_WARNING, this.sourceName, comment.getLineno(), "", 0);
        }
    }

    private boolean handlePossibleFileOverviewJsDoc(JsDocInfoParser jsDocInfoParser) {
        if (jsDocInfoParser.getFileOverviewJSDocInfo() != this.fileOverviewInfo) {
            this.fileOverviewInfo = jsDocInfoParser.getFileOverviewJSDocInfo();
            return true;
        }
        return false;
    }

    private void handlePossibleFileOverviewJsDoc(Comment comment) {
        JsDocInfoParser jsDocInfoParser = this.createJsDocInfoParser(comment);
        comment.setParsed(true);
        this.handlePossibleFileOverviewJsDoc(jsDocInfoParser);
    }

    private JSDocInfo handleJsDoc(AstNode astNode) {
        Comment comment = astNode.getJsDocNode();
        if (comment != null) {
            JsDocInfoParser jsDocInfoParser = this.createJsDocInfoParser(comment);
            comment.setParsed(true);
            if (!this.handlePossibleFileOverviewJsDoc(jsDocInfoParser)) {
                return jsDocInfoParser.retrieveAndResetParsedJSDocInfo();
            }
        }
        return null;
    }

    private com.google.javascript.rhino.Node transform(AstNode astNode) {
        JSDocInfo jSDocInfo = this.handleJsDoc(astNode);
        com.google.javascript.rhino.Node node = this.justTransform(astNode);
        if (jSDocInfo != null) {
            node.setJSDocInfo(jSDocInfo);
        }
        this.setSourceInfo(node, astNode);
        return node;
    }

    private com.google.javascript.rhino.Node transformNameAsString(Name name) {
        JSDocInfo jSDocInfo = this.handleJsDoc(name);
        com.google.javascript.rhino.Node node = this.transformDispatcher.processName(name, true);
        if (jSDocInfo != null) {
            node.setJSDocInfo(jSDocInfo);
        }
        this.setSourceInfo(node, name);
        return node;
    }

    private com.google.javascript.rhino.Node transformNumberAsString(NumberLiteral numberLiteral) {
        JSDocInfo jSDocInfo = this.handleJsDoc(numberLiteral);
        com.google.javascript.rhino.Node node = this.newStringNode(IRFactory.getStringValue(numberLiteral.getNumber()));
        if (jSDocInfo != null) {
            node.setJSDocInfo(jSDocInfo);
        }
        this.setSourceInfo(node, numberLiteral);
        return node;
    }

    private static String getStringValue(double d) {
        long l = (long)d;
        if ((double)l == d) {
            return Long.toString(l);
        }
        return Double.toString(d);
    }

    private void setSourceInfo(com.google.javascript.rhino.Node node, AstNode astNode) {
        if (node.getType() == 105 && node.getFirstChild().getLineno() != -1) {
            node.setLineno(node.getFirstChild().getLineno());
            node.setCharno(node.getFirstChild().getCharno());
        } else if (node.getLineno() == -1) {
            int n = astNode.getLineno();
            node.setLineno(n);
            int n2 = this.position2charno(astNode.getAbsolutePosition());
            node.setCharno(n2);
        }
    }

    private JsDocInfoParser createJsDocInfoParser(Comment comment) {
        String string = comment.getValue();
        int n = comment.getLineno();
        int n2 = comment.getAbsolutePosition();
        int n3 = 3;
        JsDocInfoParser jsDocInfoParser = new JsDocInfoParser(new JsDocTokenStream(string.substring(n3), n, this.position2charno(n2) + n3), comment, this.sourceName, this.config, this.errorReporter);
        jsDocInfoParser.setFileLevelJsDocBuilder(this.fileLevelJsDocBuilder);
        jsDocInfoParser.setFileOverviewJSDocInfo(this.fileOverviewInfo);
        jsDocInfoParser.parse();
        return jsDocInfoParser;
    }

    private int position2charno(int n) {
        int n2 = this.sourceString.lastIndexOf(10, n);
        if (n2 == -1) {
            return n;
        }
        return n - n2 - 1;
    }

    private com.google.javascript.rhino.Node justTransform(AstNode astNode) {
        return (com.google.javascript.rhino.Node)this.transformDispatcher.process(astNode);
    }

    private static int transformTokenType(int n) {
        switch (n) {
            case 4: {
                return 4;
            }
            case 9: {
                return 9;
            }
            case 10: {
                return 10;
            }
            case 11: {
                return 11;
            }
            case 12: {
                return 12;
            }
            case 13: {
                return 13;
            }
            case 14: {
                return 14;
            }
            case 15: {
                return 15;
            }
            case 16: {
                return 16;
            }
            case 17: {
                return 17;
            }
            case 18: {
                return 18;
            }
            case 19: {
                return 19;
            }
            case 20: {
                return 20;
            }
            case 21: {
                return 21;
            }
            case 22: {
                return 22;
            }
            case 23: {
                return 23;
            }
            case 24: {
                return 24;
            }
            case 25: {
                return 25;
            }
            case 26: {
                return 26;
            }
            case 27: {
                return 27;
            }
            case 28: {
                return 28;
            }
            case 29: {
                return 29;
            }
            case 30: {
                return 30;
            }
            case 31: {
                return 31;
            }
            case 32: {
                return 32;
            }
            case 33: {
                return 33;
            }
            case 35: {
                return 34;
            }
            case 36: {
                return 35;
            }
            case 37: {
                return 36;
            }
            case 38: {
                return 37;
            }
            case 39: {
                return 38;
            }
            case 40: {
                return 39;
            }
            case 41: {
                return 40;
            }
            case 42: {
                return 41;
            }
            case 43: {
                return 42;
            }
            case 44: {
                return 43;
            }
            case 45: {
                return 44;
            }
            case 46: {
                return 45;
            }
            case 47: {
                return 46;
            }
            case 48: {
                return 47;
            }
            case 50: {
                return 49;
            }
            case 52: {
                return 51;
            }
            case 53: {
                return 52;
            }
            case 65: {
                return 63;
            }
            case 66: {
                return 64;
            }
            case 81: {
                return 77;
            }
            case 87: {
                return 83;
            }
            case 89: {
                return 85;
            }
            case 90: {
                return 86;
            }
            case 91: {
                return 87;
            }
            case 92: {
                return 88;
            }
            case 93: {
                return 89;
            }
            case 94: {
                return 90;
            }
            case 95: {
                return 91;
            }
            case 96: {
                return 92;
            }
            case 97: {
                return 93;
            }
            case 98: {
                return 94;
            }
            case 99: {
                return 95;
            }
            case 100: {
                return 96;
            }
            case 101: {
                return 97;
            }
            case 102: {
                return 98;
            }
            case 103: {
                return 99;
            }
            case 104: {
                return 100;
            }
            case 105: {
                return 101;
            }
            case 106: {
                return 102;
            }
            case 107: {
                return 103;
            }
            case 109: {
                return 105;
            }
            case 112: {
                return 108;
            }
            case 113: {
                return 109;
            }
            case 114: {
                return 110;
            }
            case 115: {
                return 111;
            }
            case 116: {
                return 112;
            }
            case 117: {
                return 113;
            }
            case 118: {
                return 114;
            }
            case 119: {
                return 115;
            }
            case 120: {
                return 116;
            }
            case 121: {
                return 117;
            }
            case 122: {
                return 118;
            }
            case 123: {
                return 119;
            }
            case 124: {
                return 120;
            }
            case 125: {
                return 121;
            }
            case 126: {
                return 122;
            }
            case 128: {
                return 124;
            }
            case 129: {
                return 125;
            }
            case 130: {
                return 126;
            }
            case 133: 
            case 134: {
                return 130;
            }
            case 136: {
                return 132;
            }
            case 151: {
                return 147;
            }
            case 152: {
                return 148;
            }
            case 154: {
                return 149;
            }
            case 160: {
                return 152;
            }
        }
        throw new IllegalStateException(String.valueOf(n));
    }

    private com.google.javascript.rhino.Node newNode(int n) {
        return new com.google.javascript.rhino.Node(n).clonePropsFrom(this.templateNode);
    }

    private com.google.javascript.rhino.Node newNode(int n, com.google.javascript.rhino.Node node) {
        return new com.google.javascript.rhino.Node(n, node).clonePropsFrom(this.templateNode);
    }

    private com.google.javascript.rhino.Node newNode(int n, com.google.javascript.rhino.Node node, com.google.javascript.rhino.Node node2) {
        return new com.google.javascript.rhino.Node(n, node, node2).clonePropsFrom(this.templateNode);
    }

    private com.google.javascript.rhino.Node newNode(int n, com.google.javascript.rhino.Node node, com.google.javascript.rhino.Node node2, com.google.javascript.rhino.Node node3) {
        return new com.google.javascript.rhino.Node(n, node, node2, node3).clonePropsFrom(this.templateNode);
    }

    private com.google.javascript.rhino.Node newStringNode(String string) {
        return com.google.javascript.rhino.Node.newString(string).clonePropsFrom(this.templateNode);
    }

    private com.google.javascript.rhino.Node newStringNode(int n, String string) {
        return com.google.javascript.rhino.Node.newString(n, string).clonePropsFrom(this.templateNode);
    }

    private com.google.javascript.rhino.Node newNumberNode(Double d) {
        return com.google.javascript.rhino.Node.newNumber(d).clonePropsFrom(this.templateNode);
    }

    private class TransformDispatcher
    extends TypeSafeDispatcher<com.google.javascript.rhino.Node> {
        private TransformDispatcher() {
        }

        private com.google.javascript.rhino.Node processGeneric(Node node) {
            com.google.javascript.rhino.Node node2 = IRFactory.this.newNode(IRFactory.transformTokenType(node.getType()));
            for (Node node3 : node) {
                node2.addChildToBack(IRFactory.this.transform((AstNode)node3));
            }
            return node2;
        }

        private com.google.javascript.rhino.Node transformAsString(AstNode astNode) {
            com.google.javascript.rhino.Node node;
            if (astNode instanceof Name) {
                node = IRFactory.this.transformNameAsString((Name)astNode);
            } else if (astNode instanceof NumberLiteral) {
                node = IRFactory.this.transformNumberAsString((NumberLiteral)astNode);
                node.putBooleanProp(36, true);
            } else {
                node = IRFactory.this.transform(astNode);
                node.putBooleanProp(36, true);
            }
            Preconditions.checkState((node.getType() == 40 ? 1 : 0) != 0);
            return node;
        }

        @Override
        com.google.javascript.rhino.Node processArrayLiteral(ArrayLiteral arrayLiteral) {
            if (arrayLiteral.isDestructuring()) {
                this.reportDestructuringAssign(arrayLiteral);
            }
            com.google.javascript.rhino.Node node = IRFactory.this.newNode(63);
            for (AstNode astNode : arrayLiteral.getElements()) {
                com.google.javascript.rhino.Node node2 = IRFactory.this.transform(astNode);
                node.addChildToBack(node2);
            }
            return node;
        }

        @Override
        com.google.javascript.rhino.Node processAssignment(Assignment assignment) {
            com.google.javascript.rhino.Node node = this.processInfixExpression(assignment);
            com.google.javascript.rhino.Node node2 = node.getFirstChild();
            if (!this.validAssignmentTarget(node2)) {
                IRFactory.this.errorReporter.error("invalid assignment target", IRFactory.this.sourceName, node2.getLineno(), "", 0);
            }
            return node;
        }

        @Override
        com.google.javascript.rhino.Node processAstRoot(AstRoot astRoot) {
            com.google.javascript.rhino.Node node = IRFactory.this.newNode(132);
            for (Node node2 : astRoot) {
                node.addChildToBack(IRFactory.this.transform((AstNode)node2));
            }
            this.parseDirectives(node);
            return node;
        }

        private void parseDirectives(com.google.javascript.rhino.Node node) {
            Set set = null;
            while (this.isDirective(node.getFirstChild())) {
                String string = node.removeFirstChild().getFirstChild().getString();
                if (set == null) {
                    set = Sets.newHashSet((Object[])new String[]{string});
                    continue;
                }
                set.add(string);
            }
            if (set != null) {
                node.setDirectives(set);
            }
        }

        private boolean isDirective(com.google.javascript.rhino.Node node) {
            if (node == null) {
                return false;
            }
            int n = node.getType();
            return (n == 130 || n == 129) && node.getFirstChild().getType() == 40 && IRFactory.this.ALLOWED_DIRECTIVES.contains(node.getFirstChild().getString());
        }

        @Override
        com.google.javascript.rhino.Node processBlock(Block block) {
            return this.processGeneric(block);
        }

        @Override
        com.google.javascript.rhino.Node processBreakStatement(BreakStatement breakStatement) {
            com.google.javascript.rhino.Node node = IRFactory.this.newNode(116);
            if (breakStatement.getBreakLabel() != null) {
                com.google.javascript.rhino.Node node2 = IRFactory.this.transform(breakStatement.getBreakLabel());
                node2.setType(153);
                node.addChildToBack(node2);
            }
            return node;
        }

        @Override
        com.google.javascript.rhino.Node processCatchClause(CatchClause catchClause) {
            Name name = catchClause.getVarName();
            com.google.javascript.rhino.Node node = IRFactory.this.newNode(120, IRFactory.this.transform(name));
            if (catchClause.getCatchCondition() != null) {
                IRFactory.this.errorReporter.error("Catch clauses are not supported", IRFactory.this.sourceName, catchClause.getCatchCondition().getLineno(), "", 0);
            }
            node.addChildToBack(IRFactory.this.transformBlock(catchClause.getBody()));
            return node;
        }

        @Override
        com.google.javascript.rhino.Node processConditionalExpression(ConditionalExpression conditionalExpression) {
            return IRFactory.this.newNode(98, IRFactory.this.transform(conditionalExpression.getTestExpression()), IRFactory.this.transform(conditionalExpression.getTrueExpression()), IRFactory.this.transform(conditionalExpression.getFalseExpression()));
        }

        @Override
        com.google.javascript.rhino.Node processContinueStatement(ContinueStatement continueStatement) {
            com.google.javascript.rhino.Node node = IRFactory.this.newNode(117);
            if (continueStatement.getLabel() != null) {
                com.google.javascript.rhino.Node node2 = IRFactory.this.transform(continueStatement.getLabel());
                node2.setType(153);
                node.addChildToBack(node2);
            }
            return node;
        }

        @Override
        com.google.javascript.rhino.Node processDoLoop(DoLoop doLoop) {
            return IRFactory.this.newNode(114, IRFactory.this.transformBlock(doLoop.getBody()), IRFactory.this.transform(doLoop.getCondition()));
        }

        @Override
        com.google.javascript.rhino.Node processElementGet(ElementGet elementGet) {
            return IRFactory.this.newNode(35, IRFactory.this.transform(elementGet.getTarget()), IRFactory.this.transform(elementGet.getElement()));
        }

        @Override
        com.google.javascript.rhino.Node processEmptyExpression(EmptyExpression emptyExpression) {
            com.google.javascript.rhino.Node node = IRFactory.this.newNode(124);
            return node;
        }

        @Override
        com.google.javascript.rhino.Node processExpressionStatement(ExpressionStatement expressionStatement) {
            com.google.javascript.rhino.Node node = IRFactory.this.newNode(IRFactory.transformTokenType(expressionStatement.getType()));
            node.addChildToBack(IRFactory.this.transform(expressionStatement.getExpression()));
            return node;
        }

        @Override
        com.google.javascript.rhino.Node processForInLoop(ForInLoop forInLoop) {
            return IRFactory.this.newNode(115, IRFactory.this.transform(forInLoop.getIterator()), IRFactory.this.transform(forInLoop.getIteratedObject()), IRFactory.this.transformBlock(forInLoop.getBody()));
        }

        @Override
        com.google.javascript.rhino.Node processForLoop(ForLoop forLoop) {
            com.google.javascript.rhino.Node node = IRFactory.this.newNode(115, IRFactory.this.transform(forLoop.getInitializer()), IRFactory.this.transform(forLoop.getCondition()), IRFactory.this.transform(forLoop.getIncrement()));
            node.addChildToBack(IRFactory.this.transformBlock(forLoop.getBody()));
            return node;
        }

        @Override
        com.google.javascript.rhino.Node processFunctionCall(FunctionCall functionCall) {
            com.google.javascript.rhino.Node node = IRFactory.this.newNode(IRFactory.transformTokenType(functionCall.getType()), IRFactory.this.transform(functionCall.getTarget()));
            for (AstNode astNode : functionCall.getArguments()) {
                node.addChildToBack(IRFactory.this.transform(astNode));
            }
            int n = functionCall.getAbsolutePosition() + functionCall.getLp();
            node.setLineno(functionCall.getLineno());
            node.setCharno(IRFactory.this.position2charno(n));
            return node;
        }

        @Override
        com.google.javascript.rhino.Node processFunctionNode(FunctionNode functionNode) {
            Name name = functionNode.getFunctionName();
            Boolean bl = false;
            if (name == null) {
                int n = functionNode.getFunctionType();
                if (n != 2) {
                    IRFactory.this.errorReporter.error("unnamed function statement", IRFactory.this.sourceName, functionNode.getLineno(), "", 0);
                }
                name = new Name();
                name.setIdentifier("");
                bl = true;
            }
            com.google.javascript.rhino.Node node = IRFactory.this.newNode(105);
            com.google.javascript.rhino.Node node2 = IRFactory.this.transform(name);
            if (bl.booleanValue()) {
                node2.setLineno(functionNode.getLineno());
                int n = functionNode.getAbsolutePosition() + functionNode.getLp();
                node2.setCharno(IRFactory.this.position2charno(n));
            }
            node.addChildToBack(node2);
            com.google.javascript.rhino.Node node3 = IRFactory.this.newNode(83);
            Name name2 = functionNode.getFunctionName();
            if (name2 != null) {
                node3.setLineno(name2.getLineno());
            } else {
                node3.setLineno(functionNode.getLineno());
            }
            int n = functionNode.getLp() + functionNode.getAbsolutePosition();
            node3.setCharno(IRFactory.this.position2charno(n));
            for (AstNode astNode : functionNode.getParams()) {
                node3.addChildToBack(IRFactory.this.transform(astNode));
            }
            node.addChildToBack(node3);
            com.google.javascript.rhino.Node node4 = IRFactory.this.transform(functionNode.getBody());
            this.parseDirectives(node4);
            node.addChildToBack(node4);
            return node;
        }

        @Override
        com.google.javascript.rhino.Node processIfStatement(IfStatement ifStatement) {
            com.google.javascript.rhino.Node node = IRFactory.this.newNode(108);
            node.addChildToBack(IRFactory.this.transform(ifStatement.getCondition()));
            node.addChildToBack(IRFactory.this.transformBlock(ifStatement.getThenPart()));
            if (ifStatement.getElsePart() != null) {
                node.addChildToBack(IRFactory.this.transformBlock(ifStatement.getElsePart()));
            }
            return node;
        }

        @Override
        com.google.javascript.rhino.Node processInfixExpression(InfixExpression infixExpression) {
            com.google.javascript.rhino.Node node = IRFactory.this.newNode(IRFactory.transformTokenType(infixExpression.getType()), IRFactory.this.transform(infixExpression.getLeft()), IRFactory.this.transform(infixExpression.getRight()));
            node.setLineno(infixExpression.getLineno());
            node.setCharno(IRFactory.this.position2charno(infixExpression.getAbsolutePosition() + infixExpression.getOperatorPosition()));
            return node;
        }

        @Override
        com.google.javascript.rhino.Node processKeywordLiteral(KeywordLiteral keywordLiteral) {
            return IRFactory.this.newNode(IRFactory.transformTokenType(keywordLiteral.getType()));
        }

        @Override
        com.google.javascript.rhino.Node processLabel(Label label) {
            return IRFactory.this.newStringNode(153, label.getName());
        }

        @Override
        com.google.javascript.rhino.Node processLabeledStatement(LabeledStatement labeledStatement) {
            com.google.javascript.rhino.Node node = IRFactory.this.newNode(126);
            com.google.javascript.rhino.Node node2 = null;
            com.google.javascript.rhino.Node node3 = node;
            for (Label label : labeledStatement.getLabels()) {
                if (node2 != null) {
                    node2.addChildToBack(node3);
                }
                node3.addChildToBack(IRFactory.this.transform(label));
                node3.setLineno(label.getLineno());
                int n = IRFactory.this.position2charno(label.getAbsolutePosition());
                node3.setCharno(n);
                node2 = node3;
                node3 = IRFactory.this.newNode(126);
            }
            node2.addChildToBack(IRFactory.this.transform(labeledStatement.getStatement()));
            return node;
        }

        @Override
        com.google.javascript.rhino.Node processName(Name name) {
            return this.processName(name, false);
        }

        com.google.javascript.rhino.Node processName(Name name, boolean bl) {
            if (bl) {
                return IRFactory.this.newStringNode(40, name.getIdentifier());
            }
            if (this.isReservedKeyword(name.getIdentifier())) {
                IRFactory.this.errorReporter.error("identifier is a reserved word", IRFactory.this.sourceName, name.getLineno(), "", 0);
            }
            return IRFactory.this.newStringNode(38, name.getIdentifier());
        }

        private boolean isReservedKeyword(String string) {
            return IRFactory.this.reservedKeywords != null && IRFactory.this.reservedKeywords.contains(string);
        }

        @Override
        com.google.javascript.rhino.Node processNewExpression(NewExpression newExpression) {
            return this.processFunctionCall(newExpression);
        }

        @Override
        com.google.javascript.rhino.Node processNumberLiteral(NumberLiteral numberLiteral) {
            return IRFactory.this.newNumberNode(numberLiteral.getNumber());
        }

        @Override
        com.google.javascript.rhino.Node processObjectLiteral(ObjectLiteral objectLiteral) {
            if (objectLiteral.isDestructuring()) {
                this.reportDestructuringAssign(objectLiteral);
            }
            com.google.javascript.rhino.Node node = IRFactory.this.newNode(64);
            for (ObjectProperty objectProperty : objectLiteral.getElements()) {
                if (((IRFactory)IRFactory.this).config.languageMode == Config.LanguageMode.ECMASCRIPT3) {
                    if (objectProperty.isGetter()) {
                        this.reportGetter(objectProperty);
                        continue;
                    }
                    if (objectProperty.isSetter()) {
                        this.reportSetter(objectProperty);
                        continue;
                    }
                }
                com.google.javascript.rhino.Node node2 = this.transformAsString(objectProperty.getLeft());
                com.google.javascript.rhino.Node node3 = IRFactory.this.transform(objectProperty.getRight());
                if (objectProperty.isGetter()) {
                    node2.setType(147);
                    Preconditions.checkState((node3.getType() == 105 ? 1 : 0) != 0);
                    if (this.getFnParamNode(node3).hasChildren()) {
                        this.reportGetterParam(objectProperty.getLeft());
                    }
                } else if (objectProperty.isSetter()) {
                    node2.setType(148);
                    Preconditions.checkState((node3.getType() == 105 ? 1 : 0) != 0);
                    if (!this.getFnParamNode(node3).hasOneChild()) {
                        this.reportSetterParam(objectProperty.getLeft());
                    }
                }
                node2.addChildToFront(node3);
                node.addChildToBack(node2);
            }
            return node;
        }

        com.google.javascript.rhino.Node getFnParamNode(com.google.javascript.rhino.Node node) {
            Preconditions.checkArgument((node.getType() == 105 ? 1 : 0) != 0);
            return node.getFirstChild().getNext();
        }

        @Override
        com.google.javascript.rhino.Node processObjectProperty(ObjectProperty objectProperty) {
            return this.processInfixExpression(objectProperty);
        }

        @Override
        com.google.javascript.rhino.Node processParenthesizedExpression(ParenthesizedExpression parenthesizedExpression) {
            com.google.javascript.rhino.Node node = IRFactory.this.transform(parenthesizedExpression.getExpression());
            node.putProp(35, Boolean.TRUE);
            return node;
        }

        @Override
        com.google.javascript.rhino.Node processPropertyGet(PropertyGet propertyGet) {
            return IRFactory.this.newNode(33, IRFactory.this.transform(propertyGet.getTarget()), this.transformAsString(propertyGet.getProperty()));
        }

        @Override
        com.google.javascript.rhino.Node processRegExpLiteral(RegExpLiteral regExpLiteral) {
            com.google.javascript.rhino.Node node = IRFactory.this.newStringNode(regExpLiteral.getValue());
            node.setLineno(regExpLiteral.getLineno());
            com.google.javascript.rhino.Node node2 = IRFactory.this.newNode(47, node);
            String string = regExpLiteral.getFlags();
            if (string != null && !string.isEmpty()) {
                com.google.javascript.rhino.Node node3 = IRFactory.this.newStringNode(string);
                node3.setLineno(regExpLiteral.getLineno());
                node2.addChildToBack(node3);
            }
            return node2;
        }

        @Override
        com.google.javascript.rhino.Node processReturnStatement(ReturnStatement returnStatement) {
            com.google.javascript.rhino.Node node = IRFactory.this.newNode(4);
            if (returnStatement.getReturnValue() != null) {
                node.addChildToBack(IRFactory.this.transform(returnStatement.getReturnValue()));
            }
            return node;
        }

        @Override
        com.google.javascript.rhino.Node processScope(Scope scope) {
            return this.processGeneric(scope);
        }

        @Override
        com.google.javascript.rhino.Node processStringLiteral(StringLiteral stringLiteral) {
            com.google.javascript.rhino.Node node = IRFactory.this.newStringNode(stringLiteral.getValue());
            return node;
        }

        @Override
        com.google.javascript.rhino.Node processSwitchCase(SwitchCase switchCase) {
            Object object;
            com.google.javascript.rhino.Node node;
            if (switchCase.isDefault()) {
                node = IRFactory.this.newNode(112);
            } else {
                object = switchCase.getExpression();
                node = IRFactory.this.newNode(111, IRFactory.this.transform((AstNode)object));
            }
            object = IRFactory.this.newNode(125);
            ((com.google.javascript.rhino.Node)object).putBooleanProp(38, true);
            ((com.google.javascript.rhino.Node)object).setLineno(switchCase.getLineno());
            ((com.google.javascript.rhino.Node)object).setCharno(IRFactory.this.position2charno(switchCase.getAbsolutePosition()));
            if (switchCase.getStatements() != null) {
                for (AstNode astNode : switchCase.getStatements()) {
                    ((com.google.javascript.rhino.Node)object).addChildToBack(IRFactory.this.transform(astNode));
                }
            }
            node.addChildToBack((com.google.javascript.rhino.Node)object);
            return node;
        }

        @Override
        com.google.javascript.rhino.Node processSwitchStatement(SwitchStatement switchStatement) {
            com.google.javascript.rhino.Node node = IRFactory.this.newNode(110, IRFactory.this.transform(switchStatement.getExpression()));
            for (SwitchCase switchCase : switchStatement.getCases()) {
                node.addChildToBack(IRFactory.this.transform(switchCase));
            }
            return node;
        }

        @Override
        com.google.javascript.rhino.Node processThrowStatement(ThrowStatement throwStatement) {
            return IRFactory.this.newNode(49, IRFactory.this.transform(throwStatement.getExpression()));
        }

        @Override
        com.google.javascript.rhino.Node processTryStatement(TryStatement tryStatement) {
            com.google.javascript.rhino.Node node = IRFactory.this.newNode(77, IRFactory.this.transformBlock(tryStatement.getTryBlock()));
            com.google.javascript.rhino.Node node2 = IRFactory.this.newNode(125);
            boolean bl = false;
            for (CatchClause catchClause : tryStatement.getCatchClauses()) {
                if (!bl) {
                    node2.setLineno(catchClause.getLineno());
                    bl = true;
                }
                node2.addChildToBack(IRFactory.this.transform(catchClause));
            }
            node.addChildToBack(node2);
            AstNode astNode = tryStatement.getFinallyBlock();
            if (astNode != null) {
                node.addChildToBack(IRFactory.this.transformBlock(astNode));
            }
            if (!bl && astNode != null) {
                node2.setLineno(astNode.getLineno());
            }
            return node;
        }

        @Override
        com.google.javascript.rhino.Node processUnaryExpression(UnaryExpression unaryExpression) {
            Object object;
            int n = IRFactory.transformTokenType(unaryExpression.getType());
            com.google.javascript.rhino.Node node = IRFactory.this.transform(unaryExpression.getOperand());
            if (n == 29 && node.getType() == 39) {
                node.setDouble(-node.getDouble());
                return node;
            }
            if (!(n != 102 && n != 103 || this.validAssignmentTarget(node))) {
                object = n == 102 ? "invalid increment target" : "invalid decrement target";
                IRFactory.this.errorReporter.error((String)object, IRFactory.this.sourceName, node.getLineno(), "", 0);
            }
            object = IRFactory.this.newNode(n, node);
            if (unaryExpression.isPostfix()) {
                ((com.google.javascript.rhino.Node)object).putBooleanProp(32, true);
            }
            return object;
        }

        private boolean validAssignmentTarget(com.google.javascript.rhino.Node node) {
            switch (node.getType()) {
                case 33: 
                case 35: 
                case 38: {
                    return true;
                }
            }
            return false;
        }

        @Override
        com.google.javascript.rhino.Node processVariableDeclaration(VariableDeclaration variableDeclaration) {
            if (!((IRFactory)IRFactory.this).config.acceptConstKeyword && variableDeclaration.getType() == 154) {
                this.processIllegalToken(variableDeclaration);
            }
            com.google.javascript.rhino.Node node = IRFactory.this.newNode(118);
            for (VariableInitializer variableInitializer : variableDeclaration.getVariables()) {
                node.addChildToBack(IRFactory.this.transform(variableInitializer));
            }
            return node;
        }

        @Override
        com.google.javascript.rhino.Node processVariableInitializer(VariableInitializer variableInitializer) {
            com.google.javascript.rhino.Node node = IRFactory.this.transform(variableInitializer.getTarget());
            if (variableInitializer.getInitializer() != null) {
                node.addChildToBack(IRFactory.this.transform(variableInitializer.getInitializer()));
                node.setLineno(node.getLineno());
            }
            return node;
        }

        @Override
        com.google.javascript.rhino.Node processWhileLoop(WhileLoop whileLoop) {
            return IRFactory.this.newNode(113, IRFactory.this.transform(whileLoop.getCondition()), IRFactory.this.transformBlock(whileLoop.getBody()));
        }

        @Override
        com.google.javascript.rhino.Node processWithStatement(WithStatement withStatement) {
            return IRFactory.this.newNode(119, IRFactory.this.transform(withStatement.getExpression()), IRFactory.this.transformBlock(withStatement.getStatement()));
        }

        @Override
        com.google.javascript.rhino.Node processIllegalToken(AstNode astNode) {
            IRFactory.this.errorReporter.error("Unsupported syntax: " + Token.typeToName(astNode.getType()), IRFactory.this.sourceName, astNode.getLineno(), "", 0);
            return IRFactory.this.newNode(124);
        }

        void reportDestructuringAssign(AstNode astNode) {
            IRFactory.this.errorReporter.error("destructuring assignment forbidden", IRFactory.this.sourceName, astNode.getLineno(), "", 0);
        }

        void reportGetter(AstNode astNode) {
            IRFactory.this.errorReporter.error("getters are not supported in Internet Explorer", IRFactory.this.sourceName, astNode.getLineno(), "", 0);
        }

        void reportSetter(AstNode astNode) {
            IRFactory.this.errorReporter.error("setters are not supported in Internet Explorer", IRFactory.this.sourceName, astNode.getLineno(), "", 0);
        }

        void reportGetterParam(AstNode astNode) {
            IRFactory.this.errorReporter.error("getters may not have parameters", IRFactory.this.sourceName, astNode.getLineno(), "", 0);
        }

        void reportSetterParam(AstNode astNode) {
            IRFactory.this.errorReporter.error("setters must have exactly one parameter", IRFactory.this.sourceName, astNode.getLineno(), "", 0);
        }
    }
}

