/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino;

import com.google.javascript.rhino.FunctionNode;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JavaScriptException;
import com.google.javascript.rhino.Kit;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.ObjArray;
import com.google.javascript.rhino.Parser;
import com.google.javascript.rhino.ScriptOrFnNode;
import com.google.javascript.rhino.ScriptRuntime;

final class IRFactory {
    private Parser parser;

    IRFactory(Parser parser) {
        this.parser = parser;
    }

    ScriptOrFnNode createScript() {
        return new ScriptOrFnNode(132);
    }

    void initScript(ScriptOrFnNode scriptOrFnNode, Node node) {
        Node node2 = node.removeChildren();
        if (node2 != null) {
            scriptOrFnNode.addChildrenToBack(node2);
        }
    }

    Node createLeaf(int n) {
        return new Node(n);
    }

    Node createLeaf(int n, int n2, int n3) {
        return new Node(n, n2, n3);
    }

    Node createSwitch(int n, int n2) {
        return new Node(110, n, n2);
    }

    void addSwitchCase(Node node, Node node2, Node node3, int n, int n2) {
        if (node.getType() != 110) {
            throw Kit.codeBug();
        }
        Node node4 = node2 != null ? new Node(111, node2, n, n2) : new Node(112, n, n2);
        node4.addChildToBack(node3);
        node.addChildToBack(node4);
    }

    void closeSwitch(Node node) {
    }

    Node createVariables(int n, int n2, int n3) {
        return new Node(n, n2, n3);
    }

    Node createExprStatement(Node node, int n, int n2) {
        int n3 = this.parser.insideFunction() ? 129 : 130;
        return new Node(n3, node, n, n2);
    }

    Node createExprStatementNoReturn(Node node, int n, int n2) {
        return new Node(129, node, n, n2);
    }

    Node createDefaultNamespace(Node node, int n, int n2) {
        this.setRequiresActivation();
        Node node2 = this.createUnary(70, node, n, n2);
        Node node3 = this.createExprStatement(node2, n, n2);
        return node3;
    }

    public Node createErrorName() {
        return Node.newString(38, "error");
    }

    Node createName(String string, int n, int n2) {
        this.checkActivationName(string, 38);
        return Node.newString(38, string, n, n2);
    }

    public Node createTaggedName(String string, JSDocInfo jSDocInfo, int n, int n2) {
        Node node = this.createName(string, n, n2);
        if (jSDocInfo != null) {
            node.setJSDocInfo(jSDocInfo);
        }
        return node;
    }

    Node createString(String string) {
        return Node.newString(string);
    }

    Node createString(String string, int n, int n2) {
        return Node.newString(string, n, n2);
    }

    Node createNumber(double d) {
        return Node.newNumber(d);
    }

    Node createNumber(double d, int n, int n2) {
        return Node.newNumber(d, n, n2);
    }

    Node createCatch(String string, int n, int n2, Node node, Node node2, int n3, int n4) {
        if (node == null) {
            node = new Node(124, n, n2);
        }
        return new Node(120, this.createName(string, n, n2), node, node2, n3, n4);
    }

    Node createThrow(Node node, int n, int n2) {
        return new Node(49, node, n, n2);
    }

    Node createReturn(Node node, int n, int n2) {
        return node == null ? new Node(4, n, n2) : new Node(4, node, n, n2);
    }

    Node createLabel(String string, int n, int n2) {
        return new Node(126, Node.newString(38, string, n, n2), n, n2);
    }

    Node createBreak(String string, int n, int n2) {
        Node node = new Node(116, n, n2);
        if (string == null) {
            return node;
        }
        Node node2 = Node.newString(38, string, n, n2);
        node.addChildToBack(node2);
        return node;
    }

    Node createContinue(String string, int n, int n2) {
        Node node = new Node(117, n, n2);
        if (string == null) {
            return node;
        }
        Node node2 = Node.newString(38, string, n, n2);
        node.addChildToBack(node2);
        return node;
    }

    Node createDebugger(int n, int n2) {
        return new Node(152, n, n2);
    }

    Node createBlock(int n, int n2) {
        return new Node(125, n, n2);
    }

    FunctionNode createFunction(String string, int n, int n2) {
        FunctionNode functionNode = new FunctionNode(string, n, n2);
        functionNode.addChildToBack(this.createName(string, n, n2));
        return functionNode;
    }

    Node initFunction(FunctionNode functionNode, int n, Node node, JSDocInfo jSDocInfo, Node node2, int n2) {
        int n3;
        functionNode.itsFunctionType = n2;
        functionNode.addChildToBack(node);
        functionNode.addChildToBack(node2);
        if (this.parser.getSourceName() != null) {
            functionNode.putProp(16, this.parser.getSourceName());
        }
        if (jSDocInfo != null) {
            functionNode.setJSDocInfo(jSDocInfo);
        }
        if ((n3 = functionNode.getFunctionCount()) != 0) {
            functionNode.itsNeedsActivation = true;
            for (int i = 0; i != n3; ++i) {
                String string;
                FunctionNode functionNode2 = functionNode.getFunctionNode(i);
                if (functionNode2.getFunctionType() != 3 || (string = functionNode2.getFunctionName()) == null || string.length() == 0) continue;
                functionNode.removeParamOrVar(string);
            }
        }
        functionNode.putIntProp(5, n);
        return functionNode;
    }

    void addChildToBack(Node node, Node node2) {
        node.addChildToBack(node2);
    }

    Node createWhile(Node node, Node node2, int n, int n2) {
        return new Node(113, node, node2, n, n2);
    }

    Node createDoWhile(Node node, Node node2, int n, int n2) {
        return new Node(114, node, node2, n, n2);
    }

    Node createFor(Node node, Node node2, Node node3, Node node4, int n, int n2) {
        return new Node(115, node, node2, node3, node4, n, n2);
    }

    Node createForIn(Node node, Node node2, Node node3, int n, int n2) {
        return new Node(115, node, node2, node3, n, n2);
    }

    Node createTryCatchFinally(Node node, Node node2, Node node3, int n, int n2) {
        if (node3 == null) {
            return new Node(77, node, node2, n, n2);
        }
        return new Node(77, node, node2, node3, n, n2);
    }

    Node createWith(Node node, Node node2, int n, int n2) {
        return new Node(119, node, node2, n, n2);
    }

    public Node createDotQuery(Node node, Node node2, int n, int n2) {
        this.setRequiresActivation();
        Node node3 = new Node(142, node, node2, n, n2);
        return node3;
    }

    Node createArrayLiteral(ObjArray objArray, int n, int n2, int n3) {
        int n4 = objArray.size();
        int[] nArray = null;
        if (n != 0) {
            nArray = new int[n];
        }
        Node node = new Node(63, n2, n3);
        int n5 = 0;
        for (int i = 0; i != n4; ++i) {
            Node node2 = (Node)objArray.get(i);
            if (node2 != null) {
                node.addChildToBack(node2);
                continue;
            }
            nArray[n5] = i;
            ++n5;
        }
        if (n != 0) {
            node.putProp(31, nArray);
        }
        return node;
    }

    Node createObjectLiteral(ObjArray objArray, int n, int n2) {
        Node node = new Node(64, n, n2);
        for (int i = 0; i < objArray.size(); i += 2) {
            Node node2 = (Node)objArray.get(i);
            node.addChildToBack(node2);
            node2 = (Node)objArray.get(i + 1);
            node.addChildToBack(node2);
        }
        return node;
    }

    Node createRegExp(String string, String string2, int n, int n2) {
        return string2.length() == 0 ? new Node(47, Node.newString(string, n, n2), n, n2) : new Node(47, Node.newString(string, n, n2), Node.newString(string2, n, n2), n, n2);
    }

    Node createIf(Node node, Node node2, Node node3, int n, int n2) {
        if (node3 == null) {
            return new Node(108, node, node2, n, n2);
        }
        return new Node(108, node, node2, node3, n, n2);
    }

    Node createCondExpr(Node node, Node node2, Node node3, int n, int n2) {
        return new Node(98, node, node2, node3, n, n2);
    }

    Node createUnary(int n, Node node, int n2, int n3) {
        return new Node(n, node, n2, n3);
    }

    Node createCallOrNew(int n, Node node, int n2, int n3) {
        Object object;
        int n4 = 0;
        if (node.getType() == 38) {
            object = node.getString();
            if (((String)object).equals("eval")) {
                n4 = 1;
            } else if (((String)object).equals("With")) {
                n4 = 2;
            }
        } else if (node.getType() == 33 && ((String)(object = node.getLastChild().getString())).equals("eval")) {
            n4 = 1;
        }
        object = new Node(n, node, n2, n3);
        if (n4 != 0) {
            this.setRequiresActivation();
            ((Node)object).putIntProp(27, n4);
        }
        return object;
    }

    Node createIncDec(int n, boolean bl, Node node, int n2, int n3) {
        if ((node = this.makeReference(node)) == null) {
            String string = n == 103 ? "msg.bad.decr" : "msg.bad.incr";
            this.parser.reportError(string);
            return null;
        }
        int n4 = node.getType();
        switch (n4) {
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 65: {
                Node node2 = new Node(n, node, n2, n3);
                node2.putIntProp(32, bl ? 1 : 0);
                return node2;
            }
        }
        throw Kit.codeBug();
    }

    Node createPropertyGet(Node node, String string, String string2, int n, int n2, int n3, int n4, int n5) {
        if (string == null && n == 0) {
            if (node == null) {
                return this.createName(string2, n4, n5);
            }
            this.checkActivationName(string2, 33);
            if (ScriptRuntime.isSpecialProperty(string2)) {
                Node node2 = new Node(69, node);
                node2.putProp(34, string2);
                return new Node(65, node2, n2, n3);
            }
            return new Node(33, node, this.createString(string2, n4, n5), n2, n3);
        }
        Node node3 = this.createString(string2);
        return this.createMemberRefGet(node, string, node3, n |= 1, n2, n3);
    }

    Node createElementGet(Node node, String string, Node node2, int n, int n2, int n3) {
        if (string == null && n == 0) {
            if (node == null) {
                throw Kit.codeBug();
            }
            return new Node(35, node, node2, n2, n3);
        }
        return this.createMemberRefGet(node, string, node2, n, n2, n3);
    }

    private Node createMemberRefGet(Node node, String string, Node node2, int n, int n2, int n3) {
        Node node3 = null;
        if (string != null) {
            node3 = string.equals("*") ? new Node(41, n2, n3) : this.createName(string, n2, n3);
        }
        Node node4 = node == null ? (string == null ? new Node(75, node2, n2, n3) : new Node(76, node3, node2, n2, n3)) : (string == null ? new Node(73, node, node2, n2, n3) : new Node(74, node, node3, node2, n2, n3));
        if (n != 0) {
            node4.putIntProp(33, n);
        }
        return new Node(65, node4, n2, n3);
    }

    Node createBinary(int n, Node node, Node node2, int n2, int n3) {
        switch (n) {
            case 104: {
                n = 33;
                Node node3 = node2;
                node3.setType(40);
                break;
            }
            case 79: {
                n = 35;
            }
        }
        return new Node(n, node, node2, n2, n3);
    }

    Node createAssignment(int n, Node node, Node node2, int n2, int n3) throws JavaScriptException {
        int n4 = node.getType();
        switch (n4) {
            case 33: 
            case 35: 
            case 38: {
                break;
            }
            default: {
                this.parser.reportError("msg.bad.assign.left");
            }
        }
        return new Node(86, node, node2, n2, n3);
    }

    private Node makeReference(Node node) {
        int n = node.getType();
        switch (n) {
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 65: {
                return node;
            }
        }
        return null;
    }

    private void checkActivationName(String string, int n) {
        if (this.parser.insideFunction()) {
            boolean bl = false;
            if ("arguments".equals(string) || this.parser.compilerEnv.activationNames != null && this.parser.compilerEnv.activationNames.containsKey(string)) {
                bl = true;
            } else if ("length".equals(string) && n == 33 && this.parser.compilerEnv.getLanguageVersion() == 120) {
                bl = true;
            }
            if (bl) {
                this.setRequiresActivation();
            }
        }
    }

    private void setRequiresActivation() {
        if (this.parser.insideFunction()) {
            ((FunctionNode)this.parser.currentScriptOrFn).itsNeedsActivation = true;
        }
    }
}

