/*
 * Decompiled with CFR 0.152.
 */
package com.google.debugging.sourcemap;

import com.google.debugging.sourcemap.SourceMapConsumerV1;
import com.google.debugging.sourcemap.SourceMapConsumerV2;
import com.google.debugging.sourcemap.SourceMapConsumerV3;
import com.google.debugging.sourcemap.SourceMapParseException;
import com.google.debugging.sourcemap.SourceMapping;
import org.json.JSONException;
import org.json.JSONObject;

public class SourceMapConsumerFactory {
    private SourceMapConsumerFactory() {
    }

    public static SourceMapping parse(String string) throws SourceMapParseException {
        if (string.startsWith("/** Begin line maps. **/")) {
            SourceMapConsumerV1 sourceMapConsumerV1 = new SourceMapConsumerV1();
            sourceMapConsumerV1.parse(string);
            return sourceMapConsumerV1;
        }
        if (string.startsWith("{")) {
            try {
                JSONObject jSONObject = new JSONObject(string);
                int n = jSONObject.getInt("version");
                switch (n) {
                    case 2: {
                        SourceMapConsumerV2 sourceMapConsumerV2 = new SourceMapConsumerV2();
                        sourceMapConsumerV2.parse(jSONObject);
                        return sourceMapConsumerV2;
                    }
                    case 3: {
                        SourceMapConsumerV3 sourceMapConsumerV3 = new SourceMapConsumerV3();
                        sourceMapConsumerV3.parse(jSONObject);
                        return sourceMapConsumerV3;
                    }
                }
                throw new SourceMapParseException("Unknown source map version:" + n);
            }
            catch (JSONException jSONException) {
                throw new SourceMapParseException("JSON parse exception: " + (Object)((Object)jSONException));
            }
        }
        throw new SourceMapParseException("unable to detect source map format");
    }
}

