/*
 * Decompiled with CFR 0.152.
 */
package com.google.debugging.sourcemap;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.debugging.sourcemap.Base64VLQ;
import com.google.debugging.sourcemap.SourceMapConsumer;
import com.google.debugging.sourcemap.SourceMapParseException;
import com.google.debugging.sourcemap.proto.Mapping;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SourceMapConsumerV3
implements SourceMapConsumer {
    static final int UNMAPPED = -1;
    private String[] sources;
    private String[] names;
    private int lineCount;
    private List<ArrayList<Entry>> lines = null;

    @Override
    public void parse(String string) throws SourceMapParseException {
        try {
            JSONObject jSONObject = new JSONObject(string);
            this.parse(jSONObject);
        }
        catch (JSONException jSONException) {
            throw new SourceMapParseException("JSON parse exception: " + (Object)((Object)jSONException));
        }
    }

    public void parse(JSONObject jSONObject) throws SourceMapParseException {
        try {
            int n = jSONObject.getInt("version");
            if (n != 3) {
                throw new SourceMapParseException("Unknown version: " + n);
            }
            String string = jSONObject.getString("file");
            if (string.isEmpty()) {
                throw new SourceMapParseException("File entry is missing or empty");
            }
            this.lineCount = jSONObject.getInt("lineCount");
            String string2 = jSONObject.getString("mappings");
            this.sources = this.getJavaStringArray(jSONObject.getJSONArray("sources"));
            this.names = this.getJavaStringArray(jSONObject.getJSONArray("names"));
            this.lines = Lists.newArrayListWithCapacity((int)this.lineCount);
            new MappingBuilder(string2).build();
        }
        catch (JSONException jSONException) {
            throw new SourceMapParseException("JSON parse exception: " + (Object)((Object)jSONException));
        }
    }

    @Override
    public Mapping.OriginalMapping getMappingForLine(int n, int n2) {
        --n2;
        if (--n < 0 || n >= this.lines.size()) {
            return null;
        }
        Preconditions.checkState((n >= 0 ? 1 : 0) != 0);
        Preconditions.checkState((n2 >= 0 ? 1 : 0) != 0);
        if (this.lines.get(n) == null) {
            return this.getPreviousMapping(n);
        }
        ArrayList<Entry> arrayList = this.lines.get(n);
        Preconditions.checkState((arrayList.size() > 0 ? 1 : 0) != 0);
        if (arrayList.get(0).getGeneratedColumn() > n2) {
            return this.getPreviousMapping(n);
        }
        int n3 = this.search(arrayList, n2, 0, arrayList.size() - 1);
        Preconditions.checkState((n3 >= 0 ? 1 : 0) != 0, (Object)("unexpected:" + n3));
        return this.getOriginalMappingForEntry(arrayList.get(n3));
    }

    private String[] getJavaStringArray(JSONArray jSONArray) throws JSONException {
        int n = jSONArray.length();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = jSONArray.getString(i);
        }
        return stringArray;
    }

    private int search(ArrayList<Entry> arrayList, int n, int n2, int n3) {
        int n4;
        int n5;
        do {
            if ((n5 = this.compareEntry(arrayList, n4 = (n3 - n2) / 2 + n2, n)) != 0) continue;
            return n4;
        } while (!(n5 < 0 ? (n2 = n4 + 1) > n3 : (n3 = n4 - 1) < n2));
        return n3;
    }

    private int compareEntry(ArrayList<Entry> arrayList, int n, int n2) {
        return arrayList.get(n).getGeneratedColumn() - n2;
    }

    private Mapping.OriginalMapping getPreviousMapping(int n) {
        do {
            if (n != 0) continue;
            return null;
        } while (this.lines.get(--n) == null);
        ArrayList<Entry> arrayList = this.lines.get(n);
        return this.getOriginalMappingForEntry(arrayList.get(arrayList.size() - 1));
    }

    private Mapping.OriginalMapping getOriginalMappingForEntry(Entry entry) {
        if (entry.getSourceFileId() == -1) {
            return null;
        }
        Mapping.OriginalMapping.Builder builder = Mapping.OriginalMapping.newBuilder().setOriginalFile(this.sources[entry.getSourceFileId()]).setLineNumber(entry.getSourceLine()).setColumnPosition(entry.getSourceColumn());
        if (entry.getNameId() != -1) {
            builder.setIdentifier(this.names[entry.getNameId()]);
        }
        return builder.build();
    }

    private static class NamedEntry
    extends UnnamedEntry {
        private final int name;

        NamedEntry(int n, int n2, int n3, int n4, int n5) {
            super(n, n2, n3, n4);
            this.name = n5;
        }

        @Override
        public int getNameId() {
            return this.name;
        }
    }

    private static class UnnamedEntry
    extends UnmappedEntry {
        private final int srcFile;
        private final int srcLine;
        private final int srcColumn;

        UnnamedEntry(int n, int n2, int n3, int n4) {
            super(n);
            this.srcFile = n2;
            this.srcLine = n3;
            this.srcColumn = n4;
        }

        @Override
        public int getSourceFileId() {
            return this.srcFile;
        }

        @Override
        public int getSourceLine() {
            return this.srcLine;
        }

        @Override
        public int getSourceColumn() {
            return this.srcColumn;
        }

        @Override
        public int getNameId() {
            return -1;
        }
    }

    private static class UnmappedEntry
    implements Entry {
        private final int column;

        UnmappedEntry(int n) {
            this.column = n;
        }

        @Override
        public int getGeneratedColumn() {
            return this.column;
        }

        @Override
        public int getSourceFileId() {
            return -1;
        }

        @Override
        public int getSourceLine() {
            return -1;
        }

        @Override
        public int getSourceColumn() {
            return -1;
        }

        @Override
        public int getNameId() {
            return -1;
        }
    }

    private static interface Entry {
        public int getGeneratedColumn();

        public int getSourceFileId();

        public int getSourceLine();

        public int getSourceColumn();

        public int getNameId();
    }

    private static class StringCharIterator
    implements Base64VLQ.CharIterator {
        final String content;
        final int length;
        int current = 0;

        StringCharIterator(String string) {
            this.content = string;
            this.length = string.length();
        }

        @Override
        public char next() {
            return this.content.charAt(this.current++);
        }

        char peek() {
            return this.content.charAt(this.current);
        }

        @Override
        public boolean hasNext() {
            return this.current < this.length;
        }
    }

    private class MappingBuilder {
        private static final int MAX_ENTRY_VALUES = 5;
        private final StringCharIterator content;
        private int line = 0;
        private int previousCol = 0;
        private int previousSrcId = 0;
        private int previousSrcLine = 0;
        private int previousSrcColumn = 0;
        private int previousNameId = 0;

        MappingBuilder(String string) {
            this.content = new StringCharIterator(string);
        }

        void build() {
            int[] nArray = new int[5];
            ArrayList<Entry> arrayList = new ArrayList<Entry>();
            while (this.content.hasNext()) {
                if (this.tryConsumeToken(';')) {
                    ArrayList<Entry> arrayList2;
                    if (arrayList.size() > 0) {
                        arrayList2 = arrayList;
                        arrayList = new ArrayList();
                    } else {
                        arrayList2 = null;
                    }
                    SourceMapConsumerV3.this.lines.add(arrayList2);
                    arrayList.clear();
                    ++this.line;
                    this.previousCol = 0;
                    continue;
                }
                int n = 0;
                while (!this.entryComplete()) {
                    nArray[n] = this.nextValue();
                    ++n;
                }
                Entry entry = this.decodeEntry(nArray, n);
                this.validateEntry(entry);
                arrayList.add(entry);
                this.tryConsumeToken(',');
            }
        }

        private void validateEntry(Entry entry) {
            Preconditions.checkState((this.line < SourceMapConsumerV3.this.lineCount ? 1 : 0) != 0);
            Preconditions.checkState((entry.getSourceFileId() == -1 || entry.getSourceFileId() < SourceMapConsumerV3.this.sources.length ? 1 : 0) != 0);
            Preconditions.checkState((entry.getNameId() == -1 || entry.getNameId() < SourceMapConsumerV3.this.names.length ? 1 : 0) != 0);
        }

        private Entry decodeEntry(int[] nArray, int n) {
            switch (n) {
                case 1: {
                    UnmappedEntry unmappedEntry = new UnmappedEntry(nArray[0] + this.previousCol);
                    this.previousCol = unmappedEntry.getGeneratedColumn();
                    return unmappedEntry;
                }
                case 4: {
                    UnnamedEntry unnamedEntry = new UnnamedEntry(nArray[0] + this.previousCol, nArray[1] + this.previousSrcId, nArray[2] + this.previousSrcLine, nArray[3] + this.previousSrcColumn);
                    this.previousCol = unnamedEntry.getGeneratedColumn();
                    this.previousSrcId = unnamedEntry.getSourceFileId();
                    this.previousSrcLine = unnamedEntry.getSourceLine();
                    this.previousSrcColumn = unnamedEntry.getSourceColumn();
                    return unnamedEntry;
                }
                case 5: {
                    NamedEntry namedEntry = new NamedEntry(nArray[0] + this.previousCol, nArray[1] + this.previousSrcId, nArray[2] + this.previousSrcLine, nArray[3] + this.previousSrcColumn, nArray[4] + this.previousNameId);
                    this.previousCol = namedEntry.getGeneratedColumn();
                    this.previousSrcId = namedEntry.getSourceFileId();
                    this.previousSrcLine = namedEntry.getSourceLine();
                    this.previousSrcColumn = namedEntry.getSourceColumn();
                    this.previousNameId = namedEntry.getNameId();
                    return namedEntry;
                }
            }
            throw new IllegalStateException("Unexpected number of values for entry:" + n);
        }

        private boolean tryConsumeToken(char c) {
            if (this.content.hasNext() && this.content.peek() == c) {
                this.content.next();
                return true;
            }
            return false;
        }

        private boolean entryComplete() {
            if (!this.content.hasNext()) {
                return true;
            }
            char c = this.content.peek();
            return c == ';' || c == ',';
        }

        private int nextValue() {
            return Base64VLQ.decode(this.content);
        }
    }
}

