/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.GlobalNamespace;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JSModuleGraph;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;

class CheckGlobalNames
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final CheckLevel level;
    private GlobalNamespace namespace = null;
    static final DiagnosticType UNDEFINED_NAME_WARNING = DiagnosticType.warning("JSC_UNDEFINED_NAME", "{0} is never defined");
    static final DiagnosticType STRICT_MODULE_DEP_QNAME = DiagnosticType.disabled("JSC_STRICT_MODULE_DEP_QNAME", "module {0} cannot reference {2}, defined in module {1}");

    CheckGlobalNames(AbstractCompiler abstractCompiler, CheckLevel checkLevel) {
        this.compiler = abstractCompiler;
        this.level = checkLevel;
    }

    CheckGlobalNames injectNamespace(GlobalNamespace globalNamespace) {
        this.namespace = globalNamespace;
        return this;
    }

    @Override
    public void process(Node node, Node node2) {
        if (this.namespace == null) {
            this.namespace = new GlobalNamespace(this.compiler, node2);
        }
        for (GlobalNamespace.Name name : this.namespace.getNameForest()) {
            this.checkDescendantNames(name, name.globalSets + name.localSets > 0);
        }
    }

    private void checkDescendantNames(GlobalNamespace.Name name, boolean bl) {
        if (name.props != null) {
            for (GlobalNamespace.Name name2 : name.props) {
                boolean bl2 = false;
                if (bl) {
                    bl2 = !CheckGlobalNames.propertyMustBeInitializedByFullName(name2) || name2.globalSets + name2.localSets > 0;
                }
                this.validateName(name2, bl2);
                this.checkDescendantNames(name2, bl2);
            }
        }
    }

    private void validateName(GlobalNamespace.Name name, boolean bl) {
        GlobalNamespace.Ref ref = name.declaration;
        if (!bl && ref != null) {
            this.reportRefToUndefinedName(name, ref);
        }
        JSModuleGraph jSModuleGraph = this.compiler.getModuleGraph();
        for (GlobalNamespace.Ref ref2 : name.getRefs()) {
            if (ref2 == name.declaration) continue;
            if (!bl) {
                this.reportRefToUndefinedName(name, ref2);
                continue;
            }
            if (ref == null || ref2.getModule() == ref.getModule() || jSModuleGraph.dependsOn(ref2.getModule(), ref.getModule())) continue;
            this.reportBadModuleReference(name, ref2);
        }
    }

    private void reportBadModuleReference(GlobalNamespace.Name name, GlobalNamespace.Ref ref) {
        this.compiler.report(JSError.make(ref.source.getName(), ref.node, STRICT_MODULE_DEP_QNAME, ref.getModule().getName(), name.declaration.getModule().getName(), name.fullName()));
    }

    private void reportRefToUndefinedName(GlobalNamespace.Name name, GlobalNamespace.Ref ref) {
        JSDocInfo jSDocInfo;
        while (name.parent != null && name.parent.globalSets + name.parent.localSets == 0) {
            name = name.parent;
        }
        Node node = ref.node.getParent();
        if (node.getType() == 130 && (jSDocInfo = ref.node.getJSDocInfo()) != null && jSDocInfo.hasTypedefType()) {
            return;
        }
        this.compiler.report(JSError.make(ref.getSourceName(), ref.node, this.level, UNDEFINED_NAME_WARNING, name.fullName()));
    }

    private static boolean propertyMustBeInitializedByFullName(GlobalNamespace.Name name) {
        return name.parent != null && name.parent.aliasingGets == 0 && name.parent.type == GlobalNamespace.Name.Type.OBJECTLIT;
    }
}

