/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Predicate;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CheckPathsBetweenNodes;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.TernaryValue;

class CheckMissingReturn
implements NodeTraversal.ScopedCallback {
    static final DiagnosticType MISSING_RETURN_STATEMENT = DiagnosticType.warning("JSC_MISSING_RETURN_STATEMENT", "Missing return statement. Function expected to return {0}.");
    private final AbstractCompiler compiler;
    private final CheckLevel level;
    private static final Predicate<Node> IS_RETURN = new Predicate<Node>(){

        public boolean apply(Node node) {
            return node != null && node.getType() == 4;
        }
    };
    private static final Predicate<DiGraph.DiGraphEdge<Node, ControlFlowGraph.Branch>> GOES_THROUGH_TRUE_CONDITION_PREDICATE = new Predicate<DiGraph.DiGraphEdge<Node, ControlFlowGraph.Branch>>(){

        public boolean apply(DiGraph.DiGraphEdge<Node, ControlFlowGraph.Branch> diGraphEdge) {
            TernaryValue ternaryValue;
            Node node;
            ControlFlowGraph.Branch branch = (ControlFlowGraph.Branch)((Object)diGraphEdge.getValue());
            if (branch == ControlFlowGraph.Branch.ON_EX) {
                return false;
            }
            if (branch.isConditional() && (node = NodeUtil.getConditionExpression((Node)diGraphEdge.getSource().getValue())) != null && (ternaryValue = NodeUtil.getImpureBooleanValue(node)) != TernaryValue.UNKNOWN) {
                return ternaryValue.toBoolean(true) == (ControlFlowGraph.Branch.ON_TRUE == branch);
            }
            return true;
        }
    };

    CheckMissingReturn(AbstractCompiler abstractCompiler, CheckLevel checkLevel) {
        this.compiler = abstractCompiler;
        this.level = checkLevel;
    }

    @Override
    public void enterScope(NodeTraversal nodeTraversal) {
        JSType jSType = this.explicitReturnExpected(nodeTraversal.getScopeRoot());
        if (jSType == null) {
            return;
        }
        if (CheckMissingReturn.fastAllPathsReturnCheck(nodeTraversal.getControlFlowGraph())) {
            return;
        }
        CheckPathsBetweenNodes<Node, ControlFlowGraph.Branch> checkPathsBetweenNodes = new CheckPathsBetweenNodes<Node, ControlFlowGraph.Branch>(nodeTraversal.getControlFlowGraph(), nodeTraversal.getControlFlowGraph().getEntry(), nodeTraversal.getControlFlowGraph().getImplicitReturn(), IS_RETURN, GOES_THROUGH_TRUE_CONDITION_PREDICATE);
        if (!checkPathsBetweenNodes.allPathsSatisfyPredicate()) {
            this.compiler.report(nodeTraversal.makeError(nodeTraversal.getScopeRoot(), this.level, MISSING_RETURN_STATEMENT, jSType.toString()));
        }
    }

    private static boolean fastAllPathsReturnCheck(ControlFlowGraph<Node> controlFlowGraph) {
        for (DiGraph.DiGraphEdge<Node, ControlFlowGraph.Branch> diGraphEdge : controlFlowGraph.getImplicitReturn().getInEdges()) {
            if (((Node)diGraphEdge.getSource().getValue()).getType() == 4) continue;
            return false;
        }
        return true;
    }

    @Override
    public void exitScope(NodeTraversal nodeTraversal) {
    }

    @Override
    public boolean shouldTraverse(NodeTraversal nodeTraversal, Node node, Node node2) {
        return true;
    }

    @Override
    public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
    }

    private JSType explicitReturnExpected(Node node) {
        JSType jSType = node.getJSType();
        if (!(jSType instanceof FunctionType)) {
            return null;
        }
        if (CheckMissingReturn.isEmptyFunction(node)) {
            return null;
        }
        JSType jSType2 = ((FunctionType)jSType).getReturnType();
        if (jSType2 == null) {
            return null;
        }
        if (!this.isVoidOrUnknown(jSType2)) {
            return jSType2;
        }
        return null;
    }

    private static boolean isEmptyFunction(Node node) {
        return node.getChildCount() == 3 && !node.getFirstChild().getNext().getNext().hasChildren();
    }

    private boolean isVoidOrUnknown(JSType jSType) {
        JSType jSType2 = this.compiler.getTypeRegistry().getNativeType(JSTypeNative.VOID_TYPE);
        return jSType2.isSubtype(jSType);
    }
}

