/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.Lists;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import java.util.List;

final class ClosureOptimizePrimitives
implements CompilerPass {
    private final AbstractCompiler compiler;

    ClosureOptimizePrimitives(AbstractCompiler abstractCompiler) {
        this.compiler = abstractCompiler;
    }

    @Override
    public void process(Node node, Node node2) {
        FindObjectCreateCalls findObjectCreateCalls = new FindObjectCreateCalls();
        NodeTraversal.traverse(this.compiler, node2, findObjectCreateCalls);
        this.processObjectCreateCalls(findObjectCreateCalls.callNodes);
    }

    private void processObjectCreateCalls(List<Node> list) {
        for (Node node : list) {
            Node node2 = node.getFirstChild().getNext();
            if (!this.canOptimizeObjectCreate(node2)) continue;
            Node node3 = new Node(64).copyInformationFrom(node);
            while (node2 != null) {
                Node node4 = node2;
                Node node5 = node2.getNext();
                node2 = node5.getNext();
                node.removeChild(node4);
                node.removeChild(node5);
                if (node4.getType() != 40) {
                    node4 = Node.newString(NodeUtil.getStringValue(node4)).copyInformationFrom(node4);
                }
                node4.setQuotedString();
                node4.addChildToBack(node5);
                node3.addChildToBack(node4);
            }
            node.getParent().replaceChild(node, node3);
            this.compiler.reportCodeChange();
        }
    }

    private boolean canOptimizeObjectCreate(Node node) {
        for (Node node2 = node; node2 != null; node2 = node2.getNext()) {
            if (node2.getType() != 40 && node2.getType() != 39) {
                return false;
            }
            if ((node2 = node2.getNext()) != null) continue;
            return false;
        }
        return true;
    }

    private class FindObjectCreateCalls
    extends NodeTraversal.AbstractPostOrderCallback {
        List<Node> callNodes = Lists.newArrayList();

        private FindObjectCreateCalls() {
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            String string;
            if (node.getType() == 37 && ("goog$object$create".equals(string = node.getFirstChild().getQualifiedName()) || "goog.object.create".equals(string))) {
                this.callNodes.add(node);
            }
        }
    }
}

