/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.io.Serializable;
import java.util.List;
import java.util.Set;

class CollapseVariableDeclarations
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final List<Collapse> collapses = Lists.newArrayList();
    private final Set<Node> nodesToCollapse = Sets.newHashSet();

    CollapseVariableDeclarations(AbstractCompiler abstractCompiler) {
        Preconditions.checkState((!abstractCompiler.getLifeCycleStage().isNormalized() ? 1 : 0) != 0);
        this.compiler = abstractCompiler;
    }

    @Override
    public void process(Node node, Node node2) {
        this.collapses.clear();
        this.nodesToCollapse.clear();
        NodeTraversal.traverse(this.compiler, node2, new GatherCollapses());
        if (!this.collapses.isEmpty()) {
            this.applyCollapses();
            this.compiler.reportCodeChange();
        }
    }

    private void applyCollapses() {
        for (Collapse collapse : this.collapses) {
            Node node = new Node(118);
            node.copyInformationFrom(collapse.startNode);
            collapse.parent.addChildBefore(node, collapse.startNode);
            boolean bl = false;
            Serializable serializable = collapse.startNode;
            while (serializable != collapse.endNode) {
                Node node2 = ((Node)serializable).getNext();
                Preconditions.checkState((node.getNext() == serializable ? 1 : 0) != 0);
                collapse.parent.removeChildAfter(node);
                if (NodeUtil.isVar((Node)serializable)) {
                    while (((Node)serializable).hasChildren()) {
                        node.addChildToBack(((Node)serializable).removeFirstChild());
                    }
                } else {
                    Node node3 = ((Node)serializable).getFirstChild();
                    Node node4 = node3.getFirstChild();
                    Preconditions.checkState((boolean)NodeUtil.isName(node4));
                    Node node5 = node3.getLastChild();
                    node4.addChildToBack(node5.detachFromParent());
                    node.addChildToBack(node4.detachFromParent());
                    bl = true;
                }
                serializable = node2;
            }
            if (!bl) continue;
            serializable = new JSDocInfo();
            ((JSDocInfo)serializable).addSuppression("duplicate");
            node.setJSDocInfo((JSDocInfo)serializable);
        }
    }

    private class GatherCollapses
    extends NodeTraversal.AbstractPostOrderCallback {
        private final Set<Scope.Var> blacklistedVars = Sets.newHashSet();

        private GatherCollapses() {
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            if (node.getType() == 118) {
                this.blacklistStubVars(nodeTraversal, node);
            }
            if (node.getType() != 118 && !this.canBeRedeclared(node, nodeTraversal.getScope())) {
                return;
            }
            if (CollapseVariableDeclarations.this.nodesToCollapse.contains(node)) {
                return;
            }
            if (node2.getType() == 108) {
                return;
            }
            Node node3 = node;
            boolean bl = node.getType() == 118;
            boolean bl2 = false;
            for (node = node.getNext(); node != null && (node.getType() == 118 || this.canBeRedeclared(node, nodeTraversal.getScope())); node = node.getNext()) {
                if (NodeUtil.isVar(node)) {
                    this.blacklistStubVars(nodeTraversal, node);
                    bl = true;
                }
                CollapseVariableDeclarations.this.nodesToCollapse.add(node);
                bl2 = true;
            }
            if (bl2 && bl) {
                CollapseVariableDeclarations.this.nodesToCollapse.add(node3);
                CollapseVariableDeclarations.this.collapses.add(new Collapse(node3, node, node2));
            }
        }

        private void blacklistStubVars(NodeTraversal nodeTraversal, Node node) {
            for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
                if (node2.getFirstChild() != null) continue;
                this.blacklistedVars.add(nodeTraversal.getScope().getVar(node2.getString()));
            }
        }

        private boolean canBeRedeclared(Node node, Scope scope) {
            if (!NodeUtil.isExprAssign(node)) {
                return false;
            }
            Node node2 = node.getFirstChild();
            Node node3 = node2.getFirstChild();
            if (!NodeUtil.isName(node3)) {
                return false;
            }
            Scope.Var var = scope.getVar(node3.getString());
            return var != null && var.getScope() == scope && !this.blacklistedVars.contains(var);
        }
    }

    private static class Collapse {
        final Node startNode;
        final Node endNode;
        final Node parent;

        Collapse(Node node, Node node2, Node node3) {
            this.startNode = node;
            this.endNode = node2;
            this.parent = node3;
        }
    }
}

