/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.ExpressionDecomposer;
import com.google.javascript.jscomp.FunctionArgumentInjector;
import com.google.javascript.jscomp.FunctionInjector;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.SpecializationAwareCompilerPass;
import com.google.javascript.jscomp.SpecializeModule;
import com.google.javascript.rhino.Node;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class InlineFunctions
implements SpecializationAwareCompilerPass {
    private final Map<String, FunctionState> fns = Maps.newHashMap();
    private final Map<Node, String> anonFns = Maps.newHashMap();
    private final AbstractCompiler compiler;
    private final FunctionInjector injector;
    private final boolean blockFunctionInliningEnabled;
    private final boolean inlineGlobalFunctions;
    private final boolean inlineLocalFunctions;
    private SpecializeModule.SpecializationState specializationState;

    InlineFunctions(AbstractCompiler abstractCompiler, Supplier<String> supplier, boolean bl, boolean bl2, boolean bl3) {
        Preconditions.checkArgument((abstractCompiler != null ? 1 : 0) != 0);
        Preconditions.checkArgument((supplier != null ? 1 : 0) != 0);
        this.compiler = abstractCompiler;
        this.inlineGlobalFunctions = bl;
        this.inlineLocalFunctions = bl2;
        this.blockFunctionInliningEnabled = bl3;
        this.injector = new FunctionInjector(abstractCompiler, supplier, true);
    }

    FunctionState getOrCreateFunctionState(String string) {
        FunctionState functionState = this.fns.get(string);
        if (functionState == null) {
            functionState = new FunctionState();
            this.fns.put(string, functionState);
        }
        return functionState;
    }

    @Override
    public void enableSpecialization(SpecializeModule.SpecializationState specializationState) {
        this.specializationState = specializationState;
    }

    @Override
    public void process(Node node, Node node2) {
        Preconditions.checkState((boolean)this.compiler.getLifeCycleStage().isNormalized());
        NodeTraversal.traverse(this.compiler, node2, new FindCandidateFunctions());
        if (this.fns.isEmpty()) {
            return;
        }
        NodeTraversal.traverse(this.compiler, node2, new FindCandidatesReferences(this.fns, this.anonFns));
        this.trimCanidatesNotMeetingMinimumRequirements();
        if (this.fns.isEmpty()) {
            return;
        }
        HashSet hashSet = Sets.newHashSet(this.fns.keySet());
        this.injector.setKnownConstants(hashSet);
        this.trimCanidatesUsingOnCost();
        if (this.fns.isEmpty()) {
            return;
        }
        this.resolveInlineConflicts();
        this.decomposeExpressions(hashSet);
        NodeTraversal.traverse(this.compiler, node2, new CallVisitor(this.fns, this.anonFns, new Inline(this.injector, this.specializationState)));
        this.removeInlinedFunctions();
    }

    private void maybeAddFunction(Function function, JSModule jSModule) {
        String string = function.getName();
        FunctionState functionState = this.getOrCreateFunctionState(string);
        if (functionState.hasExistingFunctionDefinition()) {
            functionState.setInline(false);
        } else if (functionState.canInline()) {
            functionState.setFn(function);
            if (this.injector.isDirectCallNodeReplacementPossible(function.getFunctionNode())) {
                functionState.inlineDirectly(true);
            }
            if (!this.isCandidateFunction(function)) {
                functionState.setInline(false);
            }
            if (functionState.canInline()) {
                Node node;
                functionState.setModule(jSModule);
                Node node2 = function.getFunctionNode();
                Set<String> set = FunctionArgumentInjector.findModifiedParameters(node2);
                if (!set.isEmpty()) {
                    functionState.inlineDirectly(false);
                    functionState.setNamesToAlias(set);
                }
                if (NodeUtil.referencesThis(node = NodeUtil.getFunctionBody(node2))) {
                    functionState.setReferencesThis(true);
                }
                if (NodeUtil.containsFunction(node)) {
                    functionState.setHasInnerFunctions(true);
                    if (this.hasLocalNames(node2)) {
                        functionState.setInline(false);
                    }
                }
            }
            if (functionState.canInline() && !functionState.canInlineDirectly() && !this.blockFunctionInliningEnabled) {
                functionState.setInline(false);
            }
        }
    }

    private boolean hasLocalNames(Node node) {
        Node node2 = NodeUtil.getFunctionBody(node);
        return NodeUtil.getFnParameters(node).hasChildren() || NodeUtil.has(node2, new NodeUtil.MatchDeclaration(), new NodeUtil.MatchShallowStatement());
    }

    private static Node getContainingFunction(NodeTraversal nodeTraversal) {
        return nodeTraversal.inGlobalScope() ? null : nodeTraversal.getScopeRoot();
    }

    private boolean isCandidateFunction(Function function) {
        String string = function.getName();
        if (this.compiler.getCodingConvention().isExported(string)) {
            return false;
        }
        if ("JSCompiler_renameProperty".equals(string)) {
            return false;
        }
        if (this.specializationState != null && !this.specializationState.canFixupFunction(function.getFunctionNode())) {
            return false;
        }
        Node node = function.getFunctionNode();
        return this.injector.doesFunctionMeetMinimumRequirements(string, node);
    }

    static boolean isCandidateUsage(Node node) {
        Node node2;
        Node node3 = node.getParent();
        Preconditions.checkState((node.getType() == 38 ? 1 : 0) != 0);
        if (node3.getType() == 118 || node3.getType() == 105) {
            return true;
        }
        if (node3.getType() == 37 && node3.getFirstChild() == node) {
            return true;
        }
        return NodeUtil.isGet(node3) && node == node3.getFirstChild() && node.getNext().getType() == 40 && node.getNext().getString().equals("call") && (node2 = node.getAncestor(2)).getType() == 37 && node2.getFirstChild() == node3;
    }

    private void trimCanidatesNotMeetingMinimumRequirements() {
        Iterator<Map.Entry<String, FunctionState>> iterator = this.fns.entrySet().iterator();
        while (iterator.hasNext()) {
            FunctionState functionState = iterator.next().getValue();
            if (functionState.hasExistingFunctionDefinition() && functionState.canInline()) continue;
            iterator.remove();
        }
    }

    void trimCanidatesUsingOnCost() {
        Iterator<Map.Entry<String, FunctionState>> iterator = this.fns.entrySet().iterator();
        while (iterator.hasNext()) {
            FunctionState functionState = iterator.next().getValue();
            if (functionState.hasReferences()) {
                boolean bl = this.mimimizeCost(functionState);
                if (bl) continue;
                iterator.remove();
                continue;
            }
            if (functionState.canRemove()) continue;
            iterator.remove();
        }
    }

    private boolean mimimizeCost(FunctionState functionState) {
        if (!this.inliningLowersCost(functionState)) {
            if (functionState.hasBlockInliningReferences()) {
                functionState.setRemove(false);
                functionState.removeBlockInliningReferences();
                if (!functionState.hasReferences() || !this.inliningLowersCost(functionState)) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private boolean inliningLowersCost(FunctionState functionState) {
        return this.injector.inliningLowersCost(functionState.getModule(), functionState.getFn().getFunctionNode(), functionState.getReferences(), functionState.getNamesToAlias(), functionState.canRemove(), functionState.getReferencesThis());
    }

    private void resolveInlineConflicts() {
        for (FunctionState functionState : this.fns.values()) {
            this.resolveInlineConflictsForFunction(functionState);
        }
    }

    private void resolveInlineConflictsForFunction(FunctionState functionState) {
        if (!functionState.hasReferences()) {
            return;
        }
        Node node = functionState.getFn().getFunctionNode();
        Set<String> set = this.findCalledFunctions(node);
        if (!set.isEmpty()) {
            for (String string : set) {
                FunctionState functionState2 = this.fns.get(string);
                if (functionState2 == null || !functionState2.canRemove()) continue;
                functionState2.setRemove(false);
                if (this.mimimizeCost(functionState2)) continue;
                functionState2.setInline(false);
            }
            functionState.setSafeFnNode(functionState.getFn().getFunctionNode().cloneTree());
        }
    }

    private Set<String> findCalledFunctions(Node node) {
        HashSet hashSet = Sets.newHashSet();
        this.findCalledFunctions(NodeUtil.getFunctionBody(node), hashSet);
        return hashSet;
    }

    private void findCalledFunctions(Node node, Set<String> set) {
        Preconditions.checkArgument((set != null ? 1 : 0) != 0);
        if (node.getType() == 38 && InlineFunctions.isCandidateUsage(node)) {
            set.add(node.getString());
        }
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
            this.findCalledFunctions(node2, set);
        }
    }

    private void decomposeExpressions(Set<String> set) {
        ExpressionDecomposer expressionDecomposer = new ExpressionDecomposer(this.compiler, this.compiler.getUniqueNameIdSupplier(), set);
        for (FunctionState functionState : this.fns.values()) {
            if (!functionState.canInline()) continue;
            for (Reference reference : functionState.getReferences()) {
                if (!reference.requiresDecomposition) continue;
                expressionDecomposer.maybeDecomposeExpression(reference.callNode);
            }
        }
    }

    void removeInlinedFunctions() {
        for (FunctionState functionState : this.fns.values()) {
            if (!functionState.canRemove()) continue;
            Function function = functionState.getFn();
            Preconditions.checkState((boolean)functionState.canInline());
            Preconditions.checkState((function != null ? 1 : 0) != 0);
            this.verifyAllReferencesInlined(functionState);
            if (this.specializationState != null) {
                this.specializationState.reportRemovedFunction(function.getFunctionNode(), function.getDeclaringBlock());
            }
            function.remove();
            this.compiler.reportCodeChange();
        }
    }

    void verifyAllReferencesInlined(FunctionState functionState) {
        for (Reference reference : functionState.getReferences()) {
            if (reference.inlined) continue;
            throw new IllegalStateException("Call site missed.\n call: " + reference.callNode.toStringTree() + "\n parent:  " + reference.callNode.getParent().toStringTree());
        }
    }

    class Reference
    extends FunctionInjector.Reference {
        final boolean requiresDecomposition;
        boolean inlined;

        Reference(Node node, JSModule jSModule, FunctionInjector.InliningMode inliningMode, boolean bl) {
            super(node, jSModule, inliningMode);
            this.inlined = false;
            this.requiresDecomposition = bl;
        }
    }

    private static class FunctionExpression
    implements Function {
        private final Node fn;
        private final String fakeName;

        public FunctionExpression(Node node, int n) {
            this.fn = node;
            this.fakeName = String.valueOf(n);
        }

        @Override
        public String getName() {
            return this.fakeName;
        }

        @Override
        public Node getFunctionNode() {
            return this.fn;
        }

        @Override
        public void remove() {
        }

        @Override
        public Node getDeclaringBlock() {
            return null;
        }
    }

    private static class FunctionVar
    implements Function {
        private final Node var;

        public FunctionVar(Node node) {
            this.var = node;
        }

        @Override
        public String getName() {
            return this.var.getFirstChild().getString();
        }

        @Override
        public Node getFunctionNode() {
            return this.var.getFirstChild().getFirstChild();
        }

        @Override
        public void remove() {
            NodeUtil.removeChild(this.var.getParent(), this.var);
        }

        @Override
        public Node getDeclaringBlock() {
            return this.var.getParent();
        }
    }

    private static class NamedFunction
    implements Function {
        private final Node fn;

        public NamedFunction(Node node) {
            this.fn = node;
        }

        @Override
        public String getName() {
            return this.fn.getFirstChild().getString();
        }

        @Override
        public Node getFunctionNode() {
            return this.fn;
        }

        @Override
        public void remove() {
            NodeUtil.removeChild(this.fn.getParent(), this.fn);
        }

        @Override
        public Node getDeclaringBlock() {
            return this.fn.getParent();
        }
    }

    private static interface Function {
        public String getName();

        public Node getFunctionNode();

        public void remove();

        public Node getDeclaringBlock();
    }

    private static class FunctionState {
        private Function fn = null;
        private Node safeFnNode = null;
        private boolean inline = true;
        private boolean remove = true;
        private boolean inlineDirectly = false;
        private boolean referencesThis = false;
        private boolean hasInnerFunctions = false;
        private Map<Node, Reference> references = null;
        private JSModule module = null;
        private Set<String> namesToAlias = null;

        private FunctionState() {
        }

        boolean hasExistingFunctionDefinition() {
            return this.fn != null;
        }

        public void setReferencesThis(boolean bl) {
            this.referencesThis = bl;
        }

        public boolean getReferencesThis() {
            return this.referencesThis;
        }

        public void setHasInnerFunctions(boolean bl) {
            this.hasInnerFunctions = bl;
        }

        public boolean hasInnerFunctions() {
            return this.hasInnerFunctions;
        }

        void removeBlockInliningReferences() {
            Iterator<Map.Entry<Node, Reference>> iterator = this.getReferencesInternal().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Node, Reference> entry = iterator.next();
                if (entry.getValue().mode != FunctionInjector.InliningMode.BLOCK) continue;
                iterator.remove();
            }
        }

        public boolean hasBlockInliningReferences() {
            for (Reference reference : this.getReferencesInternal().values()) {
                if (reference.mode != FunctionInjector.InliningMode.BLOCK) continue;
                return true;
            }
            return false;
        }

        public Function getFn() {
            return this.fn;
        }

        public void setFn(Function function) {
            Preconditions.checkState((this.fn == null ? 1 : 0) != 0);
            this.fn = function;
        }

        public Node getSafeFnNode() {
            return this.safeFnNode != null ? this.safeFnNode : this.fn.getFunctionNode();
        }

        public void setSafeFnNode(Node node) {
            this.safeFnNode = node;
        }

        public boolean canInline() {
            return this.inline;
        }

        public void setInline(boolean bl) {
            this.inline = bl;
            if (!bl) {
                this.references = null;
                this.remove = false;
            }
        }

        public boolean canRemove() {
            return this.remove;
        }

        public void setRemove(boolean bl) {
            this.remove = bl;
        }

        public boolean canInlineDirectly() {
            return this.inlineDirectly;
        }

        public void inlineDirectly(boolean bl) {
            this.inlineDirectly = bl;
        }

        public boolean hasReferences() {
            return this.references != null && !this.references.isEmpty();
        }

        private Map<Node, Reference> getReferencesInternal() {
            if (this.references == null) {
                return Collections.emptyMap();
            }
            return this.references;
        }

        public void addReference(Reference reference) {
            if (this.references == null) {
                this.references = Maps.newHashMap();
            }
            this.references.put(reference.callNode, reference);
        }

        public Collection<Reference> getReferences() {
            return this.getReferencesInternal().values();
        }

        public Reference getReference(Node node) {
            return this.getReferencesInternal().get(node);
        }

        public Set<String> getNamesToAlias() {
            if (this.namesToAlias == null) {
                return Collections.emptySet();
            }
            return Collections.unmodifiableSet(this.namesToAlias);
        }

        public void setNamesToAlias(Set<String> set) {
            this.namesToAlias = set;
        }

        public void setModule(JSModule jSModule) {
            this.module = jSModule;
        }

        public JSModule getModule() {
            return this.module;
        }
    }

    private static class Inline
    implements CallVisitorCallback {
        private final FunctionInjector injector;
        private final SpecializeModule.SpecializationState specializationState;

        Inline(FunctionInjector functionInjector, SpecializeModule.SpecializationState specializationState) {
            this.injector = functionInjector;
            this.specializationState = specializationState;
        }

        @Override
        public void visitCallSite(NodeTraversal nodeTraversal, Node node, Node node2, FunctionState functionState) {
            Reference reference;
            Preconditions.checkState((boolean)functionState.hasExistingFunctionDefinition());
            if (functionState.canInline() && (reference = functionState.getReference(node)) != null) {
                Node node3;
                if (this.specializationState != null && (node3 = InlineFunctions.getContainingFunction(nodeTraversal)) != null) {
                    this.specializationState.reportSpecializedFunction(node3);
                }
                this.inlineFunction(nodeTraversal, node, functionState, reference.mode);
                reference.inlined = true;
            }
        }

        private void inlineFunction(NodeTraversal nodeTraversal, Node node, FunctionState functionState, FunctionInjector.InliningMode inliningMode) {
            Function function = functionState.getFn();
            String string = function.getName();
            Node node2 = functionState.getSafeFnNode();
            Node node3 = this.injector.inline(nodeTraversal, node, string, node2, inliningMode);
            nodeTraversal.getCompiler().reportCodeChange();
            nodeTraversal.getCompiler().addToDebugLog("Inlined function: " + function.getName());
        }
    }

    private class FindCandidatesReferences
    extends CallVisitor
    implements CallVisitorCallback {
        FindCandidatesReferences(Map<String, FunctionState> map, Map<Node, String> map2) {
            super(map, map2, null);
            this.callback = this;
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            super.visit(nodeTraversal, node, node2);
            if (node.getType() == 38) {
                this.checkNameUsage(nodeTraversal, node, node2);
            }
        }

        @Override
        public void visitCallSite(NodeTraversal nodeTraversal, Node node, Node node2, FunctionState functionState) {
            this.maybeAddReference(nodeTraversal, functionState, node, nodeTraversal.getModule());
        }

        void maybeAddReference(NodeTraversal nodeTraversal, FunctionState functionState, Node node, JSModule jSModule) {
            if (!functionState.canInline()) {
                return;
            }
            boolean bl = false;
            FunctionInjector.InliningMode inliningMode = functionState.canInlineDirectly() ? FunctionInjector.InliningMode.DIRECT : FunctionInjector.InliningMode.BLOCK;
            bl = this.maybeAddReferenceUsingMode(nodeTraversal, functionState, node, jSModule, inliningMode);
            if (!bl && inliningMode == FunctionInjector.InliningMode.DIRECT && InlineFunctions.this.blockFunctionInliningEnabled) {
                inliningMode = FunctionInjector.InliningMode.BLOCK;
                bl = this.maybeAddReferenceUsingMode(nodeTraversal, functionState, node, jSModule, inliningMode);
            }
            if (!bl) {
                functionState.setRemove(false);
            }
        }

        private boolean maybeAddReferenceUsingMode(NodeTraversal nodeTraversal, FunctionState functionState, Node node, JSModule jSModule, FunctionInjector.InliningMode inliningMode) {
            Object object;
            if (InlineFunctions.this.specializationState != null && (object = InlineFunctions.getContainingFunction(nodeTraversal)) != null && !InlineFunctions.this.specializationState.canFixupFunction((Node)object)) {
                return false;
            }
            object = InlineFunctions.this.injector.canInlineReferenceToFunction(nodeTraversal, node, functionState.getFn().getFunctionNode(), functionState.getNamesToAlias(), inliningMode, functionState.getReferencesThis(), functionState.hasInnerFunctions());
            if (object != FunctionInjector.CanInlineResult.NO) {
                boolean bl = object == FunctionInjector.CanInlineResult.AFTER_DECOMPOSITION;
                functionState.addReference(new Reference(node, jSModule, inliningMode, bl));
                return true;
            }
            return false;
        }

        private void checkNameUsage(NodeTraversal nodeTraversal, Node node, Node node2) {
            Node node3;
            Preconditions.checkState((node.getType() == 38 ? 1 : 0) != 0);
            if (InlineFunctions.isCandidateUsage(node)) {
                return;
            }
            String string = node.getString();
            FunctionState functionState = (FunctionState)InlineFunctions.this.fns.get(string);
            if (functionState == null) {
                return;
            }
            if (node2.getType() == 30 && (node3 = node2.getFirstChild()).getType() == 38 && node3.getString().equals("JSCompiler_ObjectPropertyString")) {
                functionState.setInline(false);
            }
            if (node2.getType() == 86 && node2.getFirstChild() == node) {
                functionState.setInline(false);
            } else {
                functionState.setRemove(false);
            }
        }
    }

    private static class CallVisitor
    extends NodeTraversal.AbstractPostOrderCallback {
        protected CallVisitorCallback callback;
        private Map<String, FunctionState> functionMap;
        private Map<Node, String> anonFunctionMap;

        CallVisitor(Map<String, FunctionState> map, Map<Node, String> map2, CallVisitorCallback callVisitorCallback) {
            this.functionMap = map;
            this.anonFunctionMap = map2;
            this.callback = callVisitorCallback;
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            switch (node.getType()) {
                case 37: {
                    Object object;
                    Node node3 = node.getFirstChild();
                    String string = null;
                    if (node3.getType() == 38) {
                        string = node3.getString();
                    } else if (node3.getType() == 105) {
                        string = this.anonFunctionMap.get(node3);
                    } else if (NodeUtil.isFunctionObjectCall(node)) {
                        Preconditions.checkState((boolean)NodeUtil.isGet(node3));
                        object = node3.getFirstChild();
                        if (((Node)object).getType() == 38) {
                            string = ((Node)object).getString();
                        } else if (((Node)object).getType() == 105) {
                            string = this.anonFunctionMap.get(object);
                        }
                    }
                    if (string == null || (object = this.functionMap.get(string)) == null) break;
                    this.callback.visitCallSite(nodeTraversal, node, node2, (FunctionState)object);
                }
            }
        }
    }

    private static interface CallVisitorCallback {
        public void visitCallSite(NodeTraversal var1, Node var2, Node var3, FunctionState var4);
    }

    private class FindCandidateFunctions
    implements NodeTraversal.Callback {
        private int callsSeen = 0;

        private FindCandidateFunctions() {
        }

        @Override
        public boolean shouldTraverse(NodeTraversal nodeTraversal, Node node, Node node2) {
            return InlineFunctions.this.inlineLocalFunctions || nodeTraversal.inGlobalScope();
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            if (nodeTraversal.inGlobalScope() && InlineFunctions.this.inlineGlobalFunctions || !nodeTraversal.inGlobalScope() && InlineFunctions.this.inlineLocalFunctions) {
                this.findNamedFunctions(nodeTraversal, node, node2);
                this.findFunctionExpressions(nodeTraversal, node);
            }
        }

        public void findNamedFunctions(NodeTraversal nodeTraversal, Node node, Node node2) {
            if (!NodeUtil.isStatement(node)) {
                return;
            }
            switch (node.getType()) {
                case 118: {
                    Preconditions.checkState((boolean)node.hasOneChild());
                    Node node3 = node.getFirstChild();
                    if (node3.getType() != 38 || !node3.hasChildren() || node3.getFirstChild().getType() != 105) break;
                    InlineFunctions.this.maybeAddFunction(new FunctionVar(node), nodeTraversal.getModule());
                    break;
                }
                case 105: {
                    Preconditions.checkState((NodeUtil.isStatementBlock(node2) || node2.getType() == 126 ? 1 : 0) != 0);
                    if (NodeUtil.isFunctionExpression(node)) break;
                    NamedFunction namedFunction = new NamedFunction(node);
                    InlineFunctions.this.maybeAddFunction(namedFunction, nodeTraversal.getModule());
                }
            }
        }

        public void findFunctionExpressions(NodeTraversal nodeTraversal, Node node) {
            switch (node.getType()) {
                case 37: {
                    Object object;
                    Node node2 = null;
                    if (node.getFirstChild().getType() == 105) {
                        node2 = node.getFirstChild();
                    } else if (NodeUtil.isFunctionObjectCall(node) && ((Node)(object = node.getFirstChild().getFirstChild())).getType() == 105) {
                        node2 = object;
                    }
                    if (node2 == null) break;
                    object = new FunctionExpression(node2, this.callsSeen++);
                    InlineFunctions.this.maybeAddFunction((Function)object, nodeTraversal.getModule());
                    InlineFunctions.this.anonFns.put(node2, object.getName());
                }
            }
        }
    }
}

