/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.LatticeElement;
import java.util.List;

interface JoinOp<L extends LatticeElement>
extends Function<List<L>, L> {

    public static abstract class BinaryJoinOp<L extends LatticeElement>
    implements JoinOp<L> {
        public final L apply(List<L> list) {
            Preconditions.checkArgument((!list.isEmpty() ? 1 : 0) != 0);
            int n = list.size();
            if (n == 1) {
                return (L)((LatticeElement)list.get(0));
            }
            if (n == 2) {
                return (L)this.apply((LatticeElement)list.get(0), (LatticeElement)list.get(1));
            }
            int n2 = BinaryJoinOp.computeMidPoint(n);
            return this.apply(this.apply(list.subList(0, n2)), this.apply(list.subList(n2, n)));
        }

        abstract L apply(L var1, L var2);

        static int computeMidPoint(int n) {
            int n2 = n >>> 1;
            if (n > 4) {
                n2 &= 0xFFFFFFFE;
            }
            return n2;
        }
    }
}

