/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class JsMessage {
    private static final String MESSAGE_REPRESENTATION_FORMAT = "{$%s}";
    private final String key;
    private final String id;
    private final List<CharSequence> parts;
    private final Set<String> placeholders;
    private final String desc;
    private final boolean hidden;
    private final String meaning;
    private final String sourceName;
    private final boolean isAnonymous;
    private final boolean isExternal;

    private JsMessage(String string, String string2, boolean bl, boolean bl2, String string3, List<CharSequence> list, Set<String> set, String string4, boolean bl3, String string5) {
        Preconditions.checkState((string2 != null ? 1 : 0) != 0);
        Preconditions.checkState((string3 != null ? 1 : 0) != 0);
        this.key = string2;
        this.id = string3;
        this.parts = Collections.unmodifiableList(list);
        this.placeholders = Collections.unmodifiableSet(set);
        this.desc = string4;
        this.hidden = bl3;
        this.meaning = string5;
        this.sourceName = string;
        this.isAnonymous = bl;
        this.isExternal = bl2;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public String getKey() {
        return this.key;
    }

    public boolean isAnonymous() {
        return this.isAnonymous;
    }

    public boolean isExternal() {
        return this.isExternal;
    }

    public String getId() {
        return this.id;
    }

    public String getDesc() {
        return this.desc;
    }

    String getMeaning() {
        return this.meaning;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public List<CharSequence> parts() {
        return this.parts;
    }

    public Set<String> placeholders() {
        return this.placeholders;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (CharSequence charSequence : this.parts) {
            stringBuilder.append(((Object)charSequence).toString());
        }
        return stringBuilder.toString();
    }

    public boolean isEmpty() {
        for (CharSequence charSequence : this.parts) {
            if (charSequence.length() <= 0) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof JsMessage)) {
            return false;
        }
        JsMessage jsMessage = (JsMessage)object;
        return this.id.equals(jsMessage.id) && this.key.equals(jsMessage.key) && this.isAnonymous == jsMessage.isAnonymous && ((Object)this.parts).equals(jsMessage.parts) && (this.meaning == null ? jsMessage.meaning == null : this.meaning.equals(jsMessage.meaning)) && ((Object)this.placeholders).equals(jsMessage.placeholders) && (this.desc == null ? jsMessage.desc == null : this.desc.equals(jsMessage.desc)) && (this.sourceName == null ? jsMessage.sourceName == null : this.sourceName.equals(jsMessage.sourceName)) && this.hidden == jsMessage.hidden;
    }

    public int hashCode() {
        int n = this.key.hashCode();
        n = 31 * n + (this.isAnonymous ? 1 : 0);
        n = 31 * n + this.id.hashCode();
        n = 31 * n + ((Object)this.parts).hashCode();
        n = 31 * n + (this.desc != null ? this.desc.hashCode() : 0);
        n = 31 * n + (this.hidden ? 1 : 0);
        n = 31 * n + (this.sourceName != null ? this.sourceName.hashCode() : 0);
        return n;
    }

    public static interface IdGenerator {
        public String generateId(String var1, List<CharSequence> var2);
    }

    static final class Hash {
        private static final long SEED64 = 3141592653589793238L;
        private static final long CONSTANT64 = -2266404186210603134L;

        private Hash() {
        }

        static long hash64(@Nullable String string) {
            return Hash.hash64(string, 3141592653589793238L);
        }

        private static long hash64(@Nullable String string, long l) {
            if (string == null) {
                return Hash.hash64(null, 0, 0, l);
            }
            return Hash.hash64(string.getBytes(), l);
        }

        private static long hash64(byte[] byArray, long l) {
            return Hash.hash64(byArray, 0, byArray == null ? 0 : byArray.length, l);
        }

        private static long hash64(byte[] byArray, int n, int n2, long l) {
            long l2;
            long l3 = l2 = -2266404186210603134L;
            long l4 = l;
            int n3 = n2;
            while (n3 >= 24) {
                l2 += Hash.word64At(byArray, n);
                l2 -= (l3 += Hash.word64At(byArray, n + 8));
                l2 -= (l4 += Hash.word64At(byArray, n + 16));
                l3 -= l4;
                l3 -= (l2 ^= l4 >>> 43);
                l4 -= l2;
                l4 -= (l3 ^= l2 << 9);
                l2 -= l3;
                l2 -= (l4 ^= l3 >>> 8);
                l3 -= l4;
                l3 -= (l2 ^= l4 >>> 38);
                l4 -= l2;
                l4 -= (l3 ^= l2 << 23);
                l2 -= l3;
                l2 -= (l4 ^= l3 >>> 5);
                l3 -= l4;
                l3 -= (l2 ^= l4 >>> 35);
                l4 -= l2;
                l4 -= (l3 ^= l2 << 49);
                l2 -= l3;
                l2 -= (l4 ^= l3 >>> 11);
                l3 -= l4;
                l3 -= (l2 ^= l4 >>> 12);
                l4 -= l2;
                l4 -= (l3 ^= l2 << 18);
                l4 ^= l3 >>> 22;
                n3 -= 24;
                n += 24;
            }
            l4 += (long)n2;
            switch (n3) {
                case 23: {
                    l4 += (long)byArray[n + 22] << 56;
                }
                case 22: {
                    l4 += ((long)byArray[n + 21] & 0xFFL) << 48;
                }
                case 21: {
                    l4 += ((long)byArray[n + 20] & 0xFFL) << 40;
                }
                case 20: {
                    l4 += ((long)byArray[n + 19] & 0xFFL) << 32;
                }
                case 19: {
                    l4 += ((long)byArray[n + 18] & 0xFFL) << 24;
                }
                case 18: {
                    l4 += ((long)byArray[n + 17] & 0xFFL) << 16;
                }
                case 17: {
                    l4 += ((long)byArray[n + 16] & 0xFFL) << 8;
                }
                case 16: {
                    l3 += Hash.word64At(byArray, n + 8);
                    l2 += Hash.word64At(byArray, n);
                    break;
                }
                case 15: {
                    l3 += ((long)byArray[n + 14] & 0xFFL) << 48;
                }
                case 14: {
                    l3 += ((long)byArray[n + 13] & 0xFFL) << 40;
                }
                case 13: {
                    l3 += ((long)byArray[n + 12] & 0xFFL) << 32;
                }
                case 12: {
                    l3 += ((long)byArray[n + 11] & 0xFFL) << 24;
                }
                case 11: {
                    l3 += ((long)byArray[n + 10] & 0xFFL) << 16;
                }
                case 10: {
                    l3 += ((long)byArray[n + 9] & 0xFFL) << 8;
                }
                case 9: {
                    l3 += (long)byArray[n + 8] & 0xFFL;
                }
                case 8: {
                    l2 += Hash.word64At(byArray, n);
                    break;
                }
                case 7: {
                    l2 += ((long)byArray[n + 6] & 0xFFL) << 48;
                }
                case 6: {
                    l2 += ((long)byArray[n + 5] & 0xFFL) << 40;
                }
                case 5: {
                    l2 += ((long)byArray[n + 4] & 0xFFL) << 32;
                }
                case 4: {
                    l2 += ((long)byArray[n + 3] & 0xFFL) << 24;
                }
                case 3: {
                    l2 += ((long)byArray[n + 2] & 0xFFL) << 16;
                }
                case 2: {
                    l2 += ((long)byArray[n + 1] & 0xFFL) << 8;
                }
                case 1: {
                    l2 += (long)byArray[n + 0] & 0xFFL;
                }
            }
            return Hash.mix64(l2, l3, l4);
        }

        private static long word64At(byte[] byArray, int n) {
            return ((long)byArray[n + 0] & 0xFFL) + (((long)byArray[n + 1] & 0xFFL) << 8) + (((long)byArray[n + 2] & 0xFFL) << 16) + (((long)byArray[n + 3] & 0xFFL) << 24) + (((long)byArray[n + 4] & 0xFFL) << 32) + (((long)byArray[n + 5] & 0xFFL) << 40) + (((long)byArray[n + 6] & 0xFFL) << 48) + (((long)byArray[n + 7] & 0xFFL) << 56);
        }

        private static long mix64(long l, long l2, long l3) {
            l -= l2;
            l -= l3;
            l2 -= l3;
            l2 -= (l ^= l3 >>> 43);
            l3 -= l;
            l3 -= (l2 ^= l << 9);
            l -= l2;
            l -= (l3 ^= l2 >>> 8);
            l2 -= l3;
            l2 -= (l ^= l3 >>> 38);
            l3 -= l;
            l3 -= (l2 ^= l << 23);
            l -= l2;
            l -= (l3 ^= l2 >>> 5);
            l2 -= l3;
            l2 -= (l ^= l3 >>> 35);
            l3 -= l;
            l3 -= (l2 ^= l << 49);
            l -= l2;
            l -= (l3 ^= l2 >>> 11);
            l2 -= l3;
            l2 -= (l ^= l3 >>> 12);
            l3 -= l;
            l3 -= (l2 ^= l << 18);
            return l3 ^= l2 >>> 22;
        }
    }

    public static class Builder {
        private static final Pattern MSG_EXTERNAL_PATTERN = Pattern.compile("MSG_EXTERNAL_(\\d+)");
        private String key;
        private String meaning;
        private String desc;
        private boolean hidden;
        private List<CharSequence> parts = Lists.newLinkedList();
        private Set<String> placeholders = Sets.newHashSet();
        private String sourceName;

        private static String getExternalMessageId(String string) {
            Matcher matcher = MSG_EXTERNAL_PATTERN.matcher(string);
            return matcher.matches() ? matcher.group(1) : null;
        }

        public Builder() {
            this(null);
        }

        public Builder(String string) {
            this.key = string;
        }

        public String getKey() {
            return this.key;
        }

        public Builder setKey(String string) {
            this.key = string;
            return this;
        }

        public Builder setSourceName(String string) {
            this.sourceName = string;
            return this;
        }

        public Builder appendPlaceholderReference(String string) {
            Preconditions.checkNotNull((Object)string, (Object)"Placeholder name could not be null");
            this.parts.add(new PlaceholderReference(string));
            this.placeholders.add(string);
            return this;
        }

        public Builder appendStringPart(String string) {
            Preconditions.checkNotNull((Object)string, (Object)"String part of the message could not be null");
            this.parts.add(string);
            return this;
        }

        public Set<String> getPlaceholders() {
            return this.placeholders;
        }

        public Builder setDesc(String string) {
            this.desc = string;
            return this;
        }

        public Builder setMeaning(String string) {
            this.meaning = string;
            return this;
        }

        public Builder setIsHidden(boolean bl) {
            this.hidden = bl;
            return this;
        }

        public boolean hasParts() {
            return !this.parts.isEmpty();
        }

        public List<CharSequence> getParts() {
            return this.parts;
        }

        public JsMessage build() {
            return this.build(null);
        }

        public JsMessage build(IdGenerator idGenerator) {
            String string;
            boolean bl = false;
            boolean bl2 = false;
            String string2 = null;
            if (this.getKey() == null) {
                this.key = "MSG_" + Builder.fingerprint(this.getParts());
                bl = true;
            }
            if (!bl && (string = Builder.getExternalMessageId(this.key)) != null) {
                bl2 = true;
                string2 = string;
            }
            if (!bl2) {
                string = this.meaning != null ? this.meaning : this.key;
                string2 = idGenerator == null ? string : idGenerator.generateId(string, this.parts);
            }
            return new JsMessage(this.sourceName, this.key, bl, bl2, string2, this.parts, this.placeholders, this.desc, this.hidden, this.meaning);
        }

        private static String fingerprint(List<CharSequence> list) {
            StringBuilder stringBuilder = new StringBuilder();
            for (CharSequence charSequence : list) {
                if (charSequence instanceof PlaceholderReference) {
                    stringBuilder.append(((Object)charSequence).toString());
                    continue;
                }
                stringBuilder.append(charSequence);
            }
            long l = Long.MAX_VALUE & Hash.hash64(stringBuilder.toString());
            return Long.toString(l, 36).toUpperCase();
        }
    }

    public static class PlaceholderReference
    implements CharSequence {
        private final String name;

        PlaceholderReference(String string) {
            this.name = string;
        }

        @Override
        public int length() {
            return this.name.length();
        }

        @Override
        public char charAt(int n) {
            return this.name.charAt(n);
        }

        @Override
        public CharSequence subSequence(int n, int n2) {
            return this.name.subSequence(n, n2);
        }

        public String getName() {
            return this.name;
        }

        @Override
        public String toString() {
            return String.format(JsMessage.MESSAGE_REPRESENTATION_FORMAT, this.name);
        }

        public boolean equals(Object object) {
            return object == this || object instanceof PlaceholderReference && this.name.equals(((PlaceholderReference)object).name);
        }

        public int hashCode() {
            return 31 * this.name.hashCode();
        }
    }

    public static enum Style {
        LEGACY,
        RELAX,
        CLOSURE;


        static Style getFromParams(boolean bl, boolean bl2) {
            if (bl) {
                return bl2 ? RELAX : CLOSURE;
            }
            return LEGACY;
        }
    }
}

