/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.ControlFlowAnalysis;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.ScopeCreator;
import com.google.javascript.jscomp.SyntacticScopeCreator;
import com.google.javascript.rhino.Node;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class NodeTraversal {
    private final AbstractCompiler compiler;
    private final Callback callback;
    private Node curNode;
    public static final DiagnosticType NODE_TRAVERSAL_ERROR = DiagnosticType.error("JSC_NODE_TRAVERSAL_ERROR", "{0}");
    private final Deque<Scope> scopes = new ArrayDeque<Scope>();
    private final Deque<Node> scopeRoots = new ArrayDeque<Node>();
    Deque<ControlFlowGraph<Node>> cfgs = new LinkedList<ControlFlowGraph<Node>>();
    private String sourceName;
    private ScopeCreator scopeCreator;
    private ScopedCallback scopeCallback;
    private static final String MISSING_SOURCE = "[source unknown]";

    public NodeTraversal(AbstractCompiler abstractCompiler, Callback callback) {
        this(abstractCompiler, callback, new SyntacticScopeCreator(abstractCompiler));
    }

    public NodeTraversal(AbstractCompiler abstractCompiler, Callback callback, ScopeCreator scopeCreator) {
        this.callback = callback;
        if (callback instanceof ScopedCallback) {
            this.scopeCallback = (ScopedCallback)callback;
        }
        this.compiler = abstractCompiler;
        this.sourceName = "";
        this.scopeCreator = scopeCreator;
    }

    private void throwUnexpectedException(Exception exception) {
        String string = exception.getMessage();
        if (!this.sourceName.isEmpty()) {
            string = exception.getMessage() + "\n" + this.formatNodeContext("Node", this.curNode) + (this.curNode == null ? "" : this.formatNodeContext("Parent", this.curNode.getParent()));
        }
        this.compiler.throwInternalError(string, exception);
    }

    private String formatNodeContext(String string, Node node) {
        if (node == null) {
            return "  " + string + ": NULL";
        }
        return "  " + string + "(" + node.toString(false, false, false) + "): " + this.formatNodePosition(node);
    }

    public void traverse(Node node) {
        try {
            this.sourceName = "";
            this.curNode = node;
            this.pushScope(node);
            this.traverseBranch(node, null);
            this.popScope();
        }
        catch (Exception exception) {
            this.throwUnexpectedException(exception);
        }
    }

    public void traverseRoots(Node ... nodeArray) {
        this.traverseRoots(Lists.newArrayList((Object[])nodeArray));
    }

    public void traverseRoots(List<Node> list) {
        if (list.isEmpty()) {
            return;
        }
        try {
            Node node = list.get(0).getParent();
            Preconditions.checkState((node != null ? 1 : 0) != 0);
            this.sourceName = "";
            this.curNode = node;
            this.pushScope(node);
            for (Node node2 : list) {
                Preconditions.checkState((node2.getParent() == node ? 1 : 0) != 0);
                this.traverseBranch(node2, node);
            }
            this.popScope();
        }
        catch (Exception exception) {
            this.throwUnexpectedException(exception);
        }
    }

    private String formatNodePosition(Node node) {
        if (node == null) {
            return "[source unknown]\n";
        }
        int n = node.getLineno();
        int n2 = node.getCharno();
        String string = this.compiler.getSourceLine(this.sourceName, n);
        if (string == null) {
            string = MISSING_SOURCE;
        }
        return this.sourceName + ":" + n + ":" + n2 + "\n" + string + "\n";
    }

    void traverseWithScope(Node node, Scope scope) {
        Preconditions.checkState((boolean)scope.isGlobal());
        this.sourceName = "";
        this.curNode = node;
        this.pushScope(scope);
        this.traverseBranch(node, null);
        this.popScope();
    }

    void traverseAtScope(Scope scope) {
        Node node = scope.getRootNode();
        if (node.getType() == 105) {
            this.sourceName = NodeTraversal.getSourceName(node);
            this.curNode = node;
            this.pushScope(scope);
            Node node2 = node.getFirstChild().getNext();
            Node node3 = node2.getNext();
            this.traverseBranch(node2, node);
            this.traverseBranch(node3, node);
            this.popScope();
        } else {
            this.traverseWithScope(node, scope);
        }
    }

    protected void traverseInnerNode(Node node, Node node2, Scope scope) {
        Preconditions.checkNotNull((Object)node2);
        if (scope != null && this.getScope() != scope) {
            this.curNode = node;
            this.pushScope(scope);
            this.traverseBranch(node, node2);
            this.popScope();
        } else {
            this.traverseBranch(node, node2);
        }
    }

    public Compiler getCompiler() {
        return (Compiler)this.compiler;
    }

    public int getLineNumber() {
        for (Node node = this.curNode; node != null; node = node.getParent()) {
            int n = node.getLineno();
            if (n < 0) continue;
            return n;
        }
        return 0;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public CompilerInput getInput() {
        return this.compiler.getInput(this.sourceName);
    }

    public JSModule getModule() {
        CompilerInput compilerInput = this.getInput();
        return compilerInput == null ? null : compilerInput.getModule();
    }

    public Node getCurrentNode() {
        return this.curNode;
    }

    public static void traverse(AbstractCompiler abstractCompiler, Node node, Callback callback) {
        NodeTraversal nodeTraversal = new NodeTraversal(abstractCompiler, callback);
        nodeTraversal.traverse(node);
    }

    public static void traverseRoots(AbstractCompiler abstractCompiler, List<Node> list, Callback callback) {
        NodeTraversal nodeTraversal = new NodeTraversal(abstractCompiler, callback);
        nodeTraversal.traverseRoots(list);
    }

    private void traverseBranch(Node node, Node node2) {
        int n = node.getType();
        if (n == 132) {
            this.sourceName = NodeTraversal.getSourceName(node);
        }
        this.curNode = node;
        if (!this.callback.shouldTraverse(this, node, node2)) {
            return;
        }
        switch (n) {
            case 105: {
                this.traverseFunction(node, node2);
                break;
            }
            default: {
                Node node3 = node.getFirstChild();
                while (node3 != null) {
                    Node node4 = node3.getNext();
                    this.traverseBranch(node3, node);
                    node3 = node4;
                }
                break block0;
            }
        }
        this.curNode = node;
        this.callback.visit(this, node, node2);
    }

    private void traverseFunction(Node node, Node node2) {
        boolean bl;
        Preconditions.checkState((node.getChildCount() == 3 ? 1 : 0) != 0);
        Preconditions.checkState((node.getType() == 105 ? 1 : 0) != 0);
        Node node3 = node.getFirstChild();
        boolean bl2 = bl = node2 != null && NodeUtil.isFunctionExpression(node);
        if (!bl) {
            this.traverseBranch(node3, node);
        }
        this.curNode = node;
        this.pushScope(node);
        if (bl) {
            this.traverseBranch(node3, node);
        }
        Node node4 = node3.getNext();
        Node node5 = node4.getNext();
        this.traverseBranch(node4, node);
        Preconditions.checkState((node5.getNext() == null && node5.getType() == 125 ? 1 : 0) != 0);
        this.traverseBranch(node5, node);
        this.popScope();
    }

    public Node getEnclosingFunction() {
        if (this.scopes.size() + this.scopeRoots.size() < 2) {
            return null;
        }
        if (this.scopeRoots.isEmpty()) {
            return this.scopes.peek().getRootNode();
        }
        return this.scopeRoots.peek();
    }

    private void pushScope(Node node) {
        Preconditions.checkState((this.curNode != null ? 1 : 0) != 0);
        this.scopeRoots.push(node);
        this.cfgs.push(null);
        if (this.scopeCallback != null) {
            this.scopeCallback.enterScope(this);
        }
    }

    private void pushScope(Scope scope) {
        Preconditions.checkState((this.curNode != null ? 1 : 0) != 0);
        this.scopes.push(scope);
        this.cfgs.push(null);
        if (this.scopeCallback != null) {
            this.scopeCallback.enterScope(this);
        }
    }

    private void popScope() {
        if (this.scopeCallback != null) {
            this.scopeCallback.exitScope(this);
        }
        if (this.scopeRoots.isEmpty()) {
            this.scopes.pop();
        } else {
            this.scopeRoots.pop();
        }
        this.cfgs.pop();
    }

    public Scope getScope() {
        Scope scope;
        Scope scope2 = scope = this.scopes.isEmpty() ? null : this.scopes.peek();
        if (this.scopeRoots.isEmpty()) {
            return scope;
        }
        Iterator<Node> iterator = this.scopeRoots.descendingIterator();
        while (iterator.hasNext()) {
            scope = this.scopeCreator.createScope(iterator.next(), scope);
            this.scopes.push(scope);
        }
        this.scopeRoots.clear();
        return scope;
    }

    public ControlFlowGraph<Node> getControlFlowGraph() {
        if (this.cfgs.peek() == null) {
            ControlFlowAnalysis controlFlowAnalysis = new ControlFlowAnalysis(this.compiler, false, true);
            controlFlowAnalysis.process(null, this.getScopeRoot());
            this.cfgs.pop();
            this.cfgs.push(controlFlowAnalysis.getCfg());
        }
        return this.cfgs.peek();
    }

    public Node getScopeRoot() {
        if (this.scopeRoots.isEmpty()) {
            return this.scopes.peek().getRootNode();
        }
        return this.scopeRoots.peek();
    }

    boolean inGlobalScope() {
        return this.getScopeDepth() <= 1;
    }

    int getScopeDepth() {
        return this.scopes.size() + this.scopeRoots.size();
    }

    public boolean hasScope() {
        return !this.scopes.isEmpty() || !this.scopeRoots.isEmpty();
    }

    public void report(Node node, DiagnosticType diagnosticType, String ... stringArray) {
        JSError jSError = JSError.make(this.getSourceName(), node, diagnosticType, stringArray);
        this.compiler.report(jSError);
    }

    private static String getSourceName(Node node) {
        String string = (String)node.getProp(16);
        return string == null ? "" : string;
    }

    public JSError makeError(Node node, CheckLevel checkLevel, DiagnosticType diagnosticType, String ... stringArray) {
        return JSError.make(this.getSourceName(), node, checkLevel, diagnosticType, stringArray);
    }

    public JSError makeError(Node node, DiagnosticType diagnosticType, String ... stringArray) {
        return JSError.make(this.getSourceName(), node, diagnosticType, stringArray);
    }

    public static abstract class AbstractNodeTypePruningCallback
    implements Callback {
        private final Set<Integer> nodeTypes;
        private final boolean include;

        public AbstractNodeTypePruningCallback(Set<Integer> set) {
            this(set, true);
        }

        public AbstractNodeTypePruningCallback(Set<Integer> set, boolean bl) {
            this.nodeTypes = set;
            this.include = bl;
        }

        @Override
        public boolean shouldTraverse(NodeTraversal nodeTraversal, Node node, Node node2) {
            return this.include == this.nodeTypes.contains(node.getType());
        }
    }

    public static abstract class AbstractShallowStatementCallback
    implements Callback {
        @Override
        public final boolean shouldTraverse(NodeTraversal nodeTraversal, Node node, Node node2) {
            return node2 == null || NodeUtil.isControlStructure(node2) || NodeUtil.isStatementBlock(node2);
        }
    }

    public static abstract class AbstractShallowCallback
    implements Callback {
        @Override
        public final boolean shouldTraverse(NodeTraversal nodeTraversal, Node node, Node node2) {
            return node2 == null || node2.getType() != 105 || node == node2.getFirstChild();
        }
    }

    public static abstract class AbstractPostOrderCallback
    implements Callback {
        @Override
        public final boolean shouldTraverse(NodeTraversal nodeTraversal, Node node, Node node2) {
            return true;
        }
    }

    public static interface ScopedCallback
    extends Callback {
        public void enterScope(NodeTraversal var1);

        public void exitScope(NodeTraversal var1);
    }

    public static interface Callback {
        public boolean shouldTraverse(NodeTraversal var1, Node var2, Node var3);

        public void visit(NodeTraversal var1, Node var2, Node var3);
    }
}

