/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.javascript.jscomp.AbstractPeepholeOptimization;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.InlineCostEstimator;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.mozilla.rhino.ScriptRuntime;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.TernaryValue;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.Locale;

class PeepholeFoldConstants
extends AbstractPeepholeOptimization {
    static final DiagnosticType INVALID_GETELEM_INDEX_ERROR = DiagnosticType.error("JSC_INVALID_GETELEM_INDEX_ERROR", "Array index not integer: {0}");
    static final DiagnosticType INDEX_OUT_OF_BOUNDS_ERROR = DiagnosticType.error("JSC_INDEX_OUT_OF_BOUNDS_ERROR", "Array index out of bounds: {0}");
    static final DiagnosticType NEGATING_A_NON_NUMBER_ERROR = DiagnosticType.error("JSC_NEGATING_A_NON_NUMBER_ERROR", "Can't negate non-numeric value: {0}");
    static final DiagnosticType BITWISE_OPERAND_OUT_OF_RANGE = DiagnosticType.error("JSC_BITWISE_OPERAND_OUT_OF_RANGE", "Operand out of range, bitwise operation will lose information: {0}");
    static final DiagnosticType SHIFT_AMOUNT_OUT_OF_BOUNDS = DiagnosticType.error("JSC_SHIFT_AMOUNT_OUT_OF_BOUNDS", "Shift amount out of bounds: {0}");
    static final DiagnosticType FRACTIONAL_BITWISE_OPERAND = DiagnosticType.error("JSC_FRACTIONAL_BITWISE_OPERAND", "Fractional bitwise operand: {0}");
    private static final double MAX_FOLD_NUMBER = Math.pow(2.0, 53.0);
    private static final Locale ROOT_LOCALE = new Locale("");

    PeepholeFoldConstants() {
    }

    @Override
    Node optimizeSubtree(Node node) {
        switch (node.getType()) {
            case 37: {
                return this.tryFoldKnownMethods(node);
            }
            case 30: {
                return this.tryFoldCtorCall(node);
            }
            case 32: {
                return this.tryFoldTypeof(node);
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                this.tryReduceOperandsForOp(node);
                return this.tryFoldUnaryOperator(node);
            }
            case 122: {
                return this.tryReduceVoid(node);
            }
        }
        this.tryReduceOperandsForOp(node);
        return this.tryFoldBinaryOperator(node);
    }

    private Node tryFoldBinaryOperator(Node node) {
        Node node2 = node.getFirstChild();
        if (node2 == null) {
            return node;
        }
        Node node3 = node2.getNext();
        if (node3 == null) {
            return node;
        }
        switch (node.getType()) {
            case 33: {
                return this.tryFoldGetProp(node, node2, node3);
            }
            case 35: {
                return this.tryFoldGetElem(node, node2, node3);
            }
            case 52: {
                return this.tryFoldInstanceof(node, node2, node3);
            }
            case 100: 
            case 101: {
                return this.tryFoldAndOr(node, node2, node3);
            }
            case 18: 
            case 19: 
            case 20: {
                return this.tryFoldShift(node, node2, node3);
            }
            case 86: {
                return this.tryFoldAssign(node, node2, node3);
            }
            case 21: {
                return this.tryFoldAdd(node, node2, node3);
            }
            case 22: 
            case 24: 
            case 25: {
                return this.tryFoldArithmeticOp(node, node2, node3);
            }
            case 9: 
            case 10: 
            case 11: 
            case 23: {
                Node node4 = this.tryFoldArithmeticOp(node, node2, node3);
                if (node4 != node) {
                    return node4;
                }
                return this.tryFoldLeftChildOp(node, node2, node3);
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 45: 
            case 46: {
                return this.tryFoldComparison(node, node2, node3);
            }
        }
        return node;
    }

    private Node tryReduceVoid(Node node) {
        Node node2 = node.getFirstChild();
        if (!(node2.getType() == 39 && node2.getDouble() == 0.0 || this.mayHaveSideEffects(node))) {
            node.replaceChild(node2, Node.newNumber(0.0));
            this.reportCodeChange();
        }
        return node;
    }

    private void tryReduceOperandsForOp(Node node) {
        switch (node.getType()) {
            case 21: {
                Node node2 = node.getFirstChild();
                Node node3 = node.getLastChild();
                if (NodeUtil.mayBeString(node2) || NodeUtil.mayBeString(node3)) break;
                this.tryConvertOperandsToNumber(node);
                break;
            }
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 94: 
            case 95: 
            case 96: 
            case 97: {
                this.tryConvertToNumber(node.getLastChild());
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: {
                this.tryConvertOperandsToNumber(node);
            }
        }
    }

    private void tryConvertOperandsToNumber(Node node) {
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            Node node3 = node2.getNext();
            this.tryConvertToNumber(node2);
            node2 = node3;
        }
    }

    private void tryConvertToNumber(Node node) {
        Node node2;
        switch (node.getType()) {
            case 39: {
                return;
            }
            case 85: 
            case 100: 
            case 101: {
                this.tryConvertToNumber(node.getLastChild());
                return;
            }
            case 98: {
                this.tryConvertToNumber(node.getChildAtIndex(1));
                this.tryConvertToNumber(node.getLastChild());
                return;
            }
            case 38: {
                if (NodeUtil.isUndefined(node)) break;
                return;
            }
        }
        Double d = NodeUtil.getNumberValue(node);
        if (d == null) {
            return;
        }
        double d2 = d;
        if (Double.isNaN(d2)) {
            node2 = Node.newString(38, "NaN");
        } else if (d2 == Double.POSITIVE_INFINITY) {
            node2 = Node.newString(38, "Infinity");
        } else if (d2 == Double.NEGATIVE_INFINITY) {
            node2 = new Node(29, Node.newString(38, "Infinity"));
            node2.copyInformationFromForTree(node);
        } else {
            node2 = Node.newNumber(d2);
        }
        node.getParent().replaceChild(node, node2);
        this.reportCodeChange();
    }

    private Node tryFoldTypeof(Node node) {
        Preconditions.checkArgument((node.getType() == 32 ? 1 : 0) != 0);
        Node node2 = node.getFirstChild();
        if (node2 == null || !NodeUtil.isLiteralValue(node2, true)) {
            return node;
        }
        String string = null;
        switch (node2.getType()) {
            case 105: {
                string = "function";
                break;
            }
            case 40: {
                string = "string";
                break;
            }
            case 39: {
                string = "number";
                break;
            }
            case 43: 
            case 44: {
                string = "boolean";
                break;
            }
            case 41: 
            case 63: 
            case 64: {
                string = "object";
                break;
            }
            case 122: {
                string = "undefined";
                break;
            }
            case 38: {
                if (!"undefined".equals(node2.getString())) break;
                string = "undefined";
            }
        }
        if (string != null) {
            Node node3 = Node.newString(string);
            node.getParent().replaceChild(node, node3);
            this.reportCodeChange();
            return node3;
        }
        return node;
    }

    private Node tryFoldUnaryOperator(Node node) {
        Preconditions.checkState((boolean)node.hasOneChild());
        Node node2 = node.getFirstChild();
        Node node3 = node.getParent();
        if (node2 == null) {
            return node;
        }
        TernaryValue ternaryValue = NodeUtil.getPureBooleanValue(node2);
        if (ternaryValue == TernaryValue.UNKNOWN) {
            return node;
        }
        switch (node.getType()) {
            case 26: {
                double d;
                if (node2.getType() == 39 && ((d = node2.getDouble()) == 0.0 || d == 1.0)) {
                    return node;
                }
                int n = ternaryValue.toBoolean(true) ? 43 : 44;
                Node node4 = new Node(n);
                node3.replaceChild(node, node4);
                this.reportCodeChange();
                return node4;
            }
            case 28: {
                if (NodeUtil.isNumericResult(node2)) {
                    node3.replaceChild(node, node2.detachFromParent());
                    this.reportCodeChange();
                    return node2;
                }
                return node;
            }
            case 29: {
                try {
                    if (node2.getType() == 38) {
                        if (node2.getString().equals("Infinity")) {
                            return node;
                        }
                        if (node2.getString().equals("NaN")) {
                            node.removeChild(node2);
                            node3.replaceChild(node, node2);
                            this.reportCodeChange();
                            return node2;
                        }
                    }
                    double d = -node2.getDouble();
                    Node node5 = Node.newNumber(d);
                    node3.replaceChild(node, node5);
                    this.reportCodeChange();
                    return node5;
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    this.error(NEGATING_A_NON_NUMBER_ERROR, node2);
                    return node;
                }
            }
            case 27: {
                try {
                    double d = node2.getDouble();
                    if (d >= -2.147483648E9 && d <= 2.147483647E9) {
                        int n = (int)d;
                        if ((double)n == d) {
                            Node node6 = Node.newNumber(~n);
                            node3.replaceChild(node, node6);
                            this.reportCodeChange();
                            return node6;
                        }
                        this.error(FRACTIONAL_BITWISE_OPERAND, node2);
                        return node;
                    }
                    this.error(BITWISE_OPERAND_OUT_OF_RANGE, node2);
                    return node;
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    this.error(NEGATING_A_NON_NUMBER_ERROR, node2);
                    return node;
                }
            }
        }
        return node;
    }

    private Node tryFoldInstanceof(Node node, Node node2, Node node3) {
        Preconditions.checkArgument((node.getType() == 52 ? 1 : 0) != 0);
        if (NodeUtil.isLiteralValue(node2, true) && !this.mayHaveSideEffects(node3)) {
            Node node4 = null;
            if (NodeUtil.isImmutableValue(node2)) {
                node4 = new Node(43);
            } else if (node3.getType() == 38 && "Object".equals(node3.getString())) {
                node4 = new Node(44);
            }
            if (node4 != null) {
                node.getParent().replaceChild(node, node4);
                this.reportCodeChange();
                return node4;
            }
        }
        return node;
    }

    private Node tryFoldAssign(Node node, Node node2, Node node3) {
        Node node4;
        Preconditions.checkArgument((node.getType() == 86 ? 1 : 0) != 0);
        if (!node3.hasChildren() || node3.getFirstChild().getNext() != node3.getLastChild()) {
            return node;
        }
        if (this.mayHaveSideEffects(node2)) {
            return node;
        }
        if (this.areNodesEqualForInlining(node2, node3.getFirstChild())) {
            node4 = node3.getLastChild();
        } else if (NodeUtil.isCommutative(node3.getType()) && this.areNodesEqualForInlining(node2, node3.getLastChild())) {
            node4 = node3.getFirstChild();
        } else {
            return node;
        }
        int n = -1;
        switch (node3.getType()) {
            case 21: {
                n = 93;
                break;
            }
            case 11: {
                n = 89;
                break;
            }
            case 9: {
                n = 87;
                break;
            }
            case 10: {
                n = 88;
                break;
            }
            case 24: {
                n = 96;
                break;
            }
            case 18: {
                n = 90;
                break;
            }
            case 25: {
                n = 97;
                break;
            }
            case 23: {
                n = 95;
                break;
            }
            case 19: {
                n = 91;
                break;
            }
            case 22: {
                n = 94;
                break;
            }
            case 20: {
                n = 92;
                break;
            }
            default: {
                return node;
            }
        }
        Node node5 = new Node(n, node2.detachFromParent(), node4.detachFromParent());
        node.getParent().replaceChild(node, node5);
        this.reportCodeChange();
        return node5;
    }

    private Node tryFoldAndOr(Node node, Node node2, Node node3) {
        Node node4 = node.getParent();
        Node node5 = null;
        int n = node.getType();
        TernaryValue ternaryValue = NodeUtil.getImpureBooleanValue(node2);
        if (ternaryValue != TernaryValue.UNKNOWN) {
            boolean bl = ternaryValue.toBoolean(true);
            if (bl && n == 100 || !bl && n == 101) {
                node5 = node2;
            } else if (!this.mayHaveSideEffects(node2)) {
                node5 = node3;
            }
        }
        if (node5 != null) {
            node.removeChild(node5);
            node4.replaceChild(node, node5);
            this.reportCodeChange();
            return node5;
        }
        return node;
    }

    private Node tryFoldChildAddString(Node node, Node node2, Node node3) {
        String string;
        String string2;
        Node node4;
        Node node5;
        if (NodeUtil.isLiteralValue(node3, false) && node2.getType() == 21 && (node5 = (node4 = node2.getFirstChild()).getNext()).getType() == 40) {
            string2 = NodeUtil.getStringValue(node5);
            string = NodeUtil.getStringValue(node3);
            if (string2 != null && string != null) {
                node2.removeChild(node4);
                String string3 = string2 + string;
                node.replaceChild(node2, node4);
                node.replaceChild(node3, Node.newString(string3));
                this.reportCodeChange();
                return node;
            }
        }
        if (NodeUtil.isLiteralValue(node2, false) && node3.getType() == 21) {
            node4 = node3.getFirstChild();
            node5 = node3.getLastChild();
            if (node4.getType() == 40) {
                string2 = NodeUtil.getStringValue(node2);
                string = NodeUtil.getStringValue(node4);
                if (string2 != null && string != null) {
                    node3.removeChild(node5);
                    String string4 = string2 + string;
                    node.replaceChild(node3, node5);
                    node.replaceChild(node2, Node.newString(string4));
                    this.reportCodeChange();
                    return node;
                }
            }
        }
        return node;
    }

    private Node tryFoldAddConstantString(Node node, Node node2, Node node3) {
        if (node2.getType() == 40 || node3.getType() == 40) {
            String string = NodeUtil.getStringValue(node2);
            String string2 = NodeUtil.getStringValue(node3);
            if (string != null && string2 != null) {
                Node node4 = Node.newString(string + string2);
                node.getParent().replaceChild(node, node4);
                this.reportCodeChange();
                return node4;
            }
        }
        return node;
    }

    private Node tryFoldArithmeticOp(Node node, Node node2, Node node3) {
        Node node4 = this.performArithmeticOp(node.getType(), node2, node3);
        if (node4 != null) {
            node4.copyInformationFromForTree(node);
            node.getParent().replaceChild(node, node4);
            this.reportCodeChange();
            return node4;
        }
        return node;
    }

    private Node performArithmeticOp(int n, Node node, Node node2) {
        double d;
        if (n == 21 && (NodeUtil.mayBeString(node, false) || NodeUtil.mayBeString(node2, false))) {
            return null;
        }
        Double d2 = NodeUtil.getNumberValue(node);
        if (d2 == null) {
            return null;
        }
        Double d3 = NodeUtil.getNumberValue(node2);
        if (d3 == null) {
            return null;
        }
        double d4 = d2;
        double d5 = d3;
        switch (n) {
            case 11: {
                d = ScriptRuntime.toInt32(d4) & ScriptRuntime.toInt32(d5);
                break;
            }
            case 9: {
                d = ScriptRuntime.toInt32(d4) | ScriptRuntime.toInt32(d5);
                break;
            }
            case 10: {
                d = ScriptRuntime.toInt32(d4) ^ ScriptRuntime.toInt32(d5);
                break;
            }
            case 21: {
                d = d4 + d5;
                break;
            }
            case 22: {
                d = d4 - d5;
                break;
            }
            case 23: {
                d = d4 * d5;
                break;
            }
            case 25: {
                if (d5 == 0.0) {
                    return null;
                }
                d = d4 % d5;
                break;
            }
            case 24: {
                if (d5 == 0.0) {
                    return null;
                }
                d = d4 / d5;
                break;
            }
            default: {
                throw new Error("Unexpected arithmetic operator");
            }
        }
        if (String.valueOf(d).length() <= String.valueOf(d4).length() + String.valueOf(d5).length() + 1 && Math.abs(d) <= MAX_FOLD_NUMBER) {
            Node node3 = Node.newNumber(d);
            return node3;
        }
        if (Double.isNaN(d)) {
            return Node.newString(38, "NaN");
        }
        if (d == Double.POSITIVE_INFINITY) {
            return Node.newString(38, "Infinity");
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return new Node(29, Node.newString(38, "Infinity"));
        }
        return null;
    }

    private Node tryFoldLeftChildOp(Node node, Node node2, Node node3) {
        int n = node.getType();
        Preconditions.checkState((NodeUtil.isAssociative(n) && NodeUtil.isCommutative(n) || node.getType() == 21 ? 1 : 0) != 0);
        Preconditions.checkState((node.getType() != 21 || !NodeUtil.mayBeString(node) ? 1 : 0) != 0);
        Double d = NodeUtil.getNumberValue(node3);
        if (d != null && node2.getType() == n) {
            Preconditions.checkState((node2.getChildCount() == 2 ? 1 : 0) != 0);
            Node node4 = node2.getFirstChild();
            Node node5 = node4.getNext();
            Node node6 = node4;
            Node node7 = this.performArithmeticOp(n, node6, node3);
            if (node7 == null) {
                node6 = node5;
                node7 = this.performArithmeticOp(n, node6, node3);
            }
            if (node7 != null) {
                node2.removeChild(node6);
                node.replaceChild(node2, node2.removeFirstChild());
                node7.copyInformationFromForTree(node3);
                node.replaceChild(node3, node7);
                this.reportCodeChange();
            }
        }
        return node;
    }

    private Node tryFoldAdd(Node node, Node node2, Node node3) {
        Preconditions.checkArgument((node.getType() == 21 ? 1 : 0) != 0);
        if (NodeUtil.mayBeString(node, true)) {
            if (NodeUtil.isLiteralValue(node2, false) && NodeUtil.isLiteralValue(node3, false)) {
                return this.tryFoldAddConstantString(node, node2, node3);
            }
            return this.tryFoldChildAddString(node, node2, node3);
        }
        Node node4 = this.tryFoldArithmeticOp(node, node2, node3);
        if (node4 != node) {
            return node4;
        }
        return this.tryFoldLeftChildOp(node, node2, node3);
    }

    private Node tryFoldShift(Node node, Node node2, Node node3) {
        if (node2.getType() == 39 && node3.getType() == 39) {
            double d;
            double d2 = node2.getDouble();
            double d3 = node3.getDouble();
            if (!(d2 >= -2.147483648E9) || !(d2 <= 2.147483647E9)) {
                this.error(BITWISE_OPERAND_OUT_OF_RANGE, node2);
                return node;
            }
            if (!(d3 >= 0.0) || !(d3 < 32.0)) {
                this.error(SHIFT_AMOUNT_OUT_OF_BOUNDS, node3);
                return node;
            }
            int n = (int)d2;
            if ((double)n != d2) {
                this.error(FRACTIONAL_BITWISE_OPERAND, node2);
                return node;
            }
            int n2 = (int)d3;
            if ((double)n2 != d3) {
                this.error(FRACTIONAL_BITWISE_OPERAND, node3);
                return node;
            }
            switch (node.getType()) {
                case 18: {
                    d = n << n2;
                    break;
                }
                case 19: {
                    d = n >> n2;
                    break;
                }
                case 20: {
                    long l = (long)n & 0xFFFFFFFFL;
                    d = l >>> n2;
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unknown shift operator: " + Node.tokenToName(node.getType())));
                }
            }
            Node node4 = Node.newNumber(d);
            node.getParent().replaceChild(node, node4);
            this.reportCodeChange();
            return node4;
        }
        return node;
    }

    private Node tryFoldComparison(Node node, Node node2, Node node3) {
        Serializable serializable;
        boolean bl;
        if (!(NodeUtil.isLiteralValue(node2, false) && NodeUtil.isLiteralValue(node3, false) || node.getType() == 16 || node.getType() == 14)) {
            return node;
        }
        int n = node.getType();
        boolean bl2 = NodeUtil.isLiteralValue(node3, false);
        boolean bl3 = 38 == node3.getType() && node3.getString().equals("undefined") || 122 == node3.getType() && NodeUtil.isLiteralValue(node3.getFirstChild(), false);
        int n2 = this.getNormalizedNodeType(node2);
        int n3 = this.getNormalizedNodeType(node3);
        block0 : switch (n2) {
            case 122: {
                if (!NodeUtil.isLiteralValue(node2.getFirstChild(), false)) {
                    return node;
                }
                if (!bl2) {
                    return node;
                }
                bl = this.compareToUndefined(node3, n);
                break;
            }
            case 41: 
            case 43: 
            case 44: {
                if (bl3) {
                    bl = this.compareToUndefined(node2, n);
                    break;
                }
                if (n3 != 44 && n3 != 43 && n3 != 41) {
                    return node;
                }
                switch (n) {
                    case 12: 
                    case 45: {
                        bl = n2 == n3;
                        break block0;
                    }
                    case 13: 
                    case 46: {
                        bl = n2 != n3;
                        break block0;
                    }
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: {
                        serializable = this.compareAsNumbers(n, node2, node3);
                        if (serializable != null) {
                            bl = (Boolean)serializable;
                            break block0;
                        }
                        return node;
                    }
                }
                return node;
            }
            case 42: {
                if (node3.getType() != 42) {
                    return node;
                }
                switch (n) {
                    case 12: 
                    case 45: {
                        bl = true;
                        break block0;
                    }
                    case 13: 
                    case 46: {
                        bl = false;
                        break block0;
                    }
                }
                return node;
            }
            case 40: {
                if (bl3) {
                    bl = this.compareToUndefined(node2, n);
                    break;
                }
                if (40 != node3.getType()) {
                    return node;
                }
                switch (n) {
                    case 12: 
                    case 45: {
                        bl = node2.getString().equals(node3.getString());
                        break block0;
                    }
                    case 13: 
                    case 46: {
                        bl = !node2.getString().equals(node3.getString());
                        break block0;
                    }
                }
                return node;
            }
            case 39: {
                if (bl3) {
                    bl = this.compareToUndefined(node2, n);
                    break;
                }
                if (39 != node3.getType()) {
                    return node;
                }
                serializable = this.compareAsNumbers(n, node2, node3);
                if (serializable != null) {
                    bl = (Boolean)serializable;
                    break;
                }
                return null;
            }
            case 38: {
                String string;
                boolean bl4;
                if (bl3) {
                    bl = this.compareToUndefined(node2, n);
                    break;
                }
                if (bl2 && (bl4 = node2.getString().equals("undefined"))) {
                    bl = this.compareToUndefined(node3, n);
                    break;
                }
                if (38 != node3.getType()) {
                    return node;
                }
                String string2 = node2.getString();
                if (!string2.equals(string = node3.getString())) {
                    return node;
                }
                switch (n) {
                    case 14: 
                    case 16: {
                        bl = false;
                        break block0;
                    }
                }
                return node;
            }
            default: {
                return node;
            }
        }
        serializable = new Node(bl ? 44 : 43);
        node.getParent().replaceChild(node, (Node)serializable);
        this.reportCodeChange();
        return serializable;
    }

    private int getNormalizedNodeType(Node node) {
        int n = node.getType();
        if (n == 26) {
            TernaryValue ternaryValue = NodeUtil.getPureBooleanValue(node);
            switch (ternaryValue) {
                case TRUE: {
                    return 44;
                }
                case FALSE: {
                    return 43;
                }
            }
        }
        return n;
    }

    private Boolean compareAsNumbers(int n, Node node, Node node2) {
        Boolean bl;
        Double d = NodeUtil.getNumberValue(node);
        if (d == null) {
            return null;
        }
        Double d2 = NodeUtil.getNumberValue(node2);
        if (d2 == null) {
            return null;
        }
        double d3 = d;
        double d4 = d2;
        switch (n) {
            case 12: 
            case 45: {
                Preconditions.checkState((node.getType() == 39 && node2.getType() == 39 ? 1 : 0) != 0);
                bl = d3 == d4;
                break;
            }
            case 13: 
            case 46: {
                Preconditions.checkState((node.getType() == 39 && node2.getType() == 39 ? 1 : 0) != 0);
                bl = d3 != d4;
                break;
            }
            case 15: {
                bl = d3 <= d4;
                break;
            }
            case 14: {
                bl = d3 < d4;
                break;
            }
            case 17: {
                bl = d3 >= d4;
                break;
            }
            case 16: {
                bl = d3 > d4;
                break;
            }
            default: {
                return null;
            }
        }
        return bl;
    }

    private boolean compareToUndefined(Node node, int n) {
        boolean bl = 38 == node.getType() && node.getString().equals("undefined") || 122 == node.getType() && NodeUtil.isLiteralValue(node.getFirstChild(), false);
        boolean bl2 = 41 == node.getType();
        boolean bl3 = bl || bl2;
        switch (n) {
            case 12: {
                return bl3;
            }
            case 13: {
                return !bl3;
            }
            case 45: {
                return bl;
            }
            case 46: {
                return !bl;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                return false;
            }
        }
        throw new IllegalStateException("unexpected.");
    }

    private Node tryFoldCtorCall(Node node) {
        Preconditions.checkArgument((node.getType() == 30 ? 1 : 0) != 0);
        if (this.inForcedStringContext(node)) {
            return this.tryFoldInForcedStringContext(node);
        }
        return node;
    }

    private boolean inForcedStringContext(Node node) {
        return node.getParent().getType() == 35 && node.getParent().getLastChild() == node;
    }

    private Node tryFoldInForcedStringContext(Node node) {
        Preconditions.checkArgument((node.getType() == 30 ? 1 : 0) != 0);
        Node node2 = node.getFirstChild();
        if (node2.getType() != 38) {
            return node;
        }
        if (node2.getString().equals("String")) {
            Node node3 = node2.getNext();
            String string = null;
            if (node3 == null) {
                string = "";
            } else {
                if (!NodeUtil.isImmutableValue(node3)) {
                    return node;
                }
                string = NodeUtil.getStringValue(node3);
            }
            if (string == null) {
                return node;
            }
            Node node4 = node.getParent();
            Node node5 = Node.newString(string);
            node4.replaceChild(node, node5);
            node5.copyInformationFrom(node4);
            this.reportCodeChange();
            return node5;
        }
        return node;
    }

    private Node tryFoldKnownMethods(Node node) {
        if ((node = this.tryFoldArrayJoin(node)).getType() == 37) {
            node = this.tryFoldKnownStringMethods(node);
        }
        return node;
    }

    private Node tryFoldKnownStringMethods(Node node) {
        Preconditions.checkArgument((node.getType() == 37 ? 1 : 0) != 0);
        Node node2 = node.getFirstChild();
        if (node2 == null) {
            return node;
        }
        if (!NodeUtil.isGet(node2)) {
            return node;
        }
        Node node3 = node2.getFirstChild();
        Node node4 = node3.getNext();
        if (node3.getType() != 40 || node4.getType() != 40) {
            return node;
        }
        String string = node4.getString();
        Node node5 = node2.getNext();
        if (node5 == null) {
            if (string.equals("toLowerCase")) {
                node = this.tryFoldStringToLowerCase(node, node3);
            } else if (string.equals("toUpperCase")) {
                node = this.tryFoldStringToUpperCase(node, node3);
            }
            return node;
        }
        if (NodeUtil.isImmutableValue(node5)) {
            if (string.equals("indexOf") || string.equals("lastIndexOf")) {
                node = this.tryFoldStringIndexOf(node, string, node3, node5);
            } else if (string.equals("substr")) {
                node = this.tryFoldStringSubstr(node, node3, node5);
            } else if (string.equals("substring")) {
                node = this.tryFoldStringSubstring(node, node3, node5);
            }
        }
        return node;
    }

    private Node tryFoldStringToLowerCase(Node node, Node node2) {
        String string = node2.getString().toLowerCase(ROOT_LOCALE);
        Node node3 = Node.newString(string);
        node.getParent().replaceChild(node, node3);
        this.reportCodeChange();
        return node3;
    }

    private Node tryFoldStringToUpperCase(Node node, Node node2) {
        String string = node2.getString().toUpperCase(ROOT_LOCALE);
        Node node3 = Node.newString(string);
        node.getParent().replaceChild(node, node3);
        this.reportCodeChange();
        return node3;
    }

    private Node tryFoldStringIndexOf(Node node, String string, Node node2, Node node3) {
        int n;
        Preconditions.checkArgument((node.getType() == 37 ? 1 : 0) != 0);
        Preconditions.checkArgument((node2.getType() == 40 ? 1 : 0) != 0);
        String string2 = NodeUtil.getStringValue(node2);
        boolean bl = string.equals("indexOf");
        Node node4 = node3.getNext();
        String string3 = NodeUtil.getStringValue(node3);
        if (string3 == null) {
            return node;
        }
        int n2 = n = bl ? 0 : string2.length();
        if (node4 != null) {
            if (node4.getNext() != null || node4.getType() != 39) {
                return node;
            }
            n = (int)node4.getDouble();
        }
        int n3 = bl ? string2.indexOf(string3, n) : string2.lastIndexOf(string3, n);
        Node node5 = Node.newNumber(n3);
        node.getParent().replaceChild(node, node5);
        this.reportCodeChange();
        return node5;
    }

    private Node tryFoldArrayJoin(Node node) {
        Node node2 = node.getFirstChild();
        if (node2 == null || !NodeUtil.isGetProp(node2)) {
            return node;
        }
        Node node3 = node2.getNext();
        if (node3 != null && !NodeUtil.isImmutableValue(node3)) {
            return node;
        }
        Node node4 = node2.getFirstChild();
        Node node5 = node4.getNext();
        if (node4.getType() != 63 || !node5.getString().equals("join")) {
            return node;
        }
        String string = node3 == null ? "," : NodeUtil.getStringValue(node3);
        LinkedList linkedList = Lists.newLinkedList();
        StringBuilder stringBuilder = null;
        int n = 0;
        Node node6 = null;
        for (Node node7 = node4.getFirstChild(); node7 != null; node7 = node7.getNext()) {
            if (NodeUtil.isImmutableValue(node7) || node7.getType() == 124) {
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder();
                } else {
                    stringBuilder.append(string);
                }
                stringBuilder.append(NodeUtil.getArrayElementStringValue(node7));
            } else {
                if (stringBuilder != null) {
                    Preconditions.checkNotNull(node6);
                    n += stringBuilder.length() + 2;
                    linkedList.add(Node.newString(stringBuilder.toString()).copyInformationFrom(node6));
                    stringBuilder = null;
                }
                n += InlineCostEstimator.getCost(node7);
                linkedList.add(node7);
            }
            node6 = node7;
        }
        if (stringBuilder != null) {
            Preconditions.checkNotNull(node6);
            n += stringBuilder.length() + 2;
            linkedList.add(Node.newString(stringBuilder.toString()).copyInformationFrom(node6));
        }
        n += linkedList.size() - 1;
        int n2 = InlineCostEstimator.getCost(node);
        switch (linkedList.size()) {
            case 0: {
                Node node8 = Node.newString("");
                node.getParent().replaceChild(node, node8);
                this.reportCodeChange();
                return node8;
            }
            case 1: {
                Node node9 = (Node)linkedList.remove(0);
                if (n > n2) {
                    return node;
                }
                node4.detachChildren();
                if (node9.getType() != 40) {
                    Node node10;
                    node9 = node10 = new Node(21, Node.newString("").copyInformationFrom(node), node9);
                }
                node.getParent().replaceChild(node, node9);
                this.reportCodeChange();
                return node9;
            }
        }
        if (linkedList.size() == node4.getChildCount()) {
            return node;
        }
        int n3 = "[].join()".length();
        n += n3;
        if ((n += node3 != null ? InlineCostEstimator.getCost(node3) : 0) > n2) {
            return node;
        }
        node4.detachChildren();
        for (Node node11 : linkedList) {
            node4.addChildToBack(node11);
        }
        this.reportCodeChange();
        return node;
    }

    private Node tryFoldStringSubstr(Node node, Node node2, Node node3) {
        int n;
        Preconditions.checkArgument((node.getType() == 37 ? 1 : 0) != 0);
        Preconditions.checkArgument((node2.getType() == 40 ? 1 : 0) != 0);
        String string = node2.getString();
        if (node3 == null || node3.getType() != 39) {
            return node;
        }
        int n2 = (int)node3.getDouble();
        Node node4 = node3.getNext();
        if (node4 != null) {
            if (node4.getType() != 39) {
                return node;
            }
            n = (int)node4.getDouble();
            if (node4.getNext() != null) {
                return node;
            }
        } else {
            n = string.length() - n2;
        }
        if (n2 + n > string.length() || n < 0 || n2 < 0) {
            return node;
        }
        String string2 = string.substring(n2, n2 + n);
        Node node5 = Node.newString(string2);
        Node node6 = node.getParent();
        node6.replaceChild(node, node5);
        this.reportCodeChange();
        return node5;
    }

    private Node tryFoldStringSubstring(Node node, Node node2, Node node3) {
        int n;
        Preconditions.checkArgument((node.getType() == 37 ? 1 : 0) != 0);
        Preconditions.checkArgument((node2.getType() == 40 ? 1 : 0) != 0);
        String string = node2.getString();
        if (node3 == null || node3.getType() != 39) {
            return node;
        }
        int n2 = (int)node3.getDouble();
        Node node4 = node3.getNext();
        if (node4 != null) {
            if (node4.getType() != 39) {
                return node;
            }
            n = (int)node4.getDouble();
            if (node4.getNext() != null) {
                return node;
            }
        } else {
            n = string.length();
        }
        if (n > string.length() || n2 > string.length() || n < 0 || n2 < 0) {
            return node;
        }
        String string2 = string.substring(n2, n);
        Node node5 = Node.newString(string2);
        Node node6 = node.getParent();
        node6.replaceChild(node, node5);
        this.reportCodeChange();
        return node5;
    }

    private Node tryFoldGetElem(Node node, Node node2, Node node3) {
        Preconditions.checkArgument((node.getType() == 35 ? 1 : 0) != 0);
        if (node2.getType() == 64) {
            return this.tryFoldObjectPropAccess(node, node2, node3);
        }
        if (node2.getType() == 63) {
            if (node3.getType() != 39) {
                return node;
            }
            double d = node3.getDouble();
            int n = (int)d;
            if ((double)n != d) {
                this.error(INVALID_GETELEM_INDEX_ERROR, node3);
                return node;
            }
            if (n < 0) {
                this.error(INDEX_OUT_OF_BOUNDS_ERROR, node3);
                return node;
            }
            Node node4 = node2.getFirstChild();
            for (int n2 = 0; node4 != null && n2 < n; node4 = node4.getNext(), ++n2) {
            }
            if (node4 == null) {
                this.error(INDEX_OUT_OF_BOUNDS_ERROR, node3);
                return node;
            }
            if (node4.getType() == 124) {
                node4 = NodeUtil.newUndefinedNode(node4);
            } else {
                node2.removeChild(node4);
            }
            node.getParent().replaceChild(node, node4);
            this.reportCodeChange();
            return node4;
        }
        return node;
    }

    private Node tryFoldGetProp(Node node, Node node2, Node node3) {
        Preconditions.checkArgument((node.getType() == 33 ? 1 : 0) != 0);
        if (node2.getType() == 64) {
            return this.tryFoldObjectPropAccess(node, node2, node3);
        }
        if (node3.getType() == 40 && node3.getString().equals("length")) {
            int n = -1;
            switch (node2.getType()) {
                case 63: {
                    if (this.mayHaveSideEffects(node2)) {
                        return node;
                    }
                    n = node2.getChildCount();
                    break;
                }
                case 40: {
                    n = node2.getString().length();
                    break;
                }
                default: {
                    return node;
                }
            }
            Preconditions.checkState((n != -1 ? 1 : 0) != 0);
            Node node4 = Node.newNumber(n);
            node.getParent().replaceChild(node, node4);
            this.reportCodeChange();
            return node4;
        }
        return node;
    }

    private Node tryFoldObjectPropAccess(Node node, Node node2, Node node3) {
        Node node4;
        Preconditions.checkArgument((boolean)NodeUtil.isGet(node));
        if (node2.getType() != 64 || node3.getType() != 40) {
            return node;
        }
        Node node5 = node.getParent();
        if (NodeUtil.isAssignmentOp(node5) && node5.getFirstChild() == node || node5.getType() == 102 || node5.getType() == 103) {
            return node;
        }
        Node node6 = null;
        Node node7 = null;
        block4: for (node4 = node2.getFirstChild(); node4 != null; node4 = node4.getNext()) {
            if (node4.getString().equals(node3.getString())) {
                switch (node4.getType()) {
                    case 148: {
                        continue block4;
                    }
                    case 40: 
                    case 147: {
                        if (node7 != null && this.mayHaveSideEffects(node7)) {
                            return node;
                        }
                        node6 = node4;
                        node7 = node6.getFirstChild();
                        continue block4;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            if (!this.mayHaveSideEffects(node4.getFirstChild())) continue;
            return node;
        }
        if (node7 == null) {
            return node;
        }
        if (node7.getType() == 105 && NodeUtil.referencesThis(node7)) {
            return node;
        }
        node4 = node7.detachFromParent();
        if (node6.getType() == 147) {
            node4 = new Node(37, node4);
        }
        node.getParent().replaceChild(node, node4);
        this.reportCodeChange();
        return node;
    }
}

