/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.javascript.jscomp.AbstractPeepholeOptimization;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.TernaryValue;
import javax.annotation.Nullable;

class PeepholeRemoveDeadCode
extends AbstractPeepholeOptimization {
    PeepholeRemoveDeadCode() {
    }

    @Override
    Node optimizeSubtree(Node node) {
        switch (node.getType()) {
            case 86: {
                return this.tryFoldAssignment(node);
            }
            case 85: {
                return this.tryFoldComma(node);
            }
            case 125: 
            case 132: {
                return this.tryOptimizeBlock(node);
            }
            case 130: {
                node = this.tryFoldExpr(node);
                return node;
            }
            case 98: {
                return this.tryFoldHook(node);
            }
            case 110: {
                return this.tryOptimizeSwitch(node);
            }
            case 108: {
                return this.tryFoldIf(node);
            }
            case 113: {
                return this.tryFoldWhile(node);
            }
            case 115: {
                Node node2 = NodeUtil.getConditionExpression(node);
                if (node2 != null) {
                    this.tryFoldForCondition(node2);
                }
                return this.tryFoldFor(node);
            }
            case 114: {
                return this.tryFoldDo(node);
            }
            case 77: {
                return this.tryFoldTry(node);
            }
        }
        return node;
    }

    private Node tryFoldTry(Node node) {
        Preconditions.checkState((node.getType() == 77 ? 1 : 0) != 0);
        Node node2 = node.getFirstChild();
        Node node3 = node2.getNext();
        Node node4 = node3.getNext();
        if (!(node3.hasChildren() || node4 != null && node4.hasChildren())) {
            node.removeChild(node2);
            node.getParent().replaceChild(node, node2);
            this.reportCodeChange();
            return node2;
        }
        return node;
    }

    private Node tryFoldAssignment(Node node) {
        Preconditions.checkState((node.getType() == 86 ? 1 : 0) != 0);
        Node node2 = node.getFirstChild();
        Node node3 = node.getLastChild();
        if (node2.getType() == 38 && node3.getType() == 38 && node2.getString().equals(node3.getString())) {
            node.getParent().replaceChild(node, node3.detachFromParent());
            this.reportCodeChange();
            return node3;
        }
        return node;
    }

    private Node tryFoldExpr(Node node) {
        Node node2 = this.trySimpilifyUnusedResult(node.getFirstChild());
        if (node2 == null) {
            Node node3 = node.getParent();
            if (node3.getType() == 126) {
                Node node4 = new Node(125).copyInformationFrom(node);
                node3.replaceChild(node, node4);
                node = node4;
            } else {
                node.detachFromParent();
                node = null;
            }
        }
        return node;
    }

    private Node trySimpilifyUnusedResult(Node node) {
        return this.trySimpilifyUnusedResult(node, true);
    }

    private Node trySimpilifyUnusedResult(Node node, boolean bl) {
        Node node2;
        Node node3 = node;
        switch (node.getType()) {
            case 98: {
                node2 = this.trySimpilifyUnusedResult(node.getFirstChild().getNext());
                Node node4 = this.trySimpilifyUnusedResult(node.getLastChild());
                if (node2 == null && node4 != null) {
                    node.setType(100);
                    Preconditions.checkState((node.getChildCount() == 2 ? 1 : 0) != 0);
                    break;
                }
                if (node2 != null && node4 == null) {
                    node.setType(101);
                    Preconditions.checkState((node.getChildCount() == 2 ? 1 : 0) != 0);
                    break;
                }
                if (node2 == null && node4 == null) {
                    node3 = this.trySimpilifyUnusedResult(node.getFirstChild());
                    break;
                }
                node3 = node;
                break;
            }
            case 100: 
            case 101: {
                Node node5 = this.trySimpilifyUnusedResult(node.getLastChild());
                if (node5 != null) break;
                Preconditions.checkState((boolean)node.hasOneChild());
                node3 = this.trySimpilifyUnusedResult(node.getFirstChild());
                break;
            }
            case 105: {
                node3 = null;
                break;
            }
            case 85: {
                Node node6 = this.trySimpilifyUnusedResult(node.getFirstChild());
                Node node7 = this.trySimpilifyUnusedResult(node.getLastChild());
                if (node6 == null && node7 == null) {
                    node3 = null;
                    break;
                }
                if (node6 == null) {
                    node3 = node7;
                    break;
                }
                if (node7 == null) {
                    node3 = node6;
                    break;
                }
                node3 = node;
                break;
            }
            default: {
                if (NodeUtil.nodeTypeMayHaveSideEffects(node)) break;
                Node node8 = null;
                Node node9 = node.getFirstChild();
                while (node9 != null) {
                    Node node10 = node9.getNext();
                    if ((node9 = this.trySimpilifyUnusedResult(node9)) != null) {
                        node9.detachFromParent();
                        node8 = node8 == null ? node9 : new Node(85, node8, node9).copyInformationFrom(node9);
                    }
                    node9 = node10;
                }
                node3 = node8;
            }
        }
        if (node != node3) {
            node2 = node.getParent();
            if (node3 == null) {
                if (bl) {
                    node2.removeChild(node);
                } else {
                    node3 = new Node(124).copyInformationFrom(node);
                    node2.replaceChild(node, node3);
                }
            } else {
                if (node3.getParent() != null) {
                    node3.detachFromParent();
                }
                node.getParent().replaceChild(node, node3);
            }
            this.reportCodeChange();
        }
        return node3;
    }

    private Node tryOptimizeSwitch(Node node) {
        Node node2;
        Node node3;
        Node node4;
        Preconditions.checkState((node.getType() == 110 ? 1 : 0) != 0);
        Node node5 = this.tryOptimizeDefaultCase(node);
        if (node5 == null) {
            node4 = null;
            node3 = null;
            node2 = node.getFirstChild().getNext();
            while (node2 != null) {
                node4 = node2.getNext();
                if (!this.mayHaveSideEffects(node2.getFirstChild()) && this.isUselessCase(node2, node3)) {
                    this.removeCase(node, node2);
                } else {
                    node3 = node2;
                }
                node2 = node4;
            }
        }
        if (node.hasOneChild()) {
            node4 = node.removeFirstChild();
            node3 = node.getParent();
            node2 = new Node(130, node4).copyInformationFrom(node);
            node3.replaceChild(node, node2);
            this.reportCodeChange();
            return node2;
        }
        return null;
    }

    private Node tryOptimizeDefaultCase(Node node) {
        Preconditions.checkState((node.getType() == 110 ? 1 : 0) != 0);
        Node node2 = node.getFirstChild();
        for (Node node3 = node.getFirstChild().getNext(); node3 != null; node3 = node3.getNext()) {
            if (node3.getType() == 112) {
                Node node4;
                Node node5 = node2.getNext();
                while (node5 != node3) {
                    node4 = node5.getNext();
                    this.removeCase(node, node5);
                    node5 = node4;
                }
                Node node6 = node4 = node2 == node.getFirstChild() ? null : node2;
                if (this.isUselessCase(node3, node4)) {
                    this.removeCase(node, node3);
                    return null;
                }
                return node3;
            }
            Preconditions.checkState((node3.getType() == 111 ? 1 : 0) != 0);
            if (!node3.getLastChild().hasChildren() && !this.mayHaveSideEffects(node3.getFirstChild())) continue;
            node2 = node3;
        }
        return null;
    }

    private void removeCase(Node node, Node node2) {
        NodeUtil.redeclareVarsInsideBranch(node2);
        node.removeChild(node2);
        this.reportCodeChange();
    }

    private boolean isUselessCase(Node node, @Nullable Node node2) {
        Node node3;
        Preconditions.checkState((node2 == null || node2.getNext() == node ? 1 : 0) != 0);
        Node node4 = node.getParent();
        if (!(node4.getLastChild() == node || node2 == null || (node3 = node2.getLastChild()).hasChildren() && this.isExit(node3.getLastChild()))) {
            return false;
        }
        node3 = node;
        while (node3 != null) {
            Preconditions.checkState((node3.getType() == 112 || node3.getType() == 111 ? 1 : 0) != 0);
            Preconditions.checkState((node == node3 || node3.getType() != 112 ? 1 : 0) != 0);
            Node node5 = node3.getLastChild();
            Preconditions.checkState((node5.getType() == 125 ? 1 : 0) != 0);
            if (node5.hasChildren()) {
                block5: for (Node node6 : node5.children()) {
                    int n = node6.getType();
                    switch (node6.getType()) {
                        case 116: {
                            return node6.getFirstChild() == null;
                        }
                        case 118: {
                            if (node6.hasOneChild() && node6.getFirstChild().getFirstChild() == null) continue block5;
                            return false;
                        }
                    }
                    return false;
                }
                continue;
            }
            node3 = node3.getNext();
        }
        return true;
    }

    private boolean isExit(Node node) {
        switch (node.getType()) {
            case 4: 
            case 49: 
            case 116: 
            case 117: {
                return true;
            }
        }
        return false;
    }

    private Node tryFoldComma(Node node) {
        Node node2 = node.getParent();
        Node node3 = node.getFirstChild();
        Node node4 = node3.getNext();
        if ((node3 = this.trySimpilifyUnusedResult(node3)) == null || !this.mayHaveSideEffects(node3)) {
            node.removeChild(node4);
            node2.replaceChild(node, node4);
            this.reportCodeChange();
            return node4;
        }
        return node;
    }

    Node tryOptimizeBlock(Node node) {
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            Node node3 = node2.getNext();
            if (!this.mayHaveSideEffects(node2) && !node2.isSyntheticBlock()) {
                node.removeChild(node2);
                this.reportCodeChange();
            } else {
                this.tryOptimizeConditionalAfterAssign(node2);
            }
            node2 = node3;
        }
        if (node.isSyntheticBlock() || node.getParent() == null) {
            return node;
        }
        if (NodeUtil.tryMergeBlock(node)) {
            this.reportCodeChange();
            return null;
        }
        return node;
    }

    private void tryOptimizeConditionalAfterAssign(Node node) {
        Node node2 = node.getNext();
        if (this.isSimpleAssignment(node) && this.isConditionalStatement(node2)) {
            Node node3;
            TernaryValue ternaryValue;
            Node node4 = this.getSimpleAssignmentName(node);
            Node node5 = this.getConditionalStatementCondition(node2);
            if (NodeUtil.isName(node4) && NodeUtil.isName(node5) && node4.getString().equals(node5.getString()) && (ternaryValue = NodeUtil.getImpureBooleanValue(node3 = this.getSimpleAssignmentValue(node))) != TernaryValue.UNKNOWN) {
                int n = ternaryValue.toBoolean(true) ? 44 : 43;
                node5.getParent().replaceChild(node5, new Node(n));
                this.reportCodeChange();
            }
        }
    }

    private boolean isSimpleAssignment(Node node) {
        if (NodeUtil.isExprAssign(node) && NodeUtil.isName(node.getFirstChild().getFirstChild())) {
            return true;
        }
        return node.getType() == 118 && node.hasOneChild() && node.getFirstChild().getFirstChild() != null;
    }

    private Node getSimpleAssignmentName(Node node) {
        Preconditions.checkState((boolean)this.isSimpleAssignment(node));
        if (NodeUtil.isExprAssign(node)) {
            return node.getFirstChild().getFirstChild();
        }
        return node.getFirstChild();
    }

    private Node getSimpleAssignmentValue(Node node) {
        Preconditions.checkState((boolean)this.isSimpleAssignment(node));
        return node.getFirstChild().getLastChild();
    }

    private boolean isConditionalStatement(Node node) {
        return node != null && (node.getType() == 108 || this.isExprConditional(node));
    }

    private boolean isExprConditional(Node node) {
        if (node.getType() == 130) {
            switch (node.getFirstChild().getType()) {
                case 98: 
                case 100: 
                case 101: {
                    return true;
                }
            }
        }
        return false;
    }

    private Node getConditionalStatementCondition(Node node) {
        if (node.getType() == 108) {
            return NodeUtil.getConditionExpression(node);
        }
        Preconditions.checkState((boolean)this.isExprConditional(node));
        return node.getFirstChild().getFirstChild();
    }

    private Node tryFoldIf(Node node) {
        Node node2;
        Node node3;
        boolean bl;
        Object object;
        Preconditions.checkState((node.getType() == 108 ? 1 : 0) != 0);
        Node node4 = node.getParent();
        Preconditions.checkNotNull((Object)node4);
        int n = node.getType();
        Object object2 = node.getFirstChild();
        Node node5 = ((Node)object2).getNext();
        Node node6 = node5.getNext();
        if (node6 != null && !this.mayHaveSideEffects(node6)) {
            node.removeChild(node6);
            node6 = null;
            this.reportCodeChange();
        }
        if (!this.mayHaveSideEffects(node5) && node6 != null) {
            node.removeChild(node6);
            node.replaceChild(node5, node6);
            object = new Node(26);
            node.replaceChild((Node)object2, (Node)object);
            ((Node)object).addChildToFront((Node)object2);
            object2 = object;
            node5 = ((Node)object2).getNext();
            node6 = null;
            this.reportCodeChange();
        }
        if (!this.mayHaveSideEffects(node5) && node6 == null) {
            if (this.mayHaveSideEffects((Node)object2)) {
                node.removeChild((Node)object2);
                object = NodeUtil.newExpr((Node)object2);
                node4.replaceChild(node, (Node)object);
                this.reportCodeChange();
                return object;
            }
            NodeUtil.removeChild(node4, node);
            this.reportCodeChange();
            return null;
        }
        object = NodeUtil.getImpureBooleanValue((Node)object2);
        if (object == TernaryValue.UNKNOWN) {
            return node;
        }
        if (this.mayHaveSideEffects((Node)object2)) {
            boolean bl2 = bl = object == TernaryValue.TRUE;
            if (!bl && node6 == null) {
                node6 = new Node(125).copyInformationFrom(node);
                node.addChildToBack(node6);
            }
            node3 = new Node(bl ? 44 : 43);
            node.replaceChild((Node)object2, node3);
            node2 = bl ? node5 : node6;
            node2.addChildToFront(new Node(130, (Node)object2).copyInformationFrom((Node)object2));
            this.reportCodeChange();
            object2 = node3;
        }
        bl = object.toBoolean(true);
        if (node.getChildCount() == 2) {
            Preconditions.checkState((n == 108 ? 1 : 0) != 0);
            if (bl) {
                node3 = node.getFirstChild().getNext();
                node.removeChild(node3);
                node4.replaceChild(node, node3);
                this.reportCodeChange();
                return node3;
            }
            NodeUtil.redeclareVarsInsideBranch(node);
            NodeUtil.removeChild(node4, node);
            this.reportCodeChange();
            return null;
        }
        node3 = node.getFirstChild().getNext();
        node2 = node3.getNext();
        Node node7 = bl ? node3 : node2;
        Node node8 = bl ? node2 : node3;
        NodeUtil.redeclareVarsInsideBranch(node8);
        node.removeChild(node7);
        node4.replaceChild(node, node7);
        this.reportCodeChange();
        return node7;
    }

    private Node tryFoldHook(Node node) {
        Node node2;
        Node node3;
        Preconditions.checkState((node.getType() == 98 ? 1 : 0) != 0);
        Node node4 = node.getParent();
        Preconditions.checkNotNull((Object)node4);
        Node node5 = node.getFirstChild();
        Node node6 = node5.getNext();
        Node node7 = node6.getNext();
        TernaryValue ternaryValue = NodeUtil.getImpureBooleanValue(node5);
        if (ternaryValue == TernaryValue.UNKNOWN) {
            return node;
        }
        node.detachChildren();
        Node node8 = node3 = ternaryValue.toBoolean(true) ? node6 : node7;
        if (this.mayHaveSideEffects(node5)) {
            node2 = new Node(85).copyInformationFrom(node);
            node2.addChildToFront(node5);
            node2.addChildToBack(node3);
        } else {
            node2 = node3;
        }
        node4.replaceChild(node, node2);
        this.reportCodeChange();
        return node2;
    }

    Node tryFoldWhile(Node node) {
        Preconditions.checkArgument((node.getType() == 113 ? 1 : 0) != 0);
        Node node2 = NodeUtil.getConditionExpression(node);
        if (NodeUtil.getPureBooleanValue(node2) != TernaryValue.FALSE) {
            return node;
        }
        NodeUtil.redeclareVarsInsideBranch(node);
        NodeUtil.removeChild(node.getParent(), node);
        this.reportCodeChange();
        return null;
    }

    Node tryFoldFor(Node node) {
        Preconditions.checkArgument((node.getType() == 115 ? 1 : 0) != 0);
        if (NodeUtil.isForIn(node)) {
            return node;
        }
        Node node2 = node.getFirstChild();
        Node node3 = node2.getNext();
        Node node4 = node3.getNext();
        if (node2.getType() != 124 && node2.getType() != 118) {
            node2 = this.trySimpilifyUnusedResult(node2, false);
        }
        if (node4.getType() != 124) {
            node4 = this.trySimpilifyUnusedResult(node4, false);
        }
        if (node.getFirstChild().getType() != 124) {
            return node;
        }
        if (NodeUtil.getImpureBooleanValue(node3) != TernaryValue.FALSE) {
            return node;
        }
        NodeUtil.redeclareVarsInsideBranch(node);
        if (!this.mayHaveSideEffects(node3)) {
            NodeUtil.removeChild(node.getParent(), node);
        } else {
            Node node5 = new Node(130, node3.detachFromParent()).copyInformationFrom(node3);
            node.getParent().replaceChild(node, node5);
        }
        this.reportCodeChange();
        return null;
    }

    Node tryFoldDo(Node node) {
        Preconditions.checkArgument((node.getType() == 114 ? 1 : 0) != 0);
        Node node2 = NodeUtil.getConditionExpression(node);
        if (NodeUtil.getImpureBooleanValue(node2) != TernaryValue.FALSE) {
            return node;
        }
        if (this.hasBreakOrContinue(node)) {
            return node;
        }
        Preconditions.checkState((boolean)NodeUtil.isControlStructureCodeBlock(node, node.getFirstChild()));
        Node node3 = node.removeFirstChild();
        Node node4 = node.getParent();
        node4.replaceChild(node, node3);
        if (this.mayHaveSideEffects(node2)) {
            Node node5 = new Node(130, node2.detachFromParent()).copyInformationFrom(node2);
            node4.addChildAfter(node5, node3);
        }
        this.reportCodeChange();
        return node;
    }

    boolean hasBreakOrContinue(Node node) {
        return NodeUtil.has(node, (Predicate<Node>)Predicates.or((Predicate)new NodeUtil.MatchNodeType(116), (Predicate)new NodeUtil.MatchNodeType(117)), new NodeUtil.MatchNotFunction());
    }

    private void tryFoldForCondition(Node node) {
        if (NodeUtil.getPureBooleanValue(node) == TernaryValue.TRUE) {
            node.getParent().replaceChild(node, new Node(124));
            this.reportCodeChange();
        }
    }
}

