/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.GlobalNamespace;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import java.text.MessageFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ProcessDefines
implements CompilerPass {
    private static final Set<String> KNOWN_DEFINES = Sets.newHashSet((Object[])new String[]{"COMPILED"});
    private final AbstractCompiler compiler;
    private final Map<String, Node> dominantReplacements;
    private GlobalNamespace namespace = null;
    static final DiagnosticType UNKNOWN_DEFINE_WARNING = DiagnosticType.warning("JSC_UNKNOWN_DEFINE_WARNING", "unknown @define variable {0}");
    static final DiagnosticType INVALID_DEFINE_TYPE_ERROR = DiagnosticType.error("JSC_INVALID_DEFINE_INIT_ERROR", "@define tag only permits literal types");
    static final DiagnosticType INVALID_DEFINE_INIT_ERROR = DiagnosticType.error("JSC_INVALID_DEFINE_INIT_ERROR", "illegal initialization of @define variable {0}");
    static final DiagnosticType NON_GLOBAL_DEFINE_INIT_ERROR = DiagnosticType.error("JSC_NON_GLOBAL_DEFINE_INIT_ERROR", "@define variable {0} assignment must be global");
    static final DiagnosticType DEFINE_NOT_ASSIGNABLE_ERROR = DiagnosticType.error("@define variable cannot be assigned here", "@define variable {0} cannot be assigned due to unsafe code at {1}.");
    private static final MessageFormat REASON_DEFINE_NOT_ASSIGNABLE = new MessageFormat("line {0} of {1}");

    ProcessDefines(AbstractCompiler abstractCompiler, Map<String, Node> map) {
        this.compiler = abstractCompiler;
        this.dominantReplacements = map;
    }

    ProcessDefines injectNamespace(GlobalNamespace globalNamespace) {
        this.namespace = globalNamespace;
        return this;
    }

    @Override
    public void process(Node node, Node node2) {
        if (this.namespace == null) {
            this.namespace = new GlobalNamespace(this.compiler, node2);
        }
        this.overrideDefines(this.collectDefines(node2, this.namespace));
    }

    private void overrideDefines(Map<String, DefineInfo> map) {
        String string;
        boolean bl = false;
        for (Map.Entry<String, DefineInfo> object2 : map.entrySet()) {
            string = object2.getKey();
            DefineInfo defineInfo = object2.getValue();
            Node node = this.dominantReplacements.get(string);
            Node node2 = node != null ? node : defineInfo.getLastValue();
            if (node2 == defineInfo.initialValue) continue;
            defineInfo.initialValueParent.replaceChild(defineInfo.initialValue, node2.cloneTree());
            this.compiler.addToDebugLog("Overriding @define variable " + string);
            bl = bl || node2.getType() != defineInfo.initialValue.getType() || !node2.isEquivalentTo(defineInfo.initialValue);
        }
        if (bl) {
            this.compiler.reportCodeChange();
        }
        Set<String> set = this.dominantReplacements.keySet();
        set.removeAll(map.keySet());
        set.removeAll(KNOWN_DEFINES);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            this.compiler.report(JSError.make(UNKNOWN_DEFINE_WARNING, string));
        }
    }

    private static String format(MessageFormat messageFormat, Object ... objectArray) {
        return messageFormat.format(objectArray);
    }

    private boolean isValidDefineType(JSTypeExpression jSTypeExpression) {
        JSType jSType = jSTypeExpression.evaluate(null, this.compiler.getTypeRegistry());
        return !jSType.isUnknownType() && jSType.isSubtype(this.compiler.getTypeRegistry().getNativeType(JSTypeNative.NUMBER_STRING_BOOLEAN));
    }

    private Map<String, DefineInfo> collectDefines(Node node, GlobalNamespace globalNamespace) {
        ArrayList arrayList = Lists.newArrayList();
        block0: for (GlobalNamespace.Name name : globalNamespace.getNameIndex().values()) {
            if (name.docInfo != null && name.docInfo.isDefine()) {
                if (this.isValidDefineType(name.docInfo.getType())) {
                    arrayList.add(name);
                    continue;
                }
                JSError jSError = JSError.make(name.declaration.getSourceName(), name.declaration.node, INVALID_DEFINE_TYPE_ERROR, new String[0]);
                this.compiler.report(jSError);
                continue;
            }
            for (GlobalNamespace.Ref ref : name.getRefs()) {
                if (ref == name.declaration) continue;
                Node node2 = ref.node;
                Node node3 = ref.node.getParent();
                JSDocInfo jSDocInfo = node2.getJSDocInfo();
                if (jSDocInfo == null && node3.getType() == 118 && node3.hasOneChild()) {
                    jSDocInfo = node3.getJSDocInfo();
                }
                if (jSDocInfo == null || !jSDocInfo.isDefine()) continue;
                arrayList.add(name);
                continue block0;
            }
        }
        CollectDefines collectDefines = new CollectDefines(this.compiler, arrayList);
        NodeTraversal.traverse(this.compiler, node, collectDefines);
        return collectDefines.getAllDefines();
    }

    private static final class DefineInfo {
        public final Node initialValueParent;
        public final Node initialValue;
        private Node lastValue;
        private boolean isAssignable;
        private String reasonNotAssignable;

        public DefineInfo(Node node, Node node2) {
            this.initialValueParent = node2;
            this.initialValue = node;
            this.lastValue = node;
            this.isAssignable = true;
        }

        public void setNotAssignable(String string) {
            this.isAssignable = false;
            this.reasonNotAssignable = string;
        }

        public String getReasonWhyNotAssignable() {
            return this.reasonNotAssignable;
        }

        public boolean recordAssignment(Node node) {
            this.lastValue = node;
            return this.isAssignable;
        }

        public Node getLastValue() {
            return this.lastValue;
        }
    }

    private static final class CollectDefines
    implements NodeTraversal.Callback {
        private final AbstractCompiler compiler;
        private final Map<String, DefineInfo> assignableDefines;
        private final Map<String, DefineInfo> allDefines;
        private final Map<Node, RefInfo> allRefInfo;
        private Node lvalueToRemoveLater = null;
        private final Deque<Integer> assignAllowed;

        CollectDefines(AbstractCompiler abstractCompiler, List<GlobalNamespace.Name> list) {
            this.compiler = abstractCompiler;
            this.allDefines = Maps.newHashMap();
            this.assignableDefines = Maps.newHashMap();
            this.assignAllowed = new ArrayDeque<Integer>();
            this.assignAllowed.push(1);
            this.allRefInfo = Maps.newHashMap();
            for (GlobalNamespace.Name name : list) {
                if (name.declaration != null) {
                    this.allRefInfo.put(name.declaration.node, new RefInfo(name.declaration, name));
                }
                for (GlobalNamespace.Ref ref : name.getRefs()) {
                    if (ref == name.declaration || ref.getTwin() != null && ref.getTwin().isSet()) continue;
                    this.allRefInfo.put(ref.node, new RefInfo(ref, name));
                }
            }
        }

        Map<String, DefineInfo> getAllDefines() {
            return this.allDefines;
        }

        @Override
        public boolean shouldTraverse(NodeTraversal nodeTraversal, Node node, Node node2) {
            this.updateAssignAllowedStack(node, true);
            return true;
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            Iterator<DefineInfo> iterator;
            RefInfo refInfo = this.allRefInfo.get(node);
            if (refInfo != null) {
                iterator = refInfo.ref;
                GlobalNamespace.Name object = refInfo.name;
                String string = object.fullName();
                switch (((GlobalNamespace.Ref)((Object)iterator)).type) {
                    case SET_FROM_GLOBAL: 
                    case SET_FROM_LOCAL: {
                        Node node3 = CollectDefines.getValueParent((GlobalNamespace.Ref)((Object)iterator));
                        Node node4 = node3.getLastChild();
                        if (node3.getType() == 86 && object.isSimpleName() && object.declaration == iterator) {
                            this.compiler.report(nodeTraversal.makeError(node4, INVALID_DEFINE_INIT_ERROR, string));
                            break;
                        }
                        if (!this.processDefineAssignment(nodeTraversal, string, node4, node3)) break;
                        refInfo.name.removeRef((GlobalNamespace.Ref)((Object)iterator));
                        this.lvalueToRemoveLater = node3;
                        break;
                    }
                    default: {
                        DefineInfo defineInfo;
                        if (!nodeTraversal.inGlobalScope() || (defineInfo = this.assignableDefines.get(string)) == null) break;
                        this.setDefineInfoNotAssignable(defineInfo, nodeTraversal);
                        this.assignableDefines.remove(string);
                    }
                }
            }
            if (!nodeTraversal.inGlobalScope() && node.getJSDocInfo() != null && node.getJSDocInfo().isDefine()) {
                this.compiler.report(nodeTraversal.makeError(node, NON_GLOBAL_DEFINE_INIT_ERROR, ""));
            }
            if (this.lvalueToRemoveLater == node) {
                this.lvalueToRemoveLater = null;
                if (node.getType() == 86) {
                    iterator = node.getLastChild();
                    node.removeChild((Node)((Object)iterator));
                    node2.replaceChild(node, (Node)((Object)iterator));
                } else {
                    Preconditions.checkState((node.getType() == 38 ? 1 : 0) != 0);
                    node.removeChild(node.getFirstChild());
                }
                this.compiler.reportCodeChange();
            }
            if (node.getType() == 37 && nodeTraversal.inGlobalScope()) {
                for (DefineInfo defineInfo : this.assignableDefines.values()) {
                    this.setDefineInfoNotAssignable(defineInfo, nodeTraversal);
                }
                this.assignableDefines.clear();
            }
            this.updateAssignAllowedStack(node, false);
        }

        private void updateAssignAllowedStack(Node node, boolean bl) {
            switch (node.getType()) {
                case 98: 
                case 105: 
                case 108: 
                case 110: 
                case 111: 
                case 113: 
                case 115: {
                    if (bl) {
                        this.assignAllowed.push(0);
                        break;
                    }
                    this.assignAllowed.remove();
                }
            }
        }

        private boolean isAssignAllowed() {
            return this.assignAllowed.element() == 1;
        }

        private boolean processDefineAssignment(NodeTraversal nodeTraversal, String string, Node node, Node node2) {
            if (node == null || !NodeUtil.isValidDefineValue(node, this.allDefines.keySet())) {
                this.compiler.report(nodeTraversal.makeError(node, INVALID_DEFINE_INIT_ERROR, string));
            } else if (!this.isAssignAllowed()) {
                this.compiler.report(nodeTraversal.makeError(node2, NON_GLOBAL_DEFINE_INIT_ERROR, string));
            } else {
                DefineInfo defineInfo = this.allDefines.get(string);
                if (defineInfo == null) {
                    defineInfo = new DefineInfo(node, node2);
                    this.allDefines.put(string, defineInfo);
                    this.assignableDefines.put(string, defineInfo);
                } else {
                    if (defineInfo.recordAssignment(node)) {
                        return true;
                    }
                    this.compiler.report(nodeTraversal.makeError(node2, DEFINE_NOT_ASSIGNABLE_ERROR, string, defineInfo.getReasonWhyNotAssignable()));
                }
            }
            return false;
        }

        private static Node getValueParent(GlobalNamespace.Ref ref) {
            return ref.node.getParent() != null && ref.node.getParent().getType() == 118 ? ref.node : ref.node.getParent();
        }

        private void setDefineInfoNotAssignable(DefineInfo defineInfo, NodeTraversal nodeTraversal) {
            defineInfo.setNotAssignable(ProcessDefines.format(REASON_DEFINE_NOT_ASSIGNABLE, new Object[]{nodeTraversal.getLineNumber(), nodeTraversal.getSourceName()}));
        }

        private static class RefInfo {
            final GlobalNamespace.Ref ref;
            final GlobalNamespace.Name name;

            RefInfo(GlobalNamespace.Ref ref, GlobalNamespace.Name name) {
                this.ref = ref;
                this.name = name;
            }
        }
    }
}

