/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Function;
import com.google.javascript.jscomp.ChainableReverseAbstractInterpreter;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.FlowScope;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.StaticSlot;
import com.google.javascript.rhino.jstype.UnionType;

class SemanticReverseAbstractInterpreter
extends ChainableReverseAbstractInterpreter {
    private static final Function<JSType.TypePair, JSType.TypePair> EQ = new Function<JSType.TypePair, JSType.TypePair>(){

        public JSType.TypePair apply(JSType.TypePair typePair) {
            if (typePair.typeA == null || typePair.typeB == null) {
                return null;
            }
            return typePair.typeA.getTypesUnderEquality(typePair.typeB);
        }
    };
    private static final Function<JSType.TypePair, JSType.TypePair> NE = new Function<JSType.TypePair, JSType.TypePair>(){

        public JSType.TypePair apply(JSType.TypePair typePair) {
            if (typePair.typeA == null || typePair.typeB == null) {
                return null;
            }
            return typePair.typeA.getTypesUnderInequality(typePair.typeB);
        }
    };
    private static final Function<JSType.TypePair, JSType.TypePair> SHEQ = new Function<JSType.TypePair, JSType.TypePair>(){

        public JSType.TypePair apply(JSType.TypePair typePair) {
            if (typePair.typeA == null || typePair.typeB == null) {
                return null;
            }
            return typePair.typeA.getTypesUnderShallowEquality(typePair.typeB);
        }
    };
    private static final Function<JSType.TypePair, JSType.TypePair> SHNE = new Function<JSType.TypePair, JSType.TypePair>(){

        public JSType.TypePair apply(JSType.TypePair typePair) {
            if (typePair.typeA == null || typePair.typeB == null) {
                return null;
            }
            return typePair.typeA.getTypesUnderShallowInequality(typePair.typeB);
        }
    };
    private final Function<JSType.TypePair, JSType.TypePair> INEQ = new Function<JSType.TypePair, JSType.TypePair>(){

        public JSType.TypePair apply(JSType.TypePair typePair) {
            return new JSType.TypePair(SemanticReverseAbstractInterpreter.this.getRestrictedWithoutUndefined(typePair.typeA), SemanticReverseAbstractInterpreter.this.getRestrictedWithoutUndefined(typePair.typeB));
        }
    };

    SemanticReverseAbstractInterpreter(CodingConvention codingConvention, JSTypeRegistry jSTypeRegistry) {
        super(codingConvention, jSTypeRegistry);
    }

    @Override
    public FlowScope getPreciserScopeKnowingConditionOutcome(Node node, FlowScope flowScope, boolean bl) {
        Node node2;
        Node node3;
        int n = node.getType();
        switch (n) {
            case 12: 
            case 13: 
            case 45: 
            case 46: 
            case 111: {
                boolean bl2;
                Node node4;
                JSType jSType;
                if (n == 111) {
                    node3 = node.getParent().getFirstChild();
                    node2 = node.getFirstChild();
                } else {
                    node3 = node.getFirstChild();
                    node2 = node.getLastChild();
                }
                Node node5 = null;
                Node node6 = null;
                if (node3.getType() == 32 && node2.getType() == 40) {
                    node5 = node3;
                    node6 = node2;
                } else if (node2.getType() == 32 && node3.getType() == 40) {
                    node5 = node2;
                    node6 = node3;
                }
                if (node5 == null || node6 == null || (jSType = this.getTypeIfRefinable(node4 = node5.getFirstChild(), flowScope)) == null) break;
                boolean bl3 = bl2 = n == 12 || n == 45 || n == 111;
                if (!bl) {
                    bl2 = !bl2;
                }
                return this.caseTypeOf(node4, jSType, node6.getString(), bl2, flowScope);
            }
        }
        switch (n) {
            case 101: {
                if (bl) {
                    return this.caseAndOrNotShortCircuiting(node.getFirstChild(), node.getLastChild(), flowScope, true);
                }
                return this.caseAndOrMaybeShortCircuiting(node.getFirstChild(), node.getLastChild(), flowScope, true);
            }
            case 100: {
                if (!bl) {
                    return this.caseAndOrNotShortCircuiting(node.getFirstChild(), node.getLastChild(), flowScope, false);
                }
                return this.caseAndOrMaybeShortCircuiting(node.getFirstChild(), node.getLastChild(), flowScope, false);
            }
            case 12: {
                if (bl) {
                    return this.caseEquality(node, flowScope, EQ);
                }
                return this.caseEquality(node, flowScope, NE);
            }
            case 13: {
                if (bl) {
                    return this.caseEquality(node, flowScope, NE);
                }
                return this.caseEquality(node, flowScope, EQ);
            }
            case 45: {
                if (bl) {
                    return this.caseEquality(node, flowScope, SHEQ);
                }
                return this.caseEquality(node, flowScope, SHNE);
            }
            case 46: {
                if (bl) {
                    return this.caseEquality(node, flowScope, SHNE);
                }
                return this.caseEquality(node, flowScope, SHEQ);
            }
            case 33: 
            case 38: {
                return this.caseNameOrGetProp(node, flowScope, bl);
            }
            case 86: {
                return this.firstPreciserScopeKnowingConditionOutcome(node.getFirstChild(), this.firstPreciserScopeKnowingConditionOutcome(node.getFirstChild().getNext(), flowScope, bl), bl);
            }
            case 26: {
                return this.firstPreciserScopeKnowingConditionOutcome(node.getFirstChild(), flowScope, !bl);
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                if (!bl) break;
                return this.caseEquality(node, flowScope, this.INEQ);
            }
            case 52: {
                return this.caseInstanceOf(node.getFirstChild(), node.getLastChild(), flowScope, bl);
            }
            case 51: {
                if (!bl || node.getFirstChild().getType() != 40) break;
                return this.caseIn(node.getLastChild(), node.getFirstChild().getString(), flowScope);
            }
            case 111: {
                node3 = node.getParent().getFirstChild();
                node2 = node.getFirstChild();
                if (bl) {
                    return this.caseEquality(node3, node2, flowScope, SHEQ);
                }
                return this.caseEquality(node3, node2, flowScope, SHNE);
            }
        }
        return this.nextPreciserScopeKnowingConditionOutcome(node, flowScope, bl);
    }

    private FlowScope caseEquality(Node node, FlowScope flowScope, Function<JSType.TypePair, JSType.TypePair> function) {
        return this.caseEquality(node.getFirstChild(), node.getLastChild(), flowScope, function);
    }

    private FlowScope caseEquality(Node node, Node node2, FlowScope flowScope, Function<JSType.TypePair, JSType.TypePair> function) {
        boolean bl;
        boolean bl2;
        JSType jSType = this.getTypeIfRefinable(node, flowScope);
        if (jSType != null) {
            bl2 = true;
        } else {
            bl2 = false;
            jSType = node.getJSType();
        }
        JSType jSType2 = this.getTypeIfRefinable(node2, flowScope);
        if (jSType2 != null) {
            bl = true;
        } else {
            bl = false;
            jSType2 = node2.getJSType();
        }
        JSType.TypePair typePair = (JSType.TypePair)function.apply((Object)new JSType.TypePair(jSType, jSType2));
        if (typePair != null && (bl2 && typePair.typeA != null || bl && typePair.typeB != null)) {
            FlowScope flowScope2 = flowScope.createChildFlowScope();
            if (bl2 && typePair.typeA != null) {
                this.declareNameInScope(flowScope2, node, typePair.typeA);
            }
            if (bl && typePair.typeB != null) {
                this.declareNameInScope(flowScope2, node2, typePair.typeB);
            }
            return flowScope2;
        }
        return flowScope;
    }

    private FlowScope caseAndOrNotShortCircuiting(Node node, Node node2, FlowScope flowScope, boolean bl) {
        boolean bl2;
        boolean bl3;
        JSType jSType = this.getTypeIfRefinable(node, flowScope);
        if (jSType != null) {
            bl3 = true;
        } else {
            bl3 = false;
            jSType = node.getJSType();
            flowScope = this.firstPreciserScopeKnowingConditionOutcome(node, flowScope, bl);
        }
        JSType jSType2 = jSType = jSType == null ? null : jSType.getRestrictedTypeGivenToBooleanOutcome(bl);
        if (jSType == null) {
            return this.firstPreciserScopeKnowingConditionOutcome(node2, flowScope, bl);
        }
        JSType jSType3 = this.getTypeIfRefinable(node2, flowScope);
        if (jSType3 != null) {
            bl2 = true;
        } else {
            bl2 = false;
            jSType3 = node2.getJSType();
            flowScope = this.firstPreciserScopeKnowingConditionOutcome(node2, flowScope, bl);
        }
        if (bl) {
            JSType jSType4 = jSType3 = jSType3 == null ? null : jSType3.getRestrictedTypeGivenToBooleanOutcome(bl);
            if (jSType != null && bl3 || jSType3 != null && bl2) {
                FlowScope flowScope2 = flowScope.createChildFlowScope();
                if (bl3 && jSType != null) {
                    this.declareNameInScope(flowScope2, node, jSType);
                }
                if (bl2 && jSType3 != null) {
                    this.declareNameInScope(flowScope2, node2, jSType3);
                }
                return flowScope2;
            }
        }
        return flowScope;
    }

    private FlowScope caseAndOrMaybeShortCircuiting(Node node, Node node2, FlowScope flowScope, boolean bl) {
        FlowScope flowScope2 = this.firstPreciserScopeKnowingConditionOutcome(node, flowScope, !bl);
        StaticSlot<JSType> staticSlot = flowScope2.findUniqueRefinedSlot(flowScope);
        if (staticSlot == null) {
            return flowScope;
        }
        FlowScope flowScope3 = this.firstPreciserScopeKnowingConditionOutcome(node, flowScope, bl);
        StaticSlot<JSType> staticSlot2 = (flowScope3 = this.firstPreciserScopeKnowingConditionOutcome(node2, flowScope3, !bl)).findUniqueRefinedSlot(flowScope);
        if (staticSlot2 == null || !staticSlot.getName().equals(staticSlot2.getName())) {
            return flowScope;
        }
        JSType jSType = staticSlot.getType().getLeastSupertype(staticSlot2.getType());
        FlowScope flowScope4 = flowScope.createChildFlowScope();
        flowScope4.inferSlotType(staticSlot.getName(), jSType);
        return flowScope4;
    }

    private FlowScope caseNameOrGetProp(Node node, FlowScope flowScope, boolean bl) {
        JSType jSType = this.getTypeIfRefinable(node, flowScope);
        if (jSType != null) {
            JSType jSType2 = jSType.getRestrictedTypeGivenToBooleanOutcome(bl);
            FlowScope flowScope2 = flowScope.createChildFlowScope();
            this.declareNameInScope(flowScope2, node, jSType2);
            return flowScope2;
        }
        return flowScope;
    }

    private FlowScope caseTypeOf(Node node, JSType jSType, String string, boolean bl, FlowScope flowScope) {
        JSType jSType2 = this.getRestrictedByTypeOfResult(jSType, string, bl);
        if (jSType2 == null) {
            return flowScope;
        }
        FlowScope flowScope2 = flowScope.createChildFlowScope();
        this.declareNameInScope(flowScope2, node, jSType2);
        return flowScope2;
    }

    private FlowScope caseInstanceOf(Node node, Node node2, FlowScope flowScope, boolean bl) {
        ChainableReverseAbstractInterpreter.RestrictByTypeOfResultVisitor restrictByTypeOfResultVisitor;
        JSType jSType;
        JSType jSType2 = this.getTypeIfRefinable(node, flowScope);
        if (jSType2 == null) {
            return flowScope;
        }
        JSType jSType3 = node2.getJSType();
        ObjectType objectType = this.typeRegistry.getNativeObjectType(JSTypeNative.UNKNOWN_TYPE);
        if (jSType3 instanceof FunctionType) {
            objectType = (FunctionType)jSType3;
        }
        if ((jSType = jSType2.visit(restrictByTypeOfResultVisitor = bl ? new RestrictByTrueInstanceOfResultVisitor(objectType) : new RestrictByFalseInstanceOfResultVisitor(objectType))) != null && !jSType.equals(jSType2)) {
            FlowScope flowScope2 = flowScope.createChildFlowScope();
            this.declareNameInScope(flowScope2, node, jSType);
            return flowScope2;
        }
        return flowScope;
    }

    private FlowScope caseIn(Node node, String string, FlowScope flowScope) {
        String string2;
        String string3;
        JSType jSType = node.getJSType();
        jSType = this.getRestrictedWithoutNull(jSType);
        jSType = this.getRestrictedWithoutUndefined(jSType);
        boolean bl = false;
        ObjectType objectType = ObjectType.cast(jSType);
        if (objectType != null) {
            bl = objectType.hasProperty(string);
        }
        if (!bl && (string3 = node.getQualifiedName()) != null && flowScope.getSlot(string2 = string3 + "." + string) == null) {
            FlowScope flowScope2 = flowScope.createChildFlowScope();
            JSType jSType2 = this.typeRegistry.getNativeType(JSTypeNative.UNKNOWN_TYPE);
            flowScope2.inferQualifiedSlot(string2, jSType2, jSType2);
            return flowScope2;
        }
        return flowScope;
    }

    private class RestrictByFalseInstanceOfResultVisitor
    extends ChainableReverseAbstractInterpreter.RestrictByFalseTypeOfResultVisitor {
        private final ObjectType target;

        RestrictByFalseInstanceOfResultVisitor(ObjectType objectType) {
            this.target = objectType;
        }

        @Override
        public JSType caseObjectType(ObjectType objectType) {
            if (this.target.isUnknownType()) {
                return objectType;
            }
            FunctionType functionType = (FunctionType)this.target;
            if (functionType.hasInstanceType()) {
                if (objectType.isSubtype(functionType.getInstanceType())) {
                    return null;
                }
                return objectType;
            }
            return null;
        }

        @Override
        public JSType caseUnionType(UnionType unionType) {
            if (this.target.isUnknownType()) {
                return unionType;
            }
            FunctionType functionType = (FunctionType)this.target;
            if (functionType.hasInstanceType()) {
                return unionType.getRestrictedUnion(functionType.getInstanceType());
            }
            return null;
        }

        @Override
        public JSType caseFunctionType(FunctionType functionType) {
            return this.caseObjectType(functionType);
        }
    }

    private class RestrictByTrueInstanceOfResultVisitor
    extends ChainableReverseAbstractInterpreter.RestrictByTrueTypeOfResultVisitor {
        private final ObjectType target;

        RestrictByTrueInstanceOfResultVisitor(ObjectType objectType) {
            this.target = objectType;
        }

        @Override
        protected JSType caseTopType(JSType jSType) {
            return this.applyCommonRestriction(jSType);
        }

        @Override
        public JSType caseUnknownType() {
            FunctionType functionType;
            if (this.target instanceof FunctionType && (functionType = (FunctionType)this.target).hasInstanceType()) {
                return functionType.getInstanceType();
            }
            return SemanticReverseAbstractInterpreter.this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        }

        @Override
        public JSType caseObjectType(ObjectType objectType) {
            return this.applyCommonRestriction(objectType);
        }

        @Override
        public JSType caseUnionType(UnionType unionType) {
            return this.applyCommonRestriction(unionType);
        }

        @Override
        public JSType caseFunctionType(FunctionType functionType) {
            return this.caseObjectType(functionType);
        }

        private JSType applyCommonRestriction(JSType jSType) {
            if (this.target.isUnknownType()) {
                return jSType;
            }
            FunctionType functionType = (FunctionType)this.target;
            if (functionType.hasInstanceType()) {
                return jSType.getGreatestSubtype(functionType.getInstanceType());
            }
            return null;
        }
    }
}

