/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.WarningsGuard;

public class ShowByPathWarningsGuard
extends WarningsGuard {
    private final String[] paths;
    private final ShowType showType;

    public ShowByPathWarningsGuard(String string) {
        this(string, ShowType.INCLUDE);
    }

    public ShowByPathWarningsGuard(String[] stringArray) {
        this(stringArray, ShowType.INCLUDE);
    }

    public ShowByPathWarningsGuard(String string, ShowType showType) {
        this(new String[]{string}, showType);
    }

    public ShowByPathWarningsGuard(String[] stringArray, ShowType showType) {
        Preconditions.checkArgument((stringArray != null ? 1 : 0) != 0);
        Preconditions.checkArgument((showType != null ? 1 : 0) != 0);
        this.paths = stringArray;
        this.showType = showType;
    }

    @Override
    public CheckLevel level(JSError jSError) {
        String string = jSError.sourceName;
        if (jSError.level != CheckLevel.ERROR && string != null) {
            boolean bl = false;
            for (String string2 : this.paths) {
                bl |= string.contains(string2);
            }
            if (bl ^ this.showType == ShowType.INCLUDE) {
                return CheckLevel.OFF;
            }
        }
        return null;
    }

    @Override
    protected int getPriority() {
        return WarningsGuard.Priority.FILTER_BY_PATH.value;
    }

    public static enum ShowType {
        INCLUDE,
        EXCLUDE;

    }
}

