/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractMessageFormatter;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.Region;
import com.google.javascript.jscomp.SourceExcerptProvider;
import com.google.javascript.jscomp.Strings;

class VerboseMessageFormatter
extends AbstractMessageFormatter {
    VerboseMessageFormatter(SourceExcerptProvider sourceExcerptProvider) {
        super(sourceExcerptProvider);
    }

    @Override
    public String formatError(JSError jSError) {
        return this.getLevelName(CheckLevel.ERROR) + ": " + this.format(jSError);
    }

    @Override
    public String formatWarning(JSError jSError) {
        return this.getLevelName(CheckLevel.WARNING) + ": " + this.format(jSError);
    }

    private String format(JSError jSError) {
        String string = jSError.description;
        String string2 = jSError.sourceName;
        int n = jSError.lineNumber;
        Region region = this.getSource().getSourceRegion(string2, n);
        String string3 = null;
        if (region != null) {
            string3 = region.getSourceExcerpt();
        }
        return String.format("%s at %s line %s %s", string, Strings.isEmpty(string2) ? "(unknown source)" : string2, n < 0 ? String.valueOf(n) : "(unknown line)", string3 != null ? ":\n\n" + string3 : ".");
    }
}

