/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeRegistry;

public class FunctionParamBuilder {
    private final JSTypeRegistry registry;
    private final Node root = new Node(83);

    public FunctionParamBuilder(JSTypeRegistry jSTypeRegistry) {
        this.registry = jSTypeRegistry;
    }

    public boolean addRequiredParams(JSType ... jSTypeArray) {
        if (this.hasOptionalOrVarArgs()) {
            return false;
        }
        for (JSType jSType : jSTypeArray) {
            this.newParameter(jSType);
        }
        return true;
    }

    public boolean addOptionalParams(JSType ... jSTypeArray) {
        if (this.hasVarArgs()) {
            return false;
        }
        for (JSType jSType : jSTypeArray) {
            this.newParameter(this.registry.createOptionalType(jSType)).setOptionalArg(true);
        }
        return true;
    }

    public boolean addVarArgs(JSType jSType) {
        if (this.hasVarArgs()) {
            return false;
        }
        if (!jSType.isEmptyType()) {
            jSType = this.registry.createOptionalType(jSType);
        }
        this.newParameter(jSType).setVarArgs(true);
        return true;
    }

    public Node newParameterFromNode(Node node) {
        Node node2 = this.newParameter(node.getJSType());
        node2.setVarArgs(node.isVarArgs());
        node2.setOptionalArg(node.isOptionalArg());
        return node2;
    }

    private Node newParameter(JSType jSType) {
        Node node = Node.newString(38, "");
        node.setJSType(jSType);
        this.root.addChildToBack(node);
        return node;
    }

    public Node build() {
        return this.root;
    }

    private boolean hasOptionalOrVarArgs() {
        Node node = this.root.getLastChild();
        return node != null && (node.isOptionalArg() || node.isVarArgs());
    }

    public boolean hasVarArgs() {
        Node node = this.root.getLastChild();
        return node != null && node.isVarArgs();
    }
}

