/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AliasExternals;
import com.google.javascript.jscomp.AliasKeywords;
import com.google.javascript.jscomp.AliasStrings;
import com.google.javascript.jscomp.AmbiguateProperties;
import com.google.javascript.jscomp.AnonymousFunctionNamingPolicy;
import com.google.javascript.jscomp.AstValidator;
import com.google.javascript.jscomp.ChainCalls;
import com.google.javascript.jscomp.CheckAccessControls;
import com.google.javascript.jscomp.CheckDebuggerStatement;
import com.google.javascript.jscomp.CheckGlobalNames;
import com.google.javascript.jscomp.CheckGlobalThis;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CheckMissingGetCssName;
import com.google.javascript.jscomp.CheckMissingReturn;
import com.google.javascript.jscomp.CheckProvides;
import com.google.javascript.jscomp.CheckRegExp;
import com.google.javascript.jscomp.CheckRequiresForConstructors;
import com.google.javascript.jscomp.CheckSideEffects;
import com.google.javascript.jscomp.CheckSuspiciousCode;
import com.google.javascript.jscomp.CheckUnreachableCode;
import com.google.javascript.jscomp.ClosureCodeRemoval;
import com.google.javascript.jscomp.ClosureOptimizePrimitives;
import com.google.javascript.jscomp.ClosureRewriteClass;
import com.google.javascript.jscomp.CoalesceVariableNames;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CollapseAnonymousFunctions;
import com.google.javascript.jscomp.CollapseProperties;
import com.google.javascript.jscomp.CollapseVariableDeclarations;
import com.google.javascript.jscomp.CombinedCompilerPass;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.ConstCheck;
import com.google.javascript.jscomp.ControlStructureCheck;
import com.google.javascript.jscomp.ConvertToDottedProperties;
import com.google.javascript.jscomp.CreateSyntheticBlocks;
import com.google.javascript.jscomp.CrossModuleCodeMotion;
import com.google.javascript.jscomp.CrossModuleMethodMotion;
import com.google.javascript.jscomp.CustomPassExecutionTime;
import com.google.javascript.jscomp.DeadAssignmentsElimination;
import com.google.javascript.jscomp.Denormalize;
import com.google.javascript.jscomp.DevirtualizePrototypeMethods;
import com.google.javascript.jscomp.DiagnosticGroups;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.DisambiguateProperties;
import com.google.javascript.jscomp.DotFormatter;
import com.google.javascript.jscomp.ErrorPass;
import com.google.javascript.jscomp.ExpandJqueryAliases;
import com.google.javascript.jscomp.ExploitAssigns;
import com.google.javascript.jscomp.ExportTestFunctions;
import com.google.javascript.jscomp.ExtractPrototypeMemberDeclarations;
import com.google.javascript.jscomp.FlowSensitiveInlineVariables;
import com.google.javascript.jscomp.FunctionNames;
import com.google.javascript.jscomp.FunctionRewriter;
import com.google.javascript.jscomp.GatherRawExports;
import com.google.javascript.jscomp.GenerateExports;
import com.google.javascript.jscomp.GlobalNamespace;
import com.google.javascript.jscomp.GoogleJsMessageIdGenerator;
import com.google.javascript.jscomp.GroupVariableDeclarations;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.IgnoreCajaProperties;
import com.google.javascript.jscomp.InlineFunctions;
import com.google.javascript.jscomp.InlineObjectLiterals;
import com.google.javascript.jscomp.InlineProperties;
import com.google.javascript.jscomp.InlineSimpleMethods;
import com.google.javascript.jscomp.InlineVariables;
import com.google.javascript.jscomp.InstrumentFunctions;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JsMessage;
import com.google.javascript.jscomp.MakeDeclaredNamesUnique;
import com.google.javascript.jscomp.MarkNoSideEffectCalls;
import com.google.javascript.jscomp.MinimizeExitPoints;
import com.google.javascript.jscomp.MoveFunctionDeclarations;
import com.google.javascript.jscomp.NameAnalyzer;
import com.google.javascript.jscomp.NameAnonymousFunctions;
import com.google.javascript.jscomp.NameAnonymousFunctionsMapped;
import com.google.javascript.jscomp.NameReferenceGraphConstruction;
import com.google.javascript.jscomp.NameReferenceGraphReport;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.ObjectPropertyStringPostprocess;
import com.google.javascript.jscomp.ObjectPropertyStringPreprocess;
import com.google.javascript.jscomp.OptimizeArgumentsArray;
import com.google.javascript.jscomp.OptimizeCalls;
import com.google.javascript.jscomp.OptimizeParameters;
import com.google.javascript.jscomp.OptimizeReturns;
import com.google.javascript.jscomp.PassConfig;
import com.google.javascript.jscomp.PassFactory;
import com.google.javascript.jscomp.PeepholeCollectPropertyAssignments;
import com.google.javascript.jscomp.PeepholeFoldConstants;
import com.google.javascript.jscomp.PeepholeOptimizationsPass;
import com.google.javascript.jscomp.PeepholeRemoveDeadCode;
import com.google.javascript.jscomp.PeepholeReplaceKnownMethods;
import com.google.javascript.jscomp.PeepholeSubstituteAlternateSyntax;
import com.google.javascript.jscomp.PreprocessorSymbolTable;
import com.google.javascript.jscomp.ProcessClosurePrimitives;
import com.google.javascript.jscomp.ProcessDefines;
import com.google.javascript.jscomp.ProcessTweaks;
import com.google.javascript.jscomp.PropertyRenamingPolicy;
import com.google.javascript.jscomp.PureFunctionIdentifier;
import com.google.javascript.jscomp.RemoveUnusedClassProperties;
import com.google.javascript.jscomp.RemoveUnusedPrototypeProperties;
import com.google.javascript.jscomp.RemoveUnusedVars;
import com.google.javascript.jscomp.RenameLabels;
import com.google.javascript.jscomp.RenameProperties;
import com.google.javascript.jscomp.RenamePrototypes;
import com.google.javascript.jscomp.RenameVars;
import com.google.javascript.jscomp.ReorderConstantExpression;
import com.google.javascript.jscomp.ReplaceCssNames;
import com.google.javascript.jscomp.ReplaceIdGenerators;
import com.google.javascript.jscomp.ReplaceMessages;
import com.google.javascript.jscomp.ReplaceMessagesForChrome;
import com.google.javascript.jscomp.ReplaceStrings;
import com.google.javascript.jscomp.RescopeGlobalSymbols;
import com.google.javascript.jscomp.RuntimeTypeCheck;
import com.google.javascript.jscomp.ScopedAliases;
import com.google.javascript.jscomp.SpecializeModule;
import com.google.javascript.jscomp.StatementFusion;
import com.google.javascript.jscomp.StrictModeCheck;
import com.google.javascript.jscomp.TightenTypes;
import com.google.javascript.jscomp.TypeCheck;
import com.google.javascript.jscomp.UnreachableCodeElimination;
import com.google.javascript.jscomp.VarCheck;
import com.google.javascript.jscomp.VariableMap;
import com.google.javascript.jscomp.VariableReferenceCheck;
import com.google.javascript.jscomp.VariableRenamingPolicy;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class DefaultPassConfig
extends PassConfig {
    private static final String COMPILED_CONSTANT_NAME = "COMPILED";
    private static final String CLOSURE_LOCALE_CONSTANT_NAME = "goog.LOCALE";
    static final DiagnosticType TIGHTEN_TYPES_WITHOUT_TYPE_CHECK = DiagnosticType.error("JSC_TIGHTEN_TYPES_WITHOUT_TYPE_CHECK", "TightenTypes requires type checking. Please use --check_types.");
    static final DiagnosticType CANNOT_USE_PROTOTYPE_AND_VAR = DiagnosticType.error("JSC_CANNOT_USE_PROTOTYPE_AND_VAR", "Rename prototypes and inline variables cannot be used together");
    static final DiagnosticType REPORT_PATH_IO_ERROR = DiagnosticType.error("JSC_REPORT_PATH_IO_ERROR", "Error writing compiler report to {0}");
    private static final DiagnosticType NAME_REF_GRAPH_FILE_ERROR = DiagnosticType.error("JSC_NAME_REF_GRAPH_FILE_ERROR", "Error \"{1}\" writing name reference graph to \"{0}\".");
    private static final DiagnosticType NAME_REF_REPORT_FILE_ERROR = DiagnosticType.error("JSC_NAME_REF_REPORT_FILE_ERROR", "Error \"{1}\" writing name reference report to \"{0}\".");
    private static final Pattern GLOBAL_SYMBOL_NAMESPACE_PATTERN = Pattern.compile("^[a-zA-Z0-9$_]+$");
    private GlobalNamespace namespaceForChecks = null;
    private PreprocessorSymbolTable preprocessorSymbolTable = null;
    private TightenTypes tightenTypes = null;
    private Set<String> exportedNames = null;
    private CrossModuleMethodMotion.IdGenerator crossModuleIdGenerator = new CrossModuleMethodMotion.IdGenerator();
    private Map<String, Integer> cssNames = null;
    private VariableMap variableMap = null;
    private VariableMap propertyMap = null;
    private VariableMap anonymousFunctionNameMap = null;
    private FunctionNames functionNames = null;
    private VariableMap stringMap = null;
    private String idGeneratorMap = null;
    final HotSwapPassFactory checkSideEffects = new HotSwapPassFactory("checkSideEffects", true){

        @Override
        protected HotSwapCompilerPass createInternal(AbstractCompiler compiler) {
            boolean protectHiddenSideEffects = DefaultPassConfig.this.options.protectHiddenSideEffects && !DefaultPassConfig.this.options.ideMode;
            return new CheckSideEffects(compiler, DefaultPassConfig.this.options.checkSuspiciousCode ? CheckLevel.WARNING : CheckLevel.OFF, protectHiddenSideEffects);
        }
    };
    final PassFactory stripSideEffectProtection = new PassFactory("stripSideEffectProtection", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler compiler) {
            return new CheckSideEffects.StripProtection(compiler);
        }
    };
    final HotSwapPassFactory suspiciousCode = new HotSwapPassFactory("suspiciousCode", true){

        @Override
        protected HotSwapCompilerPass createInternal(AbstractCompiler compiler) {
            ArrayList sharedCallbacks = Lists.newArrayList();
            if (DefaultPassConfig.this.options.checkSuspiciousCode) {
                sharedCallbacks.add(new CheckSuspiciousCode());
            }
            if (DefaultPassConfig.this.options.enables(DiagnosticGroups.GLOBAL_THIS)) {
                sharedCallbacks.add(new CheckGlobalThis(compiler));
            }
            if (DefaultPassConfig.this.options.enables(DiagnosticGroups.DEBUGGER_STATEMENT_PRESENT)) {
                sharedCallbacks.add(new CheckDebuggerStatement(compiler));
            }
            return DefaultPassConfig.combineChecks(compiler, sharedCallbacks);
        }
    };
    final HotSwapPassFactory checkControlStructures = new HotSwapPassFactory("checkControlStructures", true){

        @Override
        protected HotSwapCompilerPass createInternal(AbstractCompiler compiler) {
            return new ControlStructureCheck(compiler);
        }
    };
    final HotSwapPassFactory checkRequires = new HotSwapPassFactory("checkRequires", true){

        @Override
        protected HotSwapCompilerPass createInternal(AbstractCompiler compiler) {
            return new CheckRequiresForConstructors(compiler, DefaultPassConfig.this.options.checkRequires);
        }
    };
    final HotSwapPassFactory checkProvides = new HotSwapPassFactory("checkProvides", true){

        @Override
        protected HotSwapCompilerPass createInternal(AbstractCompiler compiler) {
            return new CheckProvides(compiler, DefaultPassConfig.this.options.checkProvides);
        }
    };
    private static final DiagnosticType GENERATE_EXPORTS_ERROR = DiagnosticType.error("JSC_GENERATE_EXPORTS_ERROR", "Exports can only be generated if export symbol/property functions are set.");
    final PassFactory generateExports = new PassFactory("generateExports", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler compiler) {
            CodingConvention convention = compiler.getCodingConvention();
            if (convention.getExportSymbolFunction() != null && convention.getExportPropertyFunction() != null) {
                return new GenerateExports(compiler, convention.getExportSymbolFunction(), convention.getExportPropertyFunction());
            }
            return new ErrorPass(compiler, GENERATE_EXPORTS_ERROR);
        }
    };
    final PassFactory exportTestFunctions = new PassFactory("exportTestFunctions", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler compiler) {
            CodingConvention convention = compiler.getCodingConvention();
            if (convention.getExportSymbolFunction() != null) {
                return new ExportTestFunctions(compiler, convention.getExportSymbolFunction(), convention.getExportPropertyFunction());
            }
            return new ErrorPass(compiler, GENERATE_EXPORTS_ERROR);
        }
    };
    final PassFactory gatherRawExports = new PassFactory("gatherRawExports", false){

        @Override
        protected CompilerPass createInternal(AbstractCompiler compiler) {
            final GatherRawExports pass = new GatherRawExports(compiler);
            return new CompilerPass(){

                @Override
                public void process(Node externs, Node root) {
                    pass.process(externs, root);
                    if (DefaultPassConfig.this.exportedNames == null) {
                        DefaultPassConfig.this.exportedNames = Sets.newHashSet();
                    }
                    DefaultPassConfig.this.exportedNames.addAll(pass.getExportedVariableNames());
                }
            };
        }
    };
    final HotSwapPassFactory closurePrimitives = new HotSwapPassFactory("processProvidesAndRequires", false){

        @Override
        protected HotSwapCompilerPass createInternal(AbstractCompiler compiler) {
            DefaultPassConfig.this.maybeInitializePreprocessorSymbolTable(compiler);
            final ProcessClosurePrimitives pass = new ProcessClosurePrimitives(compiler, DefaultPassConfig.this.preprocessorSymbolTable, DefaultPassConfig.this.options.brokenClosureRequiresLevel);
            return new HotSwapCompilerPass(){

                @Override
                public void process(Node externs, Node root) {
                    pass.process(externs, root);
                    DefaultPassConfig.this.exportedNames = pass.getExportedVariableNames();
                }

                @Override
                public void hotSwapScript(Node scriptRoot, Node originalRoot) {
                    pass.hotSwapScript(scriptRoot, originalRoot);
                }
            };
        }
    };
    final PassFactory jqueryAliases = new PassFactory("jqueryAliases", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler compiler) {
            return new ExpandJqueryAliases(compiler);
        }
    };
    final PassFactory replaceMessages = new PassFactory("replaceMessages", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler compiler) {
            return new ReplaceMessages(compiler, DefaultPassConfig.this.options.messageBundle, true, JsMessage.Style.getFromParams(true, false), false);
        }
    };
    final PassFactory replaceMessagesForChrome = new PassFactory("replaceMessages", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler compiler) {
            return new ReplaceMessagesForChrome(compiler, new GoogleJsMessageIdGenerator(DefaultPassConfig.this.options.tcProjectId), true, JsMessage.Style.getFromParams(true, false));
        }
    };
    final HotSwapPassFactory closureGoogScopeAliases = new HotSwapPassFactory("processGoogScopeAliases", true){

        @Override
        protected HotSwapCompilerPass createInternal(AbstractCompiler compiler) {
            DefaultPassConfig.this.maybeInitializePreprocessorSymbolTable(compiler);
            return new ScopedAliases(compiler, DefaultPassConfig.this.preprocessorSymbolTable, DefaultPassConfig.this.options.getAliasTransformationHandler());
        }
    };
    final HotSwapPassFactory closureRewriteGoogClass = new HotSwapPassFactory("closureRewriteGoogClass", true){

        @Override
        protected HotSwapCompilerPass createInternal(AbstractCompiler compiler) {
            return new ClosureRewriteClass(compiler);
        }
    };
    final PassFactory closureCheckGetCssName = new PassFactory("checkMissingGetCssName", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler compiler) {
            String blacklist = DefaultPassConfig.this.options.checkMissingGetCssNameBlacklist;
            Preconditions.checkState((blacklist != null && !blacklist.isEmpty() ? 1 : 0) != 0, (Object)"Not checking use of goog.getCssName because of empty blacklist.");
            return new CheckMissingGetCssName(compiler, DefaultPassConfig.this.options.checkMissingGetCssNameLevel, blacklist);
        }
    };
    final PassFactory closureReplaceGetCssName = new PassFactory("renameCssNames", true){

        @Override
        protected CompilerPass createInternal(final AbstractCompiler compiler) {
            return new CompilerPass(){

                @Override
                public void process(Node externs, Node jsRoot) {
                    HashMap newCssNames = null;
                    if (DefaultPassConfig.this.options.gatherCssNames) {
                        newCssNames = Maps.newHashMap();
                    }
                    ReplaceCssNames pass = new ReplaceCssNames(compiler, newCssNames, DefaultPassConfig.this.options.cssRenamingWhitelist);
                    pass.process(externs, jsRoot);
                    DefaultPassConfig.this.cssNames = newCssNames;
                }
            };
        }
    };
    final PassFactory createSyntheticBlocks = new PassFactory("createSyntheticBlocks", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler compiler) {
            return new CreateSyntheticBlocks(compiler, DefaultPassConfig.this.options.syntheticBlockStartMarker, DefaultPassConfig.this.options.syntheticBlockEndMarker);
        }
    };
    final PassFactory peepholeOptimizations = new PassFactory("peepholeOptimizations", false){

        @Override
        protected CompilerPass createInternal(AbstractCompiler compiler) {
            boolean late = false;
            return new PeepholeOptimizationsPass(compiler, new PeepholeSubstituteAlternateSyntax(false), new PeepholeReplaceKnownMethods(false), new PeepholeRemoveDeadCode(), new PeepholeFoldConstants(false), new PeepholeCollectPropertyAssignments());
        }
    };
    final PassFactory latePeepholeOptimizations = new PassFactory("latePeepholeOptimizations", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler compiler) {
            boolean late = true;
            return new PeepholeOptimizationsPass(compiler, new StatementFusion(), new PeepholeRemoveDeadCode(), new PeepholeSubstituteAlternateSyntax(true), new PeepholeReplaceKnownMethods(true), new PeepholeFoldConstants(true), new ReorderConstantExpression());
        }
    };
    final HotSwapPassFactory checkVars = new HotSwapPassFactory("checkVars", true){

        @Override
        protected HotSwapCompilerPass createInternal(AbstractCompiler compiler) {
            return new VarCheck(compiler);
        }
    };
    final PassFactory checkRegExp = new PassFactory("checkRegExp", true){

        @Override
        protected CompilerPass createInternal(final AbstractCompiler compiler) {
            final CheckRegExp pass = new CheckRegExp(compiler);
            return new CompilerPass(){

                @Override
                public void process(Node externs, Node root) {
                    pass.process(externs, root);
                    compiler.setHasRegExpGlobalReferences(pass.isGlobalRegExpPropertiesUsed());
                }
            };
        }
    };
    final HotSwapPassFactory checkVariableReferences = new HotSwapPassFactory("checkVariableReferences", true){

        @Override
        protected HotSwapCompilerPass createInternal(AbstractCompiler compiler) {
            return new VariableReferenceCheck(compiler, DefaultPassConfig.this.options.aggressiveVarCheck);
        }
    };
    final PassFactory objectPropertyStringPreprocess = new PassFactory("ObjectPropertyStringPreprocess", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler compiler) {
            return new ObjectPropertyStringPreprocess(compiler);
        }
    };
    final HotSwapPassFactory resolveTypes = new HotSwapPassFactory("resolveTypes", false){

        @Override
        protected HotSwapCompilerPass createInternal(AbstractCompiler compiler) {
            return new GlobalTypeResolver(compiler);
        }
    };
    final PassFactory clearTypedScopePass = new PassFactory("clearTypedScopePass", false){

        @Override
        protected CompilerPass createInternal(AbstractCompiler compiler) {
            return new ClearTypedScope();
        }
    };
    final HotSwapPassFactory inferTypes = new HotSwapPassFactory("inferTypes", false){

        @Override
        protected HotSwapCompilerPass createInternal(final AbstractCompiler compiler) {
            return new HotSwapCompilerPass(){

                @Override
                public void process(Node externs, Node root) {
                    Preconditions.checkNotNull((Object)DefaultPassConfig.this.topScope);
                    Preconditions.checkNotNull((Object)DefaultPassConfig.this.getTypedScopeCreator());
                    DefaultPassConfig.this.makeTypeInference(compiler).process(externs, root);
                }

                @Override
                public void hotSwapScript(Node scriptRoot, Node originalRoot) {
                    DefaultPassConfig.this.makeTypeInference(compiler).inferAllScopes(scriptRoot);
                }
            };
        }
    };
    final HotSwapPassFactory inferJsDocInfo = new HotSwapPassFactory("inferJsDocInfo", false){

        @Override
        protected HotSwapCompilerPass createInternal(final AbstractCompiler compiler) {
            return new HotSwapCompilerPass(){

                @Override
                public void process(Node externs, Node root) {
                    Preconditions.checkNotNull((Object)DefaultPassConfig.this.topScope);
                    Preconditions.checkNotNull((Object)DefaultPassConfig.this.getTypedScopeCreator());
                    DefaultPassConfig.this.makeInferJsDocInfo(compiler).process(externs, root);
                }

                @Override
                public void hotSwapScript(Node scriptRoot, Node originalRoot) {
                    DefaultPassConfig.this.makeInferJsDocInfo(compiler).hotSwapScript(scriptRoot, originalRoot);
                }
            };
        }
    };
    final HotSwapPassFactory checkTypes = new HotSwapPassFactory("checkTypes", false){

        @Override
        protected HotSwapCompilerPass createInternal(final AbstractCompiler compiler) {
            return new HotSwapCompilerPass(){

                @Override
                public void process(Node externs, Node root) {
                    Preconditions.checkNotNull((Object)DefaultPassConfig.this.topScope);
                    Preconditions.checkNotNull((Object)DefaultPassConfig.this.getTypedScopeCreator());
                    TypeCheck check = DefaultPassConfig.this.makeTypeCheck(compiler);
                    check.process(externs, root);
                    compiler.getErrorManager().setTypedPercent(check.getTypedPercent());
                }

                @Override
                public void hotSwapScript(Node scriptRoot, Node originalRoot) {
                    DefaultPassConfig.this.makeTypeCheck(compiler).check(scriptRoot, false);
                }
            };
        }
    };
    final HotSwapPassFactory checkControlFlow = new HotSwapPassFactory("checkControlFlow", true){

        @Override
        protected HotSwapCompilerPass createInternal(AbstractCompiler compiler) {
            ArrayList callbacks = Lists.newArrayList();
            if (DefaultPassConfig.this.options.checkUnreachableCode.isOn()) {
                callbacks.add(new CheckUnreachableCode(compiler, DefaultPassConfig.this.options.checkUnreachableCode));
            }
            if (DefaultPassConfig.this.options.checkMissingReturn.isOn() && DefaultPassConfig.this.options.checkTypes) {
                callbacks.add(new CheckMissingReturn(compiler, DefaultPassConfig.this.options.checkMissingReturn));
            }
            return DefaultPassConfig.combineChecks(compiler, callbacks);
        }
    };
    final HotSwapPassFactory checkAccessControls = new HotSwapPassFactory("checkAccessControls", true){

        @Override
        protected HotSwapCompilerPass createInternal(AbstractCompiler compiler) {
            return new CheckAccessControls(compiler);
        }
    };
    final PassFactory checkGlobalNames = new PassFactory("checkGlobalNames", true){

        @Override
        protected CompilerPass createInternal(final AbstractCompiler compiler) {
            return new CompilerPass(){

                @Override
                public void process(Node externs, Node jsRoot) {
                    DefaultPassConfig.this.namespaceForChecks = new GlobalNamespace(compiler, externs, jsRoot);
                    new CheckGlobalNames(compiler, DefaultPassConfig.this.options.checkGlobalNamesLevel).injectNamespace(DefaultPassConfig.this.namespaceForChecks).process(externs, jsRoot);
                }
            };
        }
    };
    final PassFactory checkStrictMode = new PassFactory("checkStrictMode", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler compiler) {
            return new StrictModeCheck(compiler, !DefaultPassConfig.this.options.checkSymbols, !DefaultPassConfig.this.options.checkCaja);
        }
    };
    final PassFactory processTweaks = new PassFactory("processTweaks", true){

        @Override
        protected CompilerPass createInternal(final AbstractCompiler compiler) {
            return new CompilerPass(){

                @Override
                public void process(Node externs, Node jsRoot) {
                    new ProcessTweaks(compiler, DefaultPassConfig.this.options.getTweakProcessing().shouldStrip(), DefaultPassConfig.this.options.getTweakReplacements()).process(externs, jsRoot);
                }
            };
        }
    };
    final PassFactory processDefines = new PassFactory("processDefines", true){

        @Override
        protected CompilerPass createInternal(final AbstractCompiler compiler) {
            return new CompilerPass(){

                @Override
                public void process(Node externs, Node jsRoot) {
                    Map<String, Node> replacements = DefaultPassConfig.getAdditionalReplacements(DefaultPassConfig.this.options);
                    replacements.putAll(DefaultPassConfig.this.options.getDefineReplacements());
                    new ProcessDefines(compiler, replacements).injectNamespace(DefaultPassConfig.this.namespaceForChecks).process(externs, jsRoot);
                }
            };
        }
    };
    final PassFactory garbageCollectChecks = new HotSwapPassFactory("garbageCollectChecks", true){

        @Override
        protected HotSwapCompilerPass createInternal(AbstractCompiler compiler) {
            return new HotSwapCompilerPass(){

                @Override
                public void process(Node externs, Node jsRoot) {
                    DefaultPassConfig.this.namespaceForChecks = null;
                }

                @Override
                public void hotSwapScript(Node scriptRoot, Node originalRoot) {
                    this.process(null, null);
                }
            };
        }
    };
    final PassFactory checkConsts = new PassFactory("checkConsts", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler compiler) {
            return new ConstCheck(compiler);
        }
    };
    final PassFactory computeFunctionNames = new PassFactory("computeFunctionNames", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler compiler) {
            return DefaultPassConfig.this.functionNames = new FunctionNames(compiler);
        }
    };
    final PassFactory ignoreCajaProperties = new PassFactory("ignoreCajaProperties", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler compiler) {
            return new IgnoreCajaProperties(compiler);
        }
    };
    final PassFactory runtimeTypeCheck = new PassFactory("runtimeTypeCheck", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler compiler) {
            return new RuntimeTypeCheck(compiler, DefaultPassConfig.this.options.runtimeTypeCheckLogFunction);
        }
    };
    final PassFactory replaceIdGenerators = new PassFactory("replaceIdGenerators", true){

        @Override
        protected CompilerPass createInternal(final AbstractCompiler compiler) {
            return new CompilerPass(){

                @Override
                public void process(Node externs, Node root) {
                    ReplaceIdGenerators pass = new ReplaceIdGenerators(compiler, DefaultPassConfig.this.options.idGenerators, DefaultPassConfig.this.options.generatePseudoNames, DefaultPassConfig.this.options.idGeneratorsMapSerialized);
                    pass.process(externs, root);
                    DefaultPassConfig.this.idGeneratorMap = pass.getSerializedIdMappings();
                }
            };
        }
    };
    final PassFactory replaceStrings = new PassFactory("replaceStrings", true){

        @Override
        protected CompilerPass createInternal(final AbstractCompiler compiler) {
            return new CompilerPass(){

                @Override
                public void process(Node externs, Node root) {
                    ReplaceStrings pass = new ReplaceStrings(compiler, DefaultPassConfig.this.options.replaceStringsPlaceholderToken, DefaultPassConfig.this.options.replaceStringsFunctionDescriptions, DefaultPassConfig.this.options.replaceStringsReservedStrings, DefaultPassConfig.this.options.replaceStringsInputMap);
                    pass.process(externs, root);
                    DefaultPassConfig.this.stringMap = pass.getStringMap();
                }
            };
        }
    };
    final PassFactory optimizeArgumentsArray = new PassFactory("optimizeArgumentsArray", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler compiler) {
            return new OptimizeArgumentsArray(compiler);
        }
    };
    final PassFactory closureCodeRemoval = new PassFactory("closureCodeRemoval", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler compiler) {
            return new ClosureCodeRemoval(compiler, DefaultPassConfig.this.options.removeAbstractMethods, DefaultPassConfig.this.options.removeClosureAsserts);
        }
    };
    final PassFactory closureOptimizePrimitives = new PassFactory("closureOptimizePrimitives", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler compiler) {
            return new ClosureOptimizePrimitives(compiler);
        }
    };
    final PassFactory rescopeGlobalSymbols = new PassFactory("rescopeGlobalSymbols", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler compiler) {
            return new RescopeGlobalSymbols(compiler, DefaultPassConfig.this.options.renamePrefixNamespace);
        }
    };
    final PassFactory collapseProperties = new PassFactory("collapseProperties", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler compiler) {
            return new CollapseProperties(compiler, DefaultPassConfig.this.options.collapsePropertiesOnExternTypes, !DefaultPassConfig.this.isInliningForbidden());
        }
    };
    final PassFactory collapseObjectLiterals = new PassFactory("collapseObjectLiterals", false){

        @Override
        protected CompilerPass createInternal(AbstractCompiler compiler) {
            return new InlineObjectLiterals(compiler, compiler.getUniqueNameIdSupplier());
        }
    };
    final PassFactory tightenTypesBuilder = new PassFactory("tightenTypes", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler compiler) {
            if (!DefaultPassConfig.this.options.checkTypes) {
                return new ErrorPass(compiler, TIGHTEN_TYPES_WITHOUT_TYPE_CHECK);
            }
            DefaultPassConfig.this.tightenTypes = new TightenTypes(compiler);
            return DefaultPassConfig.this.tightenTypes;
        }
    };
    final PassFactory disambiguateProperties = new PassFactory("disambiguateProperties", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler compiler) {
            if (DefaultPassConfig.this.tightenTypes == null) {
                return DisambiguateProperties.forJSTypeSystem(compiler, DefaultPassConfig.this.options.propertyInvalidationErrors);
            }
            return DisambiguateProperties.forConcreteTypeSystem(compiler, DefaultPassConfig.this.tightenTypes, DefaultPassConfig.this.options.propertyInvalidationErrors);
        }
    };
    final PassFactory chainCalls = new PassFactory("chainCalls", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler compiler) {
            return new ChainCalls(compiler);
        }
    };
    final PassFactory devirtualizePrototypeMethods = new PassFactory("devirtualizePrototypeMethods", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler compiler) {
            return new DevirtualizePrototypeMethods(compiler);
        }
    };
    final PassFactory optimizeCallsAndRemoveUnusedVars = new PassFactory("optimizeCalls_and_removeUnusedVars", false){

        @Override
        protected CompilerPass createInternal(AbstractCompiler compiler) {
            OptimizeCalls passes = new OptimizeCalls(compiler);
            if (DefaultPassConfig.this.options.optimizeReturns) {
                passes.addPass(new OptimizeReturns(compiler));
            }
            if (DefaultPassConfig.this.options.optimizeParameters) {
                passes.addPass(new OptimizeParameters(compiler));
            }
            if (DefaultPassConfig.this.options.optimizeCalls) {
                boolean removeOnlyLocals = DefaultPassConfig.this.options.removeUnusedLocalVars && !DefaultPassConfig.this.options.removeUnusedVars;
                boolean preserveAnonymousFunctionNames = DefaultPassConfig.this.options.anonymousFunctionNaming != AnonymousFunctionNamingPolicy.OFF;
                passes.addPass(new RemoveUnusedVars(compiler, !removeOnlyLocals, preserveAnonymousFunctionNames, true));
            }
            return passes;
        }
    };
    final PassFactory markPureFunctions = new PassFactory("markPureFunctions", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler compiler) {
            return new PureFunctionIdentifier.Driver(compiler, DefaultPassConfig.this.options.debugFunctionSideEffectsPath, false);
        }
    };
    final PassFactory markNoSideEffectCalls = new PassFactory("markNoSideEffectCalls", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler compiler) {
            return new MarkNoSideEffectCalls(compiler);
        }
    };
    final PassFactory inlineVariables = new PassFactory("inlineVariables", false){

        @Override
        protected CompilerPass createInternal(AbstractCompiler compiler) {
            InlineVariables.Mode mode;
            if (DefaultPassConfig.this.isInliningForbidden()) {
                return new ErrorPass(compiler, CANNOT_USE_PROTOTYPE_AND_VAR);
            }
            if (DefaultPassConfig.this.options.inlineVariables) {
                mode = InlineVariables.Mode.ALL;
            } else if (DefaultPassConfig.this.options.inlineLocalVariables) {
                mode = InlineVariables.Mode.LOCALS_ONLY;
            } else {
                throw new IllegalStateException("No variable inlining option set.");
            }
            return new InlineVariables(compiler, mode, true);
        }
    };
    final PassFactory inlineConstants = new PassFactory("inlineConstants", false){

        @Override
        protected CompilerPass createInternal(AbstractCompiler compiler) {
            return new InlineVariables(compiler, InlineVariables.Mode.CONSTANTS_ONLY, true);
        }
    };
    final PassFactory minimizeExitPoints = new PassFactory("minimizeExitPoints", false){

        @Override
        protected CompilerPass createInternal(AbstractCompiler compiler) {
            return new MinimizeExitPoints(compiler);
        }
    };
    final PassFactory removeUnreachableCode = new PassFactory("removeUnreachableCode", false){

        @Override
        protected CompilerPass createInternal(AbstractCompiler compiler) {
            return new UnreachableCodeElimination(compiler, true);
        }
    };
    final PassFactory removeUnusedPrototypeProperties = new PassFactory("removeUnusedPrototypeProperties", false){

        @Override
        protected CompilerPass createInternal(AbstractCompiler compiler) {
            return new RemoveUnusedPrototypeProperties(compiler, DefaultPassConfig.this.options.removeUnusedPrototypePropertiesInExterns, !DefaultPassConfig.this.options.removeUnusedVars);
        }
    };
    final PassFactory removeUnusedClassProperties = new PassFactory("removeUnusedClassProperties", false){

        @Override
        protected CompilerPass createInternal(AbstractCompiler compiler) {
            return new RemoveUnusedClassProperties(compiler);
        }
    };
    final PassFactory smartNamePass = new PassFactory("smartNamePass", true){

        @Override
        protected CompilerPass createInternal(final AbstractCompiler compiler) {
            return new CompilerPass(){

                @Override
                public void process(Node externs, Node root) {
                    NameAnalyzer na = new NameAnalyzer(compiler, false);
                    na.process(externs, root);
                    String reportPath = DefaultPassConfig.this.options.reportPath;
                    if (reportPath != null) {
                        try {
                            Files.write((CharSequence)na.getHtmlReport(), (File)new File(reportPath), (Charset)Charsets.UTF_8);
                        }
                        catch (IOException e) {
                            compiler.report(JSError.make(REPORT_PATH_IO_ERROR, reportPath));
                        }
                    }
                    if (DefaultPassConfig.this.options.smartNameRemoval) {
                        na.removeUnreferenced();
                    }
                }
            };
        }
    };
    final PassFactory smartNamePass2 = new PassFactory("smartNamePass", true){

        @Override
        protected CompilerPass createInternal(final AbstractCompiler compiler) {
            return new CompilerPass(){

                @Override
                public void process(Node externs, Node root) {
                    NameAnalyzer na = new NameAnalyzer(compiler, false);
                    na.process(externs, root);
                    na.removeUnreferenced();
                }
            };
        }
    };
    final PassFactory inlineSimpleMethods = new PassFactory("inlineSimpleMethods", false){

        @Override
        protected CompilerPass createInternal(AbstractCompiler compiler) {
            return new InlineSimpleMethods(compiler);
        }
    };
    final PassFactory deadAssignmentsElimination = new PassFactory("deadAssignmentsElimination", false){

        @Override
        protected CompilerPass createInternal(AbstractCompiler compiler) {
            return new DeadAssignmentsElimination(compiler);
        }
    };
    final PassFactory inlineFunctions = new PassFactory("inlineFunctions", false){

        @Override
        protected CompilerPass createInternal(AbstractCompiler compiler) {
            boolean enableBlockInlining = !DefaultPassConfig.this.isInliningForbidden();
            return new InlineFunctions(compiler, compiler.getUniqueNameIdSupplier(), DefaultPassConfig.this.options.inlineFunctions, DefaultPassConfig.this.options.inlineLocalFunctions, enableBlockInlining, DefaultPassConfig.this.options.assumeStrictThis() || DefaultPassConfig.this.options.getLanguageIn() == CompilerOptions.LanguageMode.ECMASCRIPT5_STRICT, true);
        }
    };
    final PassFactory inlineProperties = new PassFactory("inlineProperties", false){

        @Override
        protected CompilerPass createInternal(AbstractCompiler compiler) {
            return new InlineProperties(compiler);
        }
    };
    final PassFactory removeUnusedVars = new PassFactory("removeUnusedVars", false){

        @Override
        protected CompilerPass createInternal(AbstractCompiler compiler) {
            boolean removeOnlyLocals = DefaultPassConfig.this.options.removeUnusedLocalVars && !DefaultPassConfig.this.options.removeUnusedVars;
            boolean preserveAnonymousFunctionNames = DefaultPassConfig.this.options.anonymousFunctionNaming != AnonymousFunctionNamingPolicy.OFF;
            return new RemoveUnusedVars(compiler, !removeOnlyLocals, preserveAnonymousFunctionNames, false);
        }
    };
    final PassFactory crossModuleCodeMotion = new PassFactory("crossModuleCodeMotion", false){

        @Override
        protected CompilerPass createInternal(AbstractCompiler compiler) {
            return new CrossModuleCodeMotion(compiler, compiler.getModuleGraph());
        }
    };
    final PassFactory crossModuleMethodMotion = new PassFactory("crossModuleMethodMotion", false){

        @Override
        protected CompilerPass createInternal(AbstractCompiler compiler) {
            return new CrossModuleMethodMotion(compiler, DefaultPassConfig.this.crossModuleIdGenerator, DefaultPassConfig.this.options.removeUnusedPrototypePropertiesInExterns);
        }
    };
    final PassFactory specializeInitialModule = new PassFactory("specializeInitialModule", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler compiler) {
            return new SpecializeModule(compiler, DefaultPassConfig.this.devirtualizePrototypeMethods, DefaultPassConfig.this.inlineFunctions, DefaultPassConfig.this.removeUnusedPrototypeProperties);
        }
    };
    final PassFactory flowSensitiveInlineVariables = new PassFactory("flowSensitiveInlineVariables", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler compiler) {
            return new FlowSensitiveInlineVariables(compiler);
        }
    };
    final PassFactory coalesceVariableNames = new PassFactory("coalesceVariableNames", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler compiler) {
            return new CoalesceVariableNames(compiler, DefaultPassConfig.this.options.generatePseudoNames);
        }
    };
    final PassFactory exploitAssign = new PassFactory("exploitAssign", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler compiler) {
            return new PeepholeOptimizationsPass(compiler, new ExploitAssigns());
        }
    };
    final PassFactory collapseVariableDeclarations = new PassFactory("collapseVariableDeclarations", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler compiler) {
            return new CollapseVariableDeclarations(compiler);
        }
    };
    final PassFactory groupVariableDeclarations = new PassFactory("groupVariableDeclarations", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler compiler) {
            return new GroupVariableDeclarations(compiler);
        }
    };
    final PassFactory extractPrototypeMemberDeclarations = new PassFactory("extractPrototypeMemberDeclarations", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler compiler) {
            return new ExtractPrototypeMemberDeclarations(compiler, ExtractPrototypeMemberDeclarations.Pattern.USE_GLOBAL_TEMP);
        }
    };
    final PassFactory rewriteFunctionExpressions = new PassFactory("rewriteFunctionExpressions", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler compiler) {
            return new FunctionRewriter(compiler);
        }
    };
    final PassFactory collapseAnonymousFunctions = new PassFactory("collapseAnonymousFunctions", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler compiler) {
            return new CollapseAnonymousFunctions(compiler);
        }
    };
    final PassFactory moveFunctionDeclarations = new PassFactory("moveFunctionDeclarations", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler compiler) {
            return new MoveFunctionDeclarations(compiler);
        }
    };
    final PassFactory nameUnmappedAnonymousFunctions = new PassFactory("nameAnonymousFunctions", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler compiler) {
            return new NameAnonymousFunctions(compiler);
        }
    };
    final PassFactory nameMappedAnonymousFunctions = new PassFactory("nameAnonymousFunctions", true){

        @Override
        protected CompilerPass createInternal(final AbstractCompiler compiler) {
            return new CompilerPass(){

                @Override
                public void process(Node externs, Node root) {
                    NameAnonymousFunctionsMapped naf = new NameAnonymousFunctionsMapped(compiler, DefaultPassConfig.this.options.inputAnonymousFunctionNamingMap);
                    naf.process(externs, root);
                    DefaultPassConfig.this.anonymousFunctionNameMap = naf.getFunctionMap();
                }
            };
        }
    };
    final PassFactory aliasExternals = new PassFactory("aliasExternals", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler compiler) {
            return new AliasExternals(compiler, compiler.getModuleGraph(), DefaultPassConfig.this.options.unaliasableGlobals, DefaultPassConfig.this.options.aliasableGlobals);
        }
    };
    final PassFactory aliasStrings = new PassFactory("aliasStrings", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler compiler) {
            return new AliasStrings(compiler, compiler.getModuleGraph(), DefaultPassConfig.this.options.aliasAllStrings ? null : DefaultPassConfig.this.options.aliasableStrings, DefaultPassConfig.this.options.aliasStringsBlacklist, DefaultPassConfig.this.options.outputJsStringUsage);
        }
    };
    final PassFactory aliasKeywords = new PassFactory("aliasKeywords", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler compiler) {
            return new AliasKeywords(compiler);
        }
    };
    final PassFactory objectPropertyStringPostprocess = new PassFactory("ObjectPropertyStringPostprocess", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler compiler) {
            return new ObjectPropertyStringPostprocess(compiler);
        }
    };
    final PassFactory ambiguateProperties = new PassFactory("ambiguateProperties", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler compiler) {
            return new AmbiguateProperties(compiler, DefaultPassConfig.this.options.anonymousFunctionNaming.getReservedCharacters());
        }
    };
    final PassFactory markUnnormalized = new PassFactory("markUnnormalized", true){

        @Override
        protected CompilerPass createInternal(final AbstractCompiler compiler) {
            return new CompilerPass(){

                @Override
                public void process(Node externs, Node root) {
                    compiler.setLifeCycleStage(AbstractCompiler.LifeCycleStage.RAW);
                }
            };
        }
    };
    final PassFactory denormalize = new PassFactory("denormalize", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler compiler) {
            return new Denormalize(compiler);
        }
    };
    final PassFactory invertContextualRenaming = new PassFactory("invertNames", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler compiler) {
            return MakeDeclaredNamesUnique.getContextualRenameInverter(compiler);
        }
    };
    final PassFactory renameProperties = new PassFactory("renameProperties", true){

        @Override
        protected CompilerPass createInternal(final AbstractCompiler compiler) {
            final VariableMap prevPropertyMap = DefaultPassConfig.this.options.inputPropertyMap;
            return new CompilerPass(){

                @Override
                public void process(Node externs, Node root) {
                    DefaultPassConfig.this.propertyMap = DefaultPassConfig.this.runPropertyRenaming(compiler, prevPropertyMap, externs, root);
                }
            };
        }
    };
    final PassFactory renameVars = new PassFactory("renameVars", true){

        @Override
        protected CompilerPass createInternal(final AbstractCompiler compiler) {
            final VariableMap prevVariableMap = DefaultPassConfig.this.options.inputVariableMap;
            return new CompilerPass(){

                @Override
                public void process(Node externs, Node root) {
                    DefaultPassConfig.this.variableMap = DefaultPassConfig.this.runVariableRenaming(compiler, prevVariableMap, externs, root);
                }
            };
        }
    };
    final PassFactory renameLabels = new PassFactory("renameLabels", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler compiler) {
            return new RenameLabels(compiler);
        }
    };
    final PassFactory convertToDottedProperties = new PassFactory("convertToDottedProperties", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler compiler) {
            return new ConvertToDottedProperties(compiler);
        }
    };
    final PassFactory sanityCheckAst = new PassFactory("sanityCheckAst", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler compiler) {
            return new AstValidator();
        }
    };
    final PassFactory sanityCheckVars = new PassFactory("sanityCheckVars", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler compiler) {
            return new VarCheck(compiler, true);
        }
    };
    final PassFactory instrumentFunctions = new PassFactory("instrumentFunctions", true){

        @Override
        protected CompilerPass createInternal(final AbstractCompiler compiler) {
            return new CompilerPass(){

                @Override
                public void process(Node externs, Node root) {
                    try {
                        FileReader templateFile = new FileReader(DefaultPassConfig.this.options.instrumentationTemplate);
                        new InstrumentFunctions(compiler, DefaultPassConfig.this.functionNames, DefaultPassConfig.this.options.instrumentationTemplate, DefaultPassConfig.this.options.appNameStr, templateFile).process(externs, root);
                    }
                    catch (IOException e) {
                        compiler.report(JSError.make(AbstractCompiler.READ_ERROR, DefaultPassConfig.this.options.instrumentationTemplate));
                    }
                }
            };
        }
    };
    final PassFactory printNameReferenceGraph = new PassFactory("printNameReferenceGraph", true){

        @Override
        protected CompilerPass createInternal(final AbstractCompiler compiler) {
            return new CompilerPass(){

                @Override
                public void process(Node externs, Node jsRoot) {
                    NameReferenceGraphConstruction gc = new NameReferenceGraphConstruction(compiler);
                    gc.process(externs, jsRoot);
                    String graphFileName = DefaultPassConfig.this.options.nameReferenceGraphPath;
                    try {
                        Files.write((CharSequence)DotFormatter.toDot(gc.getNameReferenceGraph()), (File)new File(graphFileName), (Charset)Charsets.UTF_8);
                    }
                    catch (IOException e) {
                        compiler.report(JSError.make(NAME_REF_GRAPH_FILE_ERROR, e.getMessage(), graphFileName));
                    }
                }
            };
        }
    };
    final PassFactory printNameReferenceReport = new PassFactory("printNameReferenceReport", true){

        @Override
        protected CompilerPass createInternal(final AbstractCompiler compiler) {
            return new CompilerPass(){

                @Override
                public void process(Node externs, Node jsRoot) {
                    NameReferenceGraphConstruction gc = new NameReferenceGraphConstruction(compiler);
                    String reportFileName = DefaultPassConfig.this.options.nameReferenceReportPath;
                    try {
                        NameReferenceGraphReport report = new NameReferenceGraphReport(gc.getNameReferenceGraph());
                        Files.write((CharSequence)report.getHtmlReport(), (File)new File(reportFileName), (Charset)Charsets.UTF_8);
                    }
                    catch (IOException e) {
                        compiler.report(JSError.make(NAME_REF_REPORT_FILE_ERROR, e.getMessage(), reportFileName));
                    }
                }
            };
        }
    };

    public DefaultPassConfig(CompilerOptions options) {
        super(options);
    }

    @Override
    protected PassConfig.State getIntermediateState() {
        return new PassConfig.State(this.cssNames == null ? null : Maps.newHashMap(this.cssNames), this.exportedNames == null ? null : Collections.unmodifiableSet(this.exportedNames), this.crossModuleIdGenerator, this.variableMap, this.propertyMap, this.anonymousFunctionNameMap, this.stringMap, this.functionNames, this.idGeneratorMap);
    }

    @Override
    protected void setIntermediateState(PassConfig.State state) {
        this.cssNames = state.cssNames == null ? null : Maps.newHashMap(state.cssNames);
        this.exportedNames = state.exportedNames == null ? null : Sets.newHashSet(state.exportedNames);
        this.crossModuleIdGenerator = state.crossModuleIdGenerator;
        this.variableMap = state.variableMap;
        this.propertyMap = state.propertyMap;
        this.anonymousFunctionNameMap = state.anonymousFunctionNameMap;
        this.stringMap = state.stringMap;
        this.functionNames = state.functionNames;
        this.idGeneratorMap = state.idGeneratorMap;
    }

    GlobalNamespace getGlobalNamespace() {
        return this.namespaceForChecks;
    }

    PreprocessorSymbolTable getPreprocessorSymbolTable() {
        return this.preprocessorSymbolTable;
    }

    void maybeInitializePreprocessorSymbolTable(AbstractCompiler compiler) {
        if (this.options.ideMode) {
            Node root = compiler.getRoot();
            if (this.preprocessorSymbolTable == null || this.preprocessorSymbolTable.getRootNode() != root) {
                this.preprocessorSymbolTable = new PreprocessorSymbolTable(root);
            }
        }
    }

    @Override
    protected List<PassFactory> getChecks() {
        ArrayList checks = Lists.newArrayList();
        checks.add(DefaultPassConfig.createEmptyPass("beforeStandardChecks"));
        if (this.options.closurePass) {
            checks.add(this.closureGoogScopeAliases);
            checks.add(this.closureRewriteGoogClass);
        }
        if (this.options.nameAnonymousFunctionsOnly) {
            if (this.options.anonymousFunctionNaming == AnonymousFunctionNamingPolicy.MAPPED) {
                checks.add(this.nameMappedAnonymousFunctions);
            } else if (this.options.anonymousFunctionNaming == AnonymousFunctionNamingPolicy.UNMAPPED) {
                checks.add(this.nameUnmappedAnonymousFunctions);
            }
            return checks;
        }
        if (this.options.jqueryPass) {
            checks.add(this.jqueryAliases.makeOneTimePass());
        }
        checks.add(this.checkSideEffects);
        if (this.options.checkSuspiciousCode || this.options.enables(DiagnosticGroups.GLOBAL_THIS) || this.options.enables(DiagnosticGroups.DEBUGGER_STATEMENT_PRESENT)) {
            checks.add(this.suspiciousCode);
        }
        if (this.options.checkControlStructures || this.options.enables(DiagnosticGroups.ES5_STRICT)) {
            checks.add(this.checkControlStructures);
        }
        if (this.options.checkRequires.isOn()) {
            checks.add(this.checkRequires);
        }
        if (this.options.checkProvides.isOn()) {
            checks.add(this.checkProvides);
        }
        if (this.options.generateExports) {
            checks.add(this.generateExports);
        }
        if (this.options.exportTestFunctions) {
            checks.add(this.exportTestFunctions);
        }
        if (this.options.closurePass) {
            checks.add(this.closurePrimitives.makeOneTimePass());
        }
        if (this.options.closurePass && this.options.checkMissingGetCssNameLevel.isOn()) {
            checks.add(this.closureCheckGetCssName);
        }
        if (this.options.syntheticBlockStartMarker != null) {
            checks.add(this.createSyntheticBlocks);
        }
        checks.add(this.checkVars);
        if (this.options.computeFunctionSideEffects) {
            checks.add(this.checkRegExp);
        }
        if (this.options.aggressiveVarCheck.isOn()) {
            checks.add(this.checkVariableReferences);
        }
        if (this.options.processObjectPropertyString) {
            checks.add(this.objectPropertyStringPreprocess);
        }
        if (this.options.checkTypes || this.options.inferTypes) {
            checks.add(this.resolveTypes.makeOneTimePass());
            checks.add(this.inferTypes.makeOneTimePass());
            if (this.options.checkTypes) {
                checks.add(this.checkTypes.makeOneTimePass());
            } else {
                checks.add(this.inferJsDocInfo.makeOneTimePass());
            }
            if (!this.options.ideMode && !this.options.saveDataStructures) {
                checks.add(this.clearTypedScopePass.makeOneTimePass());
            }
        }
        if (this.options.checkUnreachableCode.isOn() || this.options.checkTypes && this.options.checkMissingReturn.isOn()) {
            checks.add(this.checkControlFlow);
        }
        if (this.options.checkTypes && (this.options.enables(DiagnosticGroups.ACCESS_CONTROLS) || this.options.enables(DiagnosticGroups.CONSTANT_PROPERTY))) {
            checks.add(this.checkAccessControls);
        }
        if (this.options.checkGlobalNamesLevel.isOn()) {
            checks.add(this.checkGlobalNames);
        }
        if (this.options.enables(DiagnosticGroups.ES5_STRICT) || this.options.checkCaja) {
            checks.add(this.checkStrictMode);
        }
        if (this.options.closurePass) {
            checks.add(this.closureReplaceGetCssName);
        }
        if (this.options.replaceMessagesWithChromeI18n) {
            checks.add(this.replaceMessagesForChrome);
        } else if (this.options.messageBundle != null) {
            checks.add(this.replaceMessages);
        }
        if (this.options.getTweakProcessing().isOn()) {
            checks.add(this.processTweaks);
        }
        checks.add(this.processDefines);
        if (this.options.instrumentationTemplate != null || this.options.recordFunctionInformation) {
            checks.add(this.computeFunctionNames);
        }
        if (this.options.nameReferenceGraphPath != null && !this.options.nameReferenceGraphPath.isEmpty()) {
            checks.add(this.printNameReferenceGraph);
        }
        if (this.options.nameReferenceReportPath != null && !this.options.nameReferenceReportPath.isEmpty()) {
            checks.add(this.printNameReferenceReport);
        }
        checks.add(DefaultPassConfig.createEmptyPass("afterStandardChecks"));
        this.assertAllOneTimePasses(checks);
        return checks;
    }

    @Override
    protected List<PassFactory> getOptimizations() {
        ArrayList passes = Lists.newArrayList();
        passes.add(this.garbageCollectChecks);
        if (this.options.runtimeTypeCheck) {
            passes.add(this.runtimeTypeCheck);
        }
        passes.add(DefaultPassConfig.createEmptyPass("beforeStandardOptimizations"));
        if (this.options.replaceIdGenerators) {
            passes.add(this.replaceIdGenerators);
        }
        if (this.options.optimizeArgumentsArray) {
            passes.add(this.optimizeArgumentsArray);
        }
        if (this.options.closurePass && (this.options.removeAbstractMethods || this.options.removeClosureAsserts)) {
            passes.add(this.closureCodeRemoval);
        }
        if (this.options.collapseProperties) {
            passes.add(this.collapseProperties);
        }
        if (!this.options.replaceStringsFunctionDescriptions.isEmpty()) {
            passes.add(this.replaceStrings);
        }
        if (this.options.tightenTypes) {
            passes.add(this.tightenTypesBuilder);
        }
        if (this.options.disambiguateProperties) {
            passes.add(this.disambiguateProperties);
        }
        if (this.options.computeFunctionSideEffects) {
            passes.add(this.markPureFunctions);
        } else if (this.options.markNoSideEffectCalls) {
            passes.add(this.markNoSideEffectCalls);
        }
        if (this.options.chainCalls) {
            passes.add(this.chainCalls);
        }
        passes.add(this.checkConsts);
        if (this.options.ignoreCajaProperties) {
            passes.add(this.ignoreCajaProperties);
        }
        this.assertAllOneTimePasses(passes);
        if (this.options.smartNameRemoval || this.options.reportPath != null) {
            passes.addAll(this.getCodeRemovingPasses());
            passes.add(this.smartNamePass);
        }
        if (this.options.closurePass) {
            passes.add(this.closureOptimizePrimitives);
        }
        if (this.options.crossModuleCodeMotion) {
            passes.add(this.crossModuleCodeMotion);
        }
        if (this.options.devirtualizePrototypeMethods) {
            passes.add(this.devirtualizePrototypeMethods);
        }
        if (this.options.customPasses != null) {
            passes.add(this.getCustomPasses(CustomPassExecutionTime.BEFORE_OPTIMIZATION_LOOP));
        }
        passes.add(DefaultPassConfig.createEmptyPass("beforeMainOptimizations"));
        if (this.options.specializeInitialModule) {
            passes.addAll(this.getMainOptimizationLoop());
            if (this.options.crossModuleCodeMotion) {
                passes.add(this.crossModuleCodeMotion);
            }
            if (this.options.crossModuleMethodMotion) {
                passes.add(this.crossModuleMethodMotion);
            }
            passes.add(this.specializeInitialModule.makeOneTimePass());
        }
        passes.addAll(this.getMainOptimizationLoop());
        passes.add(DefaultPassConfig.createEmptyPass("beforeModuleMotion"));
        if (this.options.crossModuleCodeMotion) {
            passes.add(this.crossModuleCodeMotion);
        }
        if (this.options.crossModuleMethodMotion) {
            passes.add(this.crossModuleMethodMotion);
        }
        passes.add(DefaultPassConfig.createEmptyPass("afterModuleMotion"));
        if (this.options.customPasses != null) {
            passes.add(this.getCustomPasses(CustomPassExecutionTime.AFTER_OPTIMIZATION_LOOP));
        }
        if (this.options.flowSensitiveInlineVariables) {
            passes.add(this.flowSensitiveInlineVariables);
            if (this.options.removeUnusedVars || this.options.removeUnusedLocalVars) {
                passes.add(this.removeUnusedVars);
            }
        }
        if (this.options.smartNameRemoval) {
            passes.add(this.smartNamePass2);
        }
        if (this.options.collapseAnonymousFunctions) {
            passes.add(this.collapseAnonymousFunctions);
        }
        if (this.options.moveFunctionDeclarations || this.options.renamePrefixNamespace != null) {
            passes.add(this.moveFunctionDeclarations);
        }
        if (this.options.anonymousFunctionNaming == AnonymousFunctionNamingPolicy.MAPPED) {
            passes.add(this.nameMappedAnonymousFunctions);
        }
        if (this.options.extractPrototypeMemberDeclarations && this.options.propertyRenaming != PropertyRenamingPolicy.HEURISTIC && this.options.propertyRenaming != PropertyRenamingPolicy.AGGRESSIVE_HEURISTIC) {
            passes.add(this.extractPrototypeMemberDeclarations);
        }
        if (this.options.ambiguateProperties && this.options.propertyRenaming == PropertyRenamingPolicy.ALL_UNQUOTED) {
            passes.add(this.ambiguateProperties);
        }
        if (this.options.propertyRenaming != PropertyRenamingPolicy.OFF) {
            passes.add(this.renameProperties);
        }
        if (this.options.reserveRawExports) {
            passes.add(this.gatherRawExports);
        }
        if (this.options.convertToDottedProperties) {
            passes.add(this.convertToDottedProperties);
        }
        if (this.options.rewriteFunctionExpressions) {
            passes.add(this.rewriteFunctionExpressions);
        }
        if (!this.options.aliasableStrings.isEmpty() || this.options.aliasAllStrings) {
            passes.add(this.aliasStrings);
        }
        if (this.options.aliasExternals) {
            passes.add(this.aliasExternals);
        }
        if (this.options.aliasKeywords) {
            passes.add(this.aliasKeywords);
        }
        passes.add(this.markUnnormalized);
        if (this.options.coalesceVariableNames) {
            passes.add(this.coalesceVariableNames);
            if (this.options.foldConstants) {
                passes.add(this.peepholeOptimizations);
            }
        }
        if (this.options.collapseVariableDeclarations) {
            passes.add(this.exploitAssign);
            passes.add(this.collapseVariableDeclarations);
        }
        passes.add(this.denormalize);
        if (this.options.instrumentationTemplate != null) {
            passes.add(this.instrumentFunctions);
        }
        if (this.options.variableRenaming != VariableRenamingPolicy.ALL) {
            passes.add(this.invertContextualRenaming);
        }
        if (this.options.variableRenaming != VariableRenamingPolicy.OFF) {
            passes.add(this.renameVars);
        }
        if (this.options.groupVariableDeclarations) {
            passes.add(this.groupVariableDeclarations);
        }
        if (this.options.processObjectPropertyString) {
            passes.add(this.objectPropertyStringPostprocess);
        }
        if (this.options.labelRenaming) {
            passes.add(this.renameLabels);
        }
        if (this.options.foldConstants) {
            passes.add(this.latePeepholeOptimizations);
        }
        if (this.options.anonymousFunctionNaming == AnonymousFunctionNamingPolicy.UNMAPPED) {
            passes.add(this.nameUnmappedAnonymousFunctions);
        }
        passes.add(this.stripSideEffectProtection);
        if (this.options.renamePrefixNamespace != null) {
            if (!GLOBAL_SYMBOL_NAMESPACE_PATTERN.matcher(this.options.renamePrefixNamespace).matches()) {
                throw new IllegalArgumentException("Illegal character in renamePrefixNamespace name: " + this.options.renamePrefixNamespace);
            }
            passes.add(this.rescopeGlobalSymbols);
        }
        passes.add(this.sanityCheckAst);
        passes.add(this.sanityCheckVars);
        return passes;
    }

    private List<PassFactory> getMainOptimizationLoop() {
        boolean runOptimizeCalls;
        ArrayList passes = Lists.newArrayList();
        if (this.options.inlineGetters) {
            passes.add(this.inlineSimpleMethods);
        }
        passes.addAll(this.getCodeRemovingPasses());
        if (this.options.inlineFunctions || this.options.inlineLocalFunctions) {
            passes.add(this.inlineFunctions);
        }
        if (this.options.inlineProperties) {
            passes.add(this.inlineProperties);
        }
        boolean bl = runOptimizeCalls = this.options.optimizeCalls || this.options.optimizeParameters || this.options.optimizeReturns;
        if (this.options.removeUnusedVars || this.options.removeUnusedLocalVars) {
            if (this.options.deadAssignmentElimination) {
                passes.add(this.deadAssignmentsElimination);
            }
            if (!runOptimizeCalls) {
                passes.add(this.removeUnusedVars);
            }
        }
        if (runOptimizeCalls) {
            passes.add(this.optimizeCallsAndRemoveUnusedVars);
        }
        this.assertAllLoopablePasses(passes);
        return passes;
    }

    private List<PassFactory> getCodeRemovingPasses() {
        ArrayList passes = Lists.newArrayList();
        if (this.options.collapseObjectLiterals && !this.isInliningForbidden()) {
            passes.add(this.collapseObjectLiterals);
        }
        if (this.options.inlineVariables || this.options.inlineLocalVariables) {
            passes.add(this.inlineVariables);
        } else if (this.options.inlineConstantVars) {
            passes.add(this.inlineConstants);
        }
        if (this.options.foldConstants) {
            passes.add(this.minimizeExitPoints);
            passes.add(this.peepholeOptimizations);
        }
        if (this.options.removeDeadCode) {
            passes.add(this.removeUnreachableCode);
        }
        if (this.options.removeUnusedPrototypeProperties) {
            passes.add(this.removeUnusedPrototypeProperties);
        }
        if (this.options.removeUnusedClassProperties && !this.isInliningForbidden()) {
            passes.add(this.removeUnusedClassProperties);
        }
        this.assertAllLoopablePasses(passes);
        return passes;
    }

    private void assertAllOneTimePasses(List<PassFactory> passes) {
        for (PassFactory pass : passes) {
            Preconditions.checkState((boolean)pass.isOneTimePass());
        }
    }

    private void assertAllLoopablePasses(List<PassFactory> passes) {
        for (PassFactory pass : passes) {
            Preconditions.checkState((!pass.isOneTimePass() ? 1 : 0) != 0);
        }
    }

    private static HotSwapCompilerPass combineChecks(AbstractCompiler compiler, List<NodeTraversal.Callback> callbacks) {
        Preconditions.checkArgument((callbacks.size() > 0 ? 1 : 0) != 0);
        NodeTraversal.Callback[] array = callbacks.toArray(new NodeTraversal.Callback[callbacks.size()]);
        return new CombinedCompilerPass(compiler, array);
    }

    private VariableMap runPropertyRenaming(AbstractCompiler compiler, VariableMap prevPropertyMap, Node externs, Node root) {
        char[] reservedChars = this.options.anonymousFunctionNaming.getReservedCharacters();
        switch (this.options.propertyRenaming) {
            case HEURISTIC: {
                RenamePrototypes rproto = new RenamePrototypes(compiler, false, reservedChars, prevPropertyMap);
                rproto.process(externs, root);
                return rproto.getPropertyMap();
            }
            case AGGRESSIVE_HEURISTIC: {
                RenamePrototypes rproto2 = new RenamePrototypes(compiler, true, reservedChars, prevPropertyMap);
                rproto2.process(externs, root);
                return rproto2.getPropertyMap();
            }
            case ALL_UNQUOTED: {
                RenameProperties rprop = new RenameProperties(compiler, this.options.propertyAffinity, this.options.generatePseudoNames, prevPropertyMap, reservedChars);
                rprop.process(externs, root);
                return rprop.getPropertyMap();
            }
        }
        throw new IllegalStateException("Unrecognized property renaming policy");
    }

    private VariableMap runVariableRenaming(AbstractCompiler compiler, VariableMap prevVariableMap, Node externs, Node root) {
        char[] reservedChars = this.options.anonymousFunctionNaming.getReservedCharacters();
        boolean preserveAnonymousFunctionNames = this.options.anonymousFunctionNaming != AnonymousFunctionNamingPolicy.OFF;
        RenameVars rn = new RenameVars(compiler, this.options.renamePrefix, this.options.variableRenaming == VariableRenamingPolicy.LOCAL, preserveAnonymousFunctionNames, this.options.generatePseudoNames, this.options.shadowVariables, prevVariableMap, reservedChars, this.exportedNames);
        rn.process(externs, root);
        return rn.getVariableMap();
    }

    static PassFactory createEmptyPass(String name) {
        return new PassFactory(name, true){

            @Override
            protected CompilerPass createInternal(AbstractCompiler compiler) {
                return DefaultPassConfig.runInSerial(new CompilerPass[0]);
            }
        };
    }

    private PassFactory getCustomPasses(final CustomPassExecutionTime executionTime) {
        return new PassFactory("runCustomPasses", true){

            @Override
            protected CompilerPass createInternal(AbstractCompiler compiler) {
                return DefaultPassConfig.runInSerial(DefaultPassConfig.this.options.customPasses.get((Object)executionTime));
            }
        };
    }

    private boolean isInliningForbidden() {
        return this.options.propertyRenaming == PropertyRenamingPolicy.HEURISTIC || this.options.propertyRenaming == PropertyRenamingPolicy.AGGRESSIVE_HEURISTIC;
    }

    private static CompilerPass runInSerial(CompilerPass ... passes) {
        return DefaultPassConfig.runInSerial(Lists.newArrayList((Object[])passes));
    }

    private static CompilerPass runInSerial(final Collection<CompilerPass> passes) {
        return new CompilerPass(){

            @Override
            public void process(Node externs, Node root) {
                for (CompilerPass pass : passes) {
                    pass.process(externs, root);
                }
            }
        };
    }

    @VisibleForTesting
    static Map<String, Node> getAdditionalReplacements(CompilerOptions options) {
        HashMap additionalReplacements = Maps.newHashMap();
        if (options.markAsCompiled || options.closurePass) {
            additionalReplacements.put(COMPILED_CONSTANT_NAME, IR.trueNode());
        }
        if (options.closurePass && options.locale != null) {
            additionalReplacements.put(CLOSURE_LOCALE_CONSTANT_NAME, IR.string(options.locale));
        }
        return additionalReplacements;
    }

    static abstract class HotSwapPassFactory
    extends PassFactory {
        HotSwapPassFactory(String name, boolean isOneTimePass) {
            super(name, isOneTimePass);
        }

        @Override
        protected abstract HotSwapCompilerPass createInternal(AbstractCompiler var1);

        @Override
        HotSwapCompilerPass getHotSwapPass(AbstractCompiler compiler) {
            return this.createInternal(compiler);
        }
    }

    class ClearTypedScope
    implements CompilerPass {
        ClearTypedScope() {
        }

        @Override
        public void process(Node externs, Node root) {
            DefaultPassConfig.this.clearTypedScope();
        }
    }

    class GlobalTypeResolver
    implements HotSwapCompilerPass {
        private final AbstractCompiler compiler;

        GlobalTypeResolver(AbstractCompiler compiler) {
            this.compiler = compiler;
        }

        @Override
        public void process(Node externs, Node root) {
            if (DefaultPassConfig.this.topScope == null) {
                DefaultPassConfig.this.regenerateGlobalTypedScope(this.compiler, root.getParent());
            } else {
                this.compiler.getTypeRegistry().resolveTypesInScope(DefaultPassConfig.this.topScope);
            }
        }

        @Override
        public void hotSwapScript(Node scriptRoot, Node originalRoot) {
            DefaultPassConfig.this.patchGlobalTypedScope(this.compiler, scriptRoot);
        }
    }
}

