/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.border;

import com.itextpdf.kernel.color.Color;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.layout.border.Border;

public class DashedBorder
extends Border {
    private static final float DASH_MODIFIER = 5.0f;
    private static final float GAP_MODIFIER = 3.5f;

    public DashedBorder(float width) {
        super(width);
    }

    public DashedBorder(Color color, float width) {
        super(color, width);
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public void draw(PdfCanvas canvas, float x1, float y1, float x2, float y2, float borderWidthBefore, float borderWidthAfter) {
        float initialGap = this.width * 3.5f;
        float dash = this.width * 5.0f;
        float dx = x2 - x1;
        float dy = y2 - y1;
        double borderLength = Math.sqrt(dx * dx + dy * dy);
        float adjustedGap = this.getDotsGap(borderLength, initialGap + dash);
        if (adjustedGap > dash) {
            adjustedGap -= dash;
        }
        float widthHalf = this.width / 2.0f;
        Border.Side borderSide = this.getBorderSide(x1, y1, x2, y2);
        switch (borderSide) {
            case TOP: {
                y1 += widthHalf;
                y2 += widthHalf;
                break;
            }
            case RIGHT: {
                x1 += widthHalf;
                x2 += widthHalf;
                break;
            }
            case BOTTOM: {
                y1 -= widthHalf;
                y2 -= widthHalf;
                break;
            }
            case LEFT: {
                x1 -= widthHalf;
                x2 -= widthHalf;
            }
        }
        canvas.setLineWidth(this.width);
        canvas.setStrokeColor(this.color);
        canvas.setLineDash(dash, adjustedGap, dash + adjustedGap / 2.0f).moveTo((double)x1, (double)y1).lineTo((double)x2, (double)y2).stroke();
    }

    @Override
    public void drawCellBorder(PdfCanvas canvas, float x1, float y1, float x2, float y2) {
        float initialGap = this.width * 3.5f;
        float dash = this.width * 5.0f;
        float dx = x2 - x1;
        float dy = y2 - y1;
        double borderLength = Math.sqrt(dx * dx + dy * dy);
        float adjustedGap = this.getDotsGap(borderLength, initialGap + dash);
        if (adjustedGap > dash) {
            adjustedGap -= dash;
        }
        canvas.saveState().setStrokeColor(this.color).setLineDash(dash, adjustedGap, dash + adjustedGap / 2.0f).setLineWidth(this.width).moveTo((double)x1, (double)y1).lineTo((double)x2, (double)y2).stroke().restoreState();
    }

    protected float getDotsGap(double distance, float initialGap) {
        double gapsNum = Math.ceil(distance / (double)initialGap);
        return (float)(distance / gapsNum);
    }
}

