/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.tagutils.IAccessibleElement;
import com.itextpdf.kernel.pdf.tagutils.TagTreePointer;
import com.itextpdf.layout.element.ListItem;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.layout.LayoutResult;
import com.itextpdf.layout.property.ListSymbolAlignment;
import com.itextpdf.layout.renderer.AbstractRenderer;
import com.itextpdf.layout.renderer.DivRenderer;
import com.itextpdf.layout.renderer.DrawContext;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.renderer.TextRenderer;

public class ListItemRenderer
extends DivRenderer {
    protected IRenderer symbolRenderer;
    protected float symbolAreaWidth;

    public ListItemRenderer(ListItem modelElement) {
        super(modelElement);
    }

    public void addSymbolRenderer(IRenderer symbolRenderer, float symbolAreaWidth) {
        this.symbolRenderer = symbolRenderer;
        this.symbolAreaWidth = symbolAreaWidth;
    }

    @Override
    public LayoutResult layout(LayoutContext layoutContext) {
        if (this.symbolRenderer != null && this.getProperty(27) == null) {
            this.setProperty(27, Float.valueOf(this.symbolRenderer.getOccupiedArea().getBBox().getHeight()));
        }
        return super.layout(layoutContext);
    }

    @Override
    public void draw(DrawContext drawContext) {
        boolean isTagged = drawContext.isTaggingEnabled() && this.getModelElement() instanceof IAccessibleElement;
        TagTreePointer tagPointer = null;
        if (isTagged) {
            tagPointer = drawContext.getDocument().getTagStructureContext().getAutoTaggingPointer();
            IAccessibleElement modelElement = (IAccessibleElement)this.getModelElement();
            PdfName role = modelElement.getRole();
            if (role != null && !PdfName.Artifact.equals((Object)role)) {
                boolean lBodyTagIsCreated = tagPointer.isElementConnectedToTag(modelElement);
                if (!lBodyTagIsCreated) {
                    tagPointer.addTag(PdfName.LI);
                } else {
                    tagPointer.moveToTag(modelElement).moveToParent();
                }
            } else {
                isTagged = false;
            }
        }
        super.draw(drawContext);
        if (this.symbolRenderer != null) {
            float x = this.occupiedArea.getBBox().getX();
            if (this.childRenderers.size() > 0) {
                Float yLine = ((AbstractRenderer)this.childRenderers.get(0)).getFirstYLineRecursively();
                if (yLine != null) {
                    if (this.symbolRenderer instanceof TextRenderer) {
                        ((TextRenderer)this.symbolRenderer).moveYLineTo(yLine.floatValue());
                    } else {
                        this.symbolRenderer.move(0.0f, yLine.floatValue() - this.symbolRenderer.getOccupiedArea().getBBox().getY());
                    }
                } else {
                    this.symbolRenderer.move(0.0f, this.occupiedArea.getBBox().getY() + this.occupiedArea.getBBox().getHeight() - (this.symbolRenderer.getOccupiedArea().getBBox().getY() + this.symbolRenderer.getOccupiedArea().getBBox().getHeight()));
                }
            } else {
                this.symbolRenderer.move(0.0f, this.occupiedArea.getBBox().getY() + this.occupiedArea.getBBox().getHeight() - this.symbolRenderer.getOccupiedArea().getBBox().getHeight() - this.symbolRenderer.getOccupiedArea().getBBox().getY());
            }
            ListSymbolAlignment listSymbolAlignment = (ListSymbolAlignment)((Object)this.parent.getProperty(38));
            float xPosition = x - this.symbolRenderer.getOccupiedArea().getBBox().getX();
            if (listSymbolAlignment == null || listSymbolAlignment == ListSymbolAlignment.RIGHT) {
                xPosition += this.symbolAreaWidth - this.symbolRenderer.getOccupiedArea().getBBox().getWidth();
            }
            this.symbolRenderer.move(xPosition, 0.0f);
            if (isTagged) {
                tagPointer.addTag(0, PdfName.Lbl);
            }
            this.symbolRenderer.draw(drawContext);
            if (isTagged) {
                tagPointer.moveToParent();
            }
        }
        if (isTagged) {
            tagPointer.moveToParent();
        }
    }

    @Override
    public IRenderer getNextRenderer() {
        return new ListItemRenderer((ListItem)this.modelElement);
    }

    @Override
    protected AbstractRenderer createSplitRenderer(int layoutResult) {
        ListItemRenderer splitRenderer = (ListItemRenderer)this.getNextRenderer();
        splitRenderer.parent = this.parent;
        splitRenderer.modelElement = this.modelElement;
        splitRenderer.occupiedArea = this.occupiedArea;
        if (layoutResult == 2) {
            splitRenderer.symbolRenderer = this.symbolRenderer;
            splitRenderer.symbolAreaWidth = this.symbolAreaWidth;
        }
        splitRenderer.setProperty(44, this.getProperty(44));
        return splitRenderer;
    }

    @Override
    protected AbstractRenderer createOverflowRenderer(int layoutResult) {
        ListItemRenderer overflowRenderer = (ListItemRenderer)this.getNextRenderer();
        overflowRenderer.parent = this.parent;
        overflowRenderer.modelElement = this.modelElement;
        if (layoutResult == 3) {
            overflowRenderer.symbolRenderer = this.symbolRenderer;
            overflowRenderer.symbolAreaWidth = this.symbolAreaWidth;
        }
        overflowRenderer.setProperty(44, this.getProperty(44));
        return overflowRenderer;
    }
}

