/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.io.font.FontProgram;
import com.itextpdf.io.font.TrueTypeFont;
import com.itextpdf.io.font.otf.GlyphLine;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.layout.property.BaseDirection;
import com.itextpdf.layout.renderer.LineRenderer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TypographyUtils {
    private static final Logger logger = LoggerFactory.getLogger(TypographyUtils.class);
    private static final String TYPOGRAPHY_PACKAGE = "com.itextpdf.typography.";
    private static final boolean TYPOGRAPHY_MODULE_INITIALIZED = TypographyUtils.checkTypographyModulePresence();

    TypographyUtils() {
    }

    static void applyOtfScript(FontProgram fontProgram, GlyphLine text, Character.UnicodeScript script) {
        if (!TYPOGRAPHY_MODULE_INITIALIZED) {
            logger.warn("Cannot find advanced typography module, which was implicitly required by one of the layout properties");
        } else {
            TypographyUtils.callMethod("com.itextpdf.typography.shaping.Shaper", "applyOtfScript", new Class[]{TrueTypeFont.class, GlyphLine.class, Character.UnicodeScript.class}, new Object[]{fontProgram, text, script});
        }
    }

    static void applyKerning(FontProgram fontProgram, GlyphLine text) {
        if (!TYPOGRAPHY_MODULE_INITIALIZED) {
            logger.warn("Cannot find advanced typography module, which was implicitly required by one of the layout properties");
        } else {
            TypographyUtils.callMethod("com.itextpdf.typography.shaping.Shaper", "applyKerning", new Class[]{FontProgram.class, GlyphLine.class}, fontProgram, text);
        }
    }

    static byte[] getBidiLevels(BaseDirection baseDirection, int[] unicodeIds) {
        if (TYPOGRAPHY_MODULE_INITIALIZED) {
            byte direction;
            switch (baseDirection) {
                case LEFT_TO_RIGHT: {
                    direction = 0;
                    break;
                }
                case RIGHT_TO_LEFT: {
                    direction = 1;
                    break;
                }
                default: {
                    direction = 2;
                }
            }
            int len = unicodeIds.length;
            byte[] types = (byte[])TypographyUtils.callMethod("com.itextpdf.typography.bidi.BidiCharacterMap", "getCharacterTypes", new Class[]{int[].class, Integer.TYPE, Integer.TYPE}, unicodeIds, 0, len);
            byte[] pairTypes = (byte[])TypographyUtils.callMethod("com.itextpdf.typography.bidi.BidiBracketMap", "getBracketTypes", new Class[]{int[].class, Integer.TYPE, Integer.TYPE}, unicodeIds, 0, len);
            int[] pairValues = (int[])TypographyUtils.callMethod("com.itextpdf.typography.bidi.BidiBracketMap", "getBracketValues", new Class[]{int[].class, Integer.TYPE, Integer.TYPE}, unicodeIds, 0, len);
            Object bidiReorder = TypographyUtils.callConstructor("com.itextpdf.typography.bidi.BidiAlgorithm", new Class[]{byte[].class, byte[].class, int[].class, Byte.TYPE}, types, pairTypes, pairValues, direction);
            return (byte[])TypographyUtils.callMethod("com.itextpdf.typography.bidi.BidiAlgorithm", "getLevels", bidiReorder, new Class[]{int[].class}, new Object[]{new int[]{len}});
        }
        logger.warn("Cannot find advanced typography module, which was implicitly required by one of the layout properties");
        return null;
    }

    static int[] reorderLine(List<LineRenderer.RendererGlyph> line, byte[] lineLevels, byte[] levels) {
        if (TYPOGRAPHY_MODULE_INITIALIZED) {
            if (levels == null) {
                return null;
            }
            int[] reorder = (int[])TypographyUtils.callMethod("com.itextpdf.typography.bidi.BidiAlgorithm", "computeReordering", new Class[]{byte[].class}, new Object[]{lineLevels});
            ArrayList<LineRenderer.RendererGlyph> reorderedLine = new ArrayList<LineRenderer.RendererGlyph>(lineLevels.length);
            for (int i = 0; i < line.size(); ++i) {
                reorderedLine.add(line.get(reorder[i]));
                if (levels[reorder[i]] % 2 != 1 || !((LineRenderer.RendererGlyph)reorderedLine.get((int)i)).glyph.hasValidUnicode()) continue;
                int pairedBracket = (Integer)TypographyUtils.callMethod("com.itextpdf.typography.bidi.BidiBracketMap", "getPairedBracket", new Class[]{Integer.TYPE}, ((LineRenderer.RendererGlyph)reorderedLine.get((int)i)).glyph.getUnicode());
                PdfFont font = ((LineRenderer.RendererGlyph)reorderedLine.get((int)i)).renderer.getPropertyAsFont(20);
                reorderedLine.set(i, new LineRenderer.RendererGlyph(font.getGlyph(pairedBracket), ((LineRenderer.RendererGlyph)reorderedLine.get((int)i)).renderer));
            }
            line.clear();
            line.addAll(reorderedLine);
            return reorder;
        }
        logger.warn("Cannot find advanced typography module, which was implicitly required by one of the layout properties");
        return null;
    }

    static Collection<Character.UnicodeScript> getSupportedScripts() {
        if (!TYPOGRAPHY_MODULE_INITIALIZED) {
            logger.warn("Cannot find advanced typography module, which was implicitly required by one of the layout properties");
            return null;
        }
        return (Collection)TypographyUtils.callMethod("com.itextpdf.typography.shaping.Shaper", "getSupportedScripts", new Class[0], new Object[0]);
    }

    static boolean isTypographyModuleInitialized() {
        return TYPOGRAPHY_MODULE_INITIALIZED;
    }

    private static boolean checkTypographyModulePresence() {
        boolean moduleFound = false;
        try {
            Class.forName("com.itextpdf.typography.shaping.Shaper");
            moduleFound = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return moduleFound;
    }

    private static Object callMethod(String className, String methodName, Class[] parameterTypes, Object ... args) {
        return TypographyUtils.callMethod(className, methodName, null, parameterTypes, args);
    }

    private static Object callMethod(String className, String methodName, Object target, Class[] parameterTypes, Object ... args) {
        try {
            Method method = Class.forName(className).getMethod(methodName, parameterTypes);
            return method.invoke(target, args);
        }
        catch (NoSuchMethodException e) {
            logger.warn(MessageFormat.format("Cannot find method {0} for class {1}", methodName, className));
        }
        catch (ClassNotFoundException e) {
            logger.warn(MessageFormat.format("Cannot find class {0}", className));
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause() != null ? e.getCause() : null);
        }
        catch (Exception exc) {
            throw new RuntimeException(exc);
        }
        return null;
    }

    private static Object callConstructor(String className, Class[] parameterTypes, Object ... args) {
        Constructor<?> constructor = null;
        try {
            constructor = Class.forName(className).getConstructor(parameterTypes);
            return constructor.newInstance(args);
        }
        catch (NoSuchMethodException e) {
            logger.warn(MessageFormat.format("Cannot find constructor for class {0}", className));
        }
        catch (ClassNotFoundException e) {
            logger.warn(MessageFormat.format("Cannot find class {0}", className));
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause() != null ? e.getCause() : null);
        }
        catch (Exception exc) {
            throw new RuntimeException(exc);
        }
        return null;
    }
}

