/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.api.agent;

import com.newrelic.api.agent.ExternalParameters;
import com.newrelic.api.agent.InboundHeaders;
import java.net.URI;

public class HttpParameters
implements ExternalParameters {
    private final String library;
    private final URI uri;
    private final String procedure;
    private final InboundHeaders inboundResponseHeaders;

    protected HttpParameters(String library, URI uri, String procedure, InboundHeaders inboundHeaders) {
        this.library = library;
        this.uri = uri;
        this.procedure = procedure;
        this.inboundResponseHeaders = inboundHeaders;
    }

    protected HttpParameters(HttpParameters httpParameters) {
        this.library = httpParameters.library;
        this.uri = httpParameters.uri;
        this.procedure = httpParameters.procedure;
        this.inboundResponseHeaders = httpParameters.inboundResponseHeaders;
    }

    public String getLibrary() {
        return this.library;
    }

    public URI getUri() {
        return this.uri;
    }

    public String getProcedure() {
        return this.procedure;
    }

    public InboundHeaders getInboundResponseHeaders() {
        return this.inboundResponseHeaders;
    }

    public static UriParameter library(String library) {
        return new Builder(library);
    }

    public static interface Build {
        public HttpParameters build();
    }

    public static interface InboundHeadersParameter {
        public Build inboundHeaders(InboundHeaders var1);

        public Build noInboundHeaders();
    }

    public static interface ProcedureParameter {
        public InboundHeadersParameter procedure(String var1);
    }

    public static interface UriParameter {
        public ProcedureParameter uri(URI var1);
    }

    protected static class Builder
    implements UriParameter,
    ProcedureParameter,
    InboundHeadersParameter,
    Build {
        private String library;
        private URI uri;
        private String procedure;
        private InboundHeaders inboundHeaders;

        public Builder(String library) {
            this.library = library;
        }

        @Override
        public ProcedureParameter uri(URI uri) {
            this.uri = uri;
            return this;
        }

        @Override
        public InboundHeadersParameter procedure(String procedure) {
            this.procedure = procedure;
            return this;
        }

        @Override
        public Build inboundHeaders(InboundHeaders inboundHeaders) {
            this.inboundHeaders = inboundHeaders;
            return this;
        }

        @Override
        public Build noInboundHeaders() {
            return this;
        }

        @Override
        public HttpParameters build() {
            return new HttpParameters(this.library, this.uri, this.procedure, this.inboundHeaders);
        }
    }
}

